/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.fileio;

import edu.uml.lgdc.fileio.FileDesc;
import edu.uml.lgdc.fileio.FileRW;
import edu.uml.lgdc.fileio.FiledescFilter;
import edu.uml.lgdc.fileio.Filer;
import edu.uml.lgdc.fileio.ParsedFTPAddr;
import edu.uml.lgdc.ftp.FtpClientProtocol;
import edu.uml.lgdc.math.Sort;
import edu.uml.lgdc.project.Console;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Vector;

public class Dir {
    public static final int ERROR_TYPE_NO = 0;
    public static final int ERROR_TYPE_PERM_CONN = 1;
    public static final int ERROR_TYPE_PERIODIC_CONN = 2;
    public static final int ERROR_TYPE_OTHER = 3;
    static final int RESTART_NOT_CHECKED = 0;
    static final int RESTART_NOT_IMPLEMENTED = 1;
    static final int RESTART_IMPLEMENTED = 2;
    private static final int MAX_CONNECTION_ATTEMPTS = 10;
    private static final int CONNECTION_TIMEOUT = 5;
    private static final int MAX_LIST_ATTEMPTS = 10;
    private static final int MAX_READ_ATTEMPTS_WITH_RERSTART = 50;
    private static final int MAX_WRITE_ATTEMPTS_WITH_RERSTART = 50;
    private static final int MAX_READ_ATTEMPTS = 10;
    private static final int MAX_WRITE_ATTEMPTS = 10;
    protected ParsedFTPAddr parsedAddr;
    protected FiledescFilter filter;
    public boolean isFTP = false;
    private FtpClientProtocol ftp;
    private boolean connected = false;
    private String dirSeparator = File.separator;
    private boolean readDir = false;
    FileDesc[] fileDesc;
    int restart = 0;
    private int maxConnectionAttempts = 10;
    private int connectionTimeout = 5;
    private int maxListAttempts = 10;
    private int maxReadAttemptsWithRestart = 50;
    private int maxWriteAttemptsWithRestart = 50;
    private int maxReadAttempts = 10;
    private int maxWriteAttempts = 10;
    public String error = null;

    public Dir() {
        this.parsedAddr = new ParsedFTPAddr();
    }

    public Dir(String fullAddress) {
        this(fullAddress, null);
    }

    public Dir(String fullAddress, FiledescFilter filter) {
        this.parsedAddr = ParsedFTPAddr.create(fullAddress);
        this.isFTP = this.parsedAddr.isFTP;
        this.filter = filter;
        this.dirSeparator = !this.isFTP ? File.separator : "/";
    }

    public void setUser(String userName, String userPass) {
        this.parsedAddr.userName = userName;
        this.parsedAddr.userPass = userPass;
    }

    public void setFTPAddress(String ftpAddress) {
        this.disconnect();
        this.parsedAddr.ftpAddress = ftpAddress;
        this.parsedAddr.badFTPAddressSpecification = false;
        this.parsedAddr.isFTP = true;
    }

    public boolean setPath(String path) {
        boolean result = true;
        this.parsedAddr.path = path;
        this.readDir = false;
        this.fileDesc = null;
        if (this.connected && this.parsedAddr.isFTP) {
            result = this.changeWorkingDirectory(this.parsedAddr.path);
        }
        return result;
    }

    public void setFilter(FiledescFilter filter) {
        this.filter = filter;
    }

    public FiledescFilter getFilter() {
        return this.filter;
    }

    public void setMaxConnectionAttempts(int maxConnectionAttempts) {
        this.maxConnectionAttempts = maxConnectionAttempts;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setMaxListAttempts(int maxListAttempts) {
        this.maxListAttempts = maxListAttempts;
    }

    public void setMaxReadAttemptsWithRestart(int maxReadAttemptsWithRestart) {
        this.maxReadAttemptsWithRestart = maxReadAttemptsWithRestart;
    }

    public void setMaxWriteAttemptsWithRestart(int maxWriteAttemptsWithRestart) {
        this.maxWriteAttemptsWithRestart = maxWriteAttemptsWithRestart;
    }

    public void setMaxReadAttempts(int maxReadAttempts) {
        this.maxReadAttempts = maxReadAttempts;
    }

    public void setMaxWriteAttempts(int maxWriteAttempts) {
        this.maxWriteAttempts = maxWriteAttempts;
    }

    public FileDesc[] getFileDesc() {
        return this.fileDesc;
    }

    public ParsedFTPAddr getParsedAddr() {
        return this.parsedAddr;
    }

    public boolean connect() {
        return this.connect(System.err);
    }

    public boolean connect(OutputStream os) {
        block11: {
            if (!this.parsedAddr.isFTP) {
                this.connected = true;
                this.restart = 1;
            }
            if (this.connected) {
                return true;
            }
            this.restart = 0;
            if (this.parsedAddr.badFTPAddressSpecification) {
                this.error = "Badly formatted ftp address: " + this.parsedAddr.address;
                return false;
            }
            String user = "anonymous";
            String pass = "anonymous@anonymous";
            if (this.parsedAddr.userName != null && !this.parsedAddr.userName.trim().equals("")) {
                user = this.parsedAddr.userName;
                pass = null;
            }
            if (this.parsedAddr.userPass != null && !this.parsedAddr.userPass.equals("")) {
                pass = this.parsedAddr.userPass;
            }
            PrintWriter trace = new PrintWriter((Writer)new OutputStreamWriter(os), true);
            try {
                this.ftp = new FtpClientProtocol(this.parsedAddr.ftpAddress, trace);
                this.ftp.setTimeout(50000);
            }
            catch (IOException e) {
                this.error = "Cannot connect to server: " + this.parsedAddr.ftpAddress + "\n" + e.toString();
                break block11;
            }
            this.ftp.setDataConnectionActiveServer();
            try {
                this.ftp.user(user);
                if (pass != null) {
                    this.ftp.password(pass);
                }
                if (!this.ftp.isLoggedIn()) break block11;
                this.ftp.setRepresentationTypeImage();
            }
            catch (IOException e) {
                this.error = "User/password illegal for ftp: " + this.parsedAddr.ftpAddress + "\n" + e.toString();
                break block11;
            }
            if (this.parsedAddr.path == null || this.parsedAddr.path.trim().length() == 0 || this.changeWorkingDirectory(this.parsedAddr.path)) {
                this.connected = true;
            }
        }
        return this.connected;
    }

    boolean reconnect() {
        return this.reconnect(this.maxConnectionAttempts);
    }

    boolean reconnect(int maxConnectionAttempt) {
        return this.reconnect(this.maxConnectionAttempts, this.connectionTimeout);
    }

    boolean reconnect(int maxConnectionAttempts, int connectionTimeout) {
        boolean connected = false;
        int connectionAttempt = 0;
        while (connectionAttempt <= maxConnectionAttempts) {
            try {
                Thread.sleep(1000 * connectionTimeout);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.connectOnceMore()) {
                connected = true;
                break;
            }
            ++connectionAttempt;
        }
        return connected;
    }

    int tryReconnectReadOperation(Exception e, int attempt, int restartPos) {
        return this.tryReconnectReadOperation(e, attempt, restartPos, false);
    }

    int tryReconnectReadOperationWithoutRestart(Exception e, int attempt) {
        return this.tryReconnectReadOperation(e, attempt, -1, true);
    }

    private int tryReconnectReadOperation(Exception e, int attempt, int restartPos, boolean forceNoRestart) {
        int result = 0;
        int maxAttempts = 10;
        if (forceNoRestart) {
            restartPos = -1;
        } else if (this.restart == 2) {
            maxAttempts = 50;
        }
        if (attempt < maxAttempts && !forceNoRestart && this.restart == 0 && restartPos > 0 && !Dir.connectionError(e.toString())) {
            this.restart = Dir.thisCommandIsNotImplemented(e.toString()) ? 1 : 2;
        }
        result = Dir.connectionError(e.toString()) ? (this.reconnect() ? (attempt < maxAttempts ? 0 : 2) : 1) : 3;
        return result;
    }

    private boolean connectOnceMore() {
        this.disconnect();
        return this.connect();
    }

    static boolean connectionError(String errorStr) {
        String connectReset = "CONNECTION RESET BY PEER";
        String readTimeOut = "READ TIMED OUT";
        String reachedMaxAttempt = "REACHED MAXIMUM ATTEMPTS";
        return (errorStr = errorStr.toUpperCase()).indexOf("CONNECTION RESET BY PEER") >= 0 || errorStr.indexOf("READ TIMED OUT") >= 0 || errorStr.indexOf("REACHED MAXIMUM ATTEMPTS") >= 0;
    }

    static boolean thisCommandIsNotImplemented(String errorStr) {
        String notImpl = "COMMAND NOT IMPLEMENTED";
        String unknown = "COMMAND UNKNOWN";
        return (errorStr = errorStr.toUpperCase()).indexOf("COMMAND NOT IMPLEMENTED") >= 0 || errorStr.indexOf("COMMAND UNKNOWN") >= 0;
    }

    public boolean delete() {
        boolean result = true;
        if (!this.readDir) {
            result = this.readDir();
        }
        if (this.readDir) {
            int i = 0;
            while (i < this.fileDesc.length) {
                result = this.delete(this.fileDesc[i]) && result;
                ++i;
            }
        }
        return result;
    }

    public boolean deleteFiles() {
        boolean result = true;
        if (!this.readDir) {
            result = this.readDir();
        }
        if (this.readDir) {
            int i = 0;
            while (i < this.fileDesc.length) {
                if (!this.fileDesc[i].isDirectory) {
                    result = this.deleteFile(this.fileDesc[i].name) && result;
                }
                ++i;
            }
        }
        return result;
    }

    public boolean deleteAll() {
        boolean result = true;
        if (!this.readDir) {
            result = this.readDir();
        }
        if (this.readDir) {
            boolean pResult = true;
            int i = 0;
            while (i < this.fileDesc.length) {
                pResult = true;
                if (this.fileDesc[i].isDirectory) {
                    String path = this.parsedAddr.path;
                    FileDesc[] desc = this.fileDesc;
                    pResult = this.setPath(String.valueOf(this.parsedAddr.path) + this.dirSeparator + this.fileDesc[i].name);
                    if (pResult) {
                        pResult = this.readDir();
                    }
                    if (pResult) {
                        pResult = this.deleteAll();
                    }
                    this.parsedAddr.path = path;
                    this.fileDesc = desc;
                    if (this.changeWorkingDirectory(path)) {
                        this.parsedAddr.path = path;
                        this.fileDesc = desc;
                        this.readDir = true;
                    } else {
                        result = false;
                    }
                }
                if (pResult) {
                    result = this.delete(this.fileDesc[i]) && result;
                }
                ++i;
            }
        }
        return result;
    }

    public boolean delete(FileDesc fileDesc) {
        boolean result = false;
        result = !fileDesc.isDirectory ? this.deleteFile(fileDesc.name) : this.deleteDir(fileDesc.name);
        return result;
    }

    private boolean changeWorkingDirectory(String path) {
        boolean result = true;
        if (this.ftp == null) {
            this.error = "Error during changing working directory on FTP: " + path + "\n" + "You should connect to FTP server before to start operations";
            return false;
        }
        String errorMes = Dir.changeWorkingDirectory(path, this.ftp);
        if (errorMes == null) {
            this.readDir = false;
        } else {
            this.error = "Error during changing working directory on FTP: " + path + "\n" + errorMes;
            result = false;
        }
        return result;
    }

    public static String changeWorkingDirectory(String path, FtpClientProtocol ftp) {
        if (ftp == null) {
            throw new IllegalArgumentException("*ftp* is null");
        }
        String errorMes = null;
        if (path == null || path.trim().length() == 0) {
            return errorMes;
        }
        try {
            ftp.changeWorkingDirectory(path);
        }
        catch (IOException e) {
            errorMes = e.toString();
        }
        return errorMes;
    }

    public void disconnect() {
        if (this.connected) {
            if (this.parsedAddr.isFTP) {
                try {
                    this.ftp.close();
                }
                catch (IOException e) {
                    this.error = "Error during closing FTP: " + this.parsedAddr.ftpAddress + "\n" + e.toString();
                }
            }
            this.connected = false;
        }
    }

    public boolean readDir() {
        this.readDir = false;
        Vector<FileDesc> allDesc = null;
        this.fileDesc = new FileDesc[0];
        if (!this.parsedAddr.isFTP) {
            String[] fileNames = new File(this.parsedAddr.path).list();
            allDesc = new Vector<FileDesc>(10, 20);
            if (fileNames != null) {
                if (fileNames.length > 1) {
                    Sort.qsort(fileNames);
                }
                int i = 0;
                while (i < fileNames.length) {
                    File file = new File(this.parsedAddr.path, fileNames[i]);
                    FileDesc desc = FileDesc.create(file);
                    String exactName = desc.name;
                    desc.name = desc.name.toUpperCase();
                    if (this.filter == null || this.filter.accept(desc)) {
                        desc.name = exactName;
                        allDesc.addElement(desc);
                    }
                    ++i;
                }
                this.readDir = true;
                this.fileDesc = new FileDesc[allDesc.size()];
                allDesc.copyInto(this.fileDesc);
                this.sortFileDesc();
            } else {
                this.error = "Can't find directory " + this.parsedAddr.path;
            }
        } else {
            this.readDir = this.createFTPDirList();
        }
        return this.readDir;
    }

    private void sortFileDesc() {
        if (this.fileDesc != null && this.fileDesc.length > 1) {
            String[] fileNames = new String[this.fileDesc.length];
            int i = 0;
            while (i < this.fileDesc.length) {
                fileNames[i] = this.fileDesc[i].name;
                ++i;
            }
            Sort sort = new Sort(fileNames);
            Object[] obj = sort.doSortObjArray(this.fileDesc);
            this.fileDesc = new FileDesc[obj.length];
            int i2 = 0;
            while (i2 < obj.length) {
                this.fileDesc[i2] = (FileDesc)obj[i2];
                ++i2;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean createFTPDirList() {
        if (this.ftp == null) {
            this.error = "You need to connect to FTP server before start file-operations";
            return false;
        }
        result = false;
        allDesc = null;
        noMoreAttempts = false;
        attempt = 0;
        ex = null;
        while (!noMoreAttempts) {
            block9: {
                allDesc = new Vector<FileDesc>(10, 20);
                try {
                    enumeration = this.ftp.createDirectoryListingEnumeration();
                    if (true) ** GOTO lbl25
                }
                catch (IOException e) {
                    this.error = "Error during start of reading working directory on FTP: " + this.parsedAddr.ftpAddress + "\n" + e.toString();
                    ex = e;
                    break block9;
                }
                {
                    do {
                        if ((desc = FileDesc.create(line = enumeration.nextElement())) == null) continue;
                        exactName = desc.name;
                        desc.name = desc.name.toUpperCase();
                        if (this.filter != null && !this.filter.accept(desc)) continue;
                        desc.name = exactName;
                        allDesc.addElement(desc);
lbl25:
                        // 4 sources

                    } while (enumeration.hasMoreElements());
                }
                noMoreAttempts = true;
                result = true;
            }
            if (noMoreAttempts) continue;
            tmpErrorStr = ex.getMessage();
            if (tmpErrorStr.startsWith("Bad length of line.")) {
                System.out.println(this.error);
                ex = new Exception("CONNECTION RESET BY PEER");
            }
            if ((errorType = this.tryReconnectReadOperationWithoutRestart((Exception)ex, attempt)) != 0) {
                noMoreAttempts = true;
            }
            ++attempt;
        }
        if (result) {
            this.fileDesc = new FileDesc[allDesc.size()];
            allDesc.copyInto(this.fileDesc);
            this.sortFileDesc();
        }
        return result;
    }

    public boolean readToStream(String filename, OutputStream out) {
        boolean result = false;
        result = this.isFTP ? this.copyFromFTPToStream(filename, out) : this.copyFromLocalToStream(filename, out);
        return result;
    }

    public boolean copyFromFTPToStream(String filename, OutputStream out) {
        boolean result = false;
        try {
            Dir.downLoadFile(this.ftp, filename, out);
            result = true;
        }
        catch (IOException e) {
            this.error = e.toString();
        }
        catch (InterruptedException e) {
            this.error = e.toString();
        }
        return result;
    }

    public boolean copyFromLocalToStream(String filename, OutputStream out) {
        boolean result;
        block12: {
            result = false;
            File inFile = new File(this.parsedAddr.path, filename);
            BufferedInputStream bi = null;
            try {
                try {
                    bi = new BufferedInputStream(new FileInputStream(inFile), 4096);
                    Filer.copyFromStreamToStream(bi, out);
                    result = true;
                }
                catch (IOException e) {
                    this.error = e.toString();
                    if (bi == null) break block12;
                    try {
                        bi.close();
                    }
                    catch (IOException ex) {
                        Console.printThreadStackTrace(ex);
                    }
                }
            }
            finally {
                if (bi != null) {
                    try {
                        bi.close();
                    }
                    catch (IOException ex) {
                        Console.printThreadStackTrace(ex);
                    }
                }
            }
        }
        return result;
    }

    public void downLoadFile(String targetDir, String filename) throws IOException, InterruptedException {
        this.downLoadFile(targetDir, filename, filename);
    }

    public void downLoadFile(String targetDir, String sourceFilename, String targetFilename) throws IOException, InterruptedException {
        this.downLoadFile(targetDir, sourceFilename, targetFilename, -1);
    }

    void downLoadFile(String targetDir, String sourceFilename, String targetFilename, int restartPos) throws IOException, InterruptedException {
        Dir.downLoadFile(this.ftp, targetDir, sourceFilename, targetFilename, restartPos);
    }

    private static void downLoadFile(FtpClientProtocol ftp, String targetDir, String sourceFilename, String targetFilename, int restartPos) throws IOException, InterruptedException {
        File file = new File(targetDir, targetFilename);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file.getPath(), restartPos > 0);
            Dir.downLoadFile(ftp, sourceFilename, out, restartPos);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    Console.printThreadStackTrace(ex);
                }
            }
        }
    }

    void upLoadFile(String path, String filename) throws IOException, InterruptedException {
        this.upLoadFile(path, filename, filename);
    }

    void upLoadFile(String path, String sourceFilename, String targetFilename) throws IOException, InterruptedException {
        Dir.uploadFile(this.ftp, path, sourceFilename, targetFilename);
    }

    private static void uploadFile(FtpClientProtocol ftp, String path, String sourceFilename, String targetFilename) throws IOException, InterruptedException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(new File(path, sourceFilename));
            Dir.upLoadFile(ftp, targetFilename, in);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    Console.printThreadStackTrace(ex);
                }
            }
        }
    }

    private static void downLoadFile(FtpClientProtocol ftp, String filename, OutputStream out) throws IOException, InterruptedException {
        Dir.downLoadFile(ftp, filename, out, -1);
    }

    private static void downLoadFile(FtpClientProtocol ftp, String fileName, OutputStream out, int restartPos) throws IOException, InterruptedException {
        if (restartPos == -1) {
            ftp.download(out, fileName);
        } else {
            ftp.downloadRestart(out, fileName, restartPos);
        }
    }

    private static void upLoadFile(FtpClientProtocol ftp, String filename, InputStream in) throws IOException, InterruptedException {
        ftp.upload(in, filename);
    }

    public boolean rename(String oldFileName, String newFileName) {
        boolean result = true;
        if (!this.parsedAddr.isFTP) {
            File oldFile = new File(this.parsedAddr.path, oldFileName);
            File newFile = new File(this.parsedAddr.path, newFileName);
            newFile.delete();
            result = oldFile.renameTo(newFile);
        } else {
            try {
                result = Dir.renameFTPFile(this.ftp, oldFileName, newFileName);
            }
            catch (IOException e) {
                this.error = e.toString();
                System.out.println(this.error);
                result = false;
            }
        }
        return result;
    }

    public boolean deleteFile(String fileName) {
        boolean result = true;
        if (!this.parsedAddr.isFTP) {
            result = new File(this.parsedAddr.path, fileName).delete();
        } else {
            try {
                Dir.deleteFTPFile(this.ftp, fileName);
            }
            catch (IOException e) {
                this.error = e.toString();
                System.out.println(this.error);
                result = false;
            }
        }
        return result;
    }

    public boolean deleteDir(String dirName) {
        boolean result = true;
        if (!this.parsedAddr.isFTP) {
            result = new File(this.parsedAddr.path, dirName).delete();
        } else {
            try {
                Dir.deleteFTPDir(this.ftp, dirName);
            }
            catch (IOException e) {
                this.error = e.toString();
                System.out.println(this.error);
                result = false;
            }
        }
        return result;
    }

    public boolean makeDir(String dirName) {
        boolean result = true;
        if (!this.parsedAddr.isFTP) {
            result = new File(this.parsedAddr.path, dirName).mkdir();
        } else {
            try {
                result = Dir.makeFTPDir(this.ftp, dirName);
            }
            catch (IOException e) {
                this.error = e.toString();
                System.out.println(this.error);
                result = false;
            }
        }
        return result;
    }

    static boolean renameFTPFile(FtpClientProtocol ftp, String oldFilename, String newFilename) throws IOException {
        return ftp.rename(oldFilename, newFilename);
    }

    static boolean deleteFTPFile(FtpClientProtocol ftp, String filename) throws IOException {
        return ftp.deleteFile(filename);
    }

    static boolean deleteFTPDir(FtpClientProtocol ftp, String dirName) throws IOException {
        return ftp.deleteDir(dirName);
    }

    static boolean makeFTPDir(FtpClientProtocol ftp, String dirName) throws IOException {
        return ftp.makeDir(dirName);
    }

    public boolean putStrToLocalDir(String text, String fileName) {
        return Dir.putStrToLocalDir(text, fileName, this.parsedAddr.path);
    }

    public static boolean putStrToLocalDir(String text, String fileName, String path) {
        boolean result;
        block13: {
            result = false;
            File f = new File(path, fileName);
            if (f.exists() && !f.delete()) {
                return result;
            }
            fileName = f.getPath();
            FileRW file = null;
            try {
                try {
                    file = new FileRW(fileName, "rw");
                    file.write(text);
                    file.close();
                    result = true;
                }
                catch (IOException ex) {
                    Console.printThreadStackTrace(ex);
                    result = false;
                    if (file == null) break block13;
                    try {
                        file.close();
                    }
                    catch (IOException ex2) {
                        Console.printThreadStackTrace(ex2);
                    }
                }
            }
            finally {
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (IOException ex) {
                        Console.printThreadStackTrace(ex);
                    }
                }
            }
        }
        return result;
    }

    public static void purgeLocalDir(String path) {
        Dir.purgeLocalDir(path, false);
    }

    public static boolean purgeLocalDir(String path, boolean recursive) {
        boolean result = true;
        File dirFile = new File(path);
        if (!dirFile.isDirectory()) {
            return false;
        }
        String[] list = dirFile.list();
        if (list == null) {
            return false;
        }
        int i = 0;
        while (i < list.length) {
            File file = new File(path, list[i]);
            if (file.isFile()) {
                result = file.delete() && result;
                file = null;
            } else if (file.isDirectory() && recursive) {
                result = Dir.purgeLocalDir(path, recursive) && result;
            }
            ++i;
        }
        return result;
    }

    public static boolean deleteFiles(String dir) {
        boolean result = true;
        String[] fileNames = new File(dir).list();
        if (fileNames == null) {
            return false;
        }
        int i = 0;
        while (i < fileNames.length) {
            File file = new File(dir, fileNames[i]);
            if (file.isFile() && !file.delete()) {
                result = false;
            }
            ++i;
        }
        return result;
    }

    public static boolean deleteDirectory(String dir) {
        if (!new File(dir).isDirectory()) {
            return false;
        }
        return Dir.deleteAll(dir, true);
    }

    public static boolean deleteAllFromDirectrory(String dir) {
        if (!new File(dir).isDirectory()) {
            return false;
        }
        return Dir.deleteAll(dir, false);
    }

    public static boolean deleteAll(String dir, boolean internal) {
        boolean result = true;
        String[] fileNames = new File(dir).list();
        if (fileNames == null) {
            return false;
        }
        int i = 0;
        while (i < fileNames.length) {
            File file = new File(dir, fileNames[i]);
            if (file.isDirectory()) {
                result = Dir.deleteAll(file.getAbsolutePath(), true) && result;
            } else if (file.isFile()) {
                result = file.delete() && result;
            }
            ++i;
        }
        if (result && internal) {
            result = new File(dir).delete();
        }
        return result;
    }
}

