/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.fileio;

import edu.uml.lgdc.fileio.DateMaskStringFilter;
import edu.uml.lgdc.fileio.Dir;
import edu.uml.lgdc.fileio.FileDesc;
import edu.uml.lgdc.fileio.FileFilterType;
import edu.uml.lgdc.fileio.FileRW;
import edu.uml.lgdc.fileio.FiledescFilter;
import edu.uml.lgdc.fileio.FiledescTimeFilter;
import edu.uml.lgdc.fileio.MaskBuilder;
import edu.uml.lgdc.math.Search;
import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.time.TimeScale;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class Filer {
    public static final int STOP_AFTER_ANY_ERROR = 0;
    public static final int STOP_AFTER_PERM_CONN_ERROR = 1;
    public static final int STOP_AFTER_PERIODIC_CONN_ERROR = 2;
    protected Dir source;
    protected Dir target;
    private int qtyOfCopied = 0;
    private int qtyOfSkipped = 0;
    private List<Integer> lstIndOfNotCopied;
    private int[] indOfNotCopied;
    private long sizeCopied;
    private TimeScale start;
    private TimeScale end;
    private long totalInSeconds;
    private int seqNoOfFileInProcess = -1;
    private boolean done = false;
    protected List<String> errors;
    private int stopOption = 0;
    private boolean aborted;
    private int lastCopyErrorType;

    public Filer() {
        this.source = new Dir();
        this.target = new Dir();
    }

    public Filer(String inFullAddress, String outFullAddress) {
        this(inFullAddress, outFullAddress, null);
    }

    public Filer(String inFullAddress, String outFullAddress, FiledescFilter filter) {
        this.source = new Dir(inFullAddress, filter);
        this.target = new Dir(outFullAddress);
    }

    public Filer(Dir source, Dir target) {
        this.source = source;
        this.target = target;
    }

    public boolean copyFiles() {
        int i;
        this.aborted = false;
        this.qtyOfCopied = 0;
        this.qtyOfSkipped = 0;
        this.lstIndOfNotCopied = new ArrayList<Integer>();
        this.indOfNotCopied = null;
        this.sizeCopied = 0L;
        this.seqNoOfFileInProcess = -1;
        this.done = false;
        this.errors = new ArrayList<String>();
        this.start = new TimeScale();
        if (this.source.readDir()) {
            i = 0;
            while (i < this.source.fileDesc.length) {
                if (!this.copy(i) && (this.stopOption == 0 || this.lastCopyErrorType == 1 || this.lastCopyErrorType == 2 && this.stopOption == 2)) {
                    this.aborted = true;
                    break;
                }
                ++i;
            }
        } else {
            this.errors.add(this.source.error);
        }
        this.end = new TimeScale();
        this.totalInSeconds = this.end.diffWholeIn(13, this.start);
        this.indOfNotCopied = new int[this.lstIndOfNotCopied.size()];
        i = 0;
        while (i < this.lstIndOfNotCopied.size()) {
            this.indOfNotCopied[i] = this.lstIndOfNotCopied.get(i);
            ++i;
        }
        this.done = true;
        this.seqNoOfFileInProcess = -1;
        return this.getResult();
    }

    public void setStopOption(int stopOption) {
        if (stopOption == 0 || stopOption == 1 || stopOption == 2) {
            this.stopOption = stopOption;
        }
    }

    public boolean getResult() {
        return this.done && (this.errors == null || this.errors.size() == 0);
    }

    public List<String> getErros() {
        return this.errors;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public int getLastCopyErrorType() {
        return this.lastCopyErrorType;
    }

    public int getQtyOfCopied() {
        return this.qtyOfCopied;
    }

    public int getQtyOfSkipped() {
        return this.qtyOfSkipped;
    }

    public int[] getIndOfNotCopied() {
        return this.indOfNotCopied;
    }

    public long getSizeCopied() {
        return this.sizeCopied;
    }

    public long getTotalInSeconds() {
        return this.totalInSeconds;
    }

    public boolean connect() {
        return this.source.connect() && this.target.connect();
    }

    public void disconnect() {
        this.source.disconnect();
        this.target.disconnect();
    }

    public boolean copy(String fileName) {
        return this.copy(fileName, null);
    }

    public boolean copy(String sourceFileName, String targetFileName) {
        boolean result = false;
        if (targetFileName == null) {
            targetFileName = sourceFileName;
        }
        result = this.source.isFTP ? this.copyFromFTPToLocal(sourceFileName, targetFileName) : (!this.target.isFTP ? this.copyFromLocalToLocal(sourceFileName, targetFileName) : this.copyFromLocalToFTP(sourceFileName, targetFileName));
        return result;
    }

    private boolean copy(int seqNo) {
        boolean result = false;
        this.seqNoOfFileInProcess = seqNo;
        this.lastCopyErrorType = 0;
        result = this.copy(this.source.fileDesc[seqNo].name);
        if (result) {
            ++this.qtyOfCopied;
            this.sizeCopied += this.source.fileDesc[seqNo].size;
        } else {
            ++this.qtyOfSkipped;
            this.lstIndOfNotCopied.add(seqNo);
            this.target.deleteFile(this.source.fileDesc[seqNo].name);
        }
        return result;
    }

    private boolean copyFromFTPToLocal(String sourceFileName, String targetFileName) {
        boolean result = false;
        String targetDir = this.target.getParsedAddr().path;
        int attempt = 0;
        int restartPos = -1;
        File file = null;
        while (true) {
            try {
                file = new File(targetDir, targetFileName);
                if (!file.exists() || file.length() == 0L || attempt == 0 || this.source.restart == 1) {
                    restartPos = -1;
                    file.delete();
                } else {
                    restartPos = (int)file.length();
                }
                this.source.downLoadFile(targetDir, sourceFileName, targetFileName, restartPos);
                result = true;
            }
            catch (Exception e) {
                if (this.seqNoOfFileInProcess != -1 && file != null && file.length() == this.source.fileDesc[this.seqNoOfFileInProcess].size) {
                    System.err.println("Size of the downloaded file is correct.");
                    System.err.println("Ignore replay error: " + e.toString());
                    result = true;
                    break;
                }
                this.lastCopyErrorType = this.source.tryReconnectReadOperation(e, attempt, restartPos);
                if (this.lastCopyErrorType != 0) {
                    this.addError(e.toString());
                    result = false;
                    break;
                }
                ++attempt;
                continue;
            }
            break;
        }
        return result;
    }

    private boolean copyFromLocalToFTP(String sourceFileName, String targetFileName) {
        boolean result = true;
        String sourceDir = this.source.getParsedAddr().path;
        try {
            this.target.upLoadFile(sourceDir, sourceFileName, String.valueOf(targetFileName) + ".TMP");
            result = this.target.rename(String.valueOf(targetFileName) + ".TMP", targetFileName);
        }
        catch (Exception e) {
            this.addError(e.toString());
            result = false;
        }
        return result;
    }

    private boolean copyFromLocalToLocal(String sourceFileName, String targetFileName) {
        boolean result = true;
        File inFile = new File(this.source.getParsedAddr().path, sourceFileName);
        File outFile = new File(this.target.getParsedAddr().path, targetFileName);
        outFile.delete();
        String inName = inFile.getPath();
        String outName = outFile.getPath();
        try {
            FileRW.fileCopy(inName, outName);
        }
        catch (IOException e) {
            this.addError(e.toString());
            result = false;
        }
        return result;
    }

    private void addError(String errorMsg) {
        if (this.errors == null) {
            this.errors = new ArrayList<String>();
        }
        this.errors.add(errorMsg);
        Console.showError(errorMsg);
    }

    public static Object[] copyDated(String sourceDir, String targetDir, String fileDateMask, TimeScale start, TimeScale end) {
        Object[] objectArray = new Object[2];
        objectArray[1] = new FileDesc[0];
        Object[] result = objectArray;
        FiledescTimeFilter filter = new FiledescTimeFilter(new DateMaskStringFilter(MaskBuilder.dateByMask(fileDateMask), start, end), FileFilterType.TYPE_FILE);
        Filer filer = new Filer(sourceDir, targetDir, filter);
        if (filer.connect()) {
            try {
                filer.copyFiles();
                if (filer.getResult()) {
                    result[1] = filer.source.fileDesc;
                }
                List<String> errs = filer.getErros();
                result[0] = errs.get(errs.size() - 1);
                int numberOfCopied = filer.getQtyOfCopied();
                FileDesc[] copiedFiles = new FileDesc[numberOfCopied];
                int k = 0;
                int[] indOfnotCopied = filer.getIndOfNotCopied();
                int i = 0;
                while (i < errs.size()) {
                    if (Search.scan(indOfnotCopied, i) < 0) {
                        copiedFiles[k++] = filer.source.fileDesc[i];
                    }
                    ++i;
                }
                result[1] = copiedFiles;
            }
            finally {
                filer.disconnect();
            }
        } else {
            result[0] = filer.source.error != null ? filer.source.error : (filer.target.error != null ? filer.target.error : "error during connection");
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    public static boolean moveAll(String sourceDir, String targetDir, FilenameFilter filter, boolean dontDeleteTargets) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean moveAll(String sourceDir, String targetDir, FilenameFilter filter) {
        return Filer.moveAll(sourceDir, targetDir, filter, false);
    }

    public static boolean moveAll(String sourceDir, String targetDir) {
        return Filer.moveAll(sourceDir, targetDir, null);
    }

    public static boolean moveAll(String sourceDir, String targetDir, boolean dontDeleteTargets) {
        return Filer.moveAll(sourceDir, targetDir, null, dontDeleteTargets);
    }

    /*
     * Exception decompiling
     */
    public static boolean copyAll(String sourceDir, String targetDir, FilenameFilter filter, boolean dontDeleteTargets) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean copyAll(String sourceDir, String targetDir, FilenameFilter filter) throws IOException {
        return Filer.copyAll(sourceDir, targetDir, filter, false);
    }

    public static boolean copyAll(String sourceDir, String targetDir) throws IOException {
        return Filer.copyAll(sourceDir, targetDir, null);
    }

    public static boolean copyAll(String sourceDir, String targetDir, boolean dontDeleteTargets) throws IOException {
        return Filer.copyAll(sourceDir, targetDir, null, dontDeleteTargets);
    }

    public static boolean copyRcrsAll(String sourceDir, String targetDir, FilenameFilter filter, boolean dontDeleteTargets) throws IOException {
        return Filer.copyRcrsAll(sourceDir, targetDir, filter, dontDeleteTargets, false);
    }

    public static boolean copyRcrsAll(String sourceDir, String targetDir, FilenameFilter filter) throws IOException {
        return Filer.copyRcrsAll(sourceDir, targetDir, filter, false);
    }

    public static boolean copyRcrsAll(String sourceDir, String targetDir) throws IOException {
        return Filer.copyRcrsAll(sourceDir, targetDir, null);
    }

    public static boolean copyRcrsAll(String sourceDir, String targetDir, boolean dontDeleteTargets) throws IOException {
        return Filer.copyRcrsAll(sourceDir, targetDir, null, dontDeleteTargets);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private static boolean copyRcrsAll(String sourceDir, String targetDir, FilenameFilter filter, boolean dontDeleteTargets, boolean internal) throws IOException {
        dirFile = new File(sourceDir);
        if (!dirFile.isDirectory()) {
            return false;
        }
        if (dirFile.equals(new File(targetDir))) {
            return false;
        }
        if (!new File(targetDir).exists()) {
            if (!internal) {
                return false;
            }
            if (!new File(targetDir).mkdir()) {
                return false;
            }
        } else if (!new File(targetDir).isDirectory()) {
            return false;
        }
        if ((list = dirFile.list(filter)) == null) {
            return false;
        }
        result = true;
        i = 0;
        while (i < list.length) {
            block15: {
                block16: {
                    sFile = new File(sourceDir, list[i]);
                    tFile = new File(targetDir, list[i]);
                    if (!sFile.isFile()) break block16;
                    if (!tFile.exists()) ** GOTO lbl-1000
                    if (!tFile.isFile()) {
                        result = false;
                        break block15;
                    } else if (!dontDeleteTargets) {
                        ** if (tFile.delete()) goto lbl-1000
lbl-1000:
                        // 1 sources

                        {
                            result = false;
                            break block15;
                        }
                    }
                    break block15;
lbl-1000:
                    // 2 sources

                    {
                        FileRW.fileCopy(sFile.getAbsolutePath(), tFile.getAbsolutePath());
                    }
                    break block15;
                }
                if (sFile.isDirectory()) {
                    result = Filer.copyRcrsAll(sFile.getAbsolutePath(), tFile.getAbsolutePath(), filter, dontDeleteTargets, true) != false && result != false;
                }
            }
            ++i;
        }
        return result;
    }

    public static void copyFromStreamToStream(InputStream in, OutputStream out) throws IOException {
        byte[] buf = new byte[4096];
        while (in.available() > 0) {
            int len = in.read(buf);
            if (len == -1) break;
            out.write(buf, 0, len);
        }
    }
}

