/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.fileio;

import edu.uml.lgdc.fileio.FileRW;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Vector;
import javax.swing.filechooser.FileFilter;

public class InsensitiveExtFilter
extends FileFilter
implements FilenameFilter {
    private Vector<String> vExt = new Vector();
    private String description = "";
    private boolean includeDirectories;
    private boolean asteriskExtensionPresent;

    public InsensitiveExtFilter(String ext) {
        this(ext, false);
    }

    public InsensitiveExtFilter(String ext, boolean includeDirectories) {
        this(new String[]{ext}, includeDirectories);
    }

    public InsensitiveExtFilter(String[] extArray) {
        this(extArray, false);
    }

    public InsensitiveExtFilter(String[] extArray, boolean includeDirectories) {
        int i = 0;
        while (i < extArray.length) {
            this.vExt.addElement(extArray[i].toLowerCase());
            if (extArray[i].equals("*")) {
                this.asteriskExtensionPresent = true;
            }
            this.description = String.valueOf(this.description) + "*." + extArray[i] + ";";
            ++i;
        }
        this.includeDirectories = includeDirectories;
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        return this.accept(file.getPath());
    }

    @Override
    public boolean accept(File dir, String filename) {
        return this.accept(new File(dir, filename).getPath());
    }

    public boolean accept(String filename) {
        File file = new File(filename);
        if (!this.includeDirectories) {
            if (file.isDirectory()) {
                return false;
            }
        } else if (file.isDirectory()) {
            return true;
        }
        if (this.asteriskExtensionPresent) {
            return true;
        }
        String extension = FileRW.getExt(filename).toLowerCase();
        for (String ext : this.vExt) {
            if (ext.length() != extension.length()) continue;
            if (ext.length() == 0) {
                return true;
            }
            if (!extension.equals(ext)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

