/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.fileio;

import edu.uml.lgdc.fileio.MaskBuilder;
import edu.uml.lgdc.fileio.MaskStringFilter;
import java.io.File;
import java.io.FilenameFilter;

public class InsensitiveFilenameFilter
implements FilenameFilter {
    private String[] fileNames;
    private MaskStringFilter[] filters;

    public InsensitiveFilenameFilter(String fileName) {
        this(new String[]{fileName});
    }

    public InsensitiveFilenameFilter(String[] fileNames) {
        this.fileNames = fileNames;
        this.buildStringFilters();
    }

    @Override
    public boolean accept(File dir, String name) {
        boolean accepted = false;
        int i = 0;
        while (i < this.filters.length) {
            if (this.filters[i].accept(name)) {
                accepted = true;
                break;
            }
            ++i;
        }
        return accepted;
    }

    private void buildStringFilters() {
        this.filters = new MaskStringFilter[this.fileNames.length];
        int i = 0;
        while (i < this.fileNames.length) {
            this.filters[i] = new MaskStringFilter(MaskBuilder.dateByMask(this.fileNames[i], false, true));
            ++i;
        }
    }
}

