/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.fileio;

import edu.uml.lgdc.datatype.ArrVec;
import edu.uml.lgdc.project.CommonConst;
import edu.uml.lgdc.project.Portable;
import java.io.File;
import java.util.ArrayList;

public class PortablePath
implements Portable,
Cloneable {
    private final File baseAbsPath;
    private String path;
    private final File[] baseAbsPathChain;
    private String internalPath;
    private String portablePath;

    public PortablePath() {
        this(new File(CommonConst.getWorkingDir()));
    }

    public PortablePath(File baseAbsPath) {
        this(baseAbsPath, ".");
    }

    public PortablePath(File baseAbsPath, String path) {
        if (baseAbsPath == null) {
            throw new IllegalArgumentException("baseAbsPath is null");
        }
        if (!baseAbsPath.exists()) {
            throw new IllegalArgumentException("baseAbsPath is not found");
        }
        if (!baseAbsPath.isDirectory()) {
            throw new IllegalArgumentException("baseAbsPath is not a directory");
        }
        if (!baseAbsPath.isAbsolute()) {
            throw new IllegalArgumentException("baseAbsPath is not an absolute path");
        }
        this.baseAbsPath = baseAbsPath;
        this.baseAbsPathChain = PortablePath.buildFilePathChain(baseAbsPath);
        this.setInternal(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getInternal() {
        String tmpInternalPath = this.internalPath;
        if (tmpInternalPath == null) {
            PortablePath portablePath = this;
            synchronized (portablePath) {
                if (this.internalPath == null) {
                    this.internalPath = this.getAbsolutePath();
                }
                return this.internalPath;
            }
        }
        return tmpInternalPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInternal(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        PortablePath portablePath = this;
        synchronized (portablePath) {
            this.path = path;
            this.internalPath = null;
            this.portablePath = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPortable() {
        String tmpPortablePath = this.portablePath;
        if (tmpPortablePath == null) {
            PortablePath portablePath = this;
            synchronized (portablePath) {
                if (this.portablePath == null) {
                    this.portablePath = this.getRelPathIfPossible(this.path);
                }
                return this.portablePath;
            }
        }
        return tmpPortablePath;
    }

    @Override
    public void setPortable(String portablePath) {
        this.setInternal(portablePath.replace('/', File.separatorChar));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return new File(this.getInternal()).equals(new File(((PortablePath)object).getInternal()));
    }

    public Object clone() {
        try {
            return (PortablePath)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String toString() {
        return this.getPortable();
    }

    private String getRelPathIfPossible(String path) {
        File absPath = new File(path).getAbsoluteFile();
        File[] absPathChain = PortablePath.buildFilePathChain(absPath);
        int minLength = Math.min(this.baseAbsPathChain.length, absPathChain.length);
        int numberOfEqualed = 0;
        int i = 0;
        while (i < minLength) {
            if (!this.baseAbsPathChain[i].equals(absPathChain[i])) break;
            ++numberOfEqualed;
            ++i;
        }
        if (numberOfEqualed == this.baseAbsPathChain.length) {
            if (absPathChain.length > this.baseAbsPathChain.length) {
                path = absPathChain[this.baseAbsPathChain.length].getName();
                i = this.baseAbsPathChain.length + 1;
                while (i < absPathChain.length) {
                    path = String.valueOf(path) + "/" + absPathChain[i].getName();
                    ++i;
                }
            } else {
                path = "";
            }
        } else {
            path = path.replace('\\', '/');
        }
        return path;
    }

    private String getAbsolutePath() {
        File[] absPathChain;
        File pathFile = new File(this.path);
        File absPathFile = new File(this.path).getAbsoluteFile();
        File[] pathChain = PortablePath.buildFilePathChain(pathFile);
        if (pathChain.length == (absPathChain = PortablePath.buildFilePathChain(absPathFile)).length) {
            return pathFile.getAbsolutePath();
        }
        return new File(this.baseAbsPath, this.path).getAbsolutePath();
    }

    public static String fromPortable(String filename) {
        return PortablePath.fromPortable(new File(CommonConst.getWorkingDir()), filename);
    }

    public static String fromPortable(File baseAbsPath, String filename) {
        PortablePath portablePath = new PortablePath(baseAbsPath);
        portablePath.setPortable(filename);
        return portablePath.getInternal();
    }

    public static String toPortable(String filename) {
        return PortablePath.toPortable(new File(CommonConst.getWorkingDir()), filename);
    }

    public static String toPortable(File baseAbsPath, String filename) {
        PortablePath portablePath = new PortablePath(baseAbsPath);
        portablePath.setInternal(filename);
        return portablePath.getPortable();
    }

    private static File[] buildFilePathChain(File file) {
        ArrayList<File> lstChain = new ArrayList<File>();
        do {
            lstChain.add(file);
        } while ((file = file.getParentFile()) != null);
        Object[] result = lstChain.toArray(new File[lstChain.size()]);
        ArrVec.mirror(result);
        return result;
    }
}

