/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.fileio;

import edu.uml.lgdc.fileio.FileRW;
import edu.uml.lgdc.multithread.BinSemaphore;
import edu.uml.lgdc.project.Console;
import java.io.File;
import java.io.IOException;

public class SharedFileRW {
    public static final long NO_KEY = -1L;
    private FileRW file;
    private transient long currentKey = -1L;
    private transient long nextKey = 1L;
    private transient int awaitingQty;
    private transient boolean requestToClose;
    private transient Runnable afterCloseAction;
    private BinSemaphore semaphore = new BinSemaphore(true);

    public SharedFileRW(FileRW file) {
        if (file == null) {
            throw new IllegalArgumentException("file is null");
        }
        this.file = file;
    }

    public void write(long key, byte[] buffer) throws IOException {
        this.check(key);
        this.file.write(buffer);
    }

    public void seek(long key, long position) throws IOException {
        this.check(key);
        this.file.seek(position);
    }

    public void copyToFile(long key, String filename) throws IOException {
        this.check(key);
        this.file.copyToFile(filename);
    }

    public long length() throws IOException {
        this.check();
        return this.file.length();
    }

    public void setLength(long key, long pos) throws IOException {
        this.check(key);
        this.file.setLength(pos);
    }

    public FileRW getFileRW(long key) throws IOException {
        this.check(key);
        return this.file;
    }

    public String getFullFileName() {
        this.check();
        return this.file.getFullFileName();
    }

    private void check(long key) throws IOException {
        this.check();
        if (this.currentKey == -1L || key != this.currentKey) {
            throw new IOException("illegal key");
        }
    }

    private void check() {
        if (this.file == null) {
            throw new RuntimeException("SharedFileRW already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long lock() throws InterruptedException {
        try {
            SharedFileRW sharedFileRW = this;
            synchronized (sharedFileRW) {
                if (this.file == null) {
                    return -1L;
                }
                ++this.awaitingQty;
            }
            this.semaphore.pend(0);
            sharedFileRW = this;
            synchronized (sharedFileRW) {
                --this.awaitingQty;
                this.newKey();
                return this.currentKey;
            }
        }
        catch (InterruptedException e) {
            SharedFileRW sharedFileRW = this;
            synchronized (sharedFileRW) {
                --this.awaitingQty;
                throw new InterruptedException(e.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(long key) {
        SharedFileRW sharedFileRW = this;
        synchronized (sharedFileRW) {
            if (this.currentKey == -1L || key != this.currentKey) {
                return;
            }
            if (this.requestToClose && this.awaitingQty == 0) {
                this.closeIt();
            }
            this.semaphore.post();
            this.currentKey = -1L;
        }
    }

    public synchronized void close() {
        this.close(null);
    }

    public synchronized void close(Runnable afterCloseAction) {
        if (this.requestToClose) {
            return;
        }
        this.afterCloseAction = afterCloseAction;
        if (this.awaitingQty == 0 && this.currentKey == -1L) {
            this.closeIt();
            this.requestToClose = false;
        } else {
            this.requestToClose = true;
        }
    }

    private void newKey() {
        this.currentKey = this.nextKey++;
    }

    private void closeIt() {
        if (this.file != null) {
            try {
                try {
                    this.file.close();
                    File f = new File(this.file.getFullFileName());
                    if (f.length() == 0L) {
                        f.delete();
                    }
                    if (this.afterCloseAction != null) {
                        this.afterCloseAction.run();
                    }
                }
                catch (IOException e) {
                    Console.printThreadStackTrace(e);
                    this.file = null;
                }
            }
            finally {
                this.file = null;
            }
        }
    }

    protected void finalize() throws Throwable {
        this.closeIt();
        super.finalize();
    }
}

