/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.fileio;

import edu.uml.lgdc.fileio.FileRW;
import edu.uml.lgdc.format.FC;
import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.time.TimeScale;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Random;

public class UniqueFile {
    private String path = "." + File.separator;
    private Random random = null;

    public UniqueFile(String path) {
        this.path = path;
        this.random = UniqueFile.createRandom();
    }

    public String createWithExt(String ext) {
        return UniqueFile.create(this.path, this.random, ext);
    }

    public String create() {
        return UniqueFile.create(this.path, this.random, "");
    }

    public static String create(String path) {
        return UniqueFile.create(path, UniqueFile.createRandom(), "");
    }

    public static String create(String path, String ext) {
        return UniqueFile.create(path, UniqueFile.createRandom(), ext);
    }

    private static String create(String path, Random random, String ext) {
        File file = null;
        while (true) {
            boolean error;
            block16: {
                String fileName;
                if ((file = new File(path, String.valueOf(fileName = FC.padRight("" + Math.abs(random.nextLong()), 8, '0')) + ext)).isFile() || file.isDirectory()) {
                    continue;
                }
                RandomAccessFile temp = null;
                error = true;
                try {
                    try {
                        temp = new FileRW(file.getPath(), "rw");
                        temp.close();
                        temp = null;
                        error = false;
                    }
                    catch (IOException e) {
                        System.out.println(e.toString());
                        if (temp != null) {
                            try {
                                temp.close();
                            }
                            catch (IOException ex) {
                                Console.printThreadStackTrace(ex);
                            }
                        }
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    if (temp != null) {
                        try {
                            temp.close();
                        }
                        catch (IOException ex) {
                            Console.printThreadStackTrace(ex);
                        }
                    }
                    throw throwable;
                }
                if (temp != null) {
                    try {
                        temp.close();
                    }
                    catch (IOException ex) {
                        Console.printThreadStackTrace(ex);
                    }
                }
            }
            if (!error) break;
        }
        return file.getAbsolutePath();
    }

    public static String getFullFileName(String path, String ext) {
        Random random = UniqueFile.createRandom();
        return UniqueFile.getFullFileName(path, random, ext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFullFileName(String path, Random random, String ext) {
        String fileName = null;
        Random random2 = random;
        synchronized (random2) {
            fileName = FC.padRight("" + Math.abs(random.nextLong()), 8, '0');
        }
        if (!path.endsWith(File.separator)) {
            path = String.valueOf(path) + File.separator;
        }
        return String.valueOf(path) + fileName + ext;
    }

    private static Random createRandom() {
        Random random = new Random();
        random.setSeed(new TimeScale().getTimeInMilliSeconds());
        return random;
    }
}

