/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.format;

import edu.uml.lgdc.datatype.PoolOfObjects;
import edu.uml.lgdc.format.FC;
import edu.uml.lgdc.gui.HotKeyButton;
import java.awt.Color;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import javax.swing.AbstractButton;

public class C {
    public static final char CR = '\u0013';
    public static final char LF = '\u0010';
    public static final String EOL = "\n";
    public static final int EOF = -1;
    public static final int EOS = -1;
    public static final int EOD = -1;
    public static final boolean CASE_SENSITIVE_FILE_SYSTEM = !new File("a").equals(new File("A"));
    public static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    public static final PoolOfObjects<CharsetDecoder> DECODERS = new PoolOfObjects<CharsetDecoder>(){

        @Override
        protected CharsetDecoder createInstanceOfObject() {
            return ISO_8859_1.newDecoder();
        }
    };
    public static final PoolOfObjects<CharsetEncoder> ENCODERS = new PoolOfObjects<CharsetEncoder>(){

        @Override
        protected CharsetEncoder createInstanceOfObject() {
            return ISO_8859_1.newEncoder();
        }
    };
    public static final String SYS_EXE_EXT_PROP_NAME = "system.executable.ext";
    public static final String WIN_EXE_EXT = ".exe";
    public static final String UNX_EXE_EXT = ".bin";
    public static final String MAC_EXE_EXT = ".app";
    private static Rectangle SCR;
    public static final String STR_BLANKS = "                                                                                                                            ";
    public static final String STR_ZEROES = "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
    public static final String STR_STARS = "****************************************************************************************************************************";
    public static final int STR_PAD_LENGTH;
    public static final String DIGITS = "0123456789";
    public static final String HEX_DIGITS = "0123456789ABCDEF";
    public static final String SMALL_ALPHA = "abcdefghijklmnopqrstuvwxyz";
    public static final String CAP_ALPHA = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String ALPHA = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final int BITS_PER_BYTE = 8;
    public static final int LOW_BYTE = 255;
    public static final int ALL_ONES = -1;
    public static final long ALL_ONES_LONG = -1L;
    public static final Color COLOR_HOT_KEY;
    private static final String COLOR_HOT_KEY_STR;
    private static final String HOT_KEY_START_TAG_COLOR;
    private static final String HOT_KEY_END_TAG_COLOR = "</FONT>";
    private static final String HOT_KEY_START_TAG_COLOR_AND_UNDERLINE;
    private static final String HOT_KEY_END_TAG_COLOR_AND_UNDERLINE = "</U></FONT>";
    private static final String HOT_KEY_START_TAG_UNDERLINE = "<U>";
    private static final String HOT_KEY_END_TAG_UNDERLINE = "</U>";
    public static final double INCH_TO_CM = 2.54;
    public static final double CM_TO_INCH = 0.39370078740157477;
    public static final int CONVENTIONAL_SCR_RES_IN_PPI = 72;
    public static final String[] INFO_VOLUME_UNITS_NAMES;
    public static final String NBSP = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
    public static final char UC_ARROW_LT = '\u2190';
    public static final char UC_ARROW_UP = '\u2191';
    public static final char UC_ARROW_RT = '\u2192';
    public static final char UC_ARROW_DN = '\u2193';
    public static final char UC_ARROW_UP_WITH_PEDESTAL = '\u21a5';
    public static final char UC_GREEK_OMEGA_CAP = '\u2126';
    public static final char UC_GREEK_PHI = '\u03c6';
    public static final char UC_GREEK_PHI_CAP = '\u03d5';
    public static final char UC_GREEK_PSI = '\u03c8';
    public static final char UC_GREEK_PSI_CAP = '\u03a8';
    public static final char UC_GREEK_MU = '\u03bc';
    public static final char UC_LESS_OR_EQUAL = '\u2264';
    public static final char UC_PLUS_MINUS = '\u00b1';
    public static final char UC_INFINITY = '\u221e';
    public static final char UC_APPROX_EQUAL = '\u2248';
    public static final char UC_DEGREE = '\u00b0';
    public static final char UC_CELSIUS_DEG = '\u2103';
    public static final char UC_MIDDLE_DOT = '\u00b7';
    public static final char UC_CCW = '\u21b6';
    public static final char UC_CW = '\u21b7';

    static {
        if (STR_BLANKS.length() != STR_ZEROES.length() || STR_BLANKS.length() != STR_STARS.length()) {
            throw new RuntimeException("design error: STR_BLANKS.length() != STR_ZEROES.length() || STR_BLANKS.length() != STR_STARS.length()");
        }
        STR_PAD_LENGTH = STR_BLANKS.length();
        COLOR_HOT_KEY = new Color(154, 50, 24);
        COLOR_HOT_KEY_STR = C.getHtmlColorStr(COLOR_HOT_KEY);
        HOT_KEY_START_TAG_COLOR = "<FONT COLOR=\"" + COLOR_HOT_KEY_STR + "\">";
        HOT_KEY_START_TAG_COLOR_AND_UNDERLINE = "<FONT COLOR=\"" + COLOR_HOT_KEY_STR + "\"><U>";
        INFO_VOLUME_UNITS_NAMES = new String[]{"B", "KB", "MB", "GB", "TB", "PB", "EB", "ZB", "YB"};
    }

    public static String getHtmlColorStr(Color color) {
        String str = "#";
        str = String.valueOf(str) + FC.int2HexStr(color.getRed(), 2) + FC.int2HexStr(color.getGreen(), 2) + FC.int2HexStr(color.getBlue(), 2);
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Rectangle getVirtScrSize() {
        if (SCR != null) return SCR;
        Class<C> clazz = C.class;
        synchronized (C.class) {
            GraphicsDevice[] gds;
            if (SCR != null) return SCR;
            Rectangle virtualBounds = new Rectangle();
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] graphicsDeviceArray = gds = ge.getScreenDevices();
            int n = gds.length;
            int n2 = 0;
            while (n2 < n) {
                GraphicsConfiguration[] gcs;
                GraphicsDevice gd = graphicsDeviceArray[n2];
                GraphicsConfiguration[] graphicsConfigurationArray = gcs = gd.getConfigurations();
                int n3 = gcs.length;
                int n4 = 0;
                while (n4 < n3) {
                    GraphicsConfiguration gc = graphicsConfigurationArray[n4];
                    virtualBounds = virtualBounds.union(gc.getBounds());
                    ++n4;
                }
                ++n2;
            }
            SCR = virtualBounds;
            // ** MonitorExit[var0] (shouldn't be in output)
            return SCR;
        }
    }

    public static void setHotKey(AbstractButton button, String text, char key) {
        HotKeyButton.setKey(button, text, key, HOT_KEY_START_TAG_COLOR, HOT_KEY_END_TAG_COLOR);
    }

    public static void setHotKey(AbstractButton button, String text, int pos) {
        HotKeyButton.setKey(button, text, pos, HOT_KEY_START_TAG_COLOR, HOT_KEY_END_TAG_COLOR);
    }

    public static void setHotKey_cu(AbstractButton button, String text, char key) {
        HotKeyButton.setKey(button, text, key, HOT_KEY_START_TAG_COLOR_AND_UNDERLINE, HOT_KEY_END_TAG_COLOR_AND_UNDERLINE);
    }

    public static void setHotKey_cu(AbstractButton button, String text, int pos) {
        HotKeyButton.setKey(button, text, pos, HOT_KEY_START_TAG_COLOR_AND_UNDERLINE, HOT_KEY_END_TAG_COLOR_AND_UNDERLINE);
    }

    public static void setHotKey_u(AbstractButton button, String text, char key) {
        HotKeyButton.setKey(button, text, key, HOT_KEY_START_TAG_COLOR, HOT_KEY_END_TAG_COLOR);
    }

    public static void setHotKey_u(AbstractButton button, String text, int pos) {
        HotKeyButton.setKey(button, text, pos, HOT_KEY_START_TAG_UNDERLINE, HOT_KEY_END_TAG_UNDERLINE);
    }

    public static String emphasizeChar_c(String text, char hotKey) {
        return C.emphasizeChar(text, hotKey, HOT_KEY_START_TAG_COLOR, HOT_KEY_END_TAG_COLOR);
    }

    public static String emphasizeChar_u(String text, char hotKey) {
        return C.emphasizeChar(text, hotKey, HOT_KEY_START_TAG_UNDERLINE, HOT_KEY_END_TAG_UNDERLINE);
    }

    public static String emphasizeChar_cu(String text, char hotKey) {
        return C.emphasizeChar(text, hotKey, HOT_KEY_START_TAG_COLOR_AND_UNDERLINE, HOT_KEY_END_TAG_COLOR_AND_UNDERLINE);
    }

    public static String emphasizeChar_c(String text, int pos) {
        return C.emphasizeChar(text, pos, HOT_KEY_START_TAG_COLOR, HOT_KEY_END_TAG_COLOR);
    }

    public static String emphasizeChar_u(String text, int pos) {
        return C.emphasizeChar(text, pos, HOT_KEY_START_TAG_UNDERLINE, HOT_KEY_END_TAG_UNDERLINE);
    }

    public static String emphasizeChar_cu(String text, int pos) {
        return C.emphasizeChar(text, pos, HOT_KEY_START_TAG_COLOR_AND_UNDERLINE, HOT_KEY_END_TAG_COLOR_AND_UNDERLINE);
    }

    public static String emphasizeChar(String text, char hotKey, String startTag, String endTag) {
        String resultText = text;
        int pos = text.indexOf(hotKey);
        if (pos >= 0) {
            resultText = "<HTML>" + text.substring(0, pos) + startTag + text.substring(pos, pos + 1) + endTag + text.substring(pos + 1) + "</HTML>";
        }
        return resultText;
    }

    public static String emphasizeChar(String text, int pos, String startTag, String endTag) {
        return "<HTML>" + text.substring(0, pos) + startTag + text.substring(pos, pos + 1) + endTag + text.substring(pos + 1) + "</HTML>";
    }
}

