/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.format;

import edu.uml.lgdc.format.StrUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

public class FC {
    public static final int ORDER_NORMAL = 0;
    public static final int ORDER_INVERTED = 1;
    public static final int LOW_BYTE = 255;
    private static short a_short;
    public static final String HEX_DIGITS = "0123456789ABCDEF";
    public static final String STR_BLANKS = "                                                                                                                            ";
    public static final String STR_ZEROES = "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";

    public static byte high_nibble(byte in) {
        return (byte)((in & 0xF0) >> 4);
    }

    public static byte low_nibble(byte in) {
        return (byte)(in & 0xF);
    }

    public static final double getDelta(int precision) {
        return 5.0 * Math.pow(10.0, -(precision + 1));
    }

    public static final double round(double value, int precision) {
        double factor = Math.pow(10.0, precision);
        long l = Math.round(value * factor);
        double d = (double)l / factor;
        return d;
    }

    public static final String padLeft(String str, int width) {
        return FC.padLeft(str, width, ' ');
    }

    public static final String padLeft(String str, int width, char ch) {
        int length = str.length();
        if (length == width) {
            return str;
        }
        if (length > width) {
            return str.substring(length - width, length);
        }
        int padLen = width - length;
        char[] chArr = new char[width];
        int i = 0;
        while (i < padLen) {
            chArr[i] = ch;
            ++i;
        }
        i = padLen;
        int j = 0;
        while (i < width) {
            chArr[i] = str.charAt(j);
            ++i;
            ++j;
        }
        return new String(chArr);
    }

    public static final String padRight(String str, int width) {
        return FC.padRight(str, width, ' ');
    }

    public static final String padRight(String str, int width, char ch) {
        int length = str.length();
        if (length == width) {
            return str;
        }
        if (length > width) {
            return str.substring(0, width);
        }
        char[] chArr = new char[width];
        int i = 0;
        while (i < length) {
            chArr[i] = str.charAt(i);
            ++i;
        }
        i = length;
        while (i < width) {
            chArr[i] = ch;
            ++i;
        }
        return new String(chArr);
    }

    public static int nibbles2Int(byte[] in, int nibbleOffset, int qty) {
        return FC.nibbles2Int(in, nibbleOffset, qty, false);
    }

    public static int nibbles2Int(byte[] in, int nibbleOffset, int qty, boolean inverted) {
        int value = 0;
        boolean upper = (nibbleOffset + qty - 1) % 2 == 0;
        int i = 0;
        while (i < qty) {
            int nibblePosition = !inverted ? (nibbleOffset + qty - 1 - i) / 2 : (nibbleOffset + i) / 2;
            byte nibble = upper ? (byte)(in[nibblePosition] >> 4) : in[nibblePosition];
            nibble = (byte)(nibble & 0xF);
            value |= nibble << i * 4;
            upper = !upper;
            ++nibbleOffset;
            ++i;
        }
        return value;
    }

    public static int BCDtoInt(byte[] in, int nibbleOffset, int qty) {
        int value = 0;
        boolean upper = nibbleOffset % 2 == 0;
        int i = 0;
        while (i < qty) {
            byte digit = upper ? (byte)(in[nibbleOffset / 2] >> 4) : in[nibbleOffset / 2];
            if ((digit = (byte)(digit & 0xF)) > 9) {
                value = Integer.MAX_VALUE;
                break;
            }
            value = 10 * value + digit;
            upper = !upper;
            ++nibbleOffset;
            ++i;
        }
        return value;
    }

    public static int BCDBytes2Int(byte[] in, int start, int length) {
        return FC.BCDBytes2Int(in, start, length, false);
    }

    public static int BCDBytes2Int(byte[] in, int start, int length, boolean inverted) {
        int value = 0;
        int i = 0;
        while (i < length) {
            byte digit = !inverted ? in[start + i] : in[start + length - 1 - i];
            if (digit > 9 || digit < 0) {
                value = Integer.MAX_VALUE;
                break;
            }
            value = 10 * value + digit;
            ++i;
        }
        return value;
    }

    public static void int2BCDBytes(int value, byte[] in, int start, int length) {
        FC.int2BCDBytes(value, in, start, length, false);
    }

    public static void int2BCDBytes(int value, byte[] in, int start, int length, boolean inverted) {
        int index = !inverted ? start + length - 1 : start;
        int i = 0;
        while (i < length) {
            if (!inverted) {
                in[index--] = (byte)(value % 10);
            } else {
                in[index++] = (byte)(value % 10);
            }
            value /= 10;
            ++i;
        }
    }

    public static int BCHDBytes2Int(byte[] in, int start, int length) {
        return FC.BCHDBytes2Int(in, start, length, false);
    }

    public static int BCHDBytes2Int(byte[] in, int start, int length, boolean inverted) {
        int value = 0;
        int i = 0;
        while (i < length) {
            byte digit = !inverted ? in[start + i] : in[start + length - 1 - i];
            if (digit > 15 || digit < 0) {
                value = Integer.MAX_VALUE;
                break;
            }
            value = 16 * value + digit;
            ++i;
        }
        return value;
    }

    public static void int2BCHDBytes(int value, byte[] in, int start, int length) {
        FC.int2BCHDBytes(value, in, start, length, false);
    }

    public static void int2BCHDBytes(int value, byte[] in, int start, int length, boolean inverted) {
        int index = !inverted ? start + length - 1 : start;
        int i = 0;
        while (i < length) {
            if (!inverted) {
                in[index--] = (byte)(value % 16);
            } else {
                in[index++] = (byte)(value % 16);
            }
            value /= 16;
            ++i;
        }
    }

    public static int bytes2Int(byte[] in, int start, int length) {
        return FC.bytes2Int(in, start, length, false);
    }

    public static int bytes2Int(byte[] in, int start, int length, boolean inverted) {
        FC.checkBytes2Int(in, start, length);
        return FC.convertBytes2Int(in, start, length, inverted, false);
    }

    private static void checkBytes2Int(byte[] in, int start, int length) {
        if (length <= 0 || length > 4) {
            throw new IllegalArgumentException("Length should be > 0 and less or equal than 4");
        }
        if (start < 0) {
            throw new IllegalArgumentException("Start should not be less than 0");
        }
        if (start + length > in.length) {
            throw new IllegalArgumentException("Start + length should not be greater than in.lenght()");
        }
    }

    private static int convertBytes2Int(byte[] in, int start, int length, boolean inverted, boolean asUnsigned) {
        int inc;
        int ind;
        int value = 0;
        boolean negative = false;
        if (!inverted) {
            ind = start;
            inc = 1;
            negative = !asUnsigned && in[start] < 0;
        } else {
            ind = start + length - 1;
            inc = -1;
            negative = !asUnsigned && in[start + length - 1] < 0;
        }
        int i = 0;
        while (i < length) {
            value = value << 8 | in[ind] & 0xFF;
            ind += inc;
            ++i;
        }
        if (negative && length < 4) {
            int shift = (4 - length) * 8;
            value <<= shift;
            value >>= shift;
        }
        return value;
    }

    private static void checkBytes2Long(byte[] in, int start, int length) {
        if (length <= 0 || length > 8) {
            throw new IllegalArgumentException("Length should be > 0 and less or equal than 8");
        }
        if (start < 0) {
            throw new IllegalArgumentException("Start should not be less than 0");
        }
        if (start + length > in.length) {
            throw new IllegalArgumentException("Start + length should be greater than length in *in*");
        }
    }

    public static long bytes2Long(byte[] in, int start, int length, boolean inverted) {
        FC.checkBytes2Long(in, start, length);
        return FC.convertBytes2Long(in, start, length, inverted, false);
    }

    private static long convertBytes2Long(byte[] in, int start, int length, boolean inverted, boolean asUnsigned) {
        int inc;
        int ind;
        long value = 0L;
        boolean negative = false;
        if (!inverted) {
            ind = start;
            inc = 1;
            negative = !asUnsigned && in[start] < 0;
        } else {
            ind = start + length - 1;
            inc = -1;
            negative = !asUnsigned && in[start + length - 1] < 0;
        }
        int i = 0;
        while (i < length) {
            value = value << 8 | (long)(in[ind] & 0xFF);
            ind += inc;
            ++i;
        }
        if (negative && length < 8) {
            int shift = (8 - length) * 8;
            value <<= shift;
            value >>= shift;
        }
        return value;
    }

    public static double bytes2Double(byte[] data, int offset) {
        return FC.bytes2Double(data, offset, false);
    }

    public static double bytes2Double(byte[] data, int offset, boolean inverted) {
        return Double.longBitsToDouble(FC.bytes2Long(data, offset, 8, inverted));
    }

    public static float bytes2Float(byte[] data, int offset) {
        return FC.bytes2Float(data, offset, false);
    }

    public static float bytes2Float(byte[] data, int offset, boolean inverted) {
        return Float.intBitsToFloat(FC.bytes2Int(data, offset, 4, inverted));
    }

    public static int unsignedBytes2Int(byte[] in, int start, int length) {
        return FC.unsignedBytes2Int(in, start, length, false);
    }

    public static int unsignedBytes2Int(byte[] in, int start, int length, boolean inverted) {
        FC.checkBytes2Int(in, start, length);
        int ind = start;
        if (inverted) {
            ind = start + length - 1;
        }
        if (length == 4 && in[ind] < 0) {
            throw new IllegalArgumentException("Value too big to fit in integer");
        }
        return FC.convertBytes2Int(in, start, length, inverted, true);
    }

    public static long unsignedBytes2Long(byte[] in, int start, int length) {
        return FC.unsignedBytes2Long(in, start, length, false);
    }

    public static long unsignedBytes2Long(byte[] in, int start, int length, boolean inverted) {
        FC.checkBytes2Long(in, start, length);
        int ind = start;
        if (inverted) {
            ind = start + length - 1;
        }
        if (length == 8 && in[ind] < 0) {
            throw new IllegalArgumentException("Value too big to fit in long");
        }
        return FC.convertBytes2Long(in, start, length, inverted, true);
    }

    public static long packBooleanArrayToLong(boolean[] switches) {
        if (switches.length > 64) {
            throw new IllegalArgumentException("length of switches > 64, (" + switches.length + ")");
        }
        byte[] array = FC.booleanArray2Bytes_left2right(switches);
        return FC.unsignedBytes2Long(array, 0, array.length);
    }

    public static boolean[] getBooleanArrayFromLong(long value, int length) {
        if (length > 64) {
            throw new IllegalArgumentException("length > 64, (" + length + ")");
        }
        int nBytes = (length + 7) / 8;
        byte[] array = new byte[nBytes];
        FC.convertLong2Bytes(value, array, 0, array.length);
        return FC.bytes2BooleanArray_left2right(array, length);
    }

    public static void convertInt2Bytes(int value, byte[] in, int start, int length) {
        FC.convertInt2Bytes(value, in, start, length, false);
    }

    public static void convertInt2Bytes(int value, byte[] in, int start, int length, boolean inverted) {
        int inc;
        int ind;
        int extraneousByteValue;
        int n = extraneousByteValue = value >= 0 ? 0 : -1;
        if (!inverted) {
            ind = start + length - 1;
            inc = -1;
        } else {
            ind = start;
            inc = 1;
        }
        int i = 0;
        while (i < length) {
            if (i < 4) {
                in[ind] = (byte)(value & 0xFF);
                value >>= 8;
            } else {
                in[ind] = extraneousByteValue;
            }
            ind += inc;
            ++i;
        }
    }

    public static void convertLong2Bytes(long value, byte[] in, int start, int length) {
        FC.convertLong2Bytes(value, in, start, length, false);
    }

    public static void convertLong2Bytes(long value, byte[] in, int start, int length, boolean inverted) {
        int inc;
        int ind;
        int extraneousByteValue;
        int n = extraneousByteValue = value >= 0L ? 0 : -1;
        if (!inverted) {
            ind = start + length - 1;
            inc = -1;
        } else {
            ind = start;
            inc = 1;
        }
        int i = 0;
        while (i < length) {
            if (i < 8) {
                in[ind] = (byte)(value & 0xFFL);
                value >>= 8;
            } else {
                in[ind] = extraneousByteValue;
            }
            ind += inc;
            ++i;
        }
    }

    public static void convertDouble2Bytes(double value, byte[] data, int offset) {
        FC.convertDouble2Bytes(value, data, offset, false);
    }

    public static void convertDouble2Bytes(double value, byte[] data, int offset, boolean inverted) {
        FC.convertLong2Bytes(Double.doubleToLongBits(value), data, offset, 8, inverted);
    }

    public static void convertFloat2Bytes(float value, byte[] data, int offset) {
        FC.convertFloat2Bytes(value, data, offset, false);
    }

    public static void convertFloat2Bytes(float value, byte[] data, int offset, boolean inverted) {
        FC.convertInt2Bytes(Float.floatToIntBits(value), data, offset, 4, inverted);
    }

    public static byte booleanArray2Byte(boolean[] values) {
        byte result = 0;
        int len = Math.min(values.length, 8);
        int i = 0;
        while (i < len) {
            if (values[i]) {
                result = (byte)(result | 1 << i);
            }
            ++i;
        }
        return result;
    }

    public static boolean[] byte2BooleanArray(byte value) {
        boolean[] result = new boolean[8];
        int i = 0;
        while (i < 8) {
            if ((value & 1) != 0) {
                result[i] = true;
            }
            value = (byte)(value >> 1);
            ++i;
        }
        return result;
    }

    public static byte[] booleanArray2Bytes_left2right(boolean[] values) {
        int bitQty = values.length;
        int byteQty = (bitQty + 7) / 8;
        byte[] array = new byte[byteQty];
        int byteIndex = -1;
        int bitIndex = 7;
        int i = 0;
        while (i < bitQty) {
            if (++bitIndex >= 8) {
                bitIndex = 0;
                array[++byteIndex] = 0;
            }
            if (values[i]) {
                int n = byteIndex;
                array[n] = (byte)(array[n] | 1 << bitIndex);
            }
            ++i;
        }
        return array;
    }

    public static boolean[] bytes2BooleanArray_left2right(byte[] array, int length) {
        if (length > array.length * 8) {
            throw new IllegalArgumentException("FC.bytes2BooleanArray: length is larger than number of bits in given array");
        }
        boolean[] values = new boolean[length];
        int byteIndex = -1;
        int bitIndex = 7;
        int arrElement = 0;
        int i = 0;
        while (i < length) {
            if (++bitIndex >= 8) {
                bitIndex = 0;
                arrElement = array[++byteIndex];
            } else {
                arrElement = (byte)(arrElement >> 1);
            }
            if ((arrElement & 1) != 0) {
                values[i] = true;
            }
            ++i;
        }
        return values;
    }

    public static byte asciiToNibble(byte in) {
        return (byte)(in > 57 ? in - 65 + 10 : in - 48);
    }

    public static byte BCD2toByte(byte[] in, int offset) {
        return (byte)(FC.high_nibble(in[offset]) * 10 + FC.low_nibble(in[offset]));
    }

    public static byte byteToBCD2(byte in) {
        byte result = (byte)(in % 10);
        byte tens = (byte)(in / 10 % 10);
        result = (byte)(result + (tens << 4));
        return result;
    }

    public static short BCD3stoShort(byte[] in, int offset) {
        a_short = (short)(FC.low_nibble(in[offset]) * 100 + FC.high_nibble(in[offset + 1]) * 10 + FC.low_nibble(in[offset + 1]));
        if (FC.high_nibble(in[offset]) == 9) {
            return -a_short;
        }
        return a_short;
    }

    public static short BCD4toShort(byte[] in, int offset) {
        return (short)(FC.high_nibble(in[offset]) * 1000 + FC.low_nibble(in[offset]) * 100 + FC.high_nibble(in[offset + 1]) * 10 + FC.low_nibble(in[offset + 1]));
    }

    public static short shortToBCD4(short in) {
        short result = (short)(in % 10);
        byte tens = (byte)(in / 10 % 10);
        byte hundreds = (byte)(in / 100 % 10);
        byte thousands = (byte)(in / 1000 % 10);
        result = (short)(result + (short)((tens << 4) + (hundreds << 8) + (thousands << 12)));
        return result;
    }

    public static void shortToBCD4(short number, byte[] out, int offset) {
        int d = 100;
        int i = 0;
        while (i < 2) {
            out[offset + i] = FC.byteToBCD2((byte)(number / d % 100));
            d /= 100;
            ++i;
        }
    }

    public static int BCD6toInt(byte[] in, int offset) {
        return FC.high_nibble(in[offset]) * 100000 + FC.low_nibble(in[offset]) * 10000 + FC.high_nibble(in[offset + 1]) * 1000 + FC.low_nibble(in[offset + 1]) * 100 + FC.high_nibble(in[offset + 2]) * 10 + FC.low_nibble(in[offset + 2]);
    }

    public static void intToBCD6(int number, byte[] out, int offset) {
        int d = 10000;
        int i = 0;
        while (i < 3) {
            out[offset + i] = FC.byteToBCD2((byte)(number / d % 100));
            d /= 100;
            ++i;
        }
    }

    public static byte asciiToBCD2(byte inUpperChar, byte inLowerChar) {
        return FC.byteToBCD2((byte)(FC.asciiToNibble(inUpperChar) * 10 + FC.asciiToNibble(inLowerChar)));
    }

    public static double AWStoDouble(byte[] in, int offset) {
        short value = FC.BCD4toShort(in, offset);
        int exp10 = FC.low_nibble(in[offset + 2]);
        byte shift = FC.high_nibble(in[offset + 2]);
        if (shift != 0) {
            if (shift < 9) {
                value = -value;
            }
            if (shift == 7 || shift == 9) {
                exp10 = -exp10;
            }
        }
        return Math.pow(10.0, exp10 -= 3) * (double)value;
    }

    public static long StringToLong(String str) {
        return FC.StringToLong(str, 0);
    }

    public static long StringToLong(String str, int width) {
        return FC.StringToLong(str, width, 0L);
    }

    public static long StringToLong(String str, int width, long defaultValue) {
        long returnVal;
        if (width > 0 && width < str.length()) {
            str = str.substring(0, width);
        }
        str = str.trim();
        try {
            returnVal = Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            returnVal = defaultValue;
        }
        return returnVal;
    }

    public static long LenientStringToLong(String str) {
        return FC.LenientStringToLong(str, 0);
    }

    public static long LenientStringToLong(String str, int width) {
        return FC.LenientStringToLong(str, width, 0L);
    }

    public static long LenientStringToLong(String str, int width, long defaultValue) {
        return (long)FC.StringToDouble(str, width, defaultValue);
    }

    public static int hexStr2Int(String str) {
        return FC.hexStr2Int(str, str.length());
    }

    public static int hexStr2Int(String str, int length) {
        return FC.hexStr2Int(str, length, 0);
    }

    public static int hexStr2Int(String str, int length, int order) {
        int digit;
        char symbol;
        int value = 0;
        int pos = 0;
        int inc = 1;
        str = str.toUpperCase();
        if (order == 1) {
            pos = length - 1;
            inc = -1;
        }
        if (length > str.length()) {
            value = -1;
        } else if (length > 8) {
            value = -1;
        } else if (length == 8) {
            symbol = str.charAt(pos);
            digit = HEX_DIGITS.indexOf(symbol);
            if (digit < 0) {
                value = -1;
            } else if (digit > 7) {
                value = -1;
            } else {
                value = digit;
                pos += inc;
                --length;
            }
        }
        if (value >= 0) {
            int k = 0;
            while (k < length) {
                symbol = str.charAt(pos);
                digit = HEX_DIGITS.indexOf(symbol);
                if (digit < 0) {
                    value = -1;
                    break;
                }
                value = 16 * value + digit;
                pos += inc;
                ++k;
            }
        }
        return value;
    }

    public static long hexStr2Long(String str) {
        return FC.hexStr2Long(str, str.length());
    }

    public static long hexStr2Long(String str, int length) {
        return FC.hexStr2Long(str, length, 0);
    }

    public static long hexStr2Long(String str, int length, int order) {
        int digit;
        char symbol;
        long value = 0L;
        int pos = 0;
        int inc = 1;
        str = str.toUpperCase();
        if (order == 1) {
            pos = length - 1;
            inc = -1;
        }
        if (length > str.length()) {
            value = -1L;
        } else if (length > 16) {
            value = -1L;
        } else if (length == 16) {
            symbol = str.charAt(pos);
            digit = HEX_DIGITS.indexOf(symbol);
            if (digit < 0) {
                value = -1L;
            } else if (digit > 7) {
                value = -1L;
            } else {
                value = digit;
                pos += inc;
                --length;
            }
        }
        if (value >= 0L) {
            int k = 0;
            while (k < length) {
                symbol = str.charAt(pos);
                digit = HEX_DIGITS.indexOf(symbol);
                if (digit < 0) {
                    value = -1L;
                    break;
                }
                value = 16L * value + (long)digit;
                pos += inc;
                ++k;
            }
        }
        return value;
    }

    public static int StringToInteger(String str) {
        return (int)FC.StringToLong(str);
    }

    public static int StringToInteger(String str, int width) {
        return (int)FC.StringToLong(str, width);
    }

    public static int StringToInteger(String str, int width, int defaultValue) {
        return (int)FC.StringToLong(str, width, defaultValue);
    }

    public static int LenientStringToInteger(String str) {
        return (int)FC.LenientStringToLong(str);
    }

    public static int LenientStringToInteger(String str, int width) {
        return (int)FC.LenientStringToLong(str, width);
    }

    public static int LenientStringToInteger(String str, int width, int defaultValue) {
        return (int)FC.LenientStringToLong(str, width, defaultValue);
    }

    public static double StringToDouble(String str) {
        return FC.StringToDouble(str, 0);
    }

    public static double StringToDouble(String str, int width) {
        return FC.StringToDouble(str, width, 0.0);
    }

    public static double StringToDouble(String str, int width, double defaultValue) {
        double returnVal;
        if (width > 0 && width < str.length()) {
            str = str.substring(0, width);
        }
        str = str.trim();
        try {
            returnVal = Double.valueOf(str);
        }
        catch (NumberFormatException e) {
            returnVal = defaultValue;
        }
        return returnVal;
    }

    public static String IntegerToString(int value) {
        return Integer.toString(value);
    }

    public static String IntegerToString(int value, int width) {
        return FC.IntegerToString(value, width, ' ');
    }

    public static boolean IntegerToString(int value, int width, StringBuilder strBuf, int offset) {
        return FC.IntegerToString(value, width, ' ', strBuf, offset);
    }

    public static String IntegerToString(int value, int width, char fill) {
        StringBuilder strBuf = new StringBuilder(width);
        strBuf.setLength(width);
        FC.IntegerToString(value, width, fill, strBuf, 0);
        return strBuf.toString();
    }

    public static boolean IntegerToString(int value, int width, char fill, StringBuilder strBuf, int offset) {
        boolean overflow = false;
        if (width <= 0) {
            throw new IllegalArgumentException("width is not positive, " + width);
        }
        if (strBuf.length() < offset + width) {
            throw new IllegalArgumentException("strBuf size is small, " + strBuf.length() + ", offset = " + offset + ", width = " + width);
        }
        boolean isNegative = false;
        int numberOfFreeDigitPositions = width;
        if (value < 0) {
            value = -value;
            isNegative = true;
            --numberOfFreeDigitPositions;
        }
        int numberOfSymbolsInWholePartSoFar = 0;
        while (value > 0 && numberOfFreeDigitPositions-- > 0) {
            strBuf.setCharAt(offset + width - ++numberOfSymbolsInWholePartSoFar, (char)(48 + value % 10));
            value /= 10;
        }
        if (value > 0) {
            int i = offset;
            while (i < offset + width) {
                strBuf.setCharAt(i, '*');
                ++i;
            }
            overflow = true;
        } else {
            if (numberOfSymbolsInWholePartSoFar == 0) {
                strBuf.setCharAt(offset + width - ++numberOfSymbolsInWholePartSoFar, '0');
            }
            if (isNegative) {
                strBuf.setCharAt(offset + width - ++numberOfSymbolsInWholePartSoFar, '-');
            }
            while (numberOfSymbolsInWholePartSoFar < width) {
                strBuf.setCharAt(offset + width - ++numberOfSymbolsInWholePartSoFar, fill);
            }
        }
        return !overflow;
    }

    public static String int2HexStr(int value, int width) {
        return String.format("%0" + width + "X", value);
    }

    public static String long2HexStr(long value, int width) {
        String str = Long.toHexString(value).toUpperCase();
        int len = str.length();
        if (len > width) {
            return str.substring(len - width);
        }
        if (len == width) {
            return str;
        }
        return String.valueOf(STR_ZEROES.substring(0, width - len)) + str;
    }

    public static String bytes2HexStr(byte[] bytes) {
        if (bytes.length == 0) {
            throw new IllegalArgumentException("array bytes is zero length");
        }
        return FC.bytes2HexStr(bytes, 0, bytes.length);
    }

    public static String bytes2HexStr(byte[] bytes, int start) {
        if (start < 0 || start >= bytes.length) {
            throw new IllegalArgumentException("start is illegal, " + start);
        }
        return FC.bytes2HexStr(bytes, start, bytes.length - start);
    }

    public static String bytes2HexStr(byte[] bytes, int start, int length) {
        if (start < 0 || length <= 0 || start + length > bytes.length) {
            throw new IllegalArgumentException("start, length are illegal or inconsistent with length of bytes");
        }
        int end = start + length;
        StringBuilder str = new StringBuilder(2 * length);
        int i = start;
        while (i < end) {
            byte c = bytes[i];
            char low = HEX_DIGITS.charAt(c & 0xF);
            char hi = HEX_DIGITS.charAt(c >> 4 & 0xF);
            str.append(hi);
            str.append(low);
            ++i;
        }
        return str.toString();
    }

    public static String DoubleToString(double value, int width, int precision) {
        StringBuilder strBuf = new StringBuilder(width);
        strBuf.setLength(width);
        FC.DoubleToString(value, width, precision, strBuf, 0);
        return strBuf.toString();
    }

    public static boolean DoubleToString(double value, int width, int precision, StringBuilder strBuf, int offset) {
        int fractionPartWidth;
        int fractionPartOffset;
        int wholePartWidth;
        boolean overflow = false;
        if (width <= 0) {
            throw new IllegalArgumentException("width is not positive, " + width);
        }
        if (precision > width - 1) {
            throw new IllegalArgumentException("precision > width - 1, width = " + width + ", precision = " + precision);
        }
        if (strBuf.length() < offset + width) {
            throw new IllegalArgumentException("strBuf size is small, " + strBuf.length() + ", *offset* = " + offset + ", *width* = " + width);
        }
        if (precision < 0) {
            precision = 0;
            wholePartWidth = width;
            fractionPartOffset = offset + width;
            fractionPartWidth = 0;
        } else {
            wholePartWidth = width - precision - 1;
            strBuf.setCharAt(offset + wholePartWidth, '.');
            fractionPartOffset = offset + wholePartWidth + 1;
            fractionPartWidth = precision;
        }
        int leftToPoint = wholePartWidth;
        boolean isNegative = false;
        if (value < 0.0) {
            value = -value;
            isNegative = true;
            --leftToPoint;
        }
        long wholePart = (long)Math.floor(value);
        long fractionPart = Math.round(Math.pow(10.0, precision) * (value - (double)wholePart));
        while (precision-- > 0) {
            if (fractionPart > 0L) {
                strBuf.setCharAt(fractionPartOffset + precision, (char)(48L + fractionPart % 10L));
                fractionPart /= 10L;
                continue;
            }
            strBuf.setCharAt(fractionPartOffset + precision, '0');
        }
        wholePart += fractionPart;
        int numberOfSymbolsInWholePartSoFar = 0;
        while (wholePart > 0L && leftToPoint-- > 0) {
            strBuf.setCharAt(offset + wholePartWidth - ++numberOfSymbolsInWholePartSoFar, (char)(48L + wholePart % 10L));
            wholePart /= 10L;
        }
        if (wholePart > 0L) {
            int i = offset;
            while (i < offset + wholePartWidth) {
                strBuf.setCharAt(i, '*');
                ++i;
            }
            i = fractionPartOffset;
            while (i < fractionPartOffset + fractionPartWidth) {
                strBuf.setCharAt(i, '*');
                ++i;
            }
            overflow = true;
        } else {
            if (numberOfSymbolsInWholePartSoFar == 0 && leftToPoint > 0) {
                strBuf.setCharAt(offset + wholePartWidth - ++numberOfSymbolsInWholePartSoFar, '0');
            }
            if (isNegative) {
                strBuf.setCharAt(offset + wholePartWidth - ++numberOfSymbolsInWholePartSoFar, '-');
            }
            while (numberOfSymbolsInWholePartSoFar < wholePartWidth) {
                strBuf.setCharAt(offset + wholePartWidth - ++numberOfSymbolsInWholePartSoFar, ' ');
            }
        }
        return !overflow;
    }

    public static String doubleToString(double value, int maxPrecision) {
        return FC.doubleToString(value, maxPrecision, false);
    }

    public static String doubleToString(double value, int maxPrecision, boolean discardTrailingZeroes) {
        int pointPos;
        int mult = (int)Math.pow(10.0, maxPrecision);
        value = (double)Math.round((double)mult * value) / (double)mult;
        String str = "" + value;
        int ePos = (str = str.toUpperCase()).indexOf(69);
        if (ePos > 0) {
            int shift = FC.StringToInteger(str.substring(ePos + 1));
            pointPos = (str = str.substring(0, ePos)).indexOf(46);
            if (pointPos >= 0) {
                if (shift > 0) {
                    str = str.length() - pointPos - 1 > shift ? String.valueOf(str.substring(0, pointPos)) + str.substring(pointPos + 1, pointPos + 1 + shift) + "." + str.substring(pointPos + 1 + shift) : (str.length() - pointPos - 1 < shift ? String.valueOf(str.substring(0, pointPos)) + str.substring(pointPos + 1) + STR_ZEROES.substring(0, shift - (str.length() - pointPos - 1)) : String.valueOf(str.substring(0, pointPos)) + str.substring(pointPos + 1));
                } else if (shift < 0) {
                    str = -shift < pointPos ? String.valueOf(str.substring(0, pointPos + shift)) + "." + str.substring(pointPos + shift, pointPos) + str.substring(pointPos + 1) : "0." + STR_ZEROES.substring(0, -shift - pointPos) + str.substring(0, pointPos) + str.substring(pointPos + 1);
                }
            } else if (shift > 0) {
                str = String.valueOf(str) + STR_ZEROES.substring(0, shift);
            } else if (shift < 0) {
                str = -shift < str.length() ? String.valueOf(str.substring(0, str.length() + shift)) + "." + str.substring(str.length() + shift) : "0." + STR_ZEROES.substring(0, -shift - str.length()) + str;
            }
        }
        if ((pointPos = str.indexOf(46)) >= 0) {
            if (maxPrecision <= 0) {
                str = str.substring(0, pointPos);
            } else if (str.length() - 1 - pointPos > maxPrecision) {
                str = str.substring(0, pointPos + 1 + maxPrecision);
            } else if (!discardTrailingZeroes && str.length() - 1 - pointPos < maxPrecision) {
                str = FC.padRight(str, pointPos + 1 + maxPrecision, '0');
            }
            if (maxPrecision > 0 && discardTrailingZeroes) {
                int trZerPos = -1;
                int i = str.length() - 1;
                while (i > pointPos) {
                    if (str.charAt(i) != '0') break;
                    trZerPos = i--;
                }
                if (trZerPos > 0) {
                    str = str.substring(0, trZerPos);
                }
                if (str.length() > 0 && str.charAt(str.length() - 1) == '.') {
                    str = str.substring(0, str.length() - 1);
                }
                if (str.length() == 0) {
                    str = "0";
                }
            }
        } else if (maxPrecision > 0) {
            str = String.valueOf(str) + "." + StrUtil.repeat('0', maxPrecision);
        }
        return str;
    }

    public static String ScientificToString(double value, int width, int precision, int expWidth) {
        int power = 0;
        double val = Math.abs(value);
        while (val >= 1.0) {
            val /= 10.0;
            ++power;
        }
        while (val < 0.1 && val != 0.0) {
            val *= 10.0;
            --power;
        }
        if (value < 0.0) {
            val = -val;
        }
        String str = FC.DoubleToString(val, width - expWidth - 2, precision);
        str = String.valueOf(str) + "E";
        str = power < 0 ? String.valueOf(str) + "-" : String.valueOf(str) + "+";
        str = String.valueOf(str) + FC.IntegerToString(Math.abs(power), expWidth).replace(' ', '0');
        return str;
    }

    public static String nowToString() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MMM-dd HH.mm.ss ");
        Date now = new Date();
        String str = formatter.format(now);
        return str;
    }

    public static String secToTimestamp(int tsec) {
        int hour = tsec / 3600;
        int min = tsec % 3600 / 60;
        int sec = tsec % 60;
        return String.valueOf(hour) + ":" + FC.IntegerToString(min, 2).replace(' ', '0') + "." + FC.IntegerToString(sec, 2).replace(' ', '0');
    }

    public static int swapBytes(int oldValue) {
        int newValue = (oldValue & 0xFF) << 24;
        newValue += (oldValue & 0xFF00) << 8;
        newValue += (oldValue & 0xFF0000) >> 8;
        return newValue += (oldValue & 0xFF000000) >> 24 & 0xFF;
    }

    public static short swapBytes(short oldValue) {
        short newValue = (short)((oldValue & 0xFF) << 8);
        newValue = (short)(newValue + ((oldValue & 0xFF00) >> 8 & 0xFF));
        return newValue;
    }

    public static float floatLE(int oldValue) {
        float newValue = Float.intBitsToFloat(FC.swapBytes(oldValue));
        return newValue;
    }

    public static short swapBytes(byte byte1, byte byte2) {
        return (short)(byte2 << 8 | byte1);
    }

    public static long intToLong(int hi, int lo) {
        return (long)hi << 32 | (long)lo & 0xFFFFFFFFL;
    }

    public static int longToHi(long val) {
        return (int)(val >>> 32);
    }

    public static int longToLo(long val) {
        return (int)val;
    }

    public static String doubleArrayToString(double[] array, int width, int fraction) {
        return FC.doubleArrayToString(array, array.length, width, fraction);
    }

    public static String doubleArrayToString(double[] array, int maxIndex, int width, int fraction) {
        String str = "";
        int i = 0;
        while (i < maxIndex) {
            str = String.valueOf(str) + FC.DoubleToString(array[i], width, fraction).trim();
            if (i < maxIndex - 1) {
                str = String.valueOf(str) + ", ";
            }
            ++i;
        }
        return str;
    }

    public static String byteArrayToString(byte[] array, int width) {
        return FC.byteArrayToString(array, array.length, width);
    }

    public static String byteArrayToString(byte[] array, int maxIndex, int width) {
        String str = "";
        int i = 0;
        while (i < maxIndex) {
            str = String.valueOf(str) + FC.IntegerToString(array[i], width).trim();
            if (i < maxIndex - 1) {
                str = String.valueOf(str) + ", ";
            }
            ++i;
        }
        return str;
    }

    public static String intArrayToString(int[] array, int width) {
        return FC.intArrayToString(array, array.length, width);
    }

    public static String intArrayToString(int[] array, int maxIndex, int width) {
        String str = "";
        int i = 0;
        while (i < maxIndex) {
            str = String.valueOf(str) + FC.IntegerToString(array[i], width).trim();
            if (i < maxIndex - 1) {
                str = String.valueOf(str) + ", ";
            }
            ++i;
        }
        return str;
    }

    public static double[] stringToDoubleArray(String str) {
        return FC.stringToDoubleArray(str, ',');
    }

    public static double[] stringToDoubleArray(String str, char separator) {
        double tmpValue = Double.MIN_VALUE;
        int startPos = 0;
        int count = 0;
        while (startPos < str.length()) {
            int width;
            int pos = str.indexOf(separator, startPos);
            if (pos == -1) {
                pos = str.length();
            }
            if ((tmpValue = (width = pos - startPos) > 0 ? FC.StringToDouble(str.substring(startPos), width, Double.MIN_VALUE) : Double.MIN_VALUE) == Double.MIN_VALUE) {
                count = 0;
                break;
            }
            startPos = pos + 1;
            ++count;
        }
        if (count == 0) {
            return null;
        }
        return FC.stringToDoubleArray(str, separator, count);
    }

    public static double[] stringToDoubleArray(String str, char separator, int count) {
        double[] array = new double[count];
        if (FC.stringToDoubleArray(str, array, separator, count)) {
            return array;
        }
        return null;
    }

    public static boolean stringToDoubleArray(String str, double[] array, char separator, int count) {
        double tmpValue = Double.MIN_VALUE;
        int startPos = 0;
        startPos = 0;
        int tmpCount = 0;
        while (startPos < str.length()) {
            int width;
            int pos = str.indexOf(separator, startPos);
            if (pos == -1) {
                pos = str.length();
            }
            if ((width = pos - startPos) > 0) {
                tmpValue = FC.StringToDouble(str.substring(startPos), width, Double.MIN_VALUE);
            }
            startPos = pos + 1;
            array[tmpCount] = tmpValue;
            ++tmpCount;
        }
        return count == tmpCount;
    }

    public static int[] stringToIntArray(String str) {
        return FC.stringToIntArray(str, ',');
    }

    public static int[] stringToIntArray(String str, char separator) {
        int tmpValue = Integer.MIN_VALUE;
        int startPos = 0;
        int count = 0;
        while (startPos < str.length()) {
            int width;
            int pos = str.indexOf(separator, startPos);
            if (pos == -1) {
                pos = str.length();
            }
            if ((tmpValue = (width = pos - startPos) > 0 ? FC.StringToInteger(str.substring(startPos), width, Integer.MIN_VALUE) : Integer.MIN_VALUE) == Integer.MIN_VALUE) {
                count = 0;
                break;
            }
            startPos = pos + 1;
            ++count;
        }
        if (count == 0) {
            return null;
        }
        return FC.stringToIntArray(str, separator, count);
    }

    public static int[] stringToIntArray(String str, char separator, int count) {
        int[] array = new int[count];
        if (FC.stringToIntArray(str, array, separator, count)) {
            return array;
        }
        return null;
    }

    public static boolean stringToIntArray(String str, int[] array, char separator, int count) {
        int tmpValue = Integer.MIN_VALUE;
        int startPos = 0;
        startPos = 0;
        int tmpCount = 0;
        while (startPos < str.length()) {
            int width;
            int pos = str.indexOf(separator, startPos);
            if (pos == -1) {
                pos = str.length();
            }
            if ((width = pos - startPos) > 0) {
                tmpValue = FC.StringToInteger(str.substring(startPos), width, Integer.MIN_VALUE);
            }
            startPos = pos + 1;
            array[tmpCount] = tmpValue;
            ++tmpCount;
        }
        return count == tmpCount;
    }

    public static byte[] stringToByteArray(String str) {
        return FC.stringToByteArray(str, ',');
    }

    public static byte[] stringToByteArray(String str, char separator) {
        int tmpValue = -128;
        int startPos = 0;
        int count = 0;
        while (startPos < str.length()) {
            int width;
            int pos = str.indexOf(separator, startPos);
            if (pos == -1) {
                pos = str.length();
            }
            if ((tmpValue = (width = pos - startPos) > 0 ? (int)((byte)FC.StringToInteger(str.substring(startPos), width, -128)) : -128) == -128) {
                count = 0;
                break;
            }
            startPos = pos + 1;
            ++count;
        }
        if (count == 0) {
            return null;
        }
        return FC.stringToByteArray(str, separator, count);
    }

    public static byte[] stringToByteArray(String str, char separator, int count) {
        byte[] array = new byte[count];
        if (FC.stringToByteArray(str, array, separator, count)) {
            return array;
        }
        return null;
    }

    public static boolean stringToByteArray(String str, byte[] array, char separator, int count) {
        int tmpValue = -128;
        int startPos = 0;
        startPos = 0;
        int tmpCount = 0;
        while (startPos < str.length()) {
            int width;
            int pos = str.indexOf(separator, startPos);
            if (pos == -1) {
                pos = str.length();
            }
            if ((width = pos - startPos) > 0) {
                tmpValue = (byte)FC.StringToInteger(str.substring(startPos), width, -128);
            }
            startPos = pos + 1;
            array[tmpCount] = tmpValue;
            ++tmpCount;
        }
        return count == tmpCount;
    }

    public static String[] str2LinesArray(String text) {
        Object[] lines = null;
        Vector<String> vLines = new Vector<String>(50, 100);
        String altSep = "\n";
        if (System.lineSeparator().equals("\n")) {
            altSep = "\r\n";
        }
        int pos1 = -1;
        int pos2 = -1;
        while (text.length() != 0) {
            pos1 = text.indexOf(System.lineSeparator());
            pos2 = text.indexOf(altSep);
            if (pos1 >= 0) {
                if (pos2 < 0 || pos2 > pos1) {
                    vLines.addElement(text.substring(0, pos1));
                    text = text.substring(pos1 + System.lineSeparator().length());
                    continue;
                }
                vLines.addElement(text.substring(0, pos2));
                text = text.substring(pos2 + altSep.length());
                continue;
            }
            if (pos2 >= 0) {
                vLines.addElement(text.substring(0, pos2));
                text = text.substring(pos2 + altSep.length());
                continue;
            }
            vLines.addElement(text);
            break;
        }
        lines = new String[vLines.size()];
        vLines.copyInto(lines);
        return lines;
    }

    public static String timeIntervalToString(long intervalInMicrosec) {
        if (intervalInMicrosec > 0L) {
            String s = "";
            int val = (int)(intervalInMicrosec / 3600000000L);
            if (val > 0) {
                s = String.valueOf(s) + val + " h ";
            }
            if ((val = (int)((intervalInMicrosec %= 3600000000L) / 60000000L)) > 0) {
                s = String.valueOf(s) + val + " m ";
            }
            if ((val = (int)((intervalInMicrosec %= 60000000L) / 1000000L)) != 0 || s.length() > 0 && (intervalInMicrosec %= 1000000L) > 0L) {
                s = String.valueOf(s) + val + " s ";
            }
            if ((val = (int)(intervalInMicrosec / 1000L)) != 0 || s.length() > 0 && (intervalInMicrosec %= 1000L) > 0L) {
                s = String.valueOf(s) + val + " ms ";
            }
            if (intervalInMicrosec > 0L) {
                s = String.valueOf(s) + intervalInMicrosec + " us ";
            }
            return s;
        }
        if (intervalInMicrosec == 0L) {
            return "0 s";
        }
        return "NEG";
    }

    public static String hex2String(int value, int width) {
        return FC.padLeft(Integer.toHexString(value), width, '0');
    }

    public static String millis2period_ISO8601(long input_millis) {
        if (input_millis == 0L) {
            return "PT0S";
        }
        long input = input_millis;
        int millis = (int)(input % 1000L);
        int seconds = (int)((input /= 1000L) % 60L);
        int minutes = (int)((input /= 60L) % 60L);
        int hours = (int)((input /= 60L) % 24L);
        int days = (int)((double)(input /= 24L) % 365.2425);
        String output = "P";
        if (days > 0) {
            output = String.valueOf(output) + days + "D";
        }
        if (hours == 0 && minutes == 0 && seconds == 0 && millis == 0) {
            return output;
        }
        output = String.valueOf(output) + "T";
        if (hours > 0 || days > 0) {
            output = String.valueOf(output) + hours + "H";
        }
        if (minutes == 0 && seconds == 0 && millis == 0) {
            return output;
        }
        if (minutes > 0 || hours > 0) {
            output = String.valueOf(output) + minutes + "M";
        }
        if (seconds == 0 && millis == 0) {
            return output;
        }
        if (seconds > 0 || millis > 0) {
            output = String.valueOf(output) + seconds;
        }
        if (millis > 0) {
            if (millis % 10 == 0) {
                millis /= 10;
            }
            if (millis % 10 == 0) {
                millis /= 10;
            }
            output = String.valueOf(output) + "." + millis;
        }
        output = String.valueOf(output) + "S";
        return output;
    }

    public static String nC2S(char c, int n) {
        String s = "";
        int i = 0;
        while (i < n) {
            s = String.valueOf(s) + c;
            ++i;
        }
        return s;
    }
}

