/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.format;

import java.util.List;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.h5.H5Group;

public class HDF5Utils {
    public static String ROOT_GROUP = "/";
    public static final int INT64_SIZE = 8;
    public static final int DOUBLE64_SIZE = 8;

    public static String iterateGroupsForDataset(H5Group grp, String datasetName, boolean seekSubgroups) {
        HObject obj2 = null;
        int o_id = -1;
        List memberList = grp.getMemberList();
        for (HObject obj2 : memberList) {
            o_id = obj2.open();
            if (o_id < 0) continue;
            try {
                String dsetSubgroup;
                int objType = H5.H5Oget_info((int)o_id).type;
                if (objType == HDF5Constants.H5O_TYPE_DATASET && obj2.getName().equals(datasetName)) {
                    return obj2.getFullName();
                }
                if (objType != HDF5Constants.H5O_TYPE_GROUP || !seekSubgroups || (dsetSubgroup = HDF5Utils.iterateGroupsForDataset((H5Group)obj2, datasetName, true)) == null) continue;
                return dsetSubgroup;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

