/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.format;

import edu.uml.lgdc.geospace.EarthGrid;
import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.time.TimeScale;

public class IonexGrid {
    private double[] latGrid = new double[3];
    private int latNodes;
    private double[] lonGrid = new double[3];
    private int lonNodes;
    private double[] altGrid = new double[3];
    private int altNodes;
    private TimeScale[] times = null;
    private int cadence_sec = -1;
    private int totalTimes = 0;
    private boolean isGood = false;

    public boolean set(EarthGrid earthGrid, double referenceAltitude_km, TimeScale start, TimeScale stop, int cadence_sec) {
        this.latGrid[0] = 90.0 - earthGrid.getLatitudeStep();
        this.latGrid[1] = -90.0 + earthGrid.getLatitudeStep();
        this.latGrid[2] = -earthGrid.getLatitudeStep();
        this.lonGrid[0] = -180.0;
        this.lonGrid[1] = 180.0;
        this.lonGrid[2] = earthGrid.getLongitudeStep();
        this.altGrid[0] = referenceAltitude_km;
        this.altGrid[1] = referenceAltitude_km;
        this.altGrid[2] = 0.0;
        this.latNodes = (int)Math.abs((this.latGrid[1] - this.latGrid[0]) / this.latGrid[2]) + 1;
        this.lonNodes = (int)Math.abs((this.lonGrid[1] - this.lonGrid[0]) / this.lonGrid[2]) + 1;
        this.altNodes = 1;
        this.isGood = this.set(start, stop, cadence_sec) && this.checkGridStepping();
        return this.isGood;
    }

    private boolean set(TimeScale start, TimeScale stop, int cadence_sec) {
        this.cadence_sec = cadence_sec;
        this.totalTimes = cadence_sec == 0 ? 1 : (int)(stop.getTimeInSeconds() - start.getTimeInSeconds()) / cadence_sec + 1;
        this.times = new TimeScale[this.totalTimes];
        long startTime = start.getTimeInMillis();
        long cadence_ms = cadence_sec * 1000;
        int i = 0;
        while (i < this.totalTimes) {
            this.times[i] = new TimeScale(startTime + cadence_ms * (long)i);
            ++i;
        }
        return this.checkCadence();
    }

    public boolean set(double[] latGrid, double[] lonGrid, double referenceAltitude_km, TimeScale start, TimeScale stop, int cadence_sec) {
        this.latGrid = latGrid;
        this.lonGrid = lonGrid;
        this.altGrid[0] = referenceAltitude_km;
        this.altGrid[1] = referenceAltitude_km;
        this.altGrid[2] = 0.0;
        this.latNodes = (int)Math.abs((latGrid[1] - latGrid[0]) / latGrid[2]) + 1;
        this.lonNodes = (int)Math.abs((lonGrid[1] - lonGrid[0]) / lonGrid[2]) + 1;
        this.altNodes = 1;
        this.isGood = this.set(start, stop, cadence_sec) && this.checkGridStepping();
        return this.isGood;
    }

    public boolean setTimes(TimeScale[] timestamps) {
        this.times = timestamps;
        this.cadence_sec = (int)(this.times[0].getTimeInSeconds() - this.times[1].getTimeInSeconds());
        return this.checkCadence();
    }

    private boolean checkGridStepping() {
        if (this.latGrid[0] + (double)(this.latNodes - 1) * this.latGrid[2] != this.latGrid[1]) {
            Console.showError("IONEX Formatter: Latitude grid is not even: " + this.latGrid[0] + " + " + this.latNodes + " steps of " + this.latGrid[2] + " does not match expected " + this.latGrid[1]);
            return false;
        }
        if (this.lonGrid[0] + (double)(this.lonNodes - 1) * this.lonGrid[2] != this.lonGrid[1]) {
            Console.showError("IONEX Formatter: Longitude grid is not even: " + this.lonGrid[0] + " + " + this.lonNodes + " steps of " + this.lonGrid[2] + " does not match expected " + this.lonGrid[1]);
            return false;
        }
        if (this.altGrid[0] + (double)(this.altNodes - 1) * this.altGrid[2] != this.altGrid[1]) {
            Console.showError("IONEX Formatter: Altitude grid is not even: " + this.altGrid[0] + " + " + this.altNodes + " steps of " + this.altGrid[2] + " does not match expected " + this.altGrid[1]);
            return false;
        }
        return true;
    }

    public boolean checkStandardSpatialGrid() {
        if (this.latGrid[0] == 90.0 + this.latGrid[2] && this.latGrid[1] == -90.0 - this.latGrid[2]) {
            if (this.lonGrid[0] == -180.0 && this.lonGrid[1] == 180.0 || this.lonGrid[0] == 0.0 && this.lonGrid[1] == 360.0) {
                return true;
            }
            Console.showError("IONEX Formatter: Longitude grids are non-standard: " + this.lonGrid[0] + ".." + this.lonGrid[1]);
            return false;
        }
        Console.showError("IONEX Formatter: Latitude grids are non-standard: " + this.latGrid[0] + ".." + this.latGrid[1]);
        return false;
    }

    private boolean checkCadence() {
        if (this.times == null) {
            Console.showError("IONEX Formatter: times are not initialized for use");
            return false;
        }
        if (this.times.length == 0) {
            System.out.println("IONEX Formatter: array of timestamps is empty");
            return false;
        }
        if (this.times.length > 1) {
            if (!TimeScale.checkTimesUniformity(this.times, this.cadence_sec)) {
                System.out.println("IONEX Formatter: Map timestamps are unsorted or not uniform");
            }
            return false;
        }
        return true;
    }

    public boolean checkCadence(double[][] maps) {
        if (maps == null) {
            Console.showError("IONEX Formatter: maps are not initialized for use");
            return false;
        }
        if (this.times.length != maps.length) {
            System.out.println("IONEX Formatter: Number of timestamps does not match number of maps");
            return false;
        }
        return this.checkCadence();
    }

    public double[] getLatitudeTriplet() {
        return this.latGrid;
    }

    public double[] getLongitudeTriplet() {
        return this.lonGrid;
    }

    public double[] getAltitudeTriplet() {
        return this.altGrid;
    }

    public int getTotalLatitudes() {
        return this.latNodes;
    }

    public int getTotalLongitudes() {
        return this.lonNodes;
    }

    public int getTotalAltitudes() {
        return this.altNodes;
    }

    public TimeScale[] getTimes() {
        return this.times;
    }

    public TimeScale getTime(int index) {
        return this.times[index];
    }

    public int getIndex(TimeScale time) {
        double secondsSinceStart = time.diffIn(13, this.times[0]);
        return (int)Math.round(secondsSinceStart / (double)this.cadence_sec);
    }

    public int getTotalTimes() {
        return this.totalTimes;
    }

    public TimeScale getStartTime() {
        return this.getTime(0);
    }

    public TimeScale getStopTime() {
        return this.getTime(this.getTotalTimes() - 1);
    }

    public int getCadence_sec() {
        return this.cadence_sec;
    }

    public boolean isGood() {
        return this.isGood;
    }

    public void reset() {
        this.isGood = false;
        this.times = null;
    }
}

