/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.format;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

public class StrDecoder {
    public static String run(byte[] bytes, Charset charset) {
        return StrDecoder.run(bytes, 0, bytes.length, charset);
    }

    public static String run(byte[] bytes, int offset, int length, Charset charset) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes is null");
        }
        if (charset == null) {
            throw new IllegalArgumentException("charset is null");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset < 0");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        if (offset + length > bytes.length) {
            throw new IllegalArgumentException("offset + length > bytes.length");
        }
        ByteBuffer in = ByteBuffer.wrap(bytes, offset, length);
        CharBuffer out = CharBuffer.allocate(length);
        CharsetDecoder decoder = charset.newDecoder();
        CoderResult coderResult = decoder.decode(in, out, true);
        if (!coderResult.isUnderflow()) {
            throw new IllegalArgumentException("bad bytes --> string conversion");
        }
        coderResult = decoder.flush(out);
        if (!coderResult.isUnderflow()) {
            throw new IllegalArgumentException("bad bytes --> string conversion");
        }
        return new String(out.array());
    }

    public static String runISO_8859_1(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("buffer is null");
        }
        return StrDecoder.runISO_8859_1(bytes, 0, bytes.length);
    }

    public static String runISO_8859_1(byte[] bytes, int offset, int length) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes is null");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset < 0");
        }
        if (offset + length > bytes.length) {
            throw new IllegalArgumentException("offset + length > bytes.length");
        }
        char[] chars = new char[length];
        int i = 0;
        while (i < length) {
            chars[i] = (char)(bytes[offset + i] & 0xFF);
            ++i;
        }
        return new String(chars);
    }
}

