/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.format;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.Arrays;

public class StrEncoder {
    public static byte[] run(String str, Charset charset) {
        if (str == null) {
            throw new IllegalArgumentException("str is null");
        }
        CharBuffer in = CharBuffer.wrap(str.toCharArray());
        ByteBuffer out = ByteBuffer.allocate(2 * str.length());
        CharsetEncoder encoder = charset.newEncoder();
        CoderResult coderResult = encoder.encode(in, out, true);
        if (!coderResult.isUnderflow()) {
            throw new RuntimeException("bad string --> bytes conversion");
        }
        coderResult = encoder.flush(out);
        if (!coderResult.isUnderflow()) {
            throw new RuntimeException("bad string --> bytes conversion");
        }
        if (out.remaining() == 0) {
            return out.array();
        }
        return Arrays.copyOf(out.array(), out.position());
    }

    public static int run(String str, byte[] bytes, Charset charset) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes is null");
        }
        return StrEncoder.run(str, bytes, 0, bytes.length, charset);
    }

    public static int run(String str, byte[] bytes, int offset, int length, Charset charset) {
        if (str == null) {
            throw new IllegalArgumentException("str is null");
        }
        if (bytes == null) {
            throw new IllegalArgumentException("bytes is null");
        }
        if (charset == null) {
            throw new IllegalArgumentException("charset is null");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset < 0");
        }
        if (length < str.length()) {
            throw new IllegalArgumentException("length < str.length()");
        }
        if (offset + length > bytes.length) {
            throw new IllegalArgumentException("offset + length > bytes.length");
        }
        CharBuffer in = CharBuffer.wrap(str.toCharArray());
        ByteBuffer out = ByteBuffer.wrap(bytes, offset, length);
        CharsetEncoder encoder = charset.newEncoder();
        CoderResult coderResult = encoder.encode(in, out, true);
        if (!coderResult.isUnderflow()) {
            throw new RuntimeException("bad string --> bytes conversion");
        }
        coderResult = encoder.flush(out);
        if (!coderResult.isUnderflow()) {
            throw new RuntimeException("bad string --> bytes conversion");
        }
        return out.position() - offset;
    }

    public static byte[] runISO_8859_1(String str, boolean nocheck) {
        if (str == null) {
            throw new IllegalArgumentException("str is null");
        }
        int length = str.length();
        byte[] bytes = new byte[length];
        if (nocheck) {
            int i = 0;
            while (i < length) {
                bytes[i] = (byte)str.charAt(i);
                ++i;
            }
        } else {
            int i = 0;
            while (i < length) {
                char c = str.charAt(i);
                if ((c & 0xFF00) != 0) {
                    throw new IllegalArgumentException("string contains non ISO-8859-1 character(s)");
                }
                bytes[i] = (byte)str.charAt(i);
                ++i;
            }
        }
        return bytes;
    }

    public static void runISO_8859_1(String str, byte[] bytes) {
        StrEncoder.runISO_8859_1(str, bytes, 0, false);
    }

    public static void runISO_8859_1(String str, byte[] bytes, int offset, boolean nocheck) {
        if (str == null) {
            throw new IllegalArgumentException("str is null");
        }
        int length = str.length();
        if (bytes == null) {
            throw new IllegalArgumentException("bytes is null");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset < 0");
        }
        if (offset + length > bytes.length) {
            throw new IllegalArgumentException("offset + str.length() > bytes.length");
        }
        if (nocheck) {
            int i = 0;
            while (i < length) {
                bytes[offset + i] = (byte)str.charAt(i);
                ++i;
            }
        } else {
            int i = 0;
            while (i < length) {
                char c = str.charAt(i);
                if ((c & 0xFF00) != 0) {
                    throw new IllegalArgumentException("string contains non ISO-8859-1 character(s)");
                }
                bytes[offset + i] = (byte)str.charAt(i);
                ++i;
            }
        }
    }
}

