/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.ftp;

import edu.uml.lgdc.ftp.Assert;
import edu.uml.lgdc.ftp.FtpDataTransferProcess;
import edu.uml.lgdc.ftp.FtpProtocolConstants;
import edu.uml.lgdc.ftp.FtpProtocolException;
import edu.uml.lgdc.ftp.FtpUserProtocolInterpreter;
import edu.uml.lgdc.project.Console;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;

public class FtpClientProtocol
implements FtpProtocolConstants {
    protected FtpUserProtocolInterpreter userPI;
    protected FtpUserDataTransferprocess userDTP;
    protected PrintWriter trace;
    protected boolean isPassiveServer;
    protected boolean isUserLoggedIn;
    protected String workingDirectory;
    protected FtpUserProtocolInterpreter.Reply reply = new FtpUserProtocolInterpreter.Reply();
    private static final char INVALID_SEPARATOR_CHAR = 'A';
    protected char pathSeparatorChar;

    public FtpClientProtocol(String hostName, int port, int timeout, PrintWriter trace) throws FtpProtocolException, IOException {
        Assert.check(trace != null);
        this.trace = trace;
        this.userPI = new FtpUserProtocolInterpreter(hostName, port, trace);
        this.userDTP = new FtpUserDataTransferprocess();
        this.isPassiveServer = false;
        this.pathSeparatorChar = (char)65;
        this.setTimeout(timeout);
    }

    public FtpClientProtocol(String hostName, PrintWriter trace) throws FtpProtocolException, IOException {
        this(hostName, 21, 20000, trace);
    }

    public FtpClientProtocol(String hostName, int port, PrintWriter trace) throws FtpProtocolException, IOException {
        this(hostName, port, 20000, trace);
    }

    public void close() throws IOException {
        Assert.pre(this.userPI != null);
        Assert.pre(this.userDTP != null);
        this.userPI.close();
        this.userPI = null;
        this.userDTP.close();
        this.userDTP = null;
        Assert.post(this.userPI == null);
        Assert.post(this.userDTP == null);
    }

    public void closeNoException() {
        try {
            this.close();
        }
        catch (IOException e) {
            Console.showError("FtpClientProcol: closeNoException, IOException: " + e.getMessage());
        }
    }

    protected void finalize() {
        if (this.userPI != null) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.userPI = null;
        }
        Assert.post(this.userPI == null);
        Assert.post(this.userDTP == null);
    }

    private String extractDirectoryName(String replyText) {
        StringBuffer buffer;
        String directoryName;
        block7: {
            int indexBegin = replyText.indexOf(34);
            if (indexBegin == -1) {
                int indexEnd = replyText.indexOf(32);
                Assert.check(indexBegin == -1);
                return indexEnd == -1 ? replyText : replyText.substring(0, indexEnd);
            }
            int indexEnd = indexBegin + 1;
            while (replyText.length() > indexEnd) {
                if (replyText.charAt(indexEnd) == '\"') {
                    if (indexEnd == replyText.length() - 1 || replyText.charAt(indexEnd + 1) != '\"') break;
                    ++indexEnd;
                }
                ++indexEnd;
            }
            if (indexEnd == replyText.length()) {
                indexEnd = replyText.indexOf(32);
                if (indexEnd == -1) {
                    indexEnd = indexBegin;
                }
                return indexEnd > 0 ? replyText.substring(0, indexEnd) : replyText;
            }
            Assert.check(indexBegin >= 0);
            Assert.check(indexBegin < indexEnd);
            Assert.check(replyText.length() > indexEnd);
            Assert.check(replyText.charAt(indexBegin) == '\"');
            Assert.check(replyText.charAt(indexEnd) == '\"');
            directoryName = replyText.substring(indexBegin + 1, indexEnd);
            indexEnd = directoryName.indexOf(34);
            if (indexEnd == -1) {
                return directoryName;
            }
            buffer = new StringBuffer(1024);
            indexBegin = 0;
            do {
                Assert.check(directoryName.charAt(indexEnd) == '\"');
                Assert.check(++indexEnd < directoryName.length());
                Assert.check(directoryName.charAt(indexEnd) == '\"');
                buffer.append(directoryName.substring(indexBegin, indexEnd));
                indexBegin = ++indexEnd;
                if (indexBegin >= directoryName.length()) break block7;
            } while ((indexEnd = directoryName.indexOf(34, indexBegin)) != -1);
            buffer.append(directoryName.substring(indexBegin));
        }
        Assert.post((directoryName = buffer.toString()).indexOf("\"\"") == -1);
        Assert.post(directoryName.indexOf(34) != -1);
        return directoryName;
    }

    public String getWorkingDirectoryWithRefresh() throws FtpProtocolException, IOException {
        this.workingDirectory = this.pwd();
        return this.workingDirectory;
    }

    private final String pwd() throws FtpProtocolException, IOException {
        this.userPI.transaction("PWD", this.reply);
        Assert.check(this.reply.code == 257);
        return this.extractDirectoryName(this.reply.text);
    }

    public final boolean isAbsolutePath(String directory) {
        Assert.pre(directory.length() > 0);
        return directory.charAt(0) == '/' || directory.charAt(0) == '\\' || directory.charAt(0) == '<' || directory.length() > 2 && directory.charAt(1) == ':' && (directory.charAt(2) == '/' || directory.charAt(2) == '\\');
    }

    public String getWorkingDirectory() throws FtpProtocolException, IOException {
        if (this.workingDirectory == null) {
            this.workingDirectory = this.pwd();
        }
        Assert.post(this.isAbsolutePath(this.workingDirectory));
        return this.workingDirectory;
    }

    public final char getPathSeparatorChar() throws FtpProtocolException, IOException {
        String path;
        char firstChar;
        if (this.pathSeparatorChar != 'A') {
            return this.pathSeparatorChar;
        }
        if (this.workingDirectory == null) {
            this.workingDirectory = this.pwd();
        }
        if (('a' <= (firstChar = (path = this.workingDirectory).charAt(0)) && firstChar <= 'z' || 'A' <= firstChar && firstChar <= 'Z') && path.length() > 2 && path.charAt(1) == ':' && (path.charAt(2) == '/' || path.charAt(2) == '\\')) {
            return path.charAt(2);
        }
        switch (firstChar) {
            case '/': {
                return firstChar;
            }
            case '\\': {
                return firstChar;
            }
            case '<': {
                return '.';
            }
        }
        throw new FtpProtocolException(500, "Unknown separator in path(" + path + ")");
    }

    public int getTimeout() throws SocketException {
        int timeout = this.userPI.getTimeout();
        Assert.post(timeout >= 0);
        Assert.post(this.userDTP.getTimeout() == timeout);
        return timeout;
    }

    public void setTimeout(int timeout) throws SocketException {
        Assert.post(timeout >= 0 || timeout == -1);
        this.userPI.setTimeout(timeout);
        this.userDTP.setTimeout(timeout);
        Assert.post(this.userDTP.getTimeout() == timeout);
        Assert.post(this.userPI.getTimeout() == timeout);
    }

    public void setTransferBufferSize(int bufferSize) {
        this.userDTP.setDataTransferBufferSize(bufferSize);
    }

    public void setTransferProgressNotificationInterval(int numberOfBytes) {
        this.userDTP.setNumberOfBytesPerProgessNotification(numberOfBytes);
    }

    protected void transferProgressListener(int bytesTransferred) {
    }

    public boolean user(String username) throws FtpProtocolException, IOException {
        this.userPI.transaction("USER", username, this.reply);
        Assert.post(this.reply.code == 230 || this.reply.code == 331);
        this.isUserLoggedIn = this.reply.code == 230;
        return this.isUserLoggedIn;
    }

    public void password(String password) throws FtpProtocolException, IOException {
        Assert.pre(!this.isUserLoggedIn);
        this.userPI.transaction("PASS", password, this.reply);
        this.isUserLoggedIn = this.reply.code == 230;
    }

    public boolean isLoggedIn() {
        return this.isUserLoggedIn;
    }

    public void logout() throws FtpProtocolException, IOException {
        this.isUserLoggedIn = false;
        this.userPI.transaction("QUIT", this.reply);
        Assert.check(this.reply.code == 221);
    }

    private String extractAbsolutePath(String replyText, String directory) {
        String newDirectory = this.extractDirectoryName(replyText);
        if (this.isAbsolutePath(newDirectory)) {
            int index = newDirectory.indexOf(directory);
            if (newDirectory.length() - directory.length() == index) {
                return newDirectory;
            }
        }
        return null;
    }

    public void changeWorkingDirectory(String directory) throws FtpProtocolException, IOException {
        char ch;
        if (directory.equals("..")) {
            this.changeToParentDirectory();
            return;
        }
        this.userPI.transaction("CWD", directory, this.reply);
        Assert.check(this.reply.code == 250);
        String newWorkingDirectory = this.extractAbsolutePath(this.reply.text, directory);
        if (newWorkingDirectory == null && this.workingDirectory != null && ((ch = this.getPathSeparatorChar()) == '/' || ch == '\\') && directory.indexOf(ch) == -1) {
            newWorkingDirectory = this.workingDirectory.charAt(this.workingDirectory.length() - 1) == ch ? String.valueOf(this.workingDirectory) + directory : String.valueOf(this.workingDirectory) + ch + directory;
        }
        this.workingDirectory = newWorkingDirectory != null ? newWorkingDirectory : this.pwd();
        Assert.post(this.isAbsolutePath(this.workingDirectory));
    }

    public void changeToParentDirectory() throws FtpProtocolException, IOException {
        this.userPI.transaction("CDUP", this.reply);
        Assert.check(this.reply.code == 200);
        String newWorkingDirectory = null;
        if (this.workingDirectory != null) {
            newWorkingDirectory = this.extractDirectoryName(this.reply.text);
            if (newWorkingDirectory != null) {
                if (this.workingDirectory.indexOf(newWorkingDirectory) != 0) {
                    newWorkingDirectory = null;
                }
            } else {
                char ch = this.getPathSeparatorChar();
                if (ch == '/' || ch == '\\') {
                    int index = this.workingDirectory.length() - 1;
                    Assert.check(this.isAbsolutePath(this.workingDirectory));
                    Assert.check(this.workingDirectory.charAt(index) != ch);
                    while (ch != this.workingDirectory.charAt(index)) {
                        Assert.check(--index >= 0);
                    }
                    if (index == 0 || index == 2 && this.workingDirectory.charAt(1) == ':') {
                        ++index;
                    }
                    newWorkingDirectory = this.workingDirectory.substring(0, index);
                }
            }
        }
        this.workingDirectory = newWorkingDirectory != null ? newWorkingDirectory : this.pwd();
        Assert.post(this.isAbsolutePath(this.workingDirectory));
    }

    public void setRepresentationTypeAscii() throws FtpProtocolException, IOException {
        this.userPI.transaction("TYPE", "A", this.reply);
        Assert.check(this.reply.code == 200);
        this.userDTP.setRepresentationType('A');
    }

    public void setRepresentationTypeImage() throws FtpProtocolException, IOException {
        this.userPI.transaction("TYPE", "I", this.reply);
        Assert.check(this.reply.code == 200);
        this.userDTP.setRepresentationType('I');
    }

    public void setTransferModeToStream() throws FtpProtocolException, IOException {
        this.userPI.transaction("MODE", "S", this.reply);
        Assert.check(this.reply.code == 200);
        this.userDTP.setTransferMode('S');
    }

    public void setTransferModeToBlock() throws FtpProtocolException, IOException {
        this.userPI.transaction("MODE", "B", this.reply);
        Assert.check(this.reply.code == 200);
        this.userDTP.setTransferMode('B');
    }

    public boolean rename(String oldFileName, String newFileName) throws IOException {
        boolean result = false;
        this.userPI.transaction("RNFR", oldFileName, this.reply);
        result = this.reply.code == 350;
        Assert.check(result, this.reply.text);
        if (!result) {
            return result;
        }
        this.userPI.transaction("RNTO", newFileName, this.reply);
        result = this.reply.code == 250;
        Assert.check(result, this.reply.text);
        return result;
    }

    public boolean deleteFile(String fileName) throws IOException {
        this.userPI.transaction("DELE", fileName, this.reply);
        boolean result = this.reply.code == 250;
        Assert.check(result, this.reply.text);
        return result;
    }

    public boolean deleteDir(String dirName) throws IOException {
        this.userPI.transaction("RMD", dirName, this.reply);
        boolean result = this.reply.code == 250;
        Assert.check(result, this.reply.text);
        return result;
    }

    public boolean makeDir(String dirName) throws IOException {
        this.userPI.transaction("MKD", dirName, this.reply);
        boolean result = this.reply.code == 257;
        Assert.check(result, this.reply.text);
        return result;
    }

    public void reinitialize() throws FtpProtocolException, IOException {
        this.userPI.transaction("REIN", this.reply);
        Assert.check(this.reply.firstDigit == 50);
    }

    protected void setPassiveServer() throws FtpProtocolException, IOException {
        this.userPI.transaction("PASV", this.reply);
        if (this.reply.code != 227) {
            throw new FtpProtocolException(501, "invalid reply(" + this.reply.code + ") from " + "PASS");
        }
        int indexStart = -1;
        int indexEnd = -1;
        int i = 0;
        while (i < this.reply.text.length()) {
            if (Character.isDigit(this.reply.text.charAt(i))) {
                indexStart = i;
                break;
            }
            ++i;
        }
        while (i < this.reply.text.length()) {
            char ch = this.reply.text.charAt(i);
            if (!Character.isDigit(ch) && ch != ',') {
                indexEnd = i;
                break;
            }
            ++i;
        }
        if (indexStart == -1 || indexEnd == -1) {
            throw new FtpProtocolException(501, "invalid reply(" + this.reply.text + ") from " + "PASS");
        }
        String addressAndPort = this.reply.text.substring(indexStart, indexEnd);
        StringBuffer hostAddress = new StringBuffer(16);
        int port = FtpDataTransferProcess.parsePortArgument(addressAndPort, hostAddress);
        this.userDTP.setToActiveClientDataConnection(new String(hostAddress), port);
    }

    protected void setDataPort() throws FtpProtocolException, IOException {
        String argument = this.userDTP.setToPassiveClientDataConnection();
        this.userPI.transaction("PORT", argument, this.reply);
        Assert.check(200 == this.reply.code);
    }

    public void setDataConnectionActiveServer() {
        this.isPassiveServer = false;
    }

    public void setDataConnectionPassiveServer() {
        this.isPassiveServer = true;
    }

    private final void setConnectionPort() throws IOException, FtpProtocolException {
        if (!this.userDTP.isStreamMode() && this.userDTP.isSocketOpen()) {
            return;
        }
        Assert.check(!this.userDTP.isSocketOpen());
        if (this.isPassiveServer) {
            this.setPassiveServer();
        } else {
            this.setDataPort();
        }
    }

    public String fileStatus(String pathname) throws FtpProtocolException, IOException {
        this.userPI.transaction("STAT", pathname, this.reply);
        Assert.check(211 == this.reply.code || 212 == this.reply.code || 213 == this.reply.code);
        return this.reply.text;
    }

    public void interruptTransfer() {
        this.userDTP.interruptTransfer();
    }

    private DirectoryListingEnumeration createDirectoryListingEnumerationForCommand(String command, String path) throws FtpProtocolException, IOException {
        Assert.pre(command.equals("LIST") || command.equals("NLST"));
        this.setConnectionPort();
        if (path.length() != 0) {
            this.userPI.transaction(command, path, this.reply);
        } else {
            this.userPI.transaction(command, this.reply);
        }
        Assert.check(125 == this.reply.code || 150 == this.reply.code);
        this.userDTP.connect();
        FtpDataTransferProcess.DirectoryListingEnumeration enumeration = this.userDTP.createDirectoryListingEnumeration();
        return new DirectoryListingEnumeration(enumeration){
            private FtpDataTransferProcess.DirectoryListingEnumeration e;
            {
                this.e = directoryListingEnumeration;
            }

            @Override
            public boolean hasMoreElements() throws IOException {
                if (this.e.hasMoreElements()) {
                    return true;
                }
                FtpClientProtocol.this.userDTP.disconnect();
                FtpClientProtocol.this.userPI.getReply(FtpClientProtocol.this.reply);
                return false;
            }

            @Override
            public String nextElement() throws IOException {
                return this.e.nextElement();
            }
        };
    }

    public DirectoryListingEnumeration createDirectoryListingEnumeration() throws FtpProtocolException, IOException {
        return this.createDirectoryListingEnumerationForCommand("LIST", "");
    }

    public DirectoryListingEnumeration createDirectoryListingEnumeration(String pathname) throws FtpProtocolException, IOException {
        return this.createDirectoryListingEnumerationForCommand("LIST", pathname);
    }

    public DirectoryListingEnumeration createDirectoryNameListingEnumeration() throws FtpProtocolException, IOException {
        return this.createDirectoryListingEnumerationForCommand("NLST", "");
    }

    public DirectoryListingEnumeration createDirectoryNameListingEnumeration(String path) throws FtpProtocolException, IOException {
        return this.createDirectoryListingEnumerationForCommand("NLST", path);
    }

    private int download(OutputStream out, String filename, int restartPos) throws FtpProtocolException, IOException, InterruptedException {
        Assert.pre(out != null);
        Assert.pre(restartPos > 0 || restartPos == -1);
        this.setConnectionPort();
        if (restartPos > 0) {
            this.userPI.transaction("REST", Integer.toString(restartPos), this.reply);
            Assert.check(this.reply.code == 350);
        }
        this.userPI.transaction("RETR", filename, this.reply);
        Assert.check(this.reply.code == 125 || this.reply.code == 150);
        this.userDTP.connect();
        int bytesTransferred = this.userDTP.download(out);
        this.userDTP.disconnect();
        this.userPI.getReply(this.reply);
        return bytesTransferred;
    }

    public int downloadRestart(OutputStream out, String filename, int restartPos) throws FtpProtocolException, IOException, InterruptedException {
        Assert.pre(restartPos > 0);
        return this.download(out, filename, restartPos);
    }

    public int download(OutputStream out, String filename) throws FtpProtocolException, IOException, InterruptedException {
        return this.download(out, filename, -1);
    }

    private int upload(InputStream in, String filename, int restartPos) throws FtpProtocolException, IOException, InterruptedException {
        Assert.pre(in != null);
        Assert.pre(restartPos > 0 || restartPos == -1);
        this.setConnectionPort();
        if (restartPos > 0) {
            this.userPI.transaction("REST", Integer.toString(restartPos), this.reply);
            Assert.check(this.reply.code == 350);
        }
        this.userPI.transaction("STOR", filename, this.reply);
        Assert.check(this.reply.code == 125 || this.reply.code == 150);
        this.userDTP.connect();
        int bytesTransferred = this.userDTP.upload(in);
        this.userDTP.disconnect();
        this.userPI.getReply(this.reply);
        return bytesTransferred;
    }

    public int uploadRestart(InputStream in, String filename, int restartPos) throws FtpProtocolException, IOException, InterruptedException {
        Assert.pre(restartPos > 0);
        return this.upload(in, filename, restartPos);
    }

    public int upload(InputStream in, String filename) throws FtpProtocolException, IOException, InterruptedException {
        return this.upload(in, filename, -1);
    }

    public static interface DirectoryListingEnumeration
    extends FtpDataTransferProcess.DirectoryListingEnumeration {
    }

    private class FtpUserDataTransferprocess
    extends FtpDataTransferProcess {
        private DataConnection dataConnection = null;

        public void close() throws IOException {
            if (this.dataConnection != null) {
                this.dataConnection.close();
                this.dataConnection = null;
            }
        }

        @Override
        public void connect() throws IOException, FtpProtocolException {
            if (this.dataConnection == null) {
                throw new FtpProtocolException(425, "No data connection open");
            }
            this.dataConnection.connect(this.getTimeout());
        }

        @Override
        public void disconnect() throws IOException, FtpProtocolException {
            if (this.dataConnection == null) {
                throw new FtpProtocolException(425, "No data connection open");
            }
            if (this.isStreamMode()) {
                this.close();
            }
        }

        protected void finalize() {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        protected void progressListener(int bytesTransferred) {
            FtpClientProtocol.this.transferProgressListener(bytesTransferred);
        }

        public String setToPassiveClientDataConnection() throws IOException {
            PassiveClientDataConnection connection = new PassiveClientDataConnection();
            this.dataConnection = connection;
            return connection.getDataPortArgument();
        }

        public void setToActiveClientDataConnection(String hostAddress, int port) throws UnknownHostException {
            this.dataConnection = new ActiveClientDataConnection(hostAddress, port);
        }

        private class ActiveClientDataConnection
        extends DataConnection {
            private InetAddress remoteInetAddress;
            private int remotePort;

            public ActiveClientDataConnection(String remoteHostAddr, int remotePort) throws UnknownHostException {
                Assert.pre(remoteHostAddr != null, "remoteHostAddr != null");
                Assert.pre(remoteHostAddr.length() >= 7);
                this.remoteInetAddress = InetAddress.getByName(remoteHostAddr);
                this.remotePort = remotePort;
            }

            @Override
            public void open(int timeout) throws IOException {
                Assert.pre(!FtpUserDataTransferprocess.this.isSocketOpen());
                FtpUserDataTransferprocess.this.setSocket(new Socket(this.remoteInetAddress, this.remotePort));
            }

            @Override
            public void close() throws IOException {
                if (FtpUserDataTransferprocess.this.isSocketOpen()) {
                    FtpUserDataTransferprocess.this.closeSocket();
                }
            }
        }

        private abstract class DataConnection {
            private DataConnection() {
            }

            private void connect(int timeout) throws IOException {
                if (!FtpUserDataTransferprocess.this.isSocketOpen()) {
                    this.open(timeout);
                }
            }

            abstract void open(int var1) throws IOException;

            abstract void close() throws IOException;
        }

        private class PassiveClientDataConnection
        extends DataConnection {
            private ServerSocket serverSocket = new ServerSocket(0);

            @Override
            public void open(int timeout) throws IOException {
                Assert.pre(!FtpUserDataTransferprocess.this.isSocketOpen());
                if (timeout > 0) {
                    this.serverSocket.setSoTimeout(timeout);
                }
                FtpUserDataTransferprocess.this.setSocket(this.serverSocket.accept());
            }

            @Override
            public void close() throws IOException {
                Assert.pre(this.serverSocket != null);
                if (FtpUserDataTransferprocess.this.isSocketOpen()) {
                    FtpUserDataTransferprocess.this.closeSocket();
                }
                this.serverSocket.close();
                this.serverSocket = null;
                Assert.post(this.serverSocket == null);
            }

            private String getDataPortArgument() throws UnknownHostException {
                return FtpDataTransferProcess.getDataPortArgument(this.serverSocket);
            }
        }
    }
}

