/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.ftp;

import edu.uml.lgdc.ftp.Assert;
import edu.uml.lgdc.ftp.FtpProtocolConstants;
import edu.uml.lgdc.ftp.FtpProtocolException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;

class FtpUserProtocolInterpreter
implements FtpProtocolConstants {
    private Socket socket;
    private BufferedWriter out;
    private BufferedReader in;
    private PrintWriter trace;
    private char[] charArrayReply;
    private StringBuilder replyStringBuffer = new StringBuilder(2000);

    public FtpUserProtocolInterpreter(String hostName, int port, PrintWriter printWriterForTrace) throws UnknownHostException, IOException {
        Assert.pre(hostName != null);
        Assert.pre(hostName.length() > 0);
        Assert.pre(port > 0);
        Assert.pre(printWriterForTrace != null);
        this.trace = printWriterForTrace;
        this.socket = new Socket(hostName, port);
        try {
            this.out = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), "ASCII"));
            this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("UnsupportedEncodingException: " + e.getMessage());
            this.out = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
            this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        }
        this.charArrayReply = new char[4];
        Reply reply = new Reply();
        this.getReply(reply);
        Assert.check(reply.code == 120 || reply.code == 220 || reply.code == 221 || reply.code == 421);
    }

    public FtpUserProtocolInterpreter(String hostName, int port, int timeout, PrintWriter printWriterForTrace) throws UnknownHostException, IOException {
        this(hostName, port, printWriterForTrace);
        this.setTimeout(timeout);
    }

    public void close() throws IOException {
        this.in.close();
        this.out.close();
        this.socket.close();
    }

    private void putCommand(String command, String argument) throws IOException {
        command = String.valueOf(command) + (argument != null ? " " + argument : "");
        this.out.write(String.valueOf(command) + "\r\n");
        this.out.flush();
    }

    private void getOneReply(Reply reply) throws IOException {
        int CODELENGTH = 3;
        int MULTILINE = 45;
        Assert.check(this.charArrayReply.length == 4);
        if (this.in.read(this.charArrayReply, 0, 4) != 4) {
            throw new SocketException("Not enough characters from reply code");
        }
        if ('1' > this.charArrayReply[0] || this.charArrayReply[0] > '5' || '0' > this.charArrayReply[1] || this.charArrayReply[1] > '5' || '0' > this.charArrayReply[2] || this.charArrayReply[2] > '9' || ' ' != this.charArrayReply[3] && '-' != this.charArrayReply[3]) {
            throw new SocketException("Invalid reply code from server \"" + new String(this.charArrayReply, 0, 4) + "\"");
        }
        reply.firstDigit = this.charArrayReply[0];
        reply.code = 0;
        int index = 0;
        while (index < 3) {
            int value = this.charArrayReply[index] - 48;
            if (value < 0 || value > 9) {
                String message = "Bad return code from server: " + new String(this.charArrayReply, 0, 3);
                throw new FtpProtocolException(501, message);
            }
            reply.code = reply.code * 10 + value;
            ++index;
        }
        String nextLine = this.in.readLine();
        this.replyStringBuffer.setLength(0);
        this.replyStringBuffer.append(nextLine);
        if (this.charArrayReply[3] == '-') {
            String terminationMarker = String.valueOf(new String(this.charArrayReply, 0, 3)) + " ";
            while ((nextLine = this.in.readLine()) != null) {
                if (nextLine.length() >= 4 && nextLine.substring(0, 4).equals(terminationMarker)) {
                    this.replyStringBuffer.append(nextLine.substring(3));
                    break;
                }
                this.replyStringBuffer.append(String.valueOf(nextLine) + "\n");
            }
        }
        reply.text = this.replyStringBuffer.toString();
    }

    public void getReply(Reply reply) throws FtpProtocolException, IOException {
        this.getOneReply(reply);
        if (reply.code == 120) {
            this.getOneReply(reply);
        }
        if (reply.firstDigit == 52 || reply.firstDigit == 53) {
            throw new FtpProtocolException(reply.code, reply.text);
        }
    }

    public final int getTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }

    public final void setTimeout(int timeout) throws SocketException {
        Assert.pre(timeout > 100 && timeout < 300000 || timeout == 0);
        this.socket.setSoTimeout(timeout);
    }

    public void transaction(String command, String argument, Reply reply) throws FtpProtocolException, IOException {
        Assert.pre(command != null);
        Assert.pre(command.length() >= 3 && command.length() <= 4);
        this.putCommand(command, argument);
        this.getReply(reply);
    }

    public void transaction(String command, Reply reply) throws FtpProtocolException, IOException {
        this.transaction(command, null, reply);
    }

    public static class Reply {
        int firstDigit;
        int code;
        String text;
    }
}

