/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.geospace;

import edu.uml.lgdc.geospace.GroundSolar;
import edu.uml.lgdc.time.TimeScale;

public class DayNightInterpolator {
    private static final double MAXIMUM_ARGUMENT = 88.0;
    private static final double EPSTEIN_STEP_HOURS = 1.0;
    private static double sunrise_LThour;
    private static double sunset_LThour;
    private static boolean polarNight;
    private static boolean polarDay;
    private static boolean isNight;

    static {
        polarNight = false;
        polarDay = false;
        isNight = false;
    }

    public static void initialize(double latN_deg, double lonE_deg, double altitude_km, TimeScale time) {
        GroundSolar sunData = new GroundSolar(latN_deg, lonE_deg, altitude_km, time);
        sunrise_LThour = sunData.getSunriseTimeInHoursLT();
        sunset_LThour = sunData.getSunsetTimeInHoursLT();
        polarNight = sunData.isAlwaysBelow();
        polarDay = sunData.isAlwaysBelow();
        isNight = sunData.isNight();
    }

    public static double getValue(double hourUT, double dayValue, double nightValue) {
        if (polarNight) {
            return nightValue;
        }
        if (polarDay) {
            return dayValue;
        }
        return nightValue + (dayValue - nightValue) * DayNightInterpolator.EpsteinStep(hourUT, sunrise_LThour) + (nightValue - dayValue) * DayNightInterpolator.EpsteinStep(hourUT, sunset_LThour);
    }

    private static double EpsteinStep(double hour, double reference_hr) {
        double d1 = (hour - reference_hr) / 1.0;
        if (Math.abs(d1) > 88.0) {
            return d1 > 0.0 ? 1 : 0;
        }
        return 1.0 / (1.0 + Math.exp(-d1));
    }

    public static boolean isNight() {
        return isNight;
    }
}

