/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.geospace;

public class EpsteinInterpolator {
    private static final double MAXIMUM_ARGUMENT = 88.0;

    public static double compute(double hour, double dayValue, double nightValue, double sunrise_hr, double sunset_hr) {
        if (Math.abs(sunset_hr) > 25.0) {
            return sunset_hr > 0.0 ? dayValue : nightValue;
        }
        return nightValue + (dayValue - nightValue) * EpsteinInterpolator.function(hour, 1.0, sunrise_hr) + (nightValue - dayValue) * EpsteinInterpolator.function(hour, 1.0, sunset_hr);
    }

    public static double function(double hour, double step_hr, double reference_hr) {
        double d1 = (hour - reference_hr) / step_hr;
        if (Math.abs(d1) > 88.0) {
            return d1 > 0.0 ? 1 : 0;
        }
        return 1.0 / (1.0 + Math.exp(-d1));
    }
}

