/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.geospace;

import edu.uml.lgdc.fileio.FileUtils;
import edu.uml.lgdc.format.FC;
import edu.uml.lgdc.geospace.GeoMagIndexChoice;
import edu.uml.lgdc.time.TimeScale;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;

public class GeoMagIndexesManager {
    public static final int CONNECTION_TIMEOUT = 3000;
    public static final int READ_TIMEOUT = 10000;
    public static final int KP_VALUES_IN_DAY = 8;
    public static final int KP_START_POSITION = 12;
    public static final int KP_LENGTH = 2;
    public static final int KP_START_INDEX = 1;
    public static final int AP_VALUES_IN_DAY = 8;
    public static final int AP_START_POSITION = 31;
    public static final int AP_LENGTH = 3;
    public static final int AP_START_INDEX = 9;
    public static final int KP_AP_LINE_LENGTH = 71;
    public static final int DATE_INDEX = 0;
    public static final int TOTAL_INDEXES_USED_KP_AP = 17;
    public static final int DATE_START_INDEX = 0;
    public static final int DATE_LENGTH = 6;
    public static final int YEAR_START_INDEX = 0;
    public static final int YEAR_LENGTH = 2;
    public static final int ROTATIONS_START_INDEX = 6;
    public static final int ROTATIONS_LENGTH = 4;
    public static final int BARTELS_SOLAR_ROTATION_NUMBER_2000 = 2272;
    public static final String DST_PREF = "dst";
    public static final String DST_EXT = "txt";
    public static final String MASK = "DSTyymmcdd      ";
    public static final char DST_CATEGORY_REALTIME = 'Q';
    public static final char DST_CATEGORY_PROVISIONAL = 'P';
    public static final char DST_CATEGORY_FINAL = '*';
    public static final int DST_VALUES_IN_DAY = 25;
    public static final int DST_START_POSITION = 20;
    public static final int DST_LENGTH = 4;
    public static final int DST_LINE_LENGTH = 120;
    public static final int DST_START_INDEX = 1;
    public static final int DST_YEAR_START_INDEX = 3;
    public static final int DST_YEAR_LENGTH = 2;
    public static final int DST_MONTH_START_INDEX = 5;
    public static final int DST_MONTH_LENGTH = 2;
    public static final int DST_DAY_START_INDEX = 8;
    public static final int DST_DAY_LENGTH = 2;
    public static final int DST_TOTAL_ELEMENTS_IN_LINE = 26;

    public static int[][] readKpAp(TimeScale startDate, TimeScale endDate, TimeScale[][] times, String folder) {
        System.out.println("Kp for " + startDate.toHumanUT() + " to " + endDate.toHumanUT());
        return GeoMagIndexesManager.readData(GeoMagIndexChoice.KP_AP, startDate, endDate, 17, folder, "", times);
    }

    public static int[][] readDST(TimeScale startDate, TimeScale endDate, TimeScale[][] times, String folder) {
        System.out.println("DST for " + startDate.toHumanUT() + " to " + endDate.toHumanUT());
        return GeoMagIndexesManager.readData(GeoMagIndexChoice.DST, startDate, endDate, 26, String.valueOf(folder) + DST_PREF, ".txt", times);
    }

    private static int[][] readData(GeoMagIndexChoice gmIndex, TimeScale sDate, TimeScale eDate, int numElementsLine, String pref, String ext, TimeScale[][] times) {
        TimeScale startDate = sDate.startOfDay();
        TimeScale endDate = eDate.endOfDay();
        int daysNumber = (int)(endDate.getTimeInMillis() / 86400000L - startDate.getTimeInMillis() / 86400000L) + 1;
        TimeScale date = new TimeScale(startDate.getTimeInMinutes());
        int[][] data = new int[daysNumber][numElementsLine];
        int year = startDate.get(1);
        int iLine = 0;
        if (times != null) {
            times[0] = new TimeScale[data.length * 24];
        }
        double startTime_min = startDate.getTimeInMinutes();
        while (year <= endDate.get(1)) {
            date.set(1, year);
            TimeScale startOfYear = year == startDate.get(1) ? startDate : date.startOfYear();
            TimeScale endOfYear = year == endDate.get(1) ? endDate : date.endOfYear();
            String fileName = String.valueOf(pref) + year + ext;
            switch (gmIndex) {
                case KP_AP: {
                    iLine = GeoMagIndexesManager.readKpApFile(data, iLine, fileName, startOfYear, endOfYear);
                    if (iLine < 0) {
                        return null;
                    }
                    if (times[0] == null) break;
                    times[0] = new TimeScale[data.length * 7];
                    int i = 0;
                    while (i < times[0].length) {
                        times[0][i] = new TimeScale(startTime_min + (double)(205 * i));
                        ++i;
                    }
                    break;
                }
                case DST: {
                    iLine = GeoMagIndexesManager.readDSTFile(data, iLine, fileName, year, startOfYear, endOfYear);
                    if (iLine < 0) {
                        return null;
                    }
                    if (times[0] == null) break;
                    int i = 0;
                    while (i < times[0].length) {
                        times[0][i] = new TimeScale(startTime_min + (double)(60 * i));
                        ++i;
                    }
                    break;
                }
            }
            ++year;
        }
        return data;
    }

    private static int readKpApFile(int[][] data, int iStart, String fileName, TimeScale startDate, TimeScale endDate) {
        int sDate = Integer.parseInt(startDate.toFormatUT("yyyyMMdd"));
        int eDate = Integer.parseInt(endDate.toFormatUT("yyyyMMdd"));
        long linesNumber = FileUtils.countLines(fileName);
        if (linesNumber != (long)((int)linesNumber)) {
            System.out.println("File too long. Should be shorter than 2147483647.");
            return iStart;
        }
        if (!new File(fileName).exists()) {
            return -1;
        }
        try {
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            int iLine = 0;
            while (iLine < (int)linesNumber) {
                String rawData = br.readLine();
                if (rawData.length() < 71) {
                    System.out.println("Check length for line " + (iLine + 1) + " in file " + new File(fileName).getAbsolutePath());
                } else {
                    String date = rawData.substring(0, 6).replace(' ', '0');
                    int rotationNumber = Integer.parseInt(rawData.substring(6, 10));
                    int cDate = Integer.parseInt(date = GeoMagIndexesManager.getYear(date, rotationNumber));
                    if (cDate >= sDate && cDate <= eDate) {
                        data[iStart][0] = cDate;
                        int i = 0;
                        while (i < 8) {
                            data[iStart][i + 1] = Integer.parseInt(rawData.substring(12 + i * 2, 12 + (i + 1) * 2).trim());
                            ++i;
                        }
                        i = 0;
                        while (i < 8) {
                            data[iStart][i + 9] = Integer.parseInt(rawData.substring(31 + i * 3, 31 + (i + 1) * 3).trim());
                            ++i;
                        }
                        ++iStart;
                    }
                }
                ++iLine;
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return iStart;
    }

    private static int readDSTFile(int[][] data, int iStart, String fileName, int year, TimeScale startDate, TimeScale endDate) {
        int sDate = Integer.parseInt(startDate.toFormatUT("yyyyMMdd"));
        int eDate = Integer.parseInt(endDate.toFormatUT("yyyyMMdd"));
        long linesNumber = FileUtils.countLines(fileName);
        if (linesNumber != (long)((int)linesNumber)) {
            System.out.println("File too long. Should be shorter than 2147483647.");
            return iStart;
        }
        if (!new File(fileName).exists()) {
            return -1;
        }
        try {
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            int iLine = 0;
            while (iLine < (int)linesNumber) {
                String rawData = br.readLine();
                if (rawData.length() < 120) {
                    System.out.println("Check length for line " + (iLine + 1) + " in file " + new File(fileName).getAbsolutePath());
                } else {
                    String date = String.valueOf(year) + rawData.substring(5, 7).replace(' ', '0') + rawData.substring(8, 10).replace(' ', '0');
                    int cDate = Integer.parseInt(date);
                    if (cDate >= sDate && cDate <= eDate) {
                        data[iStart][0] = cDate;
                        int i = 0;
                        while (i < 25) {
                            int startPos = 20 + i * 4;
                            int sign = rawData.substring(startPos, startPos + 1).trim().isEmpty() ? 1 : -1;
                            data[iStart][i + 1] = Integer.parseInt(rawData.substring(startPos + 1, startPos + 4).trim());
                            data[iStart][i + 1] = sign * data[iStart][i + 1];
                            ++i;
                        }
                        ++iStart;
                    }
                }
                ++iLine;
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return iStart;
    }

    public static void writeDSTFile(String fileName, int[][][] data, Character[] category, int year) {
        File file = new File(fileName);
        file.mkdirs();
        if (file.exists()) {
            file.delete();
        }
        try {
            PrintWriter writer = new PrintWriter(file.getAbsolutePath());
            int iMonth = 0;
            while (iMonth < data.length) {
                if (data[iMonth] == null) break;
                int iDay = 0;
                while (iDay < data[iMonth].length) {
                    String line = MASK.replace("yy", FC.IntegerToString(year % 100, 2, '0'));
                    line = line.replace("mm", FC.IntegerToString(iMonth + 1, 2, '0'));
                    line = line.replace("dd", FC.IntegerToString(iDay + 1, 2, '0'));
                    line = line.replace('c', category[iMonth].charValue());
                    line = String.valueOf(line) + FC.IntegerToString(0, 4);
                    int average = 0;
                    int iVal = 0;
                    while (iVal < data[iMonth][iDay].length) {
                        average += data[iMonth][iDay][iVal];
                        line = String.valueOf(line) + FC.IntegerToString(data[iMonth][iDay][iVal], 4, ' ');
                        ++iVal;
                    }
                    line = String.valueOf(line) + FC.IntegerToString(average /= data[iMonth][iDay].length, 4, ' ');
                    writer.write(String.valueOf(line) + "\n");
                    ++iDay;
                }
                ++iMonth;
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String getYear(String date, int rotations) {
        if (rotations < 2272) {
            date = "19" + date;
        } else if (rotations > 2272) {
            date = "20" + date;
        } else if (rotations == 2272) {
            date = date.substring(0, 2) == "99" ? "19" + date : "20" + date;
        }
        return date;
    }

    public static DisturbedPeriod[] getDistubedPeriods_DST(TimeScale startTime, TimeScale endTime, int stormClass, String folder) {
        ArrayList<DisturbedPeriod> periods = new ArrayList<DisturbedPeriod>();
        int[][] dst = GeoMagIndexesManager.readDST(startTime, endTime, null, folder);
        int countHours = 0;
        TimeScale sTime = new TimeScale();
        int i = 0;
        while (i < dst.length) {
            int iHour = 0;
            while (iHour < 24) {
                countHours = GeoMagIndexesManager.countStormDST(dst[i][iHour + 1], dst[i][0], iHour, countHours, stormClass, sTime, periods);
                ++iHour;
            }
            ++i;
        }
        DisturbedPeriod[] periodsArray = new DisturbedPeriod[periods.size()];
        return periods.toArray(periodsArray);
    }

    public static double[] getAverageDST(TimeScale startTime, TimeScale endTime, String folder) {
        int[][] dst = GeoMagIndexesManager.readDST(startTime, endTime, null, folder);
        double[] aver_dst = new double[dst.length];
        int i = 0;
        while (i < dst.length) {
            int iHour = 0;
            while (iHour < 24) {
                int n = i;
                aver_dst[n] = aver_dst[n] + (double)dst[i][iHour + 1];
                ++iHour;
            }
            int n = i++;
            aver_dst[n] = aver_dst[n] / 24.0;
        }
        return aver_dst;
    }

    public static int[] getDST(TimeScale startTime, TimeScale endTime, TimeScale[][] times, String folder) {
        int[][] dst = GeoMagIndexesManager.readDST(startTime, endTime, times, folder);
        int[] dstOut = new int[dst.length * 24];
        int i = 0;
        while (i < dst.length) {
            int iHour = 0;
            while (iHour < 24) {
                int n = iHour + 24 * i;
                dstOut[n] = dstOut[n] + dst[i][iHour + 1];
                ++iHour;
            }
            ++i;
        }
        return dstOut;
    }

    private static int countStormDST(int dst, int date, int iHour, int countHours, int stormClass, TimeScale startTime, ArrayList<DisturbedPeriod> periods) {
        if (dst <= DisturbedPeriod.DST_STORM_THRESHOLD[stormClass]) {
            if (countHours == 0) {
                startTime.setTimeInMinutes(GeoMagIndexesManager.getInt2TimeScale(date, iHour, false).getTimeInMinutes());
            }
            ++countHours;
        } else {
            if (countHours != 0) {
                DisturbedPeriod period = new DisturbedPeriod(stormClass, (TimeScale)startTime.clone(), GeoMagIndexesManager.getInt2TimeScale(date, iHour - 1, true));
                periods.add(period);
            }
            countHours = 0;
        }
        return countHours;
    }

    public static TimeScale getInt2TimeScale(int date, int hour, boolean isHourEnd) {
        int year = date / 10000;
        int month = (date - year * 10000) / 100;
        int day = date - year * 10000 - month * 100;
        if (!isHourEnd) {
            return new TimeScale(year, month - 1, day, hour, 0, 0);
        }
        return new TimeScale(year, month - 1, day, hour, 59, 59);
    }

    public static String getIndexFileName(int year, GeoMagIndexChoice indexID) {
        switch (indexID) {
            case DST: {
                return DST_PREF + year + "." + DST_EXT;
            }
            case KP_AP: {
                return "" + year;
            }
        }
        return null;
    }

    private static void printOutKpAp(int[] data, int date) {
        String kpStr = "";
        String apStr = "";
        int iKp = 1;
        while (iKp < 9) {
            kpStr = String.valueOf(kpStr) + data[iKp] + " ";
            ++iKp;
        }
        int iAp = 9;
        while (iAp < 17) {
            apStr = String.valueOf(apStr) + data[iAp] + " ";
            ++iAp;
        }
        System.out.println(String.valueOf(date) + " " + kpStr + " " + apStr);
    }

    private static void printOutDST(int[] data, int date) {
        String dstStr = "";
        int iDST = 1;
        while (iDST < 26) {
            dstStr = String.valueOf(dstStr) + data[iDST] + " ";
            ++iDST;
        }
        System.out.println(String.valueOf(date) + " " + dstStr);
    }

    public static class DisturbedPeriod {
        public static final int DST_STORM_MODERATE = 0;
        public static final int DST_STORM_INTENSE = 1;
        public static final int DST_STORM_SUPER = 2;
        public static final String[] DST_STORM_NAMES = new String[]{"moderate", "intense", "super"};
        public static final int[] DST_STORM_THRESHOLD = new int[]{-50, -100, -250};
        public TimeScale startTime;
        public TimeScale endTime;
        public int stormClassDST;

        public DisturbedPeriod(int stormClassDST, TimeScale startTime, TimeScale endTime) {
            this.stormClassDST = stormClassDST;
            this.startTime = startTime;
            this.endTime = endTime;
        }

        public void printOut() {
            System.out.println("Strorm class " + DST_STORM_NAMES[this.stormClassDST] + " from " + this.startTime.toHumanUT() + " to " + this.endTime.toHumanUT());
        }

        public TimeScale[] getTimePeriod() {
            TimeScale[] times = new TimeScale[]{(TimeScale)this.startTime.clone(), (TimeScale)this.endTime.clone()};
            return times;
        }
    }
}

