/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.geospace;

import edu.uml.lgdc.fileio.FileUtils;
import edu.uml.lgdc.geospace.GeoMagIndexChoice;
import edu.uml.lgdc.geospace.GeoMagIndexesManager;
import edu.uml.lgdc.project.CommandLineParam;
import edu.uml.lgdc.time.TimeScale;
import java.io.File;
import java.io.IOException;

public abstract class Getter {
    public void getRecentData(String rootPath) {
        int year_now = new TimeScale().get(1);
        int year_before = year_now - 1;
        File file_now = new File(String.valueOf(rootPath) + GeoMagIndexesManager.getIndexFileName(year_now, this.getIndexID()));
        File file_before = new File(String.valueOf(rootPath) + GeoMagIndexesManager.getIndexFileName(year_before, this.getIndexID()));
        File[] files = new File[]{file_now, file_before};
        int[] years = new int[]{year_now, year_before};
        File temp = new File(rootPath, "temp.txt");
        try {
            int i = 0;
            while (i < files.length) {
                if (this.getFile(temp, years[i])) {
                    if (files[i].exists()) {
                        files[i].delete();
                    }
                    FileUtils.moveFile(temp, files[i]);
                }
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected abstract GeoMagIndexChoice getIndexID();

    protected abstract boolean getFile(File var1, int var2);

    public static String parseDstPath(CommandLineParam commandLineParam, String defaultPath) {
        if (commandLineParam.isKeyExists("dst_path")) {
            return commandLineParam.getKeyValue("dst_path");
        }
        System.out.println("Work with default DST data folder (relative path): " + defaultPath);
        System.out.println("To specify folder use parameter -dst_path:PATH_TO_DST_ROOT_FOLDER_HERE");
        return defaultPath;
    }

    public static String parseKpApPath(CommandLineParam commandLineParam, String defaultPath) {
        if (commandLineParam.isKeyExists("kpap_path")) {
            return commandLineParam.getKeyValue("kpap_path");
        }
        System.out.println("Work with default Kp_Ap data folder (relative path): " + defaultPath);
        System.out.println("To specify folder use parameter -kpap_path:PATH_TO_KPAP_ROOT_FOLDER_HERE");
        return defaultPath;
    }

    public static int parseUpdatesPerDay(CommandLineParam commandLineParam) {
        if (commandLineParam.isKeyExists("numupdates")) {
            try {
                return Integer.parseInt(commandLineParam.getKeyValue("numupdates").trim());
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return 0;
    }
}

