/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.geospace;

import edu.uml.lgdc.format.FC;
import edu.uml.lgdc.time.RealHours;
import edu.uml.lgdc.time.TimeScale;
import java.util.Vector;

public class GroundSolar {
    public static final double ALWAYS_BELOW_HORIZON = -99.0;
    public static final double ALWAYS_ABOVE_HORIZON = 99.0;
    private static final int MAX_DAYS_TO_SKIP = 365;
    private double sunriseInHoursLT;
    private double sunsetInHoursLT;
    private double sunriseInHoursUT;
    private double sunsetInHoursUT;
    private TimeScale sunriseTimeLT;
    private TimeScale sunsetTimeLT;
    private TimeScale sunriseTimeUT;
    private TimeScale sunsetTimeUT;
    private double noonSunDeclination;
    private double noonSunZenith;
    private double sunDeclination;
    private double sunZenith;
    private double latitude;
    private double longitude;
    private TimeScale ut;
    private double height;
    private double offsetInHoursToUT = 0.0;
    private double offset = 0.0;
    private int dayOfYear;
    private double hours;

    public GroundSolar(double latitude, double longitude, TimeScale ut) {
        this(latitude, longitude, 0.0, ut);
    }

    public GroundSolar(double latitude, double longitude, double height, TimeScale ut) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.height = height;
        this.ut = ut;
        this.setup();
    }

    public void setTime(TimeScale ut) {
        this.ut = ut;
        this.setup();
    }

    public void setHeight(double height) {
        this.height = height;
        this.setup();
    }

    public boolean isNormalTrajectory() {
        return this.sunriseInHoursLT != 99.0 && this.sunriseInHoursLT != -99.0;
    }

    public boolean isAlwaysAbove() {
        return this.sunriseInHoursLT == 99.0;
    }

    public boolean isAlwaysBelow() {
        return this.sunriseInHoursLT == -99.0;
    }

    public double getSunriseTimeInHoursLT() {
        return this.sunriseInHoursLT;
    }

    public double getSunsetTimeInHoursLT() {
        return this.sunsetInHoursLT;
    }

    public double getSunriseTimeInHoursUT() {
        return this.sunriseInHoursUT;
    }

    public double getSunsetTimeInHoursUT() {
        return this.sunsetInHoursUT;
    }

    public TimeScale getSunriseTimeLT() {
        return this.sunriseTimeLT;
    }

    public TimeScale getSunsetTimeLT() {
        return this.sunsetTimeLT;
    }

    public TimeScale getSunriseTimeUT() {
        return this.sunriseTimeUT;
    }

    public TimeScale getSunsetTimeUT() {
        return this.sunsetTimeUT;
    }

    public double getOffsetInHoursToUT() {
        return this.offsetInHoursToUT;
    }

    public double getDeclination() {
        return this.sunDeclination;
    }

    public double getZenith() {
        return this.sunZenith;
    }

    public double getNoonDeclination() {
        return this.noonSunDeclination;
    }

    public double getNoonZenith() {
        return this.noonSunZenith;
    }

    public void setLocalTimeOffset(double offset) {
        this.offset = offset;
    }

    public boolean isDay(double lcHour) {
        return !this.isNight(lcHour);
    }

    public boolean isNight(double lcHour) {
        boolean isNight = false;
        if (this.isAlwaysBelow()) {
            isNight = true;
        } else if (this.isNormalTrajectory() && (lcHour > this.getSunsetTimeInHoursLT() || lcHour < this.getSunriseTimeInHoursLT())) {
            isNight = true;
        }
        return isNight;
    }

    public boolean isDay() {
        return !this.isNight();
    }

    public boolean isNight() {
        boolean isNight = false;
        if (this.isAlwaysBelow()) {
            isNight = true;
        } else if (this.isNormalTrajectory()) {
            isNight = this.sunsetTimeUT.before(this.ut) || this.ut.before(this.sunriseTimeUT);
        }
        return isNight;
    }

    public String toString() {
        double localSunset;
        double localSunrise = this.sunriseInHoursUT;
        if (localSunrise != -99.0 && localSunrise != 99.0) {
            if ((localSunrise += this.offset) >= 24.0) {
                localSunrise -= 24.0;
            } else if (localSunrise < 0.0) {
                localSunrise += 24.0;
            }
        }
        if ((localSunset = this.sunsetInHoursUT) != -99.0 && localSunset != 99.0) {
            if ((localSunset += this.offset) >= 24.0) {
                localSunset -= 24.0;
            } else if (localSunset < 0.0) {
                localSunset += 24.0;
            }
        }
        return "latitude = " + FC.DoubleToString(this.latitude, 7, 2) + "\r\n" + "longitude = " + FC.DoubleToString(this.longitude, 7, 2) + "\r\n" + "ut = " + this.ut.toHumanUT() + "\r\n" + "sunrise time = " + this.timeToHuman(this.sunriseInHoursLT) + "\r\n" + "sunset time = " + this.timeToHuman(this.sunsetInHoursLT) + "\r\n" + "sunrise time local = " + this.timeToHuman(localSunrise) + "\r\n" + "sunset time local = " + this.timeToHuman(localSunset) + "\r\n" + "sun declination = " + FC.DoubleToString(this.sunDeclination, 7, 2) + "\r\n" + "sun zenith = " + FC.DoubleToString(this.sunZenith, 7, 2) + "\r\n" + "noon sun declination = " + FC.DoubleToString(this.noonSunDeclination, 7, 2) + "\r\n" + "noon sun zenith = " + FC.DoubleToString(this.noonSunZenith, 7, 2) + "\r\n";
    }

    private String timeToHuman(double time) {
        String timeStr = "";
        timeStr = time == 99.0 ? "ALWAYS ABOVE" : (time == -99.0 ? "ALWAYS BELOW" : RealHours.toHuman(time));
        return timeStr;
    }

    private void setup() {
        this.setup(this.latitude, this.longitude, this.height, TimeScale.getLongitudeTime(this.longitude, this.ut));
    }

    private void setup(double latitude, double longitude, double height, TimeScale longitudeTime) {
        this.setup(latitude, longitude, height, longitudeTime.get(6), RealHours.toRealHours(longitudeTime));
    }

    private void setup(double latitude, double longitude, double height, int localDayOfYear, double longitudeHour) {
        this.calc(latitude, longitude, height, localDayOfYear, longitudeHour);
        double tmpSunDeclination = this.sunDeclination;
        double tmpSunZenith = this.sunZenith;
        this.calc(latitude, longitude, height, localDayOfYear, 12.0);
        this.noonSunDeclination = this.sunDeclination;
        this.noonSunZenith = this.sunZenith;
        this.sunDeclination = tmpSunDeclination;
        this.sunZenith = tmpSunZenith;
        if (this.sunriseInHoursUT == 99.0 || this.sunriseInHoursUT == 99.0) {
            this.sunriseTimeLT = null;
            this.sunsetTimeLT = null;
            this.sunriseTimeUT = null;
            this.sunsetTimeUT = null;
        } else {
            RealHours rh = new RealHours(this.sunriseInHoursLT);
            this.sunriseTimeLT = TimeScale.getLongitudeTime(longitude, this.ut);
            this.sunriseTimeLT.set(11, rh.getHours());
            this.sunriseTimeLT.set(12, rh.getMinutes());
            this.sunriseTimeLT.set(13, rh.getSeconds());
            this.sunriseTimeLT.set(14, rh.getMillisecs());
            rh = new RealHours(this.sunsetInHoursLT);
            this.sunsetTimeLT = TimeScale.getLongitudeTime(longitude, this.ut);
            this.sunsetTimeLT.set(11, rh.getHours());
            this.sunsetTimeLT.set(12, rh.getMinutes());
            this.sunsetTimeLT.set(13, rh.getSeconds());
            this.sunsetTimeLT.set(14, rh.getMillisecs());
            this.sunriseTimeUT = TimeScale.getTimeUT(longitude, this.sunriseTimeLT);
            this.sunsetTimeUT = TimeScale.getTimeUT(longitude, this.sunsetTimeLT);
        }
    }

    private void calc(double latitude, double longitude, int localDayOfYear, double longitudeHour) {
        this.calc(latitude, longitude, 0.0, localDayOfYear, longitudeHour);
    }

    private void calc(double latitude, double longitude, double height, int localDayOfYear, double longitudeHour) {
        double b;
        double dcl;
        double p1 = 0.017203534;
        double p2 = 0.034407068;
        double p3 = 0.051610602;
        double p4 = 0.068814136;
        double p6 = 0.103221204;
        height *= 1000.0;
        this.offsetInHoursToUT = longitude / 15.0;
        if (this.offsetInHoursToUT > 12.0) {
            this.offsetInHoursToUT = 24.0 - this.offsetInHoursToUT;
            this.offsetInHoursToUT = -this.offsetInHoursToUT;
        }
        double wlon = 360.0 - longitude;
        double td = (double)localDayOfYear + (longitudeHour + wlon / 15.0) / 24.0;
        double te = td + 0.9369;
        this.sunDeclination = dcl = 23.256 * Math.sin(p1 * (te - 82.242)) + 0.381 * Math.sin(p2 * (te - 44.855)) + 0.167 * Math.sin(p3 * (te - 23.355)) - 0.013 * Math.sin(p4 * (te + 11.97)) + 0.011 * Math.sin(p6 * (te - 10.41)) + 0.339137;
        double dc = Math.toRadians(dcl);
        double tf = te - 0.5;
        double eqt = -7.38 * Math.sin(p1 * (tf - 4.0)) - 9.87 * Math.sin(p2 * (tf + 9.0)) + 0.27 * Math.sin(p3 * (tf - 53.0)) - 0.2 * Math.cos(p4 * (tf - 17.0));
        double et = Math.toRadians(eqt) / 4.0;
        double fa = Math.toRadians(latitude);
        double phi = 0.26179939 * (longitudeHour - 12.0) + et;
        double a = Math.sin(fa) * Math.sin(dc);
        double cosx = a + (b = Math.cos(fa) * Math.cos(dc)) * Math.cos(phi);
        if (cosx > 1.0) {
            cosx = 1.0;
        } else if (cosx < -1.0) {
            cosx = -1.0;
        }
        this.sunZenith = Math.toDegrees(Math.acos(cosx));
        double ch = Math.cos(Math.toRadians(90.83 + 0.0347 * Math.sqrt(height)));
        double cosphi = (ch - a) / b;
        double secphi = 999999.0;
        if (cosphi != 0.0) {
            secphi = 1.0 / cosphi;
        }
        this.sunsetInHoursLT = 99.0;
        this.sunriseInHoursLT = 99.0;
        if (secphi > -1.0 && secphi <= 0.0) {
            this.sunsetInHoursUT = this.sunsetInHoursLT;
            this.sunriseInHoursUT = this.sunriseInHoursLT;
            return;
        }
        this.sunsetInHoursLT = -99.0;
        this.sunriseInHoursLT = -99.0;
        if (secphi > 0.0 && secphi < 1.0) {
            this.sunsetInHoursUT = this.sunsetInHoursLT;
            this.sunriseInHoursUT = this.sunriseInHoursLT;
            return;
        }
        if (cosphi > 1.0) {
            cosphi = 1.0;
        }
        if (cosphi < -1.0) {
            cosphi = -1.0;
        }
        phi = Math.acos(cosphi);
        this.sunriseInHoursLT = 12.0 - (phi /= 0.26179939) - (et /= 0.26179939);
        this.sunsetInHoursLT = 12.0 + phi - et;
        if (this.sunriseInHoursLT < 0.0) {
            this.sunriseInHoursLT = -this.sunriseInHoursLT % 24.0;
            if (this.sunriseInHoursLT > 0.0) {
                this.sunriseInHoursLT = 24.0 - this.sunriseInHoursLT;
            }
        }
        if (this.sunsetInHoursLT >= 24.0) {
            this.sunsetInHoursLT %= 24.0;
        }
        this.sunriseInHoursUT = this.sunriseInHoursLT;
        this.sunsetInHoursUT = this.sunsetInHoursLT;
        this.sunriseInHoursUT -= longitude / 15.0;
        if (this.sunriseInHoursUT < 0.0) {
            this.sunriseInHoursUT = -this.sunriseInHoursUT % 24.0;
            if (this.sunriseInHoursUT > 0.0) {
                this.sunriseInHoursUT = 24.0 - this.sunriseInHoursUT;
            }
        }
        if (this.sunriseInHoursUT >= 24.0) {
            this.sunriseInHoursUT %= 24.0;
        }
        this.sunsetInHoursUT -= longitude / 15.0;
        if (this.sunsetInHoursUT < 0.0) {
            this.sunsetInHoursUT = -this.sunsetInHoursUT % 24.0;
            if (this.sunsetInHoursUT > 0.0) {
                this.sunsetInHoursUT = 24.0 - this.sunsetInHoursUT;
            }
        }
        if (this.sunsetInHoursUT >= 24.0) {
            this.sunsetInHoursUT %= 24.0;
        }
    }

    public TimeScale[][] getCoverage(TimeScale startTime, TimeScale endTime, boolean isNight, int maxNumberOfIntervals) {
        if (!isNight) {
            return this.getDayCoverage(startTime, endTime, maxNumberOfIntervals);
        }
        return this.getNightCoverage(startTime, endTime, maxNumberOfIntervals);
    }

    public TimeScale[][] getDayCoverage(TimeScale startTime, TimeScale endTime, int maxNumberOfIntervals) {
        TimeScale endInt;
        TimeScale startInt;
        TimeScale[][] intervals = new TimeScale[0][2];
        Vector<TimeScale[]> vIntervals = new Vector<TimeScale[]>(50, 50);
        this.setTime(startTime);
        if (this.isDay()) {
            startInt = this.getStartOfDaytimeBefore(startTime);
            if (startInt == null) {
                return new TimeScale[][]{new TimeScale[2]};
            }
            TimeScale startInt1 = this.getSunsetBefore(startInt);
            if (startInt1 != null && (startInt1 = this.getSunriseBefore(startInt1)) != null) {
                TimeScale endInt1 = this.getEndOfDaytimeAfter(startInt1);
                vIntervals.addElement(new TimeScale[]{startInt1, endInt1});
            }
        } else {
            startInt = this.getSunriseBefore(startTime);
            if (startInt == null) {
                return intervals;
            }
            endInt = this.getEndOfDaytimeAfter(startInt);
            vIntervals.addElement(new TimeScale[]{startInt, endInt});
            startInt = this.getSunriseAfter(startTime, endTime);
            if (startInt == null) {
                return new TimeScale[][]{{((TimeScale[])vIntervals.elementAt(0))[0], ((TimeScale[])vIntervals.elementAt(0))[1]}};
            }
        }
        do {
            endInt = this.getEndOfDaytimeAfter(startInt);
            vIntervals.addElement(new TimeScale[]{startInt, endInt});
        } while (vIntervals.size() < maxNumberOfIntervals && endInt.before(endTime) && (startInt = this.getSunriseAfter(endInt, endTime)) != null);
        intervals = new TimeScale[vIntervals.size()][2];
        vIntervals.copyInto((Object[])intervals);
        return intervals;
    }

    public TimeScale[][] getNightCoverage(TimeScale startTime, TimeScale endTime, int maxNumberOfIntervals) {
        TimeScale endInt;
        TimeScale startInt;
        TimeScale[][] intervals = new TimeScale[0][2];
        Vector<TimeScale[]> vIntervals = new Vector<TimeScale[]>(50, 50);
        this.setTime(startTime);
        if (this.isNight()) {
            startInt = this.getStartOfNighttimeBefore(startTime);
            if (startInt == null) {
                return new TimeScale[][]{new TimeScale[2]};
            }
            TimeScale startInt1 = this.getSunriseBefore(startInt);
            if (startInt1 != null && (startInt1 = this.getSunsetBefore(startInt1)) != null) {
                TimeScale endInt1 = this.getEndOfNighttimeAfter(startInt1);
                vIntervals.addElement(new TimeScale[]{startInt1, endInt1});
            }
        } else {
            startInt = this.getSunsetBefore(startTime);
            if (startInt == null) {
                return intervals;
            }
            endInt = this.getEndOfNighttimeAfter(startInt);
            vIntervals.addElement(new TimeScale[]{startInt, endInt});
            startInt = this.getSunsetAfter(startTime, endTime);
            if (startInt == null) {
                return new TimeScale[][]{{((TimeScale[])vIntervals.elementAt(0))[0], ((TimeScale[])vIntervals.elementAt(0))[1]}};
            }
        }
        do {
            endInt = this.getEndOfNighttimeAfter(startInt);
            vIntervals.addElement(new TimeScale[]{startInt, endInt});
        } while (vIntervals.size() < maxNumberOfIntervals && endInt.before(endTime) && (startInt = this.getSunsetAfter(endInt, endTime)) != null);
        intervals = new TimeScale[vIntervals.size()][2];
        vIntervals.copyInto((Object[])intervals);
        return intervals;
    }

    private TimeScale getStartOfDaytimeBefore(TimeScale startTime) {
        TimeScale sunrise = null;
        TimeScale time = new TimeScale(startTime.getTimeInMinutes());
        TimeScale startOfLastFullDaylight = null;
        int numberOfSkippedDays = 0;
        do {
            this.setTime(time);
            if (this.isNormalTrajectory()) {
                if (startOfLastFullDaylight == null) {
                    if (!startTime.before(this.sunriseTimeUT)) {
                        sunrise = this.sunriseTimeUT;
                        break;
                    }
                } else if (!startTime.before(startOfLastFullDaylight)) {
                    sunrise = startOfLastFullDaylight;
                    break;
                }
            } else {
                if (this.isAlwaysBelow()) {
                    sunrise = time.endOfDay();
                    break;
                }
                startOfLastFullDaylight = time.startOfDay();
                if (!startTime.before(startOfLastFullDaylight)) {
                    startOfLastFullDaylight = null;
                }
            }
            time.add(5, -1);
        } while (++numberOfSkippedDays <= 365);
        return sunrise;
    }

    private TimeScale getStartOfNighttimeBefore(TimeScale startTime) {
        TimeScale sunset = null;
        TimeScale time = new TimeScale(startTime.getTimeInMinutes());
        TimeScale startOfLastFullNight = null;
        int numberOfSkippedDays = 0;
        do {
            this.setTime(time);
            if (this.isNormalTrajectory()) {
                if (startOfLastFullNight == null) {
                    if (!startTime.before(this.sunsetTimeUT)) {
                        sunset = this.sunsetTimeUT;
                        break;
                    }
                } else if (!startTime.before(startOfLastFullNight)) {
                    sunset = startOfLastFullNight;
                    break;
                }
            } else {
                if (this.isAlwaysAbove()) {
                    sunset = time.endOfDay();
                    break;
                }
                startOfLastFullNight = time.startOfDay();
                if (!startTime.before(startOfLastFullNight)) {
                    startOfLastFullNight = null;
                }
            }
            time.add(5, -1);
        } while (++numberOfSkippedDays <= 365);
        return sunset;
    }

    private TimeScale getSunriseBefore(TimeScale startTime) {
        TimeScale sunrise = null;
        TimeScale time = new TimeScale(startTime.getTimeInMinutes());
        TimeScale startOfLastFullDay = null;
        int numberOfSkippedDays = 0;
        do {
            this.setTime(time);
            if (this.isNormalTrajectory()) {
                if (this.sunriseTimeUT.before(startTime)) {
                    if (startOfLastFullDay == null) {
                        sunrise = this.sunriseTimeUT;
                        break;
                    }
                    sunrise = startOfLastFullDay;
                    break;
                }
            } else if (this.isAlwaysAbove()) {
                startOfLastFullDay = time.startOfDay();
            } else if (startOfLastFullDay != null) {
                sunrise = startOfLastFullDay;
                break;
            }
            time.add(5, -1);
        } while (++numberOfSkippedDays <= 365);
        return sunrise;
    }

    private TimeScale getSunsetBefore(TimeScale startTime) {
        TimeScale sunset = null;
        TimeScale time = new TimeScale(startTime.getTimeInMinutes());
        TimeScale startOfLastFullNight = null;
        int numberOfSkippedDays = 0;
        do {
            this.setTime(time);
            if (this.isNormalTrajectory()) {
                if (this.sunsetTimeUT.before(startTime)) {
                    if (startOfLastFullNight == null) {
                        sunset = this.sunsetTimeUT;
                        break;
                    }
                    sunset = startOfLastFullNight;
                    break;
                }
            } else if (this.isAlwaysBelow()) {
                startOfLastFullNight = time.startOfDay();
            } else if (startOfLastFullNight != null) {
                sunset = startOfLastFullNight;
                break;
            }
            time.add(5, -1);
        } while (++numberOfSkippedDays <= 365);
        return sunset;
    }

    private TimeScale getSunriseAfter(TimeScale startTime, TimeScale endTime) {
        TimeScale sunrise = null;
        TimeScale maxDateForCheck = new TimeScale(endTime.getTimeInMinutes());
        maxDateForCheck.add(5, 1);
        TimeScale time = new TimeScale(startTime.getTimeInMinutes());
        do {
            this.setTime(time);
            if (this.isNormalTrajectory()) {
                if (startTime.before(this.sunriseTimeUT)) {
                    if (!this.sunriseTimeUT.before(endTime)) break;
                    sunrise = this.sunriseTimeUT;
                    break;
                }
            } else if (this.isAlwaysAbove()) {
                sunrise = time.startOfDay();
                if (startTime.before(sunrise)) break;
                sunrise = null;
                break;
            }
            time.add(5, 1);
        } while (time.before(maxDateForCheck));
        return sunrise;
    }

    private TimeScale getSunsetAfter(TimeScale startTime, TimeScale endTime) {
        TimeScale sunset = null;
        TimeScale maxDateForCheck = new TimeScale(endTime.getTimeInMinutes());
        maxDateForCheck.add(5, 1);
        TimeScale time = new TimeScale(startTime.getTimeInMinutes());
        do {
            this.setTime(time);
            if (this.isNormalTrajectory()) {
                if (startTime.before(this.sunsetTimeUT)) {
                    if (!this.sunsetTimeUT.before(endTime)) break;
                    sunset = this.sunsetTimeUT;
                    break;
                }
            } else if (this.isAlwaysBelow()) {
                sunset = time.startOfDay();
                if (startTime.before(sunset)) break;
                sunset = null;
            }
            time.add(5, 1);
        } while (time.before(maxDateForCheck));
        return sunset;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TimeScale getEndOfDaytimeAfter(TimeScale startTime) {
        TimeScale sunset = null;
        TimeScale time = new TimeScale(startTime.getTimeInMinutes());
        TimeScale endOfLastFullDaylight = null;
        int numberOfSkippedDays = 0;
        do {
            this.setTime(time);
            if (this.isNormalTrajectory()) {
                if (endOfLastFullDaylight != null) return endOfLastFullDaylight;
                if (startTime.before(this.sunsetTimeUT)) {
                    return this.sunsetTimeUT;
                }
            } else {
                if (this.isAlwaysBelow()) {
                    return time.startOfDay();
                }
                endOfLastFullDaylight = time.endOfDay();
                if (!startTime.before(endOfLastFullDaylight)) {
                    endOfLastFullDaylight = null;
                }
            }
            time.add(5, 1);
        } while (++numberOfSkippedDays <= 365);
        return sunset;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TimeScale getEndOfNighttimeAfter(TimeScale startTime) {
        TimeScale sunrise = null;
        TimeScale time = new TimeScale(startTime.getTimeInMinutes());
        TimeScale endOfLastFullNight = null;
        int numberOfSkippedDays = 0;
        do {
            this.setTime(time);
            if (this.isNormalTrajectory()) {
                if (endOfLastFullNight != null) return endOfLastFullNight;
                if (startTime.before(this.sunriseTimeUT)) {
                    return this.sunriseTimeUT;
                }
            } else {
                if (this.isAlwaysAbove()) {
                    return time.startOfDay();
                }
                endOfLastFullNight = time.endOfDay();
                if (!startTime.before(endOfLastFullNight)) {
                    endOfLastFullNight = null;
                }
            }
            time.add(5, 1);
        } while (++numberOfSkippedDays <= 365);
        return sunrise;
    }
}

