/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.geospace;

import edu.uml.lgdc.format.FC;
import edu.uml.lgdc.format.StrUtil;
import edu.uml.lgdc.project.CommonConst;
import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.time.TimeScale;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

public class IGRF {
    public static final String IGRFDATA = "igrfdata.txt";
    public static final String NAME = "IGRF";
    public static final double RE = 6371.2;
    private static final String FILE_SIGNATURE = "IGRFData ";
    private static final double DATA_FILE_VERSION = 3.0;
    private static final int MAX_HARMONICS = 14;
    private static final int COEFF_DIM = 105;
    private static final int LAST_COEFF_DIM = 45;
    private static final double[] REC = new double[105];
    private static double version = 0.0;
    public double bR;
    public double bT;
    public double bF;
    public double B;
    public double dip;
    public double dec;
    public double diplat;
    public double fce;
    private static final String DATAFILE_NAME;
    public static final int DATAFILE_ERROR_OK = 0;
    public static final int DATAFILE_ERROR_ZEROLENGTH = 1;
    public static final int DATAFILE_ERROR_SIGNATURE = 2;
    public static final int DATAFILE_ERROR_ELEMENT_QTY = 3;
    public static final int DATAFILE_ERROR_TIME_FORMAT = 4;
    public static final int DATAFILE_ERROR_NUMBER_FORMAT = 5;
    public static final int DATAFILE_ERROR_TIME_DECREASE = 6;
    public static final int DATAFILE_ERROR_NO_ENTRIES = 7;
    public static final int DATAFILE_ERROR_LACK_OF_ENTRIES = 8;
    public static final int DATAFILE_ERROR_IO = 9;
    public static final int DATAFILE_ERROR_OBSOLETE = 10;
    private static final int MAX_INACCURATE_MES = 10;
    private static TimeScale[] TIMES;
    private static double[][] G;
    private static double[][] H;
    private static double[] DG;
    private static double[] DH;
    private static boolean datafileInUse;
    private static boolean softwareObsolete;
    private static int datafileErrorCode;
    public static TimeScale MIN_DATE;
    public static TimeScale MAX_DATE;
    public static double MIN_DATE_IN_MINUTES;
    public static double MAX_DATE_IN_MINUTES;
    private double[] g = new double[105];
    private double[] h = new double[105];
    private int prevYear = 0;
    private int prevDayOfYear = 0;
    private TimeScale prevUT = null;
    private int prevHarmonicsQty = -1;
    private double prevRadius = 0.0;
    private double prevTheta = -1000.0;
    private double prevPhi = -1000.0;
    private static boolean extrapolationInaccurateMes;
    private static int countInaccurateMes;
    private static boolean compatibleMode;
    private static IGRF myIGRF;

    /*
     * Opcode count of 14215 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        int n = 1;
        while (n <= 14) {
            int n2 = 2 * n - 1;
            n2 *= n2 - 2;
            int m = 1;
            while (m <= n) {
                int mn = n * (n - 1) / 2 + m;
                IGRF.REC[mn - 1] = (double)((n - m) * (n + m - 2)) / (double)n2;
                ++m;
            }
            ++n;
        }
        DATAFILE_NAME = new File(CommonConst.getShareResourcesDir(), IGRFDATA).getPath();
        TIMES = new TimeScale[]{new TimeScale("1945.01.01"), new TimeScale("1950.01.01"), new TimeScale("1955.01.01"), new TimeScale("1960.01.01"), new TimeScale("1965.01.01"), new TimeScale("1970.01.01"), new TimeScale("1975.01.01"), new TimeScale("1980.01.01"), new TimeScale("1985.01.01"), new TimeScale("1990.01.01"), new TimeScale("1995.01.01"), new TimeScale("2000.01.01"), new TimeScale("2005.01.01"), new TimeScale("2011.01.01"), new TimeScale("2015.01.01"), new TimeScale("2020.01.01")};
        G = new double[][]{{0.0, -30594.0, -2285.0, -1244.0, 2990.0, 1578.0, 1282.0, -1834.0, 1255.0, 913.0, 944.0, 776.0, 544.0, -421.0, 304.0, -253.0, 346.0, 194.0, -20.0, -142.0, -82.0, 59.0, 57.0, 6.0, -246.0, -25.0, 21.0, -104.0, 70.0, -40.0, 0.0, 0.0, -29.0, -10.0, 15.0, 29.0, 13.0, 7.0, -8.0, -5.0, 9.0, 7.0, -10.0, 7.0, 2.0, 5.0, -21.0, 1.0, -11.0, 3.0, 16.0, -3.0, -4.0, -3.0, -4.0, -3.0, 11.0, 1.0, 2.0, -5.0, -1.0, 8.0, -1.0, -3.0, 5.0, -2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, -30554.0, -2250.0, -1341.0, 2998.0, 1576.0, 1297.0, -1889.0, 1274.0, 896.0, 954.0, 792.0, 528.0, -408.0, 303.0, -240.0, 349.0, 211.0, -20.0, -147.0, -76.0, 54.0, 57.0, 4.0, -247.0, -16.0, 12.0, -105.0, 65.0, -55.0, 2.0, 1.0, -40.0, -7.0, 5.0, 19.0, 22.0, 15.0, -4.0, -1.0, 11.0, 15.0, -13.0, 5.0, -1.0, 3.0, -7.0, -1.0, -25.0, 10.0, 5.0, -5.0, -2.0, 3.0, 8.0, -8.0, 4.0, -1.0, 13.0, -4.0, 4.0, 12.0, 3.0, 2.0, 10.0, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, -30500.0, -2215.0, -1440.0, 3003.0, 1581.0, 1302.0, -1944.0, 1288.0, 882.0, 958.0, 796.0, 510.0, -397.0, 290.0, -229.0, 360.0, 230.0, -23.0, -152.0, -69.0, 47.0, 57.0, 3.0, -247.0, -8.0, 7.0, -107.0, 65.0, -56.0, 2.0, 10.0, -32.0, -11.0, 9.0, 18.0, 11.0, 9.0, -6.0, -14.0, 6.0, 10.0, -7.0, 6.0, 9.0, 4.0, 9.0, -4.0, -5.0, 2.0, 4.0, 1.0, 2.0, 2.0, 5.0, -3.0, -5.0, -1.0, 2.0, -3.0, 7.0, 4.0, -2.0, 6.0, -2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, -30421.0, -2169.0, -1555.0, 3002.0, 1590.0, 1302.0, -1992.0, 1289.0, 878.0, 957.0, 800.0, 504.0, -394.0, 269.0, -222.0, 362.0, 242.0, -26.0, -156.0, -63.0, 46.0, 58.0, 1.0, -237.0, -1.0, -2.0, -113.0, 67.0, -56.0, 5.0, 15.0, -32.0, -7.0, 17.0, 8.0, 15.0, 6.0, -4.0, -11.0, 2.0, 10.0, -5.0, 10.0, 8.0, 4.0, 6.0, 0.0, -9.0, 1.0, 4.0, -1.0, -2.0, 3.0, -1.0, 1.0, -3.0, 4.0, 0.0, -1.0, 4.0, 6.0, 1.0, -1.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, -30334.0, -2119.0, -1662.0, 2997.0, 1594.0, 1297.0, -2038.0, 1292.0, 856.0, 957.0, 804.0, 479.0, -390.0, 252.0, -219.0, 358.0, 254.0, -31.0, -157.0, -62.0, 45.0, 61.0, 8.0, -228.0, 4.0, 1.0, -111.0, 75.0, -57.0, 4.0, 13.0, -26.0, -6.0, 13.0, 1.0, 13.0, 5.0, -4.0, -14.0, 0.0, 8.0, -1.0, 11.0, 4.0, 8.0, 10.0, 2.0, -13.0, 10.0, -1.0, -1.0, 5.0, 1.0, -2.0, -2.0, -3.0, 2.0, -5.0, -2.0, 4.0, 4.0, 0.0, 2.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, -30220.0, -2068.0, -1781.0, 3000.0, 1611.0, 1287.0, -2091.0, 1278.0, 838.0, 952.0, 800.0, 461.0, -395.0, 234.0, -216.0, 359.0, 262.0, -42.0, -160.0, -56.0, 43.0, 64.0, 15.0, -212.0, 2.0, 3.0, -112.0, 72.0, -57.0, 1.0, 14.0, -22.0, -2.0, 13.0, -2.0, 14.0, 6.0, -2.0, -13.0, -3.0, 5.0, 0.0, 11.0, 3.0, 8.0, 10.0, 2.0, -12.0, 10.0, -1.0, 0.0, 3.0, 1.0, -1.0, -3.0, -3.0, 2.0, -5.0, -1.0, 6.0, 4.0, 1.0, 0.0, 3.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, -30100.0, -2013.0, -1902.0, 3010.0, 1632.0, 1276.0, -2144.0, 1260.0, 830.0, 946.0, 791.0, 438.0, -405.0, 216.0, -218.0, 356.0, 264.0, -59.0, -159.0, -49.0, 45.0, 66.0, 28.0, -198.0, 1.0, 6.0, -111.0, 71.0, -56.0, 1.0, 16.0, -14.0, 0.0, 12.0, -5.0, 14.0, 6.0, -1.0, -12.0, -8.0, 4.0, 0.0, 10.0, 1.0, 7.0, 10.0, 2.0, -12.0, 10.0, -1.0, -1.0, 4.0, 1.0, -2.0, -3.0, -3.0, 2.0, -5.0, -2.0, 5.0, 4.0, 1.0, 0.0, 3.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, -29992.0, -1956.0, -1997.0, 3027.0, 1663.0, 1281.0, -2180.0, 1251.0, 833.0, 938.0, 782.0, 398.0, -419.0, 199.0, -218.0, 357.0, 261.0, -74.0, -162.0, -48.0, 48.0, 66.0, 42.0, -192.0, 4.0, 14.0, -108.0, 72.0, -59.0, 2.0, 21.0, -12.0, 1.0, 11.0, -2.0, 18.0, 6.0, 0.0, -11.0, -7.0, 4.0, 3.0, 6.0, -1.0, 5.0, 10.0, 1.0, -12.0, 9.0, -3.0, -1.0, 7.0, 2.0, -5.0, -4.0, -4.0, 2.0, -5.0, -2.0, 5.0, 3.0, 1.0, 2.0, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, -29873.0, -1905.0, -2072.0, 3044.0, 1687.0, 1296.0, -2208.0, 1247.0, 829.0, 936.0, 780.0, 361.0, -424.0, 170.0, -214.0, 355.0, 253.0, -93.0, -164.0, -46.0, 53.0, 65.0, 51.0, -185.0, 4.0, 16.0, -102.0, 74.0, -62.0, 3.0, 24.0, -6.0, 4.0, 10.0, 0.0, 21.0, 6.0, 0.0, -11.0, -9.0, 4.0, 4.0, 4.0, -4.0, 5.0, 10.0, 1.0, -12.0, 9.0, -3.0, -1.0, 7.0, 1.0, -5.0, -4.0, -4.0, 3.0, -5.0, -2.0, 5.0, 3.0, 1.0, 2.0, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, -29775.0, -1848.0, -2131.0, 3059.0, 1686.0, 1314.0, -2239.0, 1248.0, 802.0, 939.0, 780.0, 325.0, -423.0, 141.0, -214.0, 353.0, 245.0, -109.0, -165.0, -36.0, 61.0, 65.0, 59.0, -178.0, 3.0, 18.0, -96.0, 77.0, -64.0, 2.0, 26.0, -1.0, 5.0, 9.0, 0.0, 23.0, 5.0, -1.0, -10.0, -12.0, 3.0, 4.0, 2.0, -6.0, 4.0, 9.0, 1.0, -12.0, 9.0, -4.0, -2.0, 7.0, 1.0, -6.0, -3.0, -4.0, 2.0, -5.0, -2.0, 4.0, 3.0, 1.0, 3.0, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, -29692.0, -1784.0, -2200.0, 3070.0, 1681.0, 1335.0, -2267.0, 1249.0, 759.0, 940.0, 780.0, 290.0, -418.0, 122.0, -214.0, 352.0, 235.0, -118.0, -166.0, -17.0, 68.0, 67.0, 68.0, -170.0, -1.0, 19.0, -93.0, 77.0, -72.0, 1.0, 28.0, 5.0, 4.0, 8.0, -2.0, 25.0, 6.0, -6.0, -9.0, -14.0, 9.0, 6.0, -5.0, -7.0, 4.0, 9.0, 3.0, -10.0, 8.0, -8.0, -1.0, 10.0, -2.0, -8.0, -3.0, -6.0, 2.0, -4.0, -1.0, 4.0, 2.0, 2.0, 5.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, -29619.4, -1728.2, -2267.7, 3068.4, 1670.9, 1339.6, -2288.0, 1252.1, 714.5, 932.3, 786.8, 250.0, -403.0, 111.3, -218.8, 351.4, 222.3, -130.4, -168.6, -12.9, 72.3, 68.2, 74.2, -160.9, -5.9, 16.9, -90.4, 79.0, -74.0, 0.0, 33.3, 9.1, 6.9, 7.3, -1.2, 24.4, 6.6, -9.2, -7.9, -16.6, 9.1, 7.0, -7.9, -7.0, 5.0, 9.4, 3.0, -8.4, 6.3, -8.9, -1.5, 9.3, -4.3, -8.2, -2.6, -6.0, 1.7, -3.1, -0.5, 3.7, 1.0, 2.0, 4.2, 0.3, -1.1, 2.7, -1.7, -1.9, 1.5, -0.1, 0.1, -0.7, 0.7, 1.7, 0.1, 1.2, 4.0, -2.2, -0.3, 0.2, 0.9, -0.2, 0.9, -0.5, 0.3, -0.3, -0.4, -0.1, -0.2, -0.4, -0.2, -0.9, 0.3, 0.1, -0.4, 1.3, -0.4, 0.7, -0.4, 0.3, -0.1, 0.4, 0.0, 0.1}, {0.0, -29554.63, -1669.05, -2337.24, 3047.69, 1657.76, 1336.3, -2305.83, 1246.39, 672.51, 920.55, 797.96, 210.65, -379.86, 100.0, -227.0, 354.41, 208.95, -136.54, -168.05, -13.55, 73.6, 69.56, 76.74, -151.34, -14.58, 14.58, -86.36, 79.88, -74.46, -1.65, 38.73, 12.3, 9.37, 5.42, 1.94, 24.8, 7.62, -11.73, -6.88, -18.11, 10.17, 9.36, -11.25, -4.87, 5.58, 9.76, 3.58, -6.94, 5.01, -10.76, -1.25, 8.76, -6.66, -9.22, -2.17, -6.12, 1.42, -2.35, -0.15, 3.06, 0.29, 2.06, 3.77, -0.21, -2.09, 2.95, -1.6, -1.88, 1.44, -0.31, 0.29, -0.79, 0.53, 1.8, 0.16, 0.96, 3.99, -2.15, -0.29, 0.21, 0.89, -0.38, 0.96, -0.3, 0.46, -0.35, -0.36, 0.08, -0.49, -0.08, -0.16, -0.88, 0.3, 0.28, -0.43, 1.18, -0.37, 0.75, -0.26, 0.35, -0.05, 0.41, -0.1, -0.18}, {0.0, -29496.5, -1585.9, -2396.6, 3026.0, 1668.6, 1339.7, -2326.3, 1231.7, 634.2, 912.6, 809.0, 166.6, -357.1, 89.7, -231.1, 357.2, 200.3, -141.2, -163.1, -7.7, 72.8, 68.6, 76.0, -141.4, -22.9, 13.1, -77.9, 80.4, -75.0, -4.7, 45.3, 14.0, 10.4, 1.6, 4.9, 24.3, 8.2, -14.5, -5.7, -19.3, 11.6, 10.9, -14.1, -3.7, 5.4, 9.4, 3.4, -5.3, 3.1, -12.4, -0.8, 8.4, -8.4, -10.1, -2.0, -6.3, 0.9, -1.1, -0.2, 2.5, -0.3, 2.2, 3.1, -1.0, -2.8, 3.0, -1.5, -2.1, 1.6, -0.5, 0.5, -0.8, 0.4, 1.8, 0.2, 0.8, 3.8, -2.1, -0.2, 0.3, 1.0, -0.7, 0.9, -0.1, 0.5, -0.4, -0.4, 0.2, -0.8, 0.0, -0.2, -0.9, 0.3, 0.4, -0.4, 1.1, -0.3, 0.8, -0.2, 0.4, 0.0, 0.4, -0.3, -0.3}, {0.0, -29442.0, -1501.0, -2445.1, 3012.9, 1676.7, 1350.7, -2352.3, 1225.6, 582.0, 907.6, 813.7, 120.4, -334.9, 70.4, -232.6, 360.1, 192.4, -140.9, -157.5, 4.1, 70.0, 67.7, 72.7, -129.9, -28.9, 13.2, -70.9, 81.6, -76.1, -6.8, 51.8, 15.0, 9.4, -2.8, 6.8, 24.2, 8.8, -16.9, -3.2, -20.6, 13.4, 11.7, -15.9, -2.0, 5.4, 8.8, 3.1, -3.3, 0.7, -13.3, -0.1, 8.7, -9.1, -10.5, -1.9, -6.3, 0.1, 0.5, -0.5, 1.8, -0.7, 2.1, 2.4, -1.8, -3.6, 3.1, -1.5, -2.3, 2.0, -0.8, 0.6, -0.7, 0.2, 1.7, -0.2, 0.4, 3.5, -1.9, -0.2, 0.4, 1.2, -0.8, 0.9, 0.1, 0.5, -0.3, -0.4, 0.2, -0.9, 0.0, 0.0, -0.9, 0.4, 0.5, -0.5, 1.0, -0.2, 0.8, -0.1, 0.3, 0.1, 0.5, -0.4, -0.3}, {0.0, -29404.8, -1450.9, -2499.6, 2982.0, 1677.0, 1363.2, -2381.2, 1236.2, 525.7, 903.0, 809.5, 86.3, -309.4, 8.0, -234.3, 363.2, 187.8, -140.7, -151.2, 13.5, 66.0, 65.5, 72.9, -121.5, -36.2, 13.5, -64.7, 80.6, -76.7, -8.2, 56.5, 15.8, 6.4, -7.2, 9.8, 23.7, 9.7, -17.6, -0.5, -21.1, 15.3, 13.7, -16.5, -0.3, 5.0, 8.4, 2.9, -1.5, -1.1, -13.2, 1.1, 8.8, -9.3, -11.9, -1.9, -6.2, -0.1, 1.7, -0.9, 0.7, -0.9, 1.9, 1.4, -2.4, -3.8, 3.0, -1.4, -2.5, 2.3, -0.9, 0.3, -0.7, -0.1, 1.4, -0.6, 0.2, 3.1, -2.0, -0.1, 0.5, 1.3, -1.2, 0.7, 0.3, 0.5, -0.3, -0.5, 0.1, -1.1, -0.3, 0.1, -0.9, 0.5, 0.7, -0.3, 0.8, 0.0, 0.8, 0.0, 0.4, 0.1, 0.5, -0.5, -0.4}};
        H = new double[][]{{0.0, 0.0, 5810.0, 0.0, -1702.0, 477.0, 0.0, -499.0, 186.0, -11.0, 0.0, 144.0, -276.0, -55.0, -178.0, 0.0, -12.0, 95.0, -67.0, -119.0, 82.0, 0.0, 6.0, 100.0, 16.0, -9.0, -16.0, -39.0, 0.0, -45.0, -18.0, 2.0, 6.0, 28.0, -17.0, -22.0, 0.0, 12.0, -21.0, -12.0, -7.0, 2.0, 18.0, 3.0, -11.0, 0.0, -27.0, 17.0, 29.0, -9.0, 4.0, 9.0, 6.0, 1.0, 8.0, 0.0, 5.0, 1.0, -20.0, -1.0, -6.0, 6.0, -4.0, -2.0, 0.0, -2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 5815.0, 0.0, -1810.0, 381.0, 0.0, -476.0, 206.0, -46.0, 0.0, 136.0, -278.0, -37.0, -210.0, 0.0, 3.0, 103.0, -87.0, -122.0, 80.0, 0.0, -1.0, 99.0, 33.0, -12.0, -12.0, -30.0, 0.0, -35.0, -17.0, 0.0, 10.0, 36.0, -18.0, -16.0, 0.0, 5.0, -22.0, 0.0, -21.0, -8.0, 17.0, -4.0, -17.0, 0.0, -24.0, 19.0, 12.0, 2.0, 2.0, 8.0, 8.0, -11.0, -7.0, 0.0, 13.0, -2.0, -10.0, 2.0, -3.0, 6.0, -3.0, 6.0, 11.0, 8.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 5820.0, 0.0, -1898.0, 291.0, 0.0, -462.0, 216.0, -83.0, 0.0, 133.0, -274.0, -23.0, -230.0, 0.0, 15.0, 110.0, -98.0, -121.0, 78.0, 0.0, -9.0, 96.0, 48.0, -16.0, -12.0, -24.0, 0.0, -50.0, -24.0, -4.0, 8.0, 28.0, -20.0, -18.0, 0.0, 10.0, -15.0, 5.0, -23.0, 3.0, 23.0, -4.0, -13.0, 0.0, -11.0, 12.0, 7.0, 6.0, -2.0, 10.0, 7.0, -6.0, 5.0, 0.0, -4.0, 0.0, -8.0, -2.0, -4.0, 1.0, -3.0, 7.0, -1.0, -3.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 5791.0, 0.0, -1967.0, 206.0, 0.0, -414.0, 224.0, -130.0, 0.0, 135.0, -278.0, 3.0, -255.0, 0.0, 16.0, 125.0, -117.0, -114.0, 81.0, 0.0, -10.0, 99.0, 60.0, -20.0, -11.0, -17.0, 0.0, -55.0, -28.0, -6.0, 7.0, 23.0, -18.0, -17.0, 0.0, 11.0, -14.0, 7.0, -18.0, 4.0, 23.0, 1.0, -20.0, 0.0, -18.0, 12.0, 2.0, 0.0, -3.0, 9.0, 8.0, 0.0, 5.0, 0.0, 4.0, 1.0, 0.0, 2.0, -5.0, 1.0, -1.0, 6.0, 0.0, -7.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 5776.0, 0.0, -2016.0, 114.0, 0.0, -404.0, 240.0, -165.0, 0.0, 148.0, -269.0, 13.0, -269.0, 0.0, 19.0, 128.0, -126.0, -97.0, 81.0, 0.0, -11.0, 100.0, 68.0, -32.0, -8.0, -7.0, 0.0, -61.0, -27.0, -2.0, 6.0, 26.0, -23.0, -12.0, 0.0, 7.0, -12.0, 9.0, -16.0, 4.0, 24.0, -3.0, -17.0, 0.0, -22.0, 15.0, 7.0, -4.0, -5.0, 10.0, 10.0, -4.0, 1.0, 0.0, 2.0, 1.0, 2.0, 6.0, -4.0, 0.0, -2.0, 3.0, 0.0, -6.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 5737.0, 0.0, -2047.0, 25.0, 0.0, -366.0, 251.0, -196.0, 0.0, 167.0, -266.0, 26.0, -279.0, 0.0, 26.0, 139.0, -139.0, -91.0, 83.0, 0.0, -12.0, 100.0, 72.0, -37.0, -6.0, 1.0, 0.0, -70.0, -27.0, -4.0, 8.0, 23.0, -23.0, -11.0, 0.0, 7.0, -15.0, 6.0, -17.0, 6.0, 21.0, -6.0, -16.0, 0.0, -21.0, 16.0, 6.0, -4.0, -5.0, 10.0, 11.0, -2.0, 1.0, 0.0, 1.0, 1.0, 3.0, 4.0, -4.0, 0.0, -1.0, 3.0, 1.0, -4.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 5675.0, 0.0, -2067.0, -68.0, 0.0, -333.0, 262.0, -223.0, 0.0, 191.0, -265.0, 39.0, -288.0, 0.0, 31.0, 148.0, -152.0, -83.0, 88.0, 0.0, -13.0, 99.0, 75.0, -41.0, -4.0, 11.0, 0.0, -77.0, -26.0, -5.0, 10.0, 22.0, -23.0, -12.0, 0.0, 6.0, -16.0, 4.0, -19.0, 6.0, 18.0, -10.0, -17.0, 0.0, -21.0, 16.0, 7.0, -4.0, -5.0, 10.0, 11.0, -3.0, 1.0, 0.0, 1.0, 1.0, 3.0, 4.0, -4.0, -1.0, -1.0, 3.0, 1.0, -5.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 5604.0, 0.0, -2129.0, -200.0, 0.0, -336.0, 271.0, -252.0, 0.0, 212.0, -257.0, 53.0, -297.0, 0.0, 46.0, 150.0, -151.0, -78.0, 92.0, 0.0, -15.0, 93.0, 71.0, -43.0, -2.0, 17.0, 0.0, -82.0, -27.0, -5.0, 16.0, 18.0, -23.0, -10.0, 0.0, 7.0, -18.0, 4.0, -22.0, 9.0, 16.0, -13.0, -15.0, 0.0, -21.0, 16.0, 9.0, -5.0, -6.0, 9.0, 10.0, -6.0, 2.0, 0.0, 1.0, 0.0, 3.0, 6.0, -4.0, 0.0, -1.0, 4.0, 0.0, -6.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 5500.0, 0.0, -2197.0, -306.0, 0.0, -310.0, 284.0, -297.0, 0.0, 232.0, -249.0, 69.0, -297.0, 0.0, 47.0, 150.0, -154.0, -75.0, 95.0, 0.0, -16.0, 88.0, 69.0, -48.0, -1.0, 21.0, 0.0, -83.0, -27.0, -2.0, 20.0, 17.0, -23.0, -7.0, 0.0, 8.0, -19.0, 5.0, -23.0, 11.0, 14.0, -15.0, -11.0, 0.0, -21.0, 15.0, 9.0, -6.0, -6.0, 9.0, 9.0, -7.0, 2.0, 0.0, 1.0, 0.0, 3.0, 6.0, -4.0, 0.0, -1.0, 4.0, 0.0, -6.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 5406.0, 0.0, -2279.0, -373.0, 0.0, -284.0, 293.0, -352.0, 0.0, 247.0, -240.0, 84.0, -299.0, 0.0, 46.0, 154.0, -153.0, -69.0, 97.0, 0.0, -16.0, 82.0, 69.0, -52.0, 1.0, 24.0, 0.0, -80.0, -26.0, 0.0, 21.0, 17.0, -23.0, -4.0, 0.0, 10.0, -19.0, 6.0, -22.0, 12.0, 12.0, -16.0, -10.0, 0.0, -20.0, 15.0, 11.0, -7.0, -7.0, 9.0, 8.0, -7.0, 2.0, 0.0, 2.0, 1.0, 3.0, 6.0, -4.0, 0.0, -2.0, 3.0, -1.0, -6.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 5306.0, 0.0, -2366.0, -413.0, 0.0, -262.0, 302.0, -427.0, 0.0, 262.0, -236.0, 97.0, -306.0, 0.0, 46.0, 165.0, -143.0, -55.0, 107.0, 0.0, -17.0, 72.0, 67.0, -58.0, 1.0, 36.0, 0.0, -69.0, -25.0, 4.0, 24.0, 17.0, -24.0, -6.0, 0.0, 11.0, -21.0, 8.0, -23.0, 15.0, 11.0, -16.0, -4.0, 0.0, -20.0, 15.0, 12.0, -6.0, -8.0, 8.0, 5.0, -8.0, 3.0, 0.0, 1.0, 0.0, 4.0, 5.0, -5.0, -1.0, -2.0, 1.0, -2.0, -7.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 5186.1, 0.0, -2481.6, -458.0, 0.0, -227.6, 293.4, -491.1, 0.0, 272.6, -231.9, 119.8, -303.8, 0.0, 43.8, 171.9, -133.1, -39.3, 106.3, 0.0, -17.4, 63.7, 65.1, -61.2, 0.7, 43.8, 0.0, -64.6, -24.2, 6.2, 24.0, 14.8, -25.4, -5.8, 0.0, 11.9, -21.5, 8.5, -21.5, 15.5, 8.9, -14.9, -2.1, 0.0, -19.7, 13.4, 12.5, -6.2, -8.4, 8.4, 3.8, -8.2, 4.8, 0.0, 1.7, 0.0, 4.0, 4.9, -5.9, -1.2, -2.9, 0.2, -2.2, -7.4, 0.0, 0.1, 1.3, -0.9, -2.6, 0.9, -0.7, -2.8, -0.9, -1.2, -1.9, -0.9, 0.0, -0.4, 0.3, 2.5, -2.6, 0.7, 0.3, 0.0, 0.0, 0.3, -0.9, -0.4, 0.8, 0.0, -0.9, 0.2, 1.8, -0.4, -1.0, -0.1, 0.7, 0.3, 0.6, 0.3, -0.2, -0.5, -0.9}, {0.0, 0.0, 5077.99, 0.0, -2594.5, -515.43, 0.0, -198.86, 269.72, -524.72, 0.0, 282.07, -225.23, 145.15, -305.36, 0.0, 42.72, 180.25, -123.45, -19.57, 103.85, 0.0, -20.33, 54.75, 63.63, -63.53, 0.24, 50.94, 0.0, -61.14, -22.57, 6.82, 25.35, 10.93, -26.32, -4.64, 0.0, 11.2, -20.88, 9.83, -19.71, 16.22, 7.61, -12.76, -0.06, 0.0, -20.11, 12.69, 12.67, -6.72, -8.16, 8.1, 2.92, -7.73, 6.01, 0.0, 2.19, 0.1, 4.46, 4.76, -6.58, -1.01, -3.47, -0.86, -2.31, -7.93, 0.0, 0.26, 1.44, -0.77, -2.27, 0.9, -0.58, -2.69, -1.08, -1.58, -1.9, -1.39, 0.0, -0.55, 0.23, 2.38, -2.63, 0.61, 0.4, 0.01, 0.02, 0.28, -0.87, -0.34, 0.88, 0.0, -0.76, 0.33, 1.72, -0.54, -1.07, -0.04, 0.63, 0.21, 0.53, 0.38, -0.22, -0.57, -0.82}, {0.0, 0.0, 4945.1, 0.0, -2707.7, -575.4, 0.0, -160.5, 251.7, -536.8, 0.0, 286.4, -211.2, 164.4, -309.2, 0.0, 44.7, 188.9, -118.1, 0.1, 100.9, 0.0, -20.8, 44.2, 61.5, -66.3, 3.1, 54.9, 0.0, -57.8, -21.2, 6.6, 24.9, 7.0, -27.7, -3.4, 0.0, 10.9, -20.0, 11.9, -17.4, 16.7, 7.1, -10.8, 1.7, 0.0, -20.5, 11.6, 12.8, -7.2, -7.4, 8.0, 2.2, -6.1, 7.0, 0.0, 2.8, -0.1, 4.7, 4.4, -7.2, -1.0, -4.0, -2.0, -2.0, -8.3, 0.0, 0.1, 1.7, -0.6, -1.8, 0.9, -0.4, -2.5, -1.3, -2.1, -1.9, -1.8, 0.0, -0.8, 0.3, 2.2, -2.5, 0.5, 0.6, 0.0, 0.1, 0.3, -0.9, -0.2, 0.8, 0.0, -0.8, 0.3, 1.7, -0.6, -1.2, -0.1, 0.5, 0.1, 0.5, 0.4, -0.2, -0.5, -0.8}, {0.0, 0.0, 4797.1, 0.0, -2845.6, -641.9, 0.0, -115.3, 244.9, -538.4, 0.0, 283.3, -188.7, 180.9, -329.5, 0.0, 47.3, 197.0, -119.3, 16.0, 100.2, 0.0, -20.8, 33.2, 58.9, -66.7, 7.3, 62.6, 0.0, -54.1, -19.5, 5.7, 24.4, 3.4, -27.4, -2.2, 0.0, 10.1, -18.3, 13.3, -14.6, 16.2, 5.7, -9.1, 2.1, 0.0, -21.6, 10.8, 11.8, -6.8, -6.9, 7.8, 1.0, -4.0, 8.4, 0.0, 3.2, -0.4, 4.6, 4.4, -7.9, -0.6, -4.2, -2.8, -1.2, -8.7, 0.0, -0.1, 2.0, -0.7, -1.1, 0.8, -0.2, -2.2, -1.4, -2.5, -2.0, -2.4, 0.0, -1.1, 0.4, 1.9, -2.2, 0.3, 0.7, -0.1, 0.3, 0.2, -0.9, -0.1, 0.7, 0.0, -0.9, 0.4, 1.6, -0.5, -1.2, -0.1, 0.4, -0.1, 0.4, 0.5, -0.3, -0.4, -0.8}, {0.0, 0.0, 4652.5, 0.0, -2991.6, -734.6, 0.0, -82.1, 241.9, -543.4, 0.0, 281.9, -158.4, 199.7, -349.7, 0.0, 47.7, 208.3, -121.2, 32.3, 98.9, 0.0, -19.1, 25.1, 52.8, -64.5, 8.9, 68.1, 0.0, -51.5, -16.9, 2.2, 23.5, -2.2, -27.2, -1.8, 0.0, 8.4, -15.3, 12.8, -11.7, 14.9, 3.6, -6.9, 2.8, 0.0, -23.4, 11.0, 9.8, -5.1, -6.3, 7.8, 0.4, -1.4, 9.6, 0.0, 3.4, -0.2, 3.6, 4.8, -8.6, -0.1, -4.3, -3.4, -0.1, -8.8, 0.0, 0.0, 2.5, -0.6, -0.4, 0.6, -0.2, -1.7, -1.6, -3.0, -2.0, -2.6, 0.0, -1.2, 0.5, 1.4, -1.8, 0.1, 0.8, -0.2, 0.6, 0.2, -0.9, 0.0, 0.5, 0.0, -0.9, 0.6, 1.4, -0.4, -1.3, -0.1, 0.3, -0.1, 0.5, 0.5, -0.4, -0.4, -0.6}};
        DG = new double[]{0.0, 5.7, 7.4, -11.0, -7.0, -2.1, 2.2, -5.9, 3.1, -12.0, -1.2, -1.6, -5.9, 5.2, -5.1, -0.3, 0.5, -0.6, 0.2, 1.3, 0.9, -0.5, -0.3, 0.4, 1.3, -1.4, 0.0, 0.9, -0.1, -0.2, 0.0, 0.7, 0.1, -0.5, -0.8, 0.8, 0.0, 0.1, -0.1, 0.4, -0.1, 0.4, 0.3, -0.1, 0.4};
        DH = new double[]{0.0, 0.0, -25.9, 0.0, -30.2, -22.4, 0.0, 6.0, -1.1, 0.5, 0.0, -0.1, 6.5, 3.6, -5.0, 0.0, 0.0, 2.5, -0.6, 3.0, 0.3, 0.0, 0.0, -1.6, -1.3, 0.8, 0.0, 1.0, 0.0, 0.6, 0.6, -0.8, -0.2, -1.1, 0.1, 0.3, 0.0, -0.2, 0.6, -0.2, 0.5, -0.3, -0.4, 0.5, 0.0};
        datafileInUse = false;
        softwareObsolete = false;
        datafileErrorCode = 0;
        MIN_DATE = TIMES[0];
        MAX_DATE = new TimeScale(TIMES[TIMES.length - 1].getTimeInMinutes());
        MAX_DATE.add(14, -1);
        MIN_DATE_IN_MINUTES = MIN_DATE.getTimeInMinutes();
        MAX_DATE_IN_MINUTES = MAX_DATE.getTimeInMinutes();
        extrapolationInaccurateMes = false;
        IGRF.readIGRFCoeff();
        compatibleMode = true;
        int i = 0;
        while (i < TIMES.length - 1) {
            if (!TIMES[i].equals(TIMES[i].startOfYear())) {
                compatibleMode = false;
                break;
            }
            ++i;
        }
        myIGRF = null;
    }

    public void calc(int year, int harmonicsQty, double radius, double theta, double phi) {
        this.calc(year, 1, harmonicsQty, radius, theta, phi);
    }

    public void calc(int year, int dayOfYear, int harmonicsQty, double radius, double theta, double phi) {
        double[] a = new double[14];
        double[] b = new double[14];
        double prorateCoeff = 0.0;
        TimeScale ut = TimeScale.createFromFields(year, -1, -1, dayOfYear, 0, 0, 0);
        if (ut.before(MIN_DATE)) {
            throw new RuntimeException("IGRF: date is below " + MIN_DATE + ", - no coefficients exist");
        }
        if (MAX_DATE.before(ut) && countInaccurateMes < 10) {
            String msg = "IGRF: date is above " + MAX_DATE + ", extrapolated coefficients may be inaccurate";
            ++countInaccurateMes;
            if (!extrapolationInaccurateMes && !softwareObsolete) {
                if (!datafileInUse) {
                    msg = datafileErrorCode == 0 ? String.valueOf(msg) + System.lineSeparator() + "  you do not use IGRF data file" : String.valueOf(msg) + System.lineSeparator() + "  your IGRF data file is obsolete or corrupted";
                }
                msg = String.valueOf(msg) + System.lineSeparator() + "  try to get up-to-date IGRF data file";
                extrapolationInaccurateMes = true;
            }
        }
        if (this.prevYear == year && this.prevDayOfYear == dayOfYear && this.prevHarmonicsQty == harmonicsQty && this.prevRadius == radius && this.prevTheta == theta && this.prevPhi == phi) {
            return;
        }
        if (compatibleMode && (year != this.prevYear || dayOfYear != this.prevDayOfYear) || !compatibleMode && !ut.equals(this.prevUT)) {
            int i;
            double dt;
            if (compatibleMode) {
                if (year >= TIMES[TIMES.length - 2].get(1)) {
                    dt = (double)((year - TIMES[TIMES.length - 2].get(1)) * 365 + dayOfYear) / 365.0;
                    i = 0;
                    while (i < 105) {
                        this.g[i] = G[TIMES.length - 2][i];
                        this.h[i] = H[TIMES.length - 2][i];
                        if (i < 45) {
                            int n = i;
                            this.g[n] = this.g[n] + DG[i] * dt;
                            int n2 = i;
                            this.h[n2] = this.h[n2] + DH[i] * dt;
                        }
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < TIMES.length - 2) {
                        if (year < TIMES[i + 1].get(1)) {
                            prorateCoeff = (double)((year - TIMES[i].get(1)) * 365 + dayOfYear) / 1825.0;
                            this.prorate(prorateCoeff, G[i], G[i + 1], H[i], H[i + 1]);
                            break;
                        }
                        ++i;
                    }
                }
            } else if (!ut.before(TIMES[TIMES.length - 2])) {
                dt = ut.diffIn(1, TIMES[TIMES.length - 2]);
                i = 0;
                while (i < 105) {
                    this.g[i] = G[TIMES.length - 2][i];
                    this.h[i] = H[TIMES.length - 2][i];
                    if (i < 45) {
                        int n = i;
                        this.g[n] = this.g[n] + DG[i] * dt;
                        int n3 = i;
                        this.h[n3] = this.h[n3] + DH[i] * dt;
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < TIMES.length - 2) {
                    if (ut.before(TIMES[i + 1])) {
                        prorateCoeff = (double)((year - TIMES[i].get(1)) * 365 + dayOfYear) / 1825.0;
                        prorateCoeff = ut.diffIn(12, TIMES[i]) / TIMES[i + 1].diffIn(12, TIMES[i]);
                        this.prorate(prorateCoeff, G[i], G[i + 1], H[i], H[i + 1]);
                        break;
                    }
                    ++i;
                }
            }
            double s = 1.0;
            int i2 = 2;
            while (i2 <= 14) {
                int mn = i2 * (i2 - 1) / 2 + 1;
                int n = mn - 1;
                this.g[n] = this.g[n] * (s *= (double)(2 * i2 - 3) / (double)(i2 - 1));
                int n4 = mn - 1;
                this.h[n4] = this.h[n4] * s;
                double p = s;
                int j = 2;
                while (j <= i2) {
                    double aa = 1.0;
                    if (j == 2) {
                        aa = 2.0;
                    }
                    int mnn = mn + j - 1;
                    int n5 = mnn - 1;
                    this.g[n5] = this.g[n5] * (p *= Math.sqrt(aa * (double)(i2 - j + 1) / (double)(i2 + j - 2)));
                    int n6 = mnn - 1;
                    this.h[n6] = this.h[n6] * p;
                    ++j;
                }
                ++i2;
            }
        }
        double p = 1.0 / radius;
        int k = harmonicsQty + 1;
        int i = 1;
        while (i <= k) {
            a[i - 1] = p /= radius;
            b[i - 1] = p * (double)i;
            ++i;
        }
        p = 1.0;
        double d = 0.0;
        double bbr = 0.0;
        double bbt = 0.0;
        double bbf = 0.0;
        double cosPhi = Math.cos(phi);
        double sinPhi = Math.sin(phi);
        double cosTheta = Math.cos(theta);
        double sinTheta = Math.sin(theta);
        double x = 0.0;
        double y = 1.0;
        int mm = 0;
        int m = 1;
        while (m <= k) {
            double w;
            if (m > 1) {
                mm = m - 1;
                w = x;
                x = w * cosPhi + y * sinPhi;
                y = y * cosPhi - w * sinPhi;
            }
            double q = p;
            double z = d;
            double bi = 0.0;
            double p2 = 0.0;
            double d2 = 0.0;
            int n = m;
            while (n <= k) {
                double an = a[n - 1];
                int mn = n * (n - 1) / 2 + m;
                double e = this.g[mn - 1];
                double hh = this.h[mn - 1];
                w = e * y + hh * x;
                bbr += b[n - 1] * w * q;
                bbt -= an * w * z;
                if (m > 1) {
                    double qq = q;
                    if (sinTheta < 1.0E-5) {
                        qq = z;
                    }
                    bi += an * (e * x - hh * y) * qq;
                }
                double xk = REC[mn - 1];
                double dp = cosTheta * z - sinTheta * q - xk * d2;
                double pm = cosTheta * q - xk * p2;
                d2 = z;
                p2 = q;
                z = dp;
                q = pm;
                ++n;
            }
            d = sinTheta * d + cosTheta * p;
            p = sinTheta * p;
            if (m > 1) {
                bbf += (bi *= (double)mm);
            }
            ++m;
        }
        this.bR = bbr;
        this.bT = bbt;
        if (sinTheta >= 1.0E-5) {
            this.bF = bbf / sinTheta;
        } else {
            if (cosTheta < 0.0) {
                bbf = -bbf;
            }
            this.bF = bbf;
        }
        this.B = Math.sqrt(this.bR * this.bR + this.bT * this.bT + this.bF * this.bF);
        this.fce = 2.8011E-5 * this.B;
        this.dip = -(90.0 - Math.toDegrees(Math.acos(this.bR / this.B)));
        this.dec = Math.toDegrees(Math.atan2(this.bF, -this.bT));
        double tandip_rad = Math.tan(Math.toRadians(this.dip));
        this.diplat = Math.toDegrees(Math.atan(0.5 * tandip_rad));
        this.prevYear = year;
        this.prevDayOfYear = dayOfYear;
        this.prevHarmonicsQty = harmonicsQty;
        this.prevRadius = radius;
        this.prevTheta = theta;
        this.prevPhi = phi;
    }

    public void calc(TimeScale time, double[] geomap) {
        this.calc(time, geomap[0], geomap[1], geomap[2]);
    }

    public void calc(TimeScale time, double latitude_DEG, double longitude_DEG, double altitude_KM) {
        double theta = Math.toRadians(90.0 - latitude_DEG);
        double phi = Math.toRadians(longitude_DEG);
        this.calc(time.get(1), time.get(6), 10, 1.0 + altitude_KM / 6371.2, theta, phi);
    }

    private void prorate(double coeff, double[] g1, double[] g2, double[] h1, double[] h2) {
        double f1 = 1.0 - coeff;
        int i = 0;
        while (i < 105) {
            this.g[i] = g1[i] * f1 + g2[i] * coeff;
            this.h[i] = h1[i] * f1 + h2[i] * coeff;
            ++i;
        }
    }

    private static void readIGRFCoeff() {
        int qtyOfCoeff;
        int lineCount;
        String arrayString;
        int qty;
        Vector<double[]> vH;
        Vector<double[]> vG;
        Vector<TimeScale> vTimes;
        block44: {
            datafileInUse = false;
            datafileErrorCode = 0;
            softwareObsolete = false;
            File datafile = new File(DATAFILE_NAME);
            if (!datafile.isFile()) {
                return;
            }
            version = 0.0;
            int minNoOfElements = 210;
            int minNoOfElementsLast = 90;
            vTimes = new Vector<TimeScale>(50, 50);
            vG = new Vector<double[]>(50, 50);
            vH = new Vector<double[]>(50, 50);
            double[] g = null;
            double[] h = null;
            qty = 0;
            BufferedReader br = null;
            arrayString = "";
            lineCount = 0;
            qtyOfCoeff = 0;
            try {
                br = new BufferedReader(new FileReader(datafile));
                while (br.ready()) {
                    String line = br.readLine();
                    if (line == null) break;
                    line = StrUtil.trimRight(line, ' ');
                    if (++lineCount == 1) {
                        if (!line.startsWith(FILE_SIGNATURE)) {
                            Console.showError("IGRF file " + DATAFILE_NAME + ": bad signature");
                            datafileErrorCode = 2;
                        } else {
                            version = FC.StringToDouble(line.substring(FILE_SIGNATURE.length() + 1).trim());
                            if (version < 2.0) {
                                Console.showError("IGRF file " + DATAFILE_NAME + " is obsolete");
                                datafileErrorCode = 10;
                            } else {
                                if (!(version > 3.0)) continue;
                                Console.showError("IGRF file " + DATAFILE_NAME + " has a newer version" + System.lineSeparator() + "you need to upgrade software");
                                softwareObsolete = true;
                            }
                        }
                        break;
                    }
                    if (line.length() == 0 || line.startsWith("#") || line.startsWith(";")) continue;
                    arrayString = String.valueOf(arrayString) + line;
                    if (line.endsWith(",")) continue;
                    String[] stringData = StrUtil.listToArray(arrayString, ",");
                    if (stringData.length < 91) {
                        Console.showError("IGRF file " + DATAFILE_NAME + " line " + stringData[0] + System.lineSeparator() + "  should be more than " + 90 + " elements separated by comma");
                        datafileErrorCode = 3;
                        break;
                    }
                    if (qty > 0 && qtyOfCoeff < 105) {
                        Console.showError("IGRF file " + DATAFILE_NAME + " line " + ((TimeScale)vTimes.elementAt(qty - 1)).toShortDateUT() + ":" + System.lineSeparator() + "  not last array, " + qtyOfCoeff + ", should have not less than " + 210 + " elements");
                        datafileErrorCode = 3;
                        break;
                    }
                    vTimes.addElement(TimeScale.parse(stringData[0]));
                    qtyOfCoeff = (stringData.length - 1) / 2;
                    int dim = 105;
                    if (qtyOfCoeff < 105) {
                        dim = 45;
                    }
                    g = new double[dim];
                    h = new double[dim];
                    int i = 0;
                    while (i < dim) {
                        if (!StrUtil.isFloatingPointNumber(stringData[1 + i]) || !StrUtil.isFloatingPointNumber(stringData[1 + qtyOfCoeff + i])) {
                            Console.showError("IGRF file " + DATAFILE_NAME + " line " + lineCount + ", element index " + i + ": G and H should be a number");
                            datafileErrorCode = 5;
                            break;
                        }
                        g[i] = FC.StringToDouble(stringData[1 + i]);
                        h[i] = FC.StringToDouble(stringData[1 + qtyOfCoeff + i]);
                        ++i;
                    }
                    if (datafileErrorCode != 0) break;
                    vG.addElement(g);
                    vH.addElement(h);
                    arrayString = "";
                    if (qty > 0 && !((TimeScale)vTimes.elementAt(qty - 1)).before(vTimes.elementAt(qty))) {
                        Console.showError("IGRF file " + DATAFILE_NAME + " line " + lineCount + ":  date/time should increase");
                        datafileErrorCode = 6;
                        break;
                    }
                    ++qty;
                }
            }
            catch (IOException e) {
                Console.showError("File " + DATAFILE_NAME + " line " + ++lineCount + ":" + System.lineSeparator() + "  " + e.toString());
                datafileErrorCode = 9;
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException ex) {
                        Console.printThreadStackTrace(ex);
                    }
                }
                break block44;
            }
            catch (Exception e) {
                try {
                    Console.showError("File " + DATAFILE_NAME + " line " + lineCount + ":" + System.lineSeparator() + "  " + e.toString());
                    datafileErrorCode = 4;
                    break block44;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException ex) {
                            Console.printThreadStackTrace(ex);
                        }
                    }
                }
            }
            if (br == null) break block44;
            try {
                br.close();
            }
            catch (IOException ex) {
                Console.printThreadStackTrace(ex);
            }
        }
        if (softwareObsolete) {
            return;
        }
        if (datafileErrorCode == 0) {
            if (lineCount == 0) {
                datafileErrorCode = 1;
                Console.showError("IGRF file " + DATAFILE_NAME + " of zero length");
            } else if (arrayString.length() > 0) {
                Console.showError("IGRF file " + DATAFILE_NAME + ": last array is incomplete");
                datafileErrorCode = 3;
            } else if (qty == 0) {
                Console.showError("IGRF file " + DATAFILE_NAME + " doesn't contain entries");
                datafileErrorCode = 7;
            } else if (qty == 1) {
                Console.showError("IGRF file " + DATAFILE_NAME + " contains only one entry");
                datafileErrorCode = 8;
            } else if (qtyOfCoeff < 45) {
                Console.showError("IGRF file " + DATAFILE_NAME + ": last array should " + "contain not less than " + 90 + " elements");
                datafileErrorCode = 3;
            }
        }
        if (datafileErrorCode != 0) {
            return;
        }
        TIMES = new TimeScale[qty];
        G = new double[qty - 1][105];
        H = new double[qty - 1][105];
        DG = new double[45];
        DH = new double[45];
        int i = 0;
        while (i < qty - 1) {
            IGRF.TIMES[i] = (TimeScale)vTimes.elementAt(i);
            IGRF.G[i] = (double[])vG.elementAt(i);
            IGRF.H[i] = (double[])vH.elementAt(i);
            ++i;
        }
        IGRF.TIMES[qty - 1] = (TimeScale)vTimes.elementAt(qty - 1);
        DG = (double[])vG.elementAt(qty - 1);
        DH = (double[])vH.elementAt(qty - 1);
        datafileInUse = true;
        MIN_DATE = TIMES[0];
        MAX_DATE = new TimeScale(TIMES[TIMES.length - 1].getTimeInMinutes());
        MAX_DATE.add(14, -1);
        MIN_DATE_IN_MINUTES = MIN_DATE.getTimeInMinutes();
        MAX_DATE_IN_MINUTES = MAX_DATE.getTimeInMinutes();
    }

    public String getModelName() {
        return "IGRF " + FC.doubleToString(version, 1);
    }

    public static synchronized IGRF get(TimeScale date, double latitude_DEG, double longitude_DEG, double altitude_KM) {
        double theta = Math.toRadians(90.0 - latitude_DEG);
        double phi = Math.toRadians(longitude_DEG);
        double radius = 1.0 + altitude_KM / 6371.2;
        int year = date.get(1);
        int dayOfYear = date.get(6);
        if (myIGRF != null && IGRF.myIGRF.prevYear == year && IGRF.myIGRF.prevDayOfYear == dayOfYear && Math.abs(IGRF.myIGRF.prevPhi - phi) < 0.01 && Math.abs(IGRF.myIGRF.prevTheta - theta) < 0.01 && Math.abs(IGRF.myIGRF.prevRadius - radius) < 0.01) {
            return myIGRF;
        }
        myIGRF = new IGRF();
        myIGRF.calc(year, dayOfYear, 10, radius, theta, phi);
        return myIGRF;
    }
}

