/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.geospace;

import edu.uml.lgdc.fileio.FileUtils;
import edu.uml.lgdc.format.FC;
import edu.uml.lgdc.format.IonexMap;
import edu.uml.lgdc.format.IonexRecordSet;
import edu.uml.lgdc.geospace.Geomap;
import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.time.TimeScale;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class IGSAverageVTECGetter {
    static final String PREF_AVERAGE_VTEC = "https://igsiono.uwm.edu.pl/data/gambit/";
    private int currentYear = -1;
    private int currentDoy = -1;
    private IonexRecordSet currentAvtec = new IonexRecordSet();
    private String rootPath_AVTEC = null;

    public IGSAverageVTECGetter(String rootPath_AVTEC) {
        this.rootPath_AVTEC = new String(rootPath_AVTEC);
    }

    public IonexRecordSet downloadAVTEC(int year, int doy) {
        if (year == this.currentYear && doy == this.currentDoy) {
            return this.currentAvtec;
        }
        String filename = IGSAverageVTECGetter.makeAvtecFilename(year, doy);
        String path = String.valueOf(this.rootPath_AVTEC) + FC.IntegerToString(year, 4, '0') + File.separator;
        File localFile = new File(path, filename);
        if (!localFile.exists()) {
            URLConnection connection;
            block6: {
                File destinationDir = new File(path);
                destinationDir.mkdirs();
                String urlName = PREF_AVERAGE_VTEC + FC.IntegerToString(year, 4, '0') + "/" + filename;
                Console.showMsg("Starting download of Average VTEC for year " + year + " doy " + doy + " from " + urlName + "...");
                try {
                    URL url = new URL(urlName);
                    connection = url.openConnection();
                    int contentLength = connection.getContentLength();
                    if (contentLength >= 300) break block6;
                    return null;
                }
                catch (IOException e) {
                    Console.showError("Error retrieving data from " + urlName);
                    return null;
                }
            }
            InputStream is = connection.getInputStream();
            FileUtils.streamToFile(is, localFile);
            Console.showMsg("done.");
        }
        if (this.readAvtec(localFile)) {
            this.currentYear = year;
            this.currentDoy = doy;
        }
        return this.currentAvtec;
    }

    public boolean dataAvailable() {
        return this.currentAvtec != null;
    }

    private boolean readAvtec(File localFile) {
        if (!localFile.exists()) {
            return false;
        }
        return IonexMap.read(this.currentAvtec, localFile.getAbsolutePath());
    }

    public static String makeAvtecFilename(int year, int doy) {
        return "gmbt" + FC.IntegerToString(doy, 3, '0') + "0." + FC.IntegerToString(year % 100, 2, '0') + "i";
    }

    public double[] getIonexMap(TimeScale time) {
        return this.currentAvtec.getMap(this.currentAvtec.getGrid().getIndex(time));
    }

    public boolean fillGambitMap(Geomap map, TimeScale time) {
        return map.setIonexMapValues(this.getIonexMap(time), this.currentAvtec.getGrid());
    }
}

