/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.geospace;

import edu.uml.lgdc.format.FC;
import edu.uml.lgdc.geospace.Geopack;
import edu.uml.lgdc.geospace.GroundSolar;
import edu.uml.lgdc.geospace.IG12;
import edu.uml.lgdc.geospace.IGRF;
import edu.uml.lgdc.geospace.SunSpots;
import edu.uml.lgdc.project.CommonConst;
import edu.uml.lgdc.time.RealHours;
import edu.uml.lgdc.time.TimeScale;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class IRIModel {
    public static final String URSI_MODEL_PREF = "URSI";
    public static final String URSI_MODEL_EXT = "ASC";
    public static final double NO_FOF1 = 999.9;
    public static final double ALTITUDE_KM = 300.0;
    private SunSpots sunspots;
    private IG12 ig12;
    private GroundSolar groundSolar;
    private double foEP;
    private double foF1P;
    private double foF1probability;
    private double foF2P;
    private double NmDP;
    private double latitude;
    private double longitude;
    private double magLatitude;
    private double magLongitude;
    private TimeScale ut;
    private int month;
    private int dayOfYear;
    private RealHours realHours;
    private Geopack geopack = new Geopack();
    public IGRF igrf = new IGRF();
    private int monthPrev = -1;
    private double rgPrev = -1.0;
    private double[][][] f2 = new double[2][76][13];
    public double xma;
    public double yma;
    public double zma;
    public double bet;
    public double dip;
    public double dec;
    public double modip;
    public double fce;

    public String toString() {
        return String.valueOf(this.groundSolar.toString()) + "\r\n" + "sun spot number = " + FC.DoubleToString(this.sunspots.getNumber(), 5, 1) + "\r\n" + "latitude = " + FC.DoubleToString(this.latitude, 7, 2) + "\r\n" + "longitude = " + FC.DoubleToString(this.longitude, 7, 2) + "\r\n" + "ut = " + this.ut.toHumanUT() + "\r\n" + "critical frequency of E-layer = " + this.foEP + "\r\n" + "critical frequency of F1-layer = " + this.foF1P + "\r\n" + "critical frequency of F2-layer = " + this.foF2P + "\r\n" + "Dec = " + this.dec + "\r\n" + "Dip = " + this.dip + "\r\n" + "fce = " + this.fce;
    }

    public void calculate(double latitude, double longitude) {
        this.calculate(latitude, longitude, new TimeScale());
    }

    public void calculate(double latitude, double longitude, TimeScale ut) {
        this.setTime(ut);
        this.setLocation(latitude, longitude);
        this.setSolarActivity();
        this.setMagneticField();
        this.loadCoefficients();
        this.calcPrediction();
    }

    public void setTime(TimeScale ut) {
        this.ut = ut;
        this.month = ut.get(2) + 1;
        this.dayOfYear = ut.get(6);
        ut.get(11);
        ut.get(12);
        ut.get(13);
        ut.get(14);
        this.realHours = new RealHours(ut);
    }

    public void setLocation(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public void setMagneticField() {
        this.igrf.calc(this.ut, this.latitude, this.longitude, 300.0);
        this.xma = -this.igrf.bT / 100000.0;
        this.yma = this.igrf.bF / 100000.0;
        this.zma = -this.igrf.bR / 100000.0;
        this.bet = this.igrf.B / 100000.0;
        this.dip = this.igrf.dip;
        this.dec = this.igrf.dec;
        this.fce = this.igrf.fce;
        double dipInRadian = Math.toRadians(this.dip);
        double dipdiv = dipInRadian / Math.sqrt(dipInRadian * dipInRadian + Math.cos(Math.toRadians(this.latitude)));
        if (dipdiv > 1.0) {
            dipdiv = 1.0;
        } else if (dipdiv < -1.0) {
            dipdiv = -1.0;
        }
        this.modip = Math.asin(dipdiv);
        this.modip = Math.toDegrees(this.modip);
        double[] geoLatLong = new double[3];
        double[] magLatLong = new double[3];
        geoLatLong[0] = this.latitude;
        geoLatLong[1] = this.longitude;
        geoLatLong[2] = 0.0;
        this.geopack.recalc(this.ut);
        this.geopack.geomapToMagmap(geoLatLong, magLatLong);
        this.magLatitude = magLatLong[0];
        this.magLongitude = magLatLong[1];
    }

    public void setSolarActivity() {
        this.sunspots = SunSpots.get(this.ut);
        this.ig12 = IG12.get(this.ut);
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getMagLatitude() {
        return this.magLatitude;
    }

    public double getMagLongitude() {
        return this.magLongitude;
    }

    public TimeScale getTimeUT() {
        return this.ut;
    }

    public float getSunspotNumber() {
        return this.sunspots.getNumber();
    }

    public boolean isSunspotNumberPredicted() {
        return this.sunspots.isPredicted();
    }

    public boolean isSunspotNumberAvailable() {
        return this.sunspots.isAvailable();
    }

    public double getIg12Number() {
        return this.ig12.getNumber();
    }

    public boolean isIg12NumberAvailable() {
        return this.ig12.isAvailable();
    }

    public GroundSolar getGroundSolar() {
        return this.groundSolar;
    }

    public double getFoEP() {
        return this.foEP;
    }

    public double getFoF1P() {
        return this.foF1P;
    }

    public double getFoF1Probability() {
        return this.foF1probability;
    }

    public double getFoF2P() {
        return this.foF2P;
    }

    public double getNmDP() {
        return this.NmDP;
    }

    public boolean isAuroralPossible() {
        return this.magLatitude >= 60.0;
    }

    public double[][] getCoefs_foF2() {
        return this.f2[0];
    }

    public double[][] getCoefs_hmF2() {
        return this.f2[0];
    }

    public void loadCoefficients() {
        double rg = Math.min(this.ig12.getNumber(), 150.0);
        if (this.month != this.monthPrev || rg != this.rgPrev) {
            int j;
            int i;
            block23: {
                File file = new File(CommonConst.getShareResourcesDir(), URSI_MODEL_PREF + (10 + this.month) + "." + URSI_MODEL_EXT);
                String fileURSI = file.getPath();
                BufferedReader in = null;
                i = 0;
                j = 0;
                int k = 0;
                try {
                    try {
                        in = new BufferedReader(new FileReader(file));
                        while (in.ready()) {
                            String line = in.readLine();
                            if (line != null) {
                                int m = 0;
                                while (m < 4) {
                                    this.f2[i][j][k] = FC.StringToDouble(line.substring(1 + m * 15, 1 + (m + 1) * 15));
                                    if (++k >= 13) {
                                        k = 0;
                                        if (++j >= 76) {
                                            j = 0;
                                            ++i;
                                        }
                                    }
                                    ++m;
                                }
                                if (i != 2) {
                                    continue;
                                }
                            }
                            break;
                        }
                    }
                    catch (IOException ex) {
                        System.out.println("Can't read file " + fileURSI + " !");
                        System.out.println(ex.toString());
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException ex2) {
                                ex2.printStackTrace();
                            }
                        }
                        break block23;
                    }
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                    throw throwable;
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            double rr2 = rg / 100.0;
            double rr1 = 1.0 - rr2;
            i = 0;
            while (i < 76) {
                j = 0;
                while (j < 13) {
                    this.f2[0][i][j] = this.f2[0][i][j] * rr1 + this.f2[1][i][j] * rr2;
                    ++j;
                }
                ++i;
            }
            this.monthPrev = this.month;
            this.rgPrev = rg;
        }
    }

    public void setCoefficients(double[][] coeff) {
        int i = 0;
        while (i < 76) {
            int j = 0;
            while (j < 13) {
                this.f2[0][i][j] = coeff[i][j];
                ++j;
            }
            ++i;
        }
    }

    private void calcPrediction() {
        double utHour = this.realHours.getRealHours();
        double lcHour = TimeScale.getLongitudeHours((double)((float)this.longitude), utHour).getRealHours();
        this.groundSolar = new GroundSolar(this.latitude, this.longitude, this.ut);
        double rg = (double)this.sunspots.getNumber() > 150.0 ? 150.0 : (double)this.sunspots.getNumber();
        double ph = 63.75 + rg * (0.728 + rg * 8.9E-4);
        double abslat = Math.abs(this.latitude);
        this.foEP = IRIModel.foEpIRI(ph, this.groundSolar.getZenith(), this.groundSolar.getNoonZenith(), abslat);
        int season = (this.dayOfYear + 45) / 92;
        if (season < 1) {
            season = 4;
        }
        if (this.latitude < 0.0 && (season -= 2) < 1) {
            season += 4;
        }
        double magbr = Math.atan(0.5 * Math.tan(Math.toRadians(this.dip)));
        magbr = Math.toDegrees(magbr);
        double absmbr = Math.abs(magbr);
        this.foF1P = 999.9;
        this.foF1probability = 0.0;
        if (!this.groundSolar.isNight(lcHour)) {
            this.foF1P = IRIModel.foF1ED(absmbr, this.sunspots.getNumber(), this.groundSolar.getZenith());
            if (this.foF1P < this.foEP) {
                this.foF1P = 999.9;
            } else {
                this.foF1probability = IRIModel.getF1Probability(this.magLatitude, this.sunspots.getNumber(), this.groundSolar.getZenith());
            }
        }
        this.NmDP = IRIModel.XmDED(this.groundSolar.getZenith(), this.sunspots.getNumber(), 4.0E8);
        this.foF2P = IRIModel.f2Out(this.modip, this.latitude, this.longitude, this.f2[0], utHour);
    }

    private static double foEpIRI(double cov, double zenith, double noonZenith, double absLatitude) {
        double c;
        double sm;
        double a = 1.0 + 0.0094 * (cov - 66.0);
        double sl = Math.cos(Math.toRadians(absLatitude));
        if (absLatitude < 32.0) {
            sm = -1.93 + 1.92 * sl;
            c = 23.0 + 116.0 * sl;
        } else {
            sm = 0.11 - 0.49 * sl;
            c = 92.0 + 35.0 * sl;
        }
        if (noonZenith >= 90.0) {
            noonZenith = 89.999;
        }
        double b = Math.pow(Math.cos(Math.toRadians(noonZenith)), sm);
        double sp = absLatitude > 12.0 ? 1.2 : 1.31;
        double xhic = zenith - 3.0 * Math.log(1.0 + Math.exp((zenith - 89.98) / 3.0));
        double d = Math.pow(Math.cos(Math.toRadians(xhic)), sp);
        double foEpIRI = a * b * c * d;
        double smin = 0.121 + 0.0015 * (cov - 60.0);
        if (foEpIRI < (smin *= smin)) {
            foEpIRI = smin;
        }
        foEpIRI = Math.pow(foEpIRI, 0.25);
        return foEpIRI;
    }

    private static double foF1ED(double yLati, double r, double chi) {
        double foF1ED = 0.0;
        double dla = yLati;
        double chi0 = 49.84733 + 0.349504 * dla;
        double chi100 = 38.96113 + 0.509932 * dla;
        double chim = chi0 + (chi100 - chi0) * r / 100.0;
        if (chi <= chim) {
            double f0 = 4.35 + dla * (0.0058 - 1.2E-4 * dla);
            double f100 = 5.348 + dla * (0.011 - 2.3E-4 * dla);
            double fs = f0 + (f100 - f0) * r / 100.0;
            double xmue = 0.093 + dla * (0.0046 - 5.4E-5 * dla) + 3.0E-4 * r;
            foF1ED = fs * Math.pow(Math.cos(Math.toRadians(chi)), xmue);
        }
        return foF1ED;
    }

    private static double getF1Probability(double magLat, double ssn, double zenith_deg) {
        double c;
        double b;
        double a;
        double gamma;
        double xarg = 0.5 + 0.5 * Math.cos(Math.toRadians(zenith_deg));
        double f1pr = Math.pow(xarg, gamma = (a = 2.98 + 0.0854 * ssn) + ((b = 0.0107 - 0.0022 * ssn) + (c = -2.56E-4 + 1.47E-5 * ssn) * magLat) * magLat);
        if (f1pr < 0.001) {
            f1pr = 0.0;
        }
        return f1pr;
    }

    private static double XmDED(double chi, double r, double nightValue) {
        if (chi > 90.0) {
            return nightValue;
        }
        double y = 6.05E8 + 8800000.0 * r;
        double yy = Math.cos(Math.toRadians(chi));
        double yyy = -0.1 / Math.pow(yy, 2.7);
        double ymd = yyy < -40.0 ? 0.0 : y * Math.exp(yyy);
        return Math.max(ymd, nightValue);
    }

    private static double f2Out(double modip, double latitude, double longitude, double[][] ff0, double utHour) {
        int[] nArray = new int[9];
        nArray[0] = 11;
        nArray[1] = 11;
        nArray[2] = 8;
        nArray[3] = 4;
        nArray[4] = 1;
        int[] qf = nArray;
        return IRIModel.gamma1(modip, latitude, longitude, utHour, 6, qf, 9, 76, 13, 988, ff0);
    }

    public double foF2NewLocation(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.setMagneticField();
        return IRIModel.f2Out(this.modip, latitude, longitude, this.f2[0], this.realHours.getRealHours());
    }

    public double foF2NewTime(double ut_hours) {
        return IRIModel.f2Out(this.modip, this.latitude, this.longitude, this.f2[0], ut_hours);
    }

    private static double gamma1(double smodip, double latitude, double longitude, double hour, int TIME_ORDER6, int[] nq, int k1, int M76, int M13, int m3, double[][] sfe) {
        double ss;
        double[] xsinx = new double[13];
        double[] coef = IRIModel.getSphericalCoefficients(hour, TIME_ORDER6, M76, sfe);
        double sum = coef[0];
        double s3 = ss = Math.sin(Math.toRadians(smodip));
        xsinx[0] = 1.0;
        int index = nq[0];
        int j = 0;
        while (j < index) {
            sum += coef[j + 1] * ss;
            xsinx[j + 1] = ss;
            ss *= s3;
            ++j;
        }
        xsinx[nq[0] + 1] = ss;
        int np = nq[0] + 1;
        s3 = ss = Math.cos(Math.toRadians(latitude));
        j = 1;
        while (j < k1) {
            double s0 = Math.toRadians(longitude * (double)j);
            double s1 = Math.cos(s0);
            double s2 = Math.sin(s0);
            index = nq[j] + 1;
            int l = 0;
            while (l < index) {
                sum += coef[++np - 1] * xsinx[l] * ss * s1;
                sum += coef[++np - 1] * xsinx[l] * ss * s2;
                ++l;
            }
            ss *= s3;
            ++j;
        }
        return sum;
    }

    public static double[] getSphericalCoefficients(double hour, int TIME_ORDER6, int M76, double[][] sfe) {
        double[] c = new double[12];
        double[] s = new double[12];
        double[] coef = new double[M76];
        double hou = Math.toRadians(15.0 * hour - 180.0);
        s[0] = Math.sin(hou);
        c[0] = Math.cos(hou);
        int i = 1;
        while (i < TIME_ORDER6) {
            c[i] = c[0] * c[i - 1] - s[0] * s[i - 1];
            s[i] = c[0] * s[i - 1] + s[0] * c[i - 1];
            ++i;
        }
        i = 0;
        while (i < M76) {
            coef[i] = sfe[i][0];
            int j = 0;
            while (j < TIME_ORDER6) {
                coef[i] = coef[i] + sfe[i][2 * j + 1] * s[j] + sfe[i][2 * j + 2] * c[j];
                ++j;
            }
            ++i;
        }
        return coef;
    }

    public static double[] getDiurnalCoefficients(double smodip, double latitude, double longitude, int[] nq, int k1, int M13, double[][] sfe) {
        double[] coef = new double[M13];
        double[] xsinx = new double[13];
        int i = 0;
        while (i < M13) {
            double ss;
            double sum = sfe[0][i];
            double s3 = ss = Math.sin(Math.toRadians(smodip));
            xsinx[0] = 1.0;
            int index = nq[0];
            int j = 0;
            while (j < index) {
                sum += sfe[j + 1][i] * ss;
                xsinx[j + 1] = ss;
                ss *= s3;
                ++j;
            }
            xsinx[nq[0] + 1] = ss;
            int np = nq[0] + 1;
            s3 = ss = Math.cos(Math.toRadians(latitude));
            j = 1;
            while (j < k1) {
                double s0 = Math.toRadians(longitude * (double)j);
                double s1 = Math.cos(s0);
                double s2 = Math.sin(s0);
                index = nq[j] + 1;
                int l = 0;
                while (l < index) {
                    sum += sfe[++np - 1][i] * xsinx[l] * ss * s1;
                    sum += sfe[++np - 1][i] * xsinx[l] * ss * s2;
                    ++l;
                }
                ss *= s3;
                ++j;
            }
            coef[i] = sum;
            ++i;
        }
        return coef;
    }
}

