/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.geospace;

import edu.uml.lgdc.geospace.DayNightInterpolator;
import edu.uml.lgdc.geospace.GroundSolar;
import edu.uml.lgdc.geospace.IGRF;
import edu.uml.lgdc.geospace.PlasmaMath;
import edu.uml.lgdc.geospace.RegulaFalsiSolvable;
import edu.uml.lgdc.geospace.RegulaFalsiSolver;
import edu.uml.lgdc.geospace.TabulatedProfile;
import edu.uml.lgdc.time.TimeScale;
import java.util.Map;
import java.util.TreeMap;

public class IRIVerticalElectronDensity
implements RegulaFalsiSolvable {
    public static final double IRI_PROFILE_START_HEIGHT = 80.0;
    public static final double IRI_PROFILE_HEIGHT_STEP = 1.0;
    DensityRegion1 densityRegion1 = null;
    DensityRegion2 densityRegion2 = new DensityRegion2();
    DensityRegion3 densityRegion3 = new DensityRegion3();
    DensityRegion4 densityRegion4 = new DensityRegion4();
    DensityRegion5 densityRegion5 = new DensityRegion5();
    DensityRegion6 densityRegion6 = new DensityRegion6();
    private double NmF2;
    private double hmF2;
    private double NmF1;
    private double hmF1;
    private double NmE;
    private double hmE;
    private double NmD;
    private double hmD;
    private double B0;
    private double B1;
    private double D1;
    private double T;
    private double valleyWidth_HBR;
    private double valleyDepth_DP;
    private double valleyDepth_UMLCAR;
    private double valleyBaseDensity_Nvb;
    private double valleyBaseHeight_HABR;
    private double valleyTopDerivative_DLN;
    private double[] valleyCoeffs;
    private double DLayer1;
    private double xkk;
    private double fp1;
    private double fp2;
    private double fp30;
    private double fp3U;
    private double Hz;
    private double Hst;
    private double Hef;
    private double Hdx;
    private double F1probability;
    private boolean nightTimeInDlayer = false;
    private boolean nightTimeInElayer = false;
    private boolean nightTimeInFlayer = false;

    public void setAnchorPoints(double NmF2, double hmF2, double NmF1, double NmE, double hmE, double NmD) {
        this.NmF2 = NmF2;
        this.hmF2 = hmF2;
        this.NmF1 = NmF1;
        this.NmE = NmE;
        this.hmE = hmE;
        this.NmD = NmD;
    }

    public double[] getAnchorPoints() {
        return new double[]{this.NmF2, this.hmF2, this.NmF1, this.hmF1, this.NmE, this.hmE, this.NmD, this.Hdx};
    }

    public void setShapeParameters(double B0, double B1) {
        this.B0 = B0;
        this.B1 = B1;
    }

    public void setF1probability(double F1probability) {
        this.F1probability = F1probability;
    }

    public double getF1probability() {
        return this.F1probability;
    }

    public void computeConstants(TimeScale timeUT, double lat_N, double lon_E) {
        double localTime_hr = timeUT.getTimeSinceMidnightIn(11) + lon_E / 15.0;
        if (localTime_hr > 24.0) {
            localTime_hr -= 24.0;
        }
        if (localTime_hr < 0.0) {
            localTime_hr += 24.0;
        }
        IGRF igrf = new IGRF();
        igrf.calc(timeUT, lat_N, lon_E, 80.0);
        double dipInRadian = Math.toRadians(igrf.dip);
        double dipdiv = dipInRadian / Math.sqrt(dipInRadian * dipInRadian + Math.cos(Math.toRadians(lat_N)));
        if (dipdiv > 1.0) {
            dipdiv = 1.0;
        } else if (dipdiv < -1.0) {
            dipdiv = -1.0;
        }
        double modip = Math.toDegrees(Math.asin(dipdiv));
        DayNightInterpolator.initialize(lat_N, lon_E, 80.0, timeUT);
        double dela = Math.abs(modip) < 18.0 ? 4.32 : 1.0 + Math.exp(-(Math.abs(modip) - 30.0) / 10.0);
        this.fp1 = DayNightInterpolator.getValue(localTime_hr, 0.02 + 0.03 / dela, 0.05);
        this.fp2 = -this.fp1 * this.fp1 / 2.0;
        double f2 = DayNightInterpolator.getValue(localTime_hr, 4.6, 4.5);
        double f3 = DayNightInterpolator.getValue(localTime_hr, -11.5, -4.0);
        this.fp30 = (-f2 * this.fp2 - this.fp1 + 1.0 / f2) / (f2 * f2);
        this.fp3U = (-f3 * this.fp2 - this.fp1 - 1.0 / f3) / (f3 * f3);
        this.hmD = DayNightInterpolator.getValue(localTime_hr, 81.0, 88.0);
        this.nightTimeInDlayer = DayNightInterpolator.isNight();
        this.setHdx(this.hmD + f2);
        double dh = this.getHdx() - this.hmD;
        double xdx = this.NmD * Math.exp(dh * (this.fp1 + dh * (this.fp2 + dh * this.fp30)));
        double dxdx = xdx * (this.fp1 + dh * (2.0 * this.fp2 + dh * 3.0 * this.fp30));
        this.xkk = -dxdx * (this.hmE - this.getHdx()) / (xdx * Math.log(xdx / this.NmE));
        if (this.xkk > 5.0) {
            this.xkk = 5.0;
            this.DLayer1 = -Math.log(xdx / this.NmE) / Math.pow(dh, this.xkk);
        } else {
            this.DLayer1 = dxdx / (xdx * this.xkk * Math.pow(dh, this.xkk - 1.0));
        }
        DayNightInterpolator.initialize(lat_N, lon_E, 110.0, timeUT);
        this.nightTimeInElayer = DayNightInterpolator.isNight();
        this.valleyBaseHeight_HABR = DayNightInterpolator.getValue(localTime_hr, 10.5 / dela, 28.0);
        this.valleyWidth_HBR = DayNightInterpolator.getValue(localTime_hr, 17.8 / dela, 45.0 + 22.0 / dela);
        double[] XDELS = new double[]{5.0, 5.0, 5.0, 10.0};
        double[] DNDS = new double[]{0.016, 0.01, 0.016, 0.016};
        int dayOfYear = timeUT.get(6);
        int season = (dayOfYear + 45) / 92;
        if (season < 1) {
            season = 4;
        }
        if (lat_N < 0.0 && (season -= 2) < 1) {
            season += 4;
        }
        this.valleyDepth_DP = DayNightInterpolator.getValue(localTime_hr, XDELS[season - 1] / dela, 81.0);
        this.valleyDepth_UMLCAR = Math.sqrt(this.valleyDepth_DP) * PlasmaMath.density2freq_m3(this.NmE);
        this.valleyTopDerivative_DLN = DayNightInterpolator.getValue(localTime_hr, DNDS[season - 1] / dela, 0.06);
        this.Hef = this.hmE + this.valleyWidth_HBR;
        this.valleyBaseDensity_Nvb = this.NmE * (1.0 - this.valleyDepth_DP / 100.0);
        this.valleyCoeffs = this.computeValleyCoefficients();
        if (0.9 * this.NmF1 < this.NmE) {
            this.F1probability = 0.0;
        }
        if (this.F1LayerPresent()) {
            RegulaFalsiSolver.setArgumentBounds(this.Hef, this.hmF2);
            this.hmF1 = RegulaFalsiSolver.solve(this.NmF1, this.densityRegion2);
            if (this.hmF1 < this.hmE || this.hmF1 > this.hmF2) {
                this.F1probability = 0.0;
                this.hmF1 = 9999.0;
                this.NmF1 = -1.0;
            }
        } else {
            this.hmF1 = 9999.0;
        }
        RegulaFalsiSolver.setArgumentBounds(this.Hef, this.F1LayerPresent() ? this.hmF1 : (this.Hef + this.hmF2) / 2.0);
        this.Hst = RegulaFalsiSolver.solve(this.NmE, this.densityRegion3);
        this.Hz = this.F1LayerPresent() ? (this.Hst + this.hmF1) / 2.0 : (2.0 * this.Hst + this.Hef + this.hmF2) / 4.0;
        double delta = this.Hz - this.Hst;
        this.T = delta * delta / (this.Hz - this.Hef - delta);
        double C1 = 0.09 + 0.11 / dela;
        GroundSolar sunData = new GroundSolar(lat_N, lon_E, 200.0, timeUT);
        double sunrise200_hr = sunData.getSunriseTimeInHoursLT();
        double sunset200_hr = sunData.getSunsetTimeInHoursLT();
        this.nightTimeInFlayer = sunData.isNight();
        this.D1 = sunrise200_hr == sunset200_hr ? 2.5 * C1 : 2.5 * C1 * Math.cos(Math.PI * (localTime_hr - 12.0) / (sunrise200_hr - sunset200_hr));
    }

    public double[] computeValleyCoefficients() {
        if (this.valleyWidth_HBR <= 0.0) {
            return null;
        }
        double[] c = new double[4];
        double Z1 = this.nightTimeInElayer ? Math.log(1.0 - this.valleyDepth_DP / 100.0) / (this.valleyBaseHeight_HABR * this.valleyBaseHeight_HABR) : -this.valleyDepth_DP / (100.0 * this.valleyBaseHeight_HABR * this.valleyBaseHeight_HABR);
        double Z3 = this.valleyTopDerivative_DLN / (2.0 * this.valleyWidth_HBR);
        double Z4 = this.valleyBaseHeight_HABR - this.valleyWidth_HBR;
        c[3] = 2.0 * (Z1 * (this.valleyWidth_HBR - 2.0 * this.valleyBaseHeight_HABR) * this.valleyWidth_HBR + Z3 * Z4 * this.valleyBaseHeight_HABR) / (this.valleyBaseHeight_HABR * this.valleyWidth_HBR * Z4 * Z4 * Z4);
        c[2] = Z1 * (2.0 * this.valleyWidth_HBR - 3.0 * this.valleyBaseHeight_HABR) / (this.valleyBaseHeight_HABR * Z4 * Z4) - (2.0 * this.valleyBaseHeight_HABR + this.valleyWidth_HBR) * c[3];
        c[1] = -2.0 * Z1 / this.valleyBaseHeight_HABR - 2.0 * this.valleyBaseHeight_HABR * c[2] - 3.0 * this.valleyBaseHeight_HABR * this.valleyBaseHeight_HABR * c[3];
        c[0] = Z1 - this.valleyBaseHeight_HABR * (c[1] + this.valleyBaseHeight_HABR * (c[2] + this.valleyBaseHeight_HABR * c[3]));
        return c;
    }

    public double getB0() {
        return this.B0;
    }

    public double getB1() {
        return this.B1;
    }

    public double getD1() {
        return this.D1;
    }

    public double[] getValleyParameters() {
        return new double[]{this.valleyDepth_DP, this.valleyWidth_HBR, this.valleyBaseDensity_Nvb, this.valleyBaseHeight_HABR, this.valleyTopDerivative_DLN};
    }

    public double getValleyBaseHeight() {
        return this.valleyBaseHeight_HABR + this.hmE;
    }

    public double gethmF1() {
        return this.hmF1;
    }

    @Override
    public double getDensity_m3(double h) {
        if (h > this.hmF2) {
            return 0.0;
        }
        if (this.F1LayerPresent() && h >= this.hmF1) {
            return this.densityRegion2.getDensity_m3(h);
        }
        if (h >= this.Hz) {
            return this.densityRegion3.getDensity_m3(h);
        }
        if (h >= this.Hef) {
            return this.densityRegion4.getDensity_m3(h);
        }
        if (h >= this.hmE) {
            return this.densityRegion5.getDensity_m3(h);
        }
        return this.densityRegion6.getDensity_m3(h);
    }

    public double expobolics(double h, double hmF2, double B0, double B1) {
        double x = (hmF2 - h) / B0;
        if (x < 0.0) {
            x = 0.0;
        }
        double z = Math.pow(x, B1);
        double expz = Math.exp(-z);
        double coshx = Math.cosh(x);
        double value = expz / coshx;
        return value;
    }

    public double getHdx() {
        return this.Hdx;
    }

    public void setHdx(double hdx) {
        this.Hdx = hdx;
    }

    public TabulatedProfile buildTabulatedProfile() {
        TabulatedProfile tabulatedProfile = new TabulatedProfile();
        TreeMap<Double, Double> workingProfile = new TreeMap<Double, Double>();
        double h = 80.0;
        while (h < this.hmF2) {
            workingProfile.put(h, this.getDensity_m3(h));
            h += 1.0;
        }
        double Hvb = this.getValleyBaseHeight();
        workingProfile.put(this.Hdx, this.NmD);
        workingProfile.put(this.hmE, this.NmE);
        workingProfile.put(Hvb, this.getDensity_m3(Hvb));
        if (this.F1LayerPresent()) {
            workingProfile.put(this.hmF1, this.NmF1);
        }
        workingProfile.put(this.hmF2, this.NmF2);
        tabulatedProfile.allocateMemory(workingProfile.size());
        tabulatedProfile.start_D = 0;
        tabulatedProfile.end_F2 = tabulatedProfile.getSize() - 1;
        tabulatedProfile.end_F1 = -1;
        tabulatedProfile.start_F1 = -1;
        int count = 0;
        for (Map.Entry entry : workingProfile.entrySet()) {
            h = (Double)entry.getKey();
            double d = (Double)entry.getValue();
            tabulatedProfile.height[count] = h;
            tabulatedProfile.putDensity(count, d * 1.0E-6);
            tabulatedProfile.frequency[count++] = PlasmaMath.density2freq_m3(d);
            if (h == this.Hdx) {
                tabulatedProfile.end_D = count - 1;
                tabulatedProfile.start_E = count;
            }
            if (h == Hvb) {
                tabulatedProfile.end_E = count - 1;
                if (this.F1LayerPresent()) {
                    tabulatedProfile.start_F1 = count;
                } else {
                    tabulatedProfile.start_F2 = count;
                }
            }
            if (this.F1LayerPresent() && h == this.hmF1) {
                tabulatedProfile.end_F1 = count - 1;
                tabulatedProfile.start_F2 = count;
            }
            if (count == tabulatedProfile.getSize()) break;
        }
        return tabulatedProfile;
    }

    public boolean F1LayerPresent() {
        return this.F1probability >= 0.5;
    }

    public class DensityRegion1
    implements RegulaFalsiSolvable {
        @Override
        public double getDensity_m3(double h) {
            return 0.0;
        }
    }

    public class DensityRegion2
    implements RegulaFalsiSolvable {
        @Override
        public double getDensity_m3(double h) {
            return IRIVerticalElectronDensity.this.NmF2 * IRIVerticalElectronDensity.this.expobolics(h, IRIVerticalElectronDensity.this.hmF2, IRIVerticalElectronDensity.this.B0, IRIVerticalElectronDensity.this.B1);
        }
    }

    public class DensityRegion3
    implements RegulaFalsiSolvable {
        @Override
        public double getDensity_m3(double h) {
            double h1bar = IRIVerticalElectronDensity.this.F1LayerPresent() ? IRIVerticalElectronDensity.this.hmF1 * (1.0 - Math.pow((IRIVerticalElectronDensity.this.hmF1 - h) / IRIVerticalElectronDensity.this.hmF1, 1.0 + IRIVerticalElectronDensity.this.D1)) : h;
            return IRIVerticalElectronDensity.this.densityRegion2.getDensity_m3(h1bar);
        }
    }

    public class DensityRegion4
    implements RegulaFalsiSolvable {
        @Override
        public double getDensity_m3(double h) {
            if (IRIVerticalElectronDensity.this.Hst < 0.0) {
                return IRIVerticalElectronDensity.this.NmE + IRIVerticalElectronDensity.this.T * (h - IRIVerticalElectronDensity.this.Hef);
            }
            double h1bar = IRIVerticalElectronDensity.this.Hst == IRIVerticalElectronDensity.this.Hef ? h : IRIVerticalElectronDensity.this.Hz + IRIVerticalElectronDensity.this.T / 2.0 - Math.signum(IRIVerticalElectronDensity.this.T) * Math.sqrt(IRIVerticalElectronDensity.this.T * (IRIVerticalElectronDensity.this.T / 4.0 + IRIVerticalElectronDensity.this.Hz - h));
            return IRIVerticalElectronDensity.this.densityRegion3.getDensity_m3(h1bar);
        }
    }

    public class DensityRegion5
    implements RegulaFalsiSolvable {
        @Override
        public double getDensity_m3(double h) {
            double dh = h - IRIVerticalElectronDensity.this.hmE;
            double z = dh * dh * (IRIVerticalElectronDensity.this.valleyCoeffs[0] + dh * (IRIVerticalElectronDensity.this.valleyCoeffs[1] + dh * (IRIVerticalElectronDensity.this.valleyCoeffs[2] + dh * IRIVerticalElectronDensity.this.valleyCoeffs[3])));
            if (IRIVerticalElectronDensity.this.nightTimeInElayer) {
                return IRIVerticalElectronDensity.this.NmE * Math.exp(z);
            }
            return IRIVerticalElectronDensity.this.NmE * (1.0 + z);
        }
    }

    public class DensityRegion6
    implements RegulaFalsiSolvable {
        @Override
        public double getDensity_m3(double h) {
            if (h > IRIVerticalElectronDensity.this.getHdx()) {
                double z = IRIVerticalElectronDensity.this.hmE - h;
                double power = Math.pow(z, IRIVerticalElectronDensity.this.xkk);
                double arg = -IRIVerticalElectronDensity.this.DLayer1 * power;
                double factor = Math.exp(arg);
                return IRIVerticalElectronDensity.this.NmE * factor;
            }
            double z = h - IRIVerticalElectronDensity.this.hmD;
            double fp3 = z > 0.0 ? IRIVerticalElectronDensity.this.fp30 : IRIVerticalElectronDensity.this.fp3U;
            return IRIVerticalElectronDensity.this.NmD * Math.exp(z * (IRIVerticalElectronDensity.this.fp1 + z * (IRIVerticalElectronDensity.this.fp2 + z * fp3)));
        }
    }
}

