/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.geospace;

import edu.uml.lgdc.format.FC;
import edu.uml.lgdc.geospace.GeoMagIndexesManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class KyotoDSTParser {
    public static final int DST_VALUES_IN_LINE = 24;
    public static final int DAY_LENGTH = 2;
    public static final int DST_FIELD_LENGTH = 4;
    public static final int SPACING = 1;
    public static final int NO_VALUE = 9999;

    public static int[][] parseFile(String fileName) {
        int maxDaysInMonth = 31;
        int[][] dst_buf = new int[maxDaysInMonth][24];
        File file = new File(fileName);
        if (!file.exists()) {
            System.out.println("Could not find file " + file.getAbsolutePath());
            return null;
        }
        BufferedReader bufReader = null;
        try {
            String line;
            bufReader = new BufferedReader(new FileReader(file));
            boolean startData = false;
            int day = 0;
            while ((line = bufReader.readLine()) != null) {
                if (line.startsWith("DAY")) {
                    startData = true;
                    continue;
                }
                if (!startData) continue;
                if (startData && line.startsWith("<")) break;
                if (line.isEmpty()) continue;
                day = Integer.parseInt(line.substring(0, 2).trim());
                int i = 0;
                while (i < 24) {
                    int start = 2 + 1 * (1 + i / 8) + i * 4;
                    dst_buf[day - 1][i] = Integer.parseInt(line.substring(start, start + 4).trim());
                    ++i;
                }
            }
            bufReader.close();
            int[][] dst = new int[day][24];
            int iDay = 0;
            while (iDay < day) {
                int iVal = 0;
                while (iVal < 24) {
                    dst[iDay][iVal] = dst_buf[iDay][iVal] != 9999 ? dst_buf[iDay][iVal] : 0;
                    ++iVal;
                }
                ++iDay;
            }
            int[][] nArray = dst;
            return nArray;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bufReader != null) {
                    bufReader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static boolean checkDataInCategory(String fileName, int year, int month) {
        File file = new File(fileName);
        String documentName = String.valueOf(KyotoDSTParser.getYearMonthID(year, month)) + "/" + "index.html";
        if (!file.exists()) {
            System.out.println("Could not find file " + file.getAbsolutePath());
            return false;
        }
        BufferedReader bufReader = null;
        try {
            String line;
            bufReader = new BufferedReader(new FileReader(file));
            boolean found = false;
            while ((line = bufReader.readLine()) != null) {
                if (!line.contains(documentName)) continue;
                found = true;
                break;
            }
            bufReader.close();
            boolean bl = found;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bufReader != null) {
                    bufReader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static void kyotoDST2NOAAFormat(String dstFileName, File[] docs, Character[] category, int year) {
        if (docs.length != 12 || category.length != 12) {
            System.out.println("There are must be 12 files with data.");
            return;
        }
        int[][][] data = new int[docs.length][][];
        int iMonth = 0;
        while (iMonth < docs.length) {
            if (docs[iMonth] == null) {
                data[iMonth] = null;
            } else {
                data[iMonth] = KyotoDSTParser.parseFile(docs[iMonth].getAbsolutePath());
                docs[iMonth].delete();
            }
            ++iMonth;
        }
        GeoMagIndexesManager.writeDSTFile(dstFileName, data, category, year);
    }

    public static String getYearMonthID(int year, int month) {
        return new String(year + FC.IntegerToString(month, 2, '0'));
    }
}

