/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.geospace;

import edu.uml.lgdc.datatype.geom.R2;
import edu.uml.lgdc.geospace.Azimuth;
import edu.uml.lgdc.geospace.Geopack;
import edu.uml.lgdc.geospace.IGRF;
import edu.uml.lgdc.geospace.LocalCoordSys;
import edu.uml.lgdc.time.TimeScale;

public class LocalCoord {
    private static final double[] NORTH_POLE_IN_MAP_COORD = new double[3];
    private static final double[] NORTH_MAG_POLE_IN_GEOMAP_COORD;
    private static final double OBSOLTETE_LAT_OF_GEOMAG_NORTH_POLE = 80.0;
    private static final double OBSOLTETE_LON_OF_GEOMAG_NORTH_POLE = 280.0;
    private double lat;
    private double lon;
    private double alt;
    private double xAxisDeclination_deg;
    private TimeScale timeUT;
    private boolean coordinateIsSet;
    private boolean xAxisDeclinationIsSet;
    private double decOfMagneticLine;
    private double decOfGeomagNorthPole;
    private double decOfObsoleteGeomagNorthPole = Double.NaN;
    private double latOfGeomagNorthPole;
    private double lonOfGeomagNorthPole;
    private double prevXAxisDeclination_deg = Double.NaN;
    private double prevLat = Double.NaN;
    private double prevLon = Double.NaN;
    private double prevAlt = Double.NaN;
    private TimeScale prevTimeUT = null;
    private boolean decCalculated = false;
    private IGRF igrf = new IGRF();
    private Geopack geo = new Geopack();
    private Azimuth azimuth = new Azimuth();

    static {
        LocalCoord.NORTH_POLE_IN_MAP_COORD[0] = 90.0;
        NORTH_MAG_POLE_IN_GEOMAP_COORD = new double[3];
    }

    public LocalCoord() {
    }

    public LocalCoord(double xAxisDeclination_deg) {
        this.xAxisDeclination_deg = xAxisDeclination_deg;
        this.xAxisDeclinationIsSet = true;
    }

    public void setCoord(double lat_deg, double lon_deg) {
        this.setCoord(lat_deg, lon_deg, 0.0);
    }

    public void setCoord(double lat_deg, double lon_deg, double alt_km) {
        this.lat = lat_deg;
        this.lon = lon_deg;
        this.alt = alt_km;
        this.coordinateIsSet = true;
        this.decCalculated = false;
    }

    public void setXAxisDeclination(double xAxisDeclination_deg) {
        this.xAxisDeclination_deg = xAxisDeclination_deg;
        this.xAxisDeclinationIsSet = true;
        this.decCalculated = false;
    }

    public void setTime(TimeScale timeUT) {
        if (timeUT == null) {
            throw new IllegalArgumentException("timeUT is null");
        }
        this.prevTimeUT = timeUT;
        this.timeUT = timeUT;
        this.decCalculated = false;
    }

    public double getRotationAngle(LocalCoordSys toCoord) {
        if (!this.xAxisDeclinationIsSet) {
            throw new RuntimeException("xAxisDeclination is not set");
        }
        if (toCoord == LocalCoordSys.GEO) {
            return this.xAxisDeclination_deg;
        }
        if (!this.decCalculated) {
            this.calculateDeclinations();
        }
        double angle = this.xAxisDeclination_deg;
        if (toCoord == LocalCoordSys.COM) {
            angle -= this.decOfMagneticLine;
        } else if (toCoord == LocalCoordSys.GM) {
            angle -= this.decOfGeomagNorthPole;
        }
        return this.ensureInRange(angle);
    }

    public double getRotationAngle(LocalCoordSys fromCoord, LocalCoordSys toCoord) {
        if (!this.xAxisDeclinationIsSet) {
            throw new RuntimeException("xAxisDeclination is not set");
        }
        double angle = 0.0;
        if (toCoord != fromCoord) {
            if (!this.decCalculated) {
                this.calculateDeclinations();
            }
            switch (fromCoord) {
                case GEO: {
                    if (toCoord == LocalCoordSys.COM) {
                        angle = -this.decOfMagneticLine;
                        break;
                    }
                    angle = -this.decOfGeomagNorthPole;
                    break;
                }
                case COM: {
                    if (toCoord == LocalCoordSys.GEO) {
                        angle = this.decOfMagneticLine;
                        break;
                    }
                    angle = this.decOfMagneticLine - this.decOfGeomagNorthPole;
                    break;
                }
                case GM: {
                    angle = toCoord == LocalCoordSys.GEO ? this.decOfGeomagNorthPole : this.decOfGeomagNorthPole - this.decOfMagneticLine;
                }
            }
            angle = this.ensureInRange(angle);
        }
        return angle;
    }

    public double getRotationAngleFromObsoleteGeomagToGeomag() {
        if (!this.xAxisDeclinationIsSet) {
            throw new RuntimeException("xAxisDeclination is not set");
        }
        if (!this.decCalculated) {
            this.calculateDeclinations();
        }
        if (this.decOfObsoleteGeomagNorthPole == Double.NaN) {
            this.calcDecOfObsoleteGeomagNorthPole();
        }
        return this.ensureInRange(this.decOfObsoleteGeomagNorthPole - this.decOfGeomagNorthPole);
    }

    public double[][] getTransformed(double[][] coords, LocalCoordSys coordSys) {
        int qty = coords.length;
        double[][] rotatedCoords = new double[qty][3];
        int i = 0;
        while (i < qty) {
            rotatedCoords[i][0] = coords[i][0];
            rotatedCoords[i][1] = coords[i][1];
            rotatedCoords[i][2] = coords[i][2];
            ++i;
        }
        this.transform(rotatedCoords, coordSys);
        return rotatedCoords;
    }

    public void transform(double[][] coords, LocalCoordSys coordSys) {
        double angle_rad = -Math.toRadians(this.getRotationAngle(coordSys));
        R2 temp = new R2();
        int i = 0;
        while (i < coords.length) {
            temp.setTo(coords[i][0], coords[i][1]);
            temp.rotate(angle_rad);
            coords[i][0] = temp.getX();
            coords[i][1] = temp.getY();
            ++i;
        }
    }

    public double[] getTransformed(double[] coord, LocalCoordSys coordSys) {
        double[] rotatedCoord = new double[]{coord[0], coord[1], coord[2]};
        this.transform(rotatedCoord, coordSys);
        return rotatedCoord;
    }

    public void transform(double[] coord, LocalCoordSys coordSys) {
        double angle_rad = -Math.toRadians(this.getRotationAngle(coordSys));
        R2 temp = new R2();
        temp.setTo(coord[0], coord[1]);
        temp.rotate(angle_rad);
        coord[0] = temp.getX();
        coord[1] = temp.getY();
    }

    private void calculateDeclinations() {
        if (!this.coordinateIsSet) {
            throw new RuntimeException("Latitude/longitude is not set");
        }
        if (this.timeUT == null) {
            throw new RuntimeException("Time is not set");
        }
        if (this.lat != this.prevLat || this.lon != this.prevLon || this.alt != this.prevAlt || this.prevXAxisDeclination_deg != this.xAxisDeclination_deg || this.timeUT != this.prevTimeUT) {
            this.calcDecOfMagneticLine();
            this.calcCoordOfGeomagNorthPole();
            this.calcDecOfGeomagNorthPole();
            this.prevLat = this.lat;
            this.prevLon = this.lon;
            this.prevAlt = this.alt;
            this.prevXAxisDeclination_deg = this.xAxisDeclination_deg;
            this.prevTimeUT = this.timeUT;
        }
        this.decCalculated = true;
    }

    private void calcDecOfMagneticLine() {
        this.igrf.calc(this.timeUT, this.lat, this.lon, this.alt);
        this.decOfMagneticLine = this.igrf.dec;
    }

    private void calcCoordOfGeomagNorthPole() {
        this.geo.recalc(this.timeUT);
        this.geo.magmapToGeomap(NORTH_POLE_IN_MAP_COORD, NORTH_MAG_POLE_IN_GEOMAP_COORD);
        this.latOfGeomagNorthPole = NORTH_MAG_POLE_IN_GEOMAP_COORD[0];
        this.lonOfGeomagNorthPole = NORTH_MAG_POLE_IN_GEOMAP_COORD[1];
    }

    private void calcDecOfGeomagNorthPole() {
        this.azimuth.calc(this.lat, this.lon, this.latOfGeomagNorthPole, this.lonOfGeomagNorthPole);
        this.decOfGeomagNorthPole = this.azimuth.getCWazimuth_deg();
    }

    private void calcDecOfObsoleteGeomagNorthPole() {
        this.azimuth.calc(this.lat, this.lon, 80.0, 280.0);
        this.decOfObsoleteGeomagNorthPole = this.azimuth.getCWazimuth_deg();
    }

    private double ensureInRange(double angle_deg) {
        if (angle_deg > 180.0) {
            angle_deg = 360.0 - angle_deg;
        } else if (angle_deg <= -180.0) {
            angle_deg += 360.0;
        }
        return angle_deg;
    }

    public double[] getCoord() {
        return new double[]{this.lat, this.lon, this.alt};
    }
}

