/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.geospace;

public enum LocalCoordSys {
    GEO("GEO", "geographic", "Geographic"),
    COM("COM", "compass", "Compass"),
    GM("GM", "geomagnetic", "Geomagnetic");

    private final String shortName;
    private final String longName;
    private final String longNameWithInitialCap;
    private final String shortNameWithInitialCap;

    private LocalCoordSys(String shortName, String longName, String longNameWithInitialCap) {
        this.shortName = shortName;
        this.longName = longName;
        this.longNameWithInitialCap = longNameWithInitialCap;
        this.shortNameWithInitialCap = Character.toUpperCase(shortName.charAt(0)) + shortName.substring(1).toLowerCase();
    }

    public String shortName() {
        return this.shortName;
    }

    public String longName() {
        return this.longName;
    }

    public String shortName(boolean initialCaps) {
        if (initialCaps) {
            return this.shortNameWithInitialCap;
        }
        return this.shortName;
    }

    public String longName(boolean initialCaps) {
        if (initialCaps) {
            return this.longNameWithInitialCap;
        }
        return this.longName;
    }

    public static LocalCoordSys getCoordSystemFromStr(String str) {
        LocalCoordSys coord;
        if ((str = str.toUpperCase()).equals("GEO")) {
            coord = GEO;
        } else if (str.equals("COM") || str.equals("MAG")) {
            coord = COM;
        } else if (str.equals("GM") || str.equals("CGM")) {
            coord = GM;
        } else {
            throw new IllegalArgumentException("Unrecognized local coordinate name: " + str);
        }
        return coord;
    }

    public static LocalCoordSys get(int ordinal) {
        if (LocalCoordSys.check(ordinal)) {
            return LocalCoordSys.values()[ordinal];
        }
        throw new IllegalArgumentException("Illegal ordinal, " + ordinal);
    }

    public static String[] shortNames(boolean initialCaps) {
        LocalCoordSys[] values = LocalCoordSys.values();
        String[] shortNames = new String[values.length];
        int i = 0;
        while (i < values.length) {
            shortNames[i] = values[i].shortName(initialCaps);
            ++i;
        }
        return shortNames;
    }

    public static String[] longNames(boolean initialCaps) {
        LocalCoordSys[] values = LocalCoordSys.values();
        String[] longNames = new String[values.length];
        int i = 0;
        while (i < values.length) {
            longNames[i] = values[i].longName(initialCaps);
            ++i;
        }
        return longNames;
    }

    public static boolean check(int value) {
        return value >= 0 && value < LocalCoordSys.values().length;
    }
}

