/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.geospace;

import edu.uml.lgdc.geospace.Dipole;
import edu.uml.lgdc.geospace.Geopack;
import edu.uml.lgdc.geospace.IGRF;
import edu.uml.lgdc.time.TimeScale;

public class MagneticFootprint
extends Geopack {
    public static final int AUTO_TOTAL_STEPS = 4000;
    public static final double MAX_REASONABLE_LENGTH = 99.0;
    public static final double UNCOMPUTABLE_LATITUDE = 999.0;
    public static final double UNCOMPUTABLE_LONGITUDE = 999.0;
    public static final double UNCOMPUTABLE_ARCLENGTH = -1.0;
    private double stepKm = 1.0;
    private double stopHeightKm = 100.0;
    private TimeScale time;
    private boolean onlyReasonableLegth = false;
    private boolean autoStep = false;

    public MagneticFootprint(TimeScale time, double stepKm, double stopHeightKm) {
        this.stepKm = stepKm;
        this.stopHeightKm = stopHeightKm;
        this.time = time;
    }

    public MagneticFootprint(TimeScale time, double stopHeightKm) {
        this.stopHeightKm = stopHeightKm;
        this.time = time;
        this.onlyReasonableLegth = true;
        this.autoStep = true;
    }

    public void trace(double[] geomap, double[] footprint, int traceDir) {
        IGRF igrf = new IGRF();
        Geopack gp = new Geopack();
        gp.recalc(this.time);
        double re = 1.0 + geomap[2] / 6371.2;
        double[] magmap = new double[3];
        gp.geomapToMagmap(geomap, magmap);
        if (this.onlyReasonableLegth || this.autoStep) {
            double lShell = Dipole.lShell(re, magmap[0]);
            double dipoleArcLength = Dipole.arcLength(lShell, magmap[0], traceDir);
            if (this.onlyReasonableLegth && dipoleArcLength > 99.0) {
                footprint[0] = 999.0;
                footprint[1] = 999.0;
                footprint[2] = -1.0;
                return;
            }
            if (this.autoStep) {
                this.stepKm = dipoleArcLength * 6371.2 / 4000.0;
            }
        }
        double arcLength = 0.0;
        double[] local = new double[3];
        double[] cart = new double[3];
        double[] offset = new double[3];
        footprint[0] = Math.toRadians(90.0 - geomap[0]);
        footprint[1] = Math.toRadians(geomap[1]);
        footprint[2] = geomap[2] + 6371.2;
        while (footprint[2] > 6371.2 + this.stopHeightKm) {
            igrf.calc(this.time.get(1), this.time.get(6), 10, footprint[2] / 6371.2, footprint[0], footprint[1]);
            local[2] = (double)traceDir * this.stepKm * igrf.bR / igrf.B;
            local[1] = (double)traceDir * this.stepKm * igrf.bF / igrf.B;
            local[0] = -((double)traceDir) * this.stepKm * Math.abs(igrf.bT) / igrf.B;
            MagneticFootprint.spherToCart(footprint, cart);
            MagneticFootprint.localToGeoWithGeomapInRad(local, footprint[0], footprint[1], offset);
            MagneticFootprint.addVectors(cart, offset, cart);
            MagneticFootprint.cartToSpher(cart, footprint);
            arcLength += this.stepKm;
        }
        footprint[1] = Math.toDegrees(footprint[1]);
        footprint[0] = 90.0 - Math.toDegrees(footprint[0]);
        footprint[2] = arcLength;
    }
}

