/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.geospace;

import edu.uml.lgdc.geospace.CharChoice;
import edu.uml.lgdc.geospace.MapTypeChoice;

public final class MapChoice
extends Enum<MapChoice> {
    public static final /* enum */ MapChoice FOF2_CLIMATE;
    public static final /* enum */ MapChoice FOF2_MEDIAN_30DAY;
    public static final /* enum */ MapChoice FOF2_WEATHER;
    public static final /* enum */ MapChoice FOF2_DELTA;
    public static final /* enum */ MapChoice FOF2_DELTA_PERCENT;
    public static final /* enum */ MapChoice NMF2_CLIMATE;
    public static final /* enum */ MapChoice NMF2_MEDIAN_30DAY;
    public static final /* enum */ MapChoice NMF2_WEATHER;
    public static final /* enum */ MapChoice NMF2_DELTA;
    public static final /* enum */ MapChoice NMF2_DELTA_PERCENT;
    public static final /* enum */ MapChoice HMF2_CLIMATE;
    public static final /* enum */ MapChoice HMF2_MEDIAN_30DAY;
    public static final /* enum */ MapChoice HMF2_WEATHER;
    public static final /* enum */ MapChoice HMF2_DELTA;
    public static final /* enum */ MapChoice HMF2_DELTA_PERCENT;
    public static final /* enum */ MapChoice MUF3000_CLIMATE;
    public static final /* enum */ MapChoice MUF3000_MEDIAN_30DAY;
    public static final /* enum */ MapChoice MUF3000_WEATHER;
    public static final /* enum */ MapChoice MUF3000_DELTA;
    public static final /* enum */ MapChoice MUF3000_DELTA_PERCENT;
    public static final /* enum */ MapChoice B0_CLIMATE;
    public static final /* enum */ MapChoice B0_MEDIAN_30DAY;
    public static final /* enum */ MapChoice B0_WEATHER;
    public static final /* enum */ MapChoice B0_DELTA;
    public static final /* enum */ MapChoice B0_DELTA_PERCENT;
    public static final /* enum */ MapChoice B1_CLIMATE;
    public static final /* enum */ MapChoice B1_MEDIAN_30DAY;
    public static final /* enum */ MapChoice B1_WEATHER;
    public static final /* enum */ MapChoice B1_DELTA;
    public static final /* enum */ MapChoice B1_DELTA_PERCENT;
    public static final /* enum */ MapChoice VTEC_CLIMATE;
    public static final /* enum */ MapChoice VTEC_MEDIAN_30DAY;
    public static final /* enum */ MapChoice VTEC_WEATHER;
    public static final /* enum */ MapChoice VTEC_DELTA;
    public static final /* enum */ MapChoice VTEC_DELTA_PERCENT;
    public static final /* enum */ MapChoice TAU_CLIMATE;
    public static final /* enum */ MapChoice TAU_MEDIAN_30DAY;
    public static final /* enum */ MapChoice TAU_WEATHER;
    public static final /* enum */ MapChoice TAU_DELTA;
    public static final /* enum */ MapChoice TAU_DELTA_PERCENT;
    public static final /* enum */ MapChoice CUSTOM_CLIMATE;
    public static final /* enum */ MapChoice CUSTOM_MEDIAN_30DAY;
    public static final /* enum */ MapChoice CUSTOM_WEATHER;
    public static final /* enum */ MapChoice CUSTOM_DELTA;
    public static final /* enum */ MapChoice CUSTOM_DELTA_PERCENT;
    public static final /* enum */ MapChoice GK;
    public static final /* enum */ MapChoice FOF2_INTERPOL_DC;
    public static final /* enum */ MapChoice FOF2_FITTED_DC;
    public static final /* enum */ MapChoice FOF2_GKFITERROR_DC;
    public static final /* enum */ MapChoice NMF2_INTERPOL_DC;
    public static final /* enum */ MapChoice NMF2_FITTED_DC;
    public static final /* enum */ MapChoice NMF2_GKFITERROR_DC;
    public static final /* enum */ MapChoice HMF2_INTERPOL_DC;
    public static final /* enum */ MapChoice HMF2_FITTED_DC;
    public static final /* enum */ MapChoice HMF2_GKFITERROR_DC;
    public static final /* enum */ MapChoice MUF3000_INTERPOL_DC;
    public static final /* enum */ MapChoice MUF3000_FITTED_DC;
    public static final /* enum */ MapChoice MUF3000_GKFITERROR_DC;
    public static final /* enum */ MapChoice B0_INTERPOL_DC;
    public static final /* enum */ MapChoice B0_FITTED_DC;
    public static final /* enum */ MapChoice B0_GKFITERROR_DC;
    public static final /* enum */ MapChoice B1_INTERPOL_DC;
    public static final /* enum */ MapChoice B1_FITTED_DC;
    public static final /* enum */ MapChoice B1_GKFITERROR_DC;
    public static final /* enum */ MapChoice VTEC_INTERPOL_DC;
    public static final /* enum */ MapChoice VTEC_FITTED_DC;
    public static final /* enum */ MapChoice VTEC_GKFITERROR_DC;
    public static final /* enum */ MapChoice TAU_INTERPOL_DC;
    public static final /* enum */ MapChoice TAU_FITTED_DC;
    public static final /* enum */ MapChoice TAU_GKFITERROR_DC;
    public static final /* enum */ MapChoice CUSTOM_INTERPOL_DC;
    public static final /* enum */ MapChoice CUSTOM_FITTED_DC;
    public static final /* enum */ MapChoice CUSTOM_GKFITERROR_DC;
    public static final /* enum */ MapChoice EVTEC_GPS;
    public static final /* enum */ MapChoice EVTEC_GPS_DELTA;
    public static final /* enum */ MapChoice EVTEC_GPS_DELTA_PERCENT;
    public static final /* enum */ MapChoice ESLAB_THICKNESS;
    public static final /* enum */ MapChoice ESLAB_THICKNESS_DELTA;
    public static final /* enum */ MapChoice ESLAB_THICKNESS_DELTA_PERCENT;
    private final String shortName;
    private final String description;
    private final MapTypeChoice type;
    private final boolean configurable;
    private int parameter;
    private int charIdent;
    private static final /* synthetic */ MapChoice[] ENUM$VALUES;

    static {
        MapChoice choice;
        FOF2_CLIMATE = new MapChoice("foF2: URSI-88 climate", "Classic foF2 climate by IRI URSI-88", MapTypeChoice.CLIMATE, false, 0, CharChoice.FOF2.getDidbaseIdent());
        FOF2_MEDIAN_30DAY = new MapChoice("foF2: 30-day median", "30-day foF2 median computation", MapTypeChoice.MEDIAN_30DAY, false, 0, CharChoice.FOF2.getDidbaseIdent());
        FOF2_WEATHER = new MapChoice("foF2: IRTAM outcome", "IRTAM Global Weather map of foF2", MapTypeChoice.WEATHER, false, 0, CharChoice.FOF2.getDidbaseIdent());
        FOF2_DELTA = new MapChoice("foF2: IRTAM versus IRI URSI-88", "Deviation of IRTAM from IRI foF2", MapTypeChoice.DELTA, false, 0, CharChoice.FOF2.getDidbaseIdent());
        FOF2_DELTA_PERCENT = new MapChoice("foF2: IRTAM versus URSI-88", "Percent deviation of IRTAM from IRI foF2", MapTypeChoice.DELTA_PERCENT, false, 0, CharChoice.FOF2.getDidbaseIdent());
        NMF2_CLIMATE = new MapChoice("NmF2: URSI-88 climate", "Classic NmF2 climate by IRI URSI-88", MapTypeChoice.CLIMATE, false, 0, CharChoice.NMF2.getDidbaseIdent());
        NMF2_MEDIAN_30DAY = new MapChoice("NmF2: 30-day median", "30-day NmF2 median computation", MapTypeChoice.MEDIAN_30DAY, false, 0, CharChoice.NMF2.getDidbaseIdent());
        NMF2_WEATHER = new MapChoice("NmF2: IRTAM outcome", "IRTAM Global Weather map of NmF2", MapTypeChoice.WEATHER, false, 0, CharChoice.NMF2.getDidbaseIdent());
        NMF2_DELTA = new MapChoice("NmF2: IRTAM versus IRI URSI-88", "Deviation of IRTAM from IRI NmF2", MapTypeChoice.DELTA, false, 0, CharChoice.NMF2.getDidbaseIdent());
        NMF2_DELTA_PERCENT = new MapChoice("NmF2: IRTAM versus URSI-88", "Percent deviation of IRTAM from IRI NmF2", MapTypeChoice.DELTA_PERCENT, false, 0, CharChoice.NMF2.getDidbaseIdent());
        HMF2_CLIMATE = new MapChoice("hmF2: climate", "hmF2 climate based on [Brunini et al., 2013] coefficients", MapTypeChoice.CLIMATE, false, 0, CharChoice.HMF2.getDidbaseIdent());
        HMF2_MEDIAN_30DAY = new MapChoice("hmF2: 30-day median", "hmF2 reference 30-day median", MapTypeChoice.MEDIAN_30DAY, false, 0, CharChoice.HMF2.getDidbaseIdent());
        HMF2_WEATHER = new MapChoice("hmF2: IRTAM outcome", "IRTAM Global Weather map of hmF2", MapTypeChoice.WEATHER, false, 0, CharChoice.HMF2.getDidbaseIdent());
        HMF2_DELTA = new MapChoice("hmF2: IRTAM versus Brunini", "Deviation of IRTAM from [Brunini et al., 2013] hmF2", MapTypeChoice.DELTA, false, 0, CharChoice.HMF2.getDidbaseIdent());
        HMF2_DELTA_PERCENT = new MapChoice("hmF2: IRTAM versus Brunini", "Percent deviation of IRTAM from [Brunini et al., 2013] hmF2", MapTypeChoice.DELTA_PERCENT, false, 0, CharChoice.HMF2.getDidbaseIdent());
        MUF3000_CLIMATE = new MapChoice("MUF3000: climate", "MUF3000 climate based on foF2 and hmF2", MapTypeChoice.CLIMATE, false, 0, CharChoice.MUF3000.getDidbaseIdent());
        MUF3000_MEDIAN_30DAY = new MapChoice("MUF3000: 30-day median", "MUF3000 reference 30-day median", MapTypeChoice.MEDIAN_30DAY, false, 0, CharChoice.MUF3000.getDidbaseIdent());
        MUF3000_WEATHER = new MapChoice("MUF3000: IRTAM outcome", "IRTAM Global Weather map of hmF2", MapTypeChoice.WEATHER, false, 0, CharChoice.MUF3000.getDidbaseIdent());
        MUF3000_DELTA = new MapChoice("MUF3000: IRTAM versus IRI", "Deviation of IRTAM from climate MUF3000", MapTypeChoice.DELTA, false, 0, CharChoice.MUF3000.getDidbaseIdent());
        MUF3000_DELTA_PERCENT = new MapChoice("MUF3000: IRTAM versus IRI", "Percent deviation of IRTAM from climate MUF3000", MapTypeChoice.DELTA_PERCENT, false, 0, CharChoice.MUF3000.getDidbaseIdent());
        B0_CLIMATE = new MapChoice("B0: climate", "B0 climate based on IRI-2016", MapTypeChoice.CLIMATE, false, 0, CharChoice.B0.getDidbaseIdent());
        B0_MEDIAN_30DAY = new MapChoice("B0: 30-day median", "B0 reference based on 30-day median", MapTypeChoice.MEDIAN_30DAY, false, 0, CharChoice.B0.getDidbaseIdent());
        B0_WEATHER = new MapChoice("B0: IRTAM outcome", "IRTAM Global Weather map of B0", MapTypeChoice.WEATHER, false, 0, CharChoice.B0.getDidbaseIdent());
        B0_DELTA = new MapChoice("B0: IRTAM versus IRI-2016", "Deviation of IRTAM from IRI-2016 B0", MapTypeChoice.DELTA, false, 0, CharChoice.B0.getDidbaseIdent());
        B0_DELTA_PERCENT = new MapChoice("B0: IRTAM versus IRI-2016", "Percent deviation of IRTAM from IRI-2016 B0", MapTypeChoice.DELTA_PERCENT, false, 0, CharChoice.B0.getDidbaseIdent());
        B1_CLIMATE = new MapChoice("B1: climate", "B1 climate based on IRI-2016", MapTypeChoice.CLIMATE, false, 0, CharChoice.B1.getDidbaseIdent());
        B1_MEDIAN_30DAY = new MapChoice("B1: 30-day median", "B1 reference 30-day median", MapTypeChoice.MEDIAN_30DAY, false, 0, CharChoice.B1.getDidbaseIdent());
        B1_WEATHER = new MapChoice("B1: IRTAM outcome", "IRTAM Global Weather map of B1", MapTypeChoice.WEATHER, false, 0, CharChoice.B1.getDidbaseIdent());
        B1_DELTA = new MapChoice("B1: IRTAM versus IRI-2016", "Deviation of IRTAM from IRI-2016 B1", MapTypeChoice.DELTA, false, 0, CharChoice.B1.getDidbaseIdent());
        B1_DELTA_PERCENT = new MapChoice("B1: IRTAM versus IRI-2016", "Percent deviation of IRTAM from IRI-2016 B1", MapTypeChoice.DELTA_PERCENT, false, 0, CharChoice.B1.getDidbaseIdent());
        VTEC_CLIMATE = new MapChoice("VTEC: 30-day average", "30-day average VTEC", MapTypeChoice.CLIMATE, false, 0, CharChoice.VTEC.getDidbaseIdent());
        VTEC_MEDIAN_30DAY = new MapChoice("VTEC: 30-day average", "30-day average VTEC", MapTypeChoice.MEDIAN_30DAY, false, 0, CharChoice.VTEC.getDidbaseIdent());
        VTEC_WEATHER = new MapChoice("VTEC: GNSS report", "VTEC by GNSS", MapTypeChoice.WEATHER, false, 0, CharChoice.VTEC.getDidbaseIdent());
        VTEC_DELTA = new MapChoice("VTEC: GNSS versus average", "Deviation of VTEC from average", MapTypeChoice.DELTA, false, 0, CharChoice.VTEC.getDidbaseIdent());
        VTEC_DELTA_PERCENT = new MapChoice("VTEC: GNSS versus average", "Percent deviation of VTEC from average", MapTypeChoice.DELTA_PERCENT, false, 0, CharChoice.VTEC.getDidbaseIdent());
        TAU_CLIMATE = new MapChoice("Slab thickness: 30-day average", "Slab thickness 30-day average", MapTypeChoice.CLIMATE, false, 0, CharChoice.TAU.getDidbaseIdent());
        TAU_MEDIAN_30DAY = new MapChoice("Slab thickness: 30-day average", "Slab thickness 30-day average", MapTypeChoice.MEDIAN_30DAY, false, 0, CharChoice.TAU.getDidbaseIdent());
        TAU_WEATHER = new MapChoice("Slab thickness: GNSS report", "Slab thickness weather report", MapTypeChoice.WEATHER, false, 0, CharChoice.TAU.getDidbaseIdent());
        TAU_DELTA = new MapChoice("Slab thickness: GNSS versus average", "Deviation of slab thickness from average", MapTypeChoice.DELTA, false, 0, CharChoice.TAU.getDidbaseIdent());
        TAU_DELTA_PERCENT = new MapChoice("Slab thickness: GNSS versus average", "Percent deviation of slab thickness from average", MapTypeChoice.DELTA_PERCENT, false, 0, CharChoice.TAU.getDidbaseIdent());
        CUSTOM_CLIMATE = new MapChoice("Custom: climate", "Custom climate", MapTypeChoice.CLIMATE, false, 0, CharChoice.getByName("Custom").getDidbaseIdent());
        CUSTOM_MEDIAN_30DAY = new MapChoice("Custom: 30-day median", "Custom 30-day median", MapTypeChoice.MEDIAN_30DAY, false, 0, CharChoice.getByName("Custom").getDidbaseIdent());
        CUSTOM_WEATHER = new MapChoice("Custom expansion synthesizer", "Global map of custom input", MapTypeChoice.WEATHER, false, 0, CharChoice.getByName("Custom").getDidbaseIdent());
        CUSTOM_DELTA = new MapChoice("Custom: IRTAM versus IRI-2016", "Deviation of IRTAM from IRI-2016", MapTypeChoice.DELTA, false, 0, CharChoice.getByName("Custom").getDidbaseIdent());
        CUSTOM_DELTA_PERCENT = new MapChoice("Custom: IRTAM versus IRI-2016", "Percent deviation of IRTAM from IRI-2016", MapTypeChoice.DELTA_PERCENT, false, 0, CharChoice.getByName("Custom").getDidbaseIdent());
        GK = new MapChoice("foF2: Geofunction Gk", "Jones-Gallet geographic function Gk, k=1..76", MapTypeChoice.GK, true, 12, CharChoice.FOF2.getDidbaseIdent());
        FOF2_INTERPOL_DC = new MapChoice("foF2: Interpolated delta-C", "Map of delta-C coefficient of diurnal expansion, interpolated", MapTypeChoice.INTERPOL_DC, true, 0, CharChoice.FOF2.getDidbaseIdent());
        FOF2_FITTED_DC = new MapChoice("foF2: Fitted delta-C", "Map of delta-C coefficient of diurnal expansion, Gk-based spatial fit", MapTypeChoice.FITTED_DC, true, 0, CharChoice.FOF2.getDidbaseIdent());
        FOF2_GKFITERROR_DC = new MapChoice("foF2: Fit error delta-C", "Map of errors of fitting delta-C with Gk spatial coefficients", MapTypeChoice.GKFITERROR_DC, true, 0, CharChoice.FOF2.getDidbaseIdent());
        NMF2_INTERPOL_DC = new MapChoice("NmF2: Interpolated delta-C", "Map of delta-C coefficient of diurnal expansion, interpolated", MapTypeChoice.INTERPOL_DC, true, 0, CharChoice.NMF2.getDidbaseIdent());
        NMF2_FITTED_DC = new MapChoice("NmF2: Fitted delta-C", "Map of delta-C coefficient of diurnal expansion, Gk-based spatial fit", MapTypeChoice.FITTED_DC, true, 0, CharChoice.NMF2.getDidbaseIdent());
        NMF2_GKFITERROR_DC = new MapChoice("NmF2: Fit error delta-C", "Map of errors of fitting delta-C with Gk spatial coefficients", MapTypeChoice.GKFITERROR_DC, true, 0, CharChoice.NMF2.getDidbaseIdent());
        HMF2_INTERPOL_DC = new MapChoice("hmF2: Interpolated delta-C", "Map of delta-C coefficient of diurnal expansion, interpolated", MapTypeChoice.INTERPOL_DC, true, 0, CharChoice.HMF2.getDidbaseIdent());
        HMF2_FITTED_DC = new MapChoice("hmF2: Fitted delta-C", "Map of delta-C coefficient of diurnal expansion, Gk-based spatial fit", MapTypeChoice.FITTED_DC, true, 0, CharChoice.HMF2.getDidbaseIdent());
        HMF2_GKFITERROR_DC = new MapChoice("hmF2: Fit error delta-C", "Map of errors of fitting delta-C with Gk spatial coefficients", MapTypeChoice.GKFITERROR_DC, true, 0, CharChoice.HMF2.getDidbaseIdent());
        MUF3000_INTERPOL_DC = new MapChoice("MUF3000: Interpolated delta-C", "Map of delta-C coefficient of diurnal expansion, interpolated", MapTypeChoice.INTERPOL_DC, true, 0, CharChoice.MUF3000.getDidbaseIdent());
        MUF3000_FITTED_DC = new MapChoice("MUF3000: Fitted delta-C", "Map of delta-C coefficient of diurnal expansion, Gk-based spatial fit", MapTypeChoice.FITTED_DC, true, 0, CharChoice.MUF3000.getDidbaseIdent());
        MUF3000_GKFITERROR_DC = new MapChoice("MUF3000: Fit error delta-C", "Map of errors of fitting delta-C with Gk spatial coefficients", MapTypeChoice.GKFITERROR_DC, true, 0, CharChoice.MUF3000.getDidbaseIdent());
        B0_INTERPOL_DC = new MapChoice("B0: Interpolated delta-C", "Map of delta-C coefficient of diurnal expansion, interpolated", MapTypeChoice.INTERPOL_DC, true, 0, CharChoice.B0.getDidbaseIdent());
        B0_FITTED_DC = new MapChoice("B0: Fitted delta-C", "Map of delta-C coefficient of diurnal expansion, Gk-based spatial fit", MapTypeChoice.FITTED_DC, true, 0, CharChoice.B0.getDidbaseIdent());
        B0_GKFITERROR_DC = new MapChoice("B0: Fit error delta-C", "Map of errors of fitting delta-C with Gk spatial coefficients", MapTypeChoice.GKFITERROR_DC, true, 0, CharChoice.B0.getDidbaseIdent());
        B1_INTERPOL_DC = new MapChoice("B1: Interpolated delta-C", "Map of delta-C coefficient of diurnal expansion, interpolated", MapTypeChoice.INTERPOL_DC, true, 0, CharChoice.B1.getDidbaseIdent());
        B1_FITTED_DC = new MapChoice("B1: Fitted delta-C", "Map of delta-C coefficient of diurnal expansion, Gk-based spatial fit", MapTypeChoice.FITTED_DC, true, 0, CharChoice.B1.getDidbaseIdent());
        B1_GKFITERROR_DC = new MapChoice("B1: Fit error delta-C", "Map of errors of fitting delta-C with Gk spatial coefficients", MapTypeChoice.GKFITERROR_DC, true, 0, CharChoice.B1.getDidbaseIdent());
        VTEC_INTERPOL_DC = new MapChoice("VTEC: Interpolated delta-C", "Map of delta-C coefficient of diurnal expansion, interpolated", MapTypeChoice.INTERPOL_DC, true, 0, CharChoice.VTEC.getDidbaseIdent());
        VTEC_FITTED_DC = new MapChoice("VTEC: Fitted delta-C", "Map of delta-C coefficient of diurnal expansion, Gk-based spatial fit", MapTypeChoice.FITTED_DC, true, 0, CharChoice.VTEC.getDidbaseIdent());
        VTEC_GKFITERROR_DC = new MapChoice("VTEC: Fit error delta-C", "Map of errors of fitting delta-C with Gk spatial coefficients", MapTypeChoice.GKFITERROR_DC, true, 0, CharChoice.VTEC.getDidbaseIdent());
        TAU_INTERPOL_DC = new MapChoice("Tau: Interpolated delta-C", "Map of delta-C coefficient of diurnal expansion, interpolated", MapTypeChoice.INTERPOL_DC, true, 0, CharChoice.TAU.getDidbaseIdent());
        TAU_FITTED_DC = new MapChoice("Tau: Fitted delta-C", "Map of delta-C coefficient of diurnal expansion, Gk-based spatial fit", MapTypeChoice.FITTED_DC, true, 0, CharChoice.TAU.getDidbaseIdent());
        TAU_GKFITERROR_DC = new MapChoice("Tau: Fit error delta-C", "Map of errors of fitting delta-C with Gk spatial coefficients", MapTypeChoice.GKFITERROR_DC, true, 0, CharChoice.TAU.getDidbaseIdent());
        CUSTOM_INTERPOL_DC = new MapChoice("Custom input: Interpolated delta-C", "Map of delta-C coefficient of diurnal expansion, interpolated", MapTypeChoice.INTERPOL_DC, true, 0, CharChoice.getByName("Custom").getDidbaseIdent());
        CUSTOM_FITTED_DC = new MapChoice("Custom input: Fitted delta-C", "Map of delta-C coefficient of diurnal expansion, Gk-based spatial fit", MapTypeChoice.FITTED_DC, true, 0, CharChoice.getByName("Custom").getDidbaseIdent());
        CUSTOM_GKFITERROR_DC = new MapChoice("Custom input: Fit error delta-C", "Map of errors of fitting delta-C with Gk spatial coefficients", MapTypeChoice.GKFITERROR_DC, true, 0, CharChoice.getByName("Custom").getDidbaseIdent());
        EVTEC_GPS = new MapChoice("VTEC: GPS measurements external", "Map of vertical TEC measured by GPS. GPS TEC data are retrieved\nfrom the Madrigal database for the time specified above.", MapTypeChoice.WEATHER, false, 0, CharChoice.VTEC.getDidbaseIdent());
        EVTEC_GPS_DELTA = new MapChoice("TEC: GPS measurements delta", "Map of vertical TEC measured by GPS minus background TEC.\nTime of background TEC data should be specified below. \nTime of foreground TEC data is still specified above. \nGPS TEC data retrieved from the Madrigal database.", MapTypeChoice.DELTA, false, 0, CharChoice.VTEC.getDidbaseIdent());
        EVTEC_GPS_DELTA_PERCENT = new MapChoice("TEC: GPS delta, %", "Map of Delta-VTEC versus reference TEC, %\nTime of reference TEC data should be specified below. \nTime of foreground TEC data is still specified above. \nGPS TEC data retrieved from the Madrigal database.", MapTypeChoice.DELTA_PERCENT, false, 0, CharChoice.VTEC.getDidbaseIdent());
        ESLAB_THICKNESS = new MapChoice("tau: TEC / NmF2 ext", "Map of slab thickness computed as ratio of TEC from GNSS and NmF2 from GIRO.\n", MapTypeChoice.WEATHER, false, 0, CharChoice.TAU.getDidbaseIdent());
        ESLAB_THICKNESS_DELTA = new MapChoice("tau: slab thickness delta ext", "Map of deviation of slab thickness from baseline.\n", MapTypeChoice.DELTA, false, 0, CharChoice.TAU.getDidbaseIdent());
        ESLAB_THICKNESS_DELTA_PERCENT = new MapChoice("tau: slab thickness delta, %", "Map of Delta-slab-thickness versus reference, %\n", MapTypeChoice.DELTA_PERCENT, false, 0, CharChoice.TAU.getDidbaseIdent());
        ENUM$VALUES = new MapChoice[]{FOF2_CLIMATE, FOF2_MEDIAN_30DAY, FOF2_WEATHER, FOF2_DELTA, FOF2_DELTA_PERCENT, NMF2_CLIMATE, NMF2_MEDIAN_30DAY, NMF2_WEATHER, NMF2_DELTA, NMF2_DELTA_PERCENT, HMF2_CLIMATE, HMF2_MEDIAN_30DAY, HMF2_WEATHER, HMF2_DELTA, HMF2_DELTA_PERCENT, MUF3000_CLIMATE, MUF3000_MEDIAN_30DAY, MUF3000_WEATHER, MUF3000_DELTA, MUF3000_DELTA_PERCENT, B0_CLIMATE, B0_MEDIAN_30DAY, B0_WEATHER, B0_DELTA, B0_DELTA_PERCENT, B1_CLIMATE, B1_MEDIAN_30DAY, B1_WEATHER, B1_DELTA, B1_DELTA_PERCENT, VTEC_CLIMATE, VTEC_MEDIAN_30DAY, VTEC_WEATHER, VTEC_DELTA, VTEC_DELTA_PERCENT, TAU_CLIMATE, TAU_MEDIAN_30DAY, TAU_WEATHER, TAU_DELTA, TAU_DELTA_PERCENT, CUSTOM_CLIMATE, CUSTOM_MEDIAN_30DAY, CUSTOM_WEATHER, CUSTOM_DELTA, CUSTOM_DELTA_PERCENT, GK, FOF2_INTERPOL_DC, FOF2_FITTED_DC, FOF2_GKFITERROR_DC, NMF2_INTERPOL_DC, NMF2_FITTED_DC, NMF2_GKFITERROR_DC, HMF2_INTERPOL_DC, HMF2_FITTED_DC, HMF2_GKFITERROR_DC, MUF3000_INTERPOL_DC, MUF3000_FITTED_DC, MUF3000_GKFITERROR_DC, B0_INTERPOL_DC, B0_FITTED_DC, B0_GKFITERROR_DC, B1_INTERPOL_DC, B1_FITTED_DC, B1_GKFITERROR_DC, VTEC_INTERPOL_DC, VTEC_FITTED_DC, VTEC_GKFITERROR_DC, TAU_INTERPOL_DC, TAU_FITTED_DC, TAU_GKFITERROR_DC, CUSTOM_INTERPOL_DC, CUSTOM_FITTED_DC, CUSTOM_GKFITERROR_DC, EVTEC_GPS, EVTEC_GPS_DELTA, EVTEC_GPS_DELTA_PERCENT, ESLAB_THICKNESS, ESLAB_THICKNESS_DELTA, ESLAB_THICKNESS_DELTA_PERCENT};
        boolean[] isMapTypeDefined = new boolean[MapChoice.values().length];
        int iChoice = 0;
        MapChoice[] mapChoiceArray = MapChoice.values();
        int n = mapChoiceArray.length;
        int n2 = 0;
        while (n2 < n) {
            choice = mapChoiceArray[n2];
            isMapTypeDefined[iChoice] = false;
            isMapTypeDefined[iChoice] = MapChoice.isDeltaMap(choice) || MapChoice.isPercentDeltaMap(choice) || MapChoice.isCharMap(choice) || MapChoice.isDebugMap(choice);
            ++iChoice;
            ++n2;
        }
        iChoice = 0;
        mapChoiceArray = MapChoice.values();
        n = mapChoiceArray.length;
        n2 = 0;
        while (n2 < n) {
            choice = mapChoiceArray[n2];
            if (!isMapTypeDefined[iChoice]) {
                throw new RuntimeException("Type is not defined for " + choice.toString() + " in MapChoice.");
            }
            ++iChoice;
            ++n2;
        }
        CharChoice[] charChoiceArray = CharChoice.values();
        int n3 = charChoiceArray.length;
        int n4 = 0;
        while (n4 < n3) {
            CharChoice cc = charChoiceArray[n4];
            MapTypeChoice[] mapTypeChoiceArray = MapTypeChoice.values();
            int n5 = mapTypeChoiceArray.length;
            int n6 = 0;
            while (n6 < n5) {
                MapTypeChoice stc = mapTypeChoiceArray[n6];
                if (MapChoice.getSurfaceChoice(cc, stc) == null) {
                    throw new RuntimeException("Define MapChoice for CharChoice " + cc.name() + " and MapTypeChoice " + stc.name());
                }
                ++n6;
            }
            ++n4;
        }
    }

    private MapChoice(String shortName, String description, MapTypeChoice type, boolean configurable, int parameter, int charIdent) {
        this.shortName = shortName;
        this.description = description;
        this.type = type;
        this.configurable = configurable;
        this.parameter = parameter;
        this.charIdent = charIdent;
    }

    public static MapChoice getSurfaceChoice(CharChoice cc, MapTypeChoice stc) {
        try {
            String fullName = String.valueOf(stc == MapTypeChoice.GK ? "" : String.valueOf(cc.name()) + "_") + stc.name();
            return MapChoice.valueOf(fullName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String shortName() {
        return this.shortName;
    }

    public String getDescription() {
        return this.description;
    }

    public MapTypeChoice getType() {
        return this.type;
    }

    public String getToolTip() {
        return "<html>" + this.description.replace("\n", "<br>") + "<html>";
    }

    public boolean configurable() {
        return this.configurable;
    }

    public int parameter() {
        return this.parameter;
    }

    public CharChoice getCC() {
        return CharChoice.getByIdent(this.charIdent);
    }

    public void setParameter(int p) {
        this.parameter = p;
    }

    private static boolean isClimateMap(MapChoice choice) {
        return choice == FOF2_CLIMATE || choice == FOF2_MEDIAN_30DAY || choice == NMF2_CLIMATE || choice == NMF2_MEDIAN_30DAY || choice == HMF2_CLIMATE || choice == HMF2_MEDIAN_30DAY || choice == B0_CLIMATE || choice == B0_MEDIAN_30DAY || choice == MUF3000_CLIMATE || choice == MUF3000_MEDIAN_30DAY || choice == B1_CLIMATE || choice == B1_MEDIAN_30DAY || choice == VTEC_CLIMATE || choice == VTEC_MEDIAN_30DAY || choice == TAU_CLIMATE || choice == TAU_MEDIAN_30DAY || choice == CUSTOM_CLIMATE || choice == CUSTOM_MEDIAN_30DAY;
    }

    public boolean isClimateMap() {
        return MapChoice.isClimateMap(this);
    }

    private static boolean isWeatherMap(MapChoice choice) {
        return choice == FOF2_WEATHER || choice == NMF2_WEATHER || choice == HMF2_WEATHER || choice == B0_WEATHER || choice == MUF3000_WEATHER || choice == B1_WEATHER || choice == VTEC_WEATHER || choice == TAU_WEATHER || choice == CUSTOM_WEATHER;
    }

    public boolean isWeatherMap() {
        return MapChoice.isWeatherMap(this);
    }

    private static boolean isDeltaMap(MapChoice choice) {
        return choice == FOF2_DELTA || choice == FOF2_DELTA_PERCENT || choice == NMF2_DELTA || choice == NMF2_DELTA_PERCENT || choice == HMF2_DELTA || choice == HMF2_DELTA_PERCENT || choice == MUF3000_DELTA || choice == MUF3000_DELTA_PERCENT || choice == B0_DELTA || choice == B0_DELTA_PERCENT || choice == B1_DELTA || choice == B1_DELTA_PERCENT || choice == VTEC_DELTA || choice == VTEC_DELTA_PERCENT || choice == TAU_DELTA || choice == TAU_DELTA_PERCENT || choice == CUSTOM_DELTA || choice == EVTEC_GPS_DELTA || choice == ESLAB_THICKNESS_DELTA || choice == EVTEC_GPS_DELTA_PERCENT || choice == ESLAB_THICKNESS_DELTA_PERCENT;
    }

    public boolean isDeltaMap() {
        return MapChoice.isDeltaMap(this);
    }

    private static boolean isPercentDeltaMap(MapChoice choice) {
        return choice == FOF2_DELTA_PERCENT || choice == NMF2_DELTA_PERCENT || choice == MUF3000_DELTA_PERCENT || choice == HMF2_DELTA_PERCENT || choice == B0_DELTA_PERCENT || choice == B1_DELTA_PERCENT || choice == VTEC_DELTA_PERCENT || choice == TAU_DELTA_PERCENT || choice == CUSTOM_DELTA_PERCENT || choice == EVTEC_GPS_DELTA_PERCENT || choice == ESLAB_THICKNESS_DELTA_PERCENT;
    }

    public boolean isPercentDeltaMap() {
        return MapChoice.isPercentDeltaMap(this);
    }

    private static boolean isCharMap(MapChoice choice) {
        return MapChoice.isClimateMap(choice) || MapChoice.isWeatherMap(choice) || choice == EVTEC_GPS || choice == ESLAB_THICKNESS;
    }

    public boolean isCharMap() {
        return MapChoice.isCharMap(this);
    }

    private static boolean isTecMap(MapChoice choice) {
        return choice == EVTEC_GPS_DELTA || choice == EVTEC_GPS;
    }

    public boolean isTecMap() {
        return MapChoice.isTecMap(this);
    }

    private static boolean isDebugMap(MapChoice choice) {
        return choice == GK || MapChoice.isFitError(choice) || MapChoice.isFittedStep(choice) || MapChoice.isInterpolationStep(choice);
    }

    private static boolean isFittedStep(MapChoice choice) {
        return choice == FOF2_FITTED_DC || choice == NMF2_FITTED_DC || choice == HMF2_FITTED_DC || choice == MUF3000_FITTED_DC || choice == B0_FITTED_DC || choice == B1_FITTED_DC || choice == VTEC_FITTED_DC || choice == TAU_FITTED_DC || choice == CUSTOM_FITTED_DC;
    }

    public boolean isFittedStep() {
        return MapChoice.isFittedStep(this);
    }

    private static boolean isFitError(MapChoice choice) {
        return choice == FOF2_GKFITERROR_DC || choice == NMF2_GKFITERROR_DC || choice == HMF2_GKFITERROR_DC || choice == MUF3000_GKFITERROR_DC || choice == B0_GKFITERROR_DC || choice == B1_GKFITERROR_DC || choice == VTEC_GKFITERROR_DC || choice == TAU_GKFITERROR_DC || choice == CUSTOM_GKFITERROR_DC;
    }

    public boolean isFitError() {
        return MapChoice.isFitError(this);
    }

    public static boolean isInterpolationStep(MapChoice choice) {
        return choice == FOF2_INTERPOL_DC || choice == NMF2_INTERPOL_DC || choice == HMF2_INTERPOL_DC || choice == MUF3000_INTERPOL_DC || choice == B0_INTERPOL_DC || choice == B1_INTERPOL_DC || choice == VTEC_INTERPOL_DC || choice == TAU_INTERPOL_DC || choice == CUSTOM_INTERPOL_DC;
    }

    public boolean isInterpolationStep() {
        return MapChoice.isInterpolationStep(this);
    }

    public boolean isExternalMap() {
        return MapChoice.isExternalMap(this);
    }

    private static boolean isExternalMap(MapChoice choice) {
        return choice == EVTEC_GPS_DELTA || choice == EVTEC_GPS || choice == ESLAB_THICKNESS || choice == ESLAB_THICKNESS_DELTA || choice == EVTEC_GPS_DELTA_PERCENT || choice == ESLAB_THICKNESS_DELTA_PERCENT;
    }

    public boolean isUserMap() {
        return MapChoice.isUserMap(this);
    }

    private static boolean isUserMap(MapChoice choice) {
        return choice != FOF2_INTERPOL_DC && choice != FOF2_FITTED_DC && choice != FOF2_GKFITERROR_DC && choice != NMF2_INTERPOL_DC && choice != NMF2_FITTED_DC && choice != NMF2_GKFITERROR_DC && choice != HMF2_INTERPOL_DC && choice != HMF2_FITTED_DC && choice != HMF2_GKFITERROR_DC && choice != B0_INTERPOL_DC && choice != B0_FITTED_DC && choice != B0_GKFITERROR_DC && choice != B1_INTERPOL_DC && choice != B1_FITTED_DC && choice != B1_GKFITERROR_DC && choice != CUSTOM_INTERPOL_DC;
    }

    public boolean isDebugMap() {
        return MapChoice.isDebugMap(this);
    }

    public static int length() {
        return MapChoice.values().length;
    }

    public static MapChoice get(int ordinal) {
        if (MapChoice.check(ordinal)) {
            return MapChoice.values()[ordinal];
        }
        throw new IllegalArgumentException("Illegal SurfaceChoice ordinal, " + ordinal);
    }

    public static String[] shortNames(boolean initialCaps) {
        MapChoice[] values = MapChoice.values();
        String[] shortNames = new String[values.length];
        int i = 0;
        while (i < values.length) {
            shortNames[i] = values[i].shortName;
            ++i;
        }
        return shortNames;
    }

    public static boolean check(int value) {
        return value >= 0 && value < MapChoice.values().length;
    }

    public static MapChoice[] values() {
        MapChoice[] mapChoiceArray = ENUM$VALUES;
        int n = mapChoiceArray.length;
        MapChoice[] mapChoiceArray2 = new MapChoice[n];
        System.arraycopy(ENUM$VALUES, 0, mapChoiceArray2, 0, n);
        return mapChoiceArray2;
    }

    public static MapChoice valueOf(String string) {
        return Enum.valueOf(MapChoice.class, string);
    }
}

