/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.geospace;

public enum MapTypeChoice {
    CLIMATE("Climate", "Classic climatology model", false),
    WEATHER("IRTAM Weather", "IRI-based Real-time assimilative map (IRTAM) weather", false),
    DELTA("IRTAM versus Climate", "Difference between IRTAM and Climate model", false),
    DELTA_PERCENT("IRTAM versus Climate", "Percent difference between IRTAM and Climate model", false),
    GK("Geofunctions Gk", "Jones-Gallet geographic function Gk, k=1..76", false),
    INTERPOL_DC("Map of interpolated delta-C", "Delta-C coefficient of diurnal expansion, interpolated map", true),
    FITTED_DC("Map of expanded delta-C", "Map of delta-C coefficient of diurnal expansion, Gk-based spatial expansion", true),
    GKFITERROR_DC("Residue of delta-C fit", "Map of residual errors of fitting delta-C using Gk spatial coefficients", true),
    MEDIAN_30DAY("30-day Median", "30-day median reference", false);

    private final String shortName;
    private final String description;
    private final String description_tooltip;
    private final boolean access;

    private MapTypeChoice(String name, String description, boolean access) {
        this.shortName = name;
        this.description = description;
        this.description_tooltip = "<html>" + description.replaceAll("\n", "<br>") + "</html>";
        this.access = access;
    }

    public boolean isAccess() {
        return this.access;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDescription_tooltip() {
        return this.description_tooltip;
    }
}

