/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.geospace;

import edu.uml.lgdc.fileio.FileUtils;
import edu.uml.lgdc.geospace.GeoMagIndexChoice;
import edu.uml.lgdc.geospace.Getter;
import edu.uml.lgdc.project.CommandLineParam;
import edu.uml.lgdc.time.TimeScale;
import java.io.File;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;

public class NOAAIndexesGetter {
    public static final String[] KEYS = new String[]{"dst_path", "kpap_path", "update_once"};
    public static final CommandLineParam.KeyType[] KEY_TYPES = new CommandLineParam.KeyType[]{CommandLineParam.KeyType.VALUE_ONLY, CommandLineParam.KeyType.VALUE_ONLY, CommandLineParam.KeyType.KEY_ONLY};
    public static final String URL_ROOT_KP_AP = "ftp://ftp.ngdc.noaa.gov/STP/GEOMAGNETIC_DATA/INDICES/KP_AP/";
    public static final String URL_ROOT_DST = "ftp://ftp.ngdc.noaa.gov/STP/GEOMAGNETIC_DATA/INDICES/DST/";
    public static final String URL_AER_30DAYS_DST = "http://www.aer.com/sites/default/files/Dst_30day.txt";
    public static final int NUMBER_UPDATES_PER_DAY = 4;
    private String rootPath_dst = null;
    private String rootPath_kpap = null;
    private boolean update_once = false;
    private int updates_per_day = 4;
    private Getter kp_apGetter = new Getter(){

        @Override
        protected boolean getFile(File file, int year) {
            return FileUtils.copyURLToFile(NOAAIndexesGetter.URL_ROOT_KP_AP + file.getName(), file);
        }

        @Override
        protected GeoMagIndexChoice getIndexID() {
            return GeoMagIndexChoice.KP_AP;
        }
    };
    private Getter dstGetter = new Getter(){

        @Override
        protected boolean getFile(File file, int year) {
            return FileUtils.copyURLToFile(NOAAIndexesGetter.URL_ROOT_DST + file.getName(), file);
        }

        @Override
        protected GeoMagIndexChoice getIndexID() {
            return GeoMagIndexChoice.DST;
        }
    };

    static {
        if (KEYS.length != KEY_TYPES.length) {
            throw new RuntimeException("KEYS.length != KEY_TYPES.length");
        }
    }

    public NOAAIndexesGetter(String rootPath_dst, String rootPath_kpap, boolean update_once, int updates_per_day) {
        this.rootPath_dst = new String(rootPath_dst);
        this.rootPath_kpap = new String(rootPath_kpap);
        this.update_once = update_once;
        this.updates_per_day = updates_per_day;
    }

    private void updateData() {
        if (!this.update_once) {
            Timer processingTimer = new Timer();
            processingTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (NOAAIndexesGetter.this.rootPath_dst != null) {
                        NOAAIndexesGetter.this.dstGetter.getRecentData(NOAAIndexesGetter.this.rootPath_dst);
                    }
                    if (NOAAIndexesGetter.this.rootPath_kpap != null) {
                        NOAAIndexesGetter.this.kp_apGetter.getRecentData(NOAAIndexesGetter.this.rootPath_kpap);
                    }
                }
            }, 0L, (long)(86400000 / this.updates_per_day));
        } else {
            NOAAIndexesGetter.updateAllFiles(this.rootPath_dst, this.rootPath_dst, URL_ROOT_DST);
            NOAAIndexesGetter.updateAllFiles(this.rootPath_kpap, this.rootPath_kpap, URL_ROOT_KP_AP);
        }
    }

    public static void updateAllFiles(String rootPath, String path, String url_root) {
        if (!path.startsWith(rootPath)) {
            System.out.println("Check root path and path. Path must be child of root path.");
            return;
        }
        String sub = path.equals(rootPath) ? "" : String.valueOf(path.substring(rootPath.length() + 1)) + "/";
        sub = sub.replace('\\', '/');
        File rootFolder = new File(rootPath);
        File currentFolder = new File(path);
        File temp = new File(String.valueOf(rootPath) + "temp");
        File[] files = currentFolder.listFiles();
        try {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    NOAAIndexesGetter.updateAllFiles(rootFolder.getAbsolutePath(), file.getAbsolutePath(), url_root);
                }
                if (FileUtils.copyURLToFile(String.valueOf(url_root) + sub + file.getName(), temp)) {
                    if (file.exists()) {
                        file.delete();
                    }
                    FileUtils.moveFile(temp, file);
                }
                ++n2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void downloadDST30Days(String folder) {
        String fileName = String.valueOf(folder) + "/AER30Days_" + new TimeScale().toFormatUT("yyyyMMdd_HHmmss");
        File file = new File(fileName);
        FileUtils.copyURLToFile(URL_AER_30DAYS_DST, file);
    }

    public static void main(String[] args) {
        String dst_path = null;
        String kpap_path = null;
        boolean update_once = false;
        int numUpdates = 0;
        CommandLineParam commandLineParam = new CommandLineParam(args);
        String errMsg = commandLineParam.checkParams(KEYS, KEY_TYPES, true);
        if (errMsg != null) {
            System.out.println(errMsg);
            System.exit(1);
        }
        if ((dst_path = Getter.parseDstPath(commandLineParam, "")).equals("")) {
            System.out.println("Specify dst root path. Program will exit.");
            System.exit(1);
        }
        if ((kpap_path = Getter.parseKpApPath(commandLineParam, "")).equals("")) {
            System.out.println("Specify kpap root path. Program will exit.");
            System.exit(1);
        }
        numUpdates = (numUpdates = Getter.parseUpdatesPerDay(commandLineParam)) == 0 ? 4 : numUpdates;
        update_once = commandLineParam.isKeyExists("update_once");
        NOAAIndexesGetter getter = new NOAAIndexesGetter(dst_path, kpap_path, update_once, numUpdates);
        getter.updateData();
    }
}

