/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.geospace;

import edu.uml.lgdc.format.FC;
import edu.uml.lgdc.project.CommonConst;
import edu.uml.lgdc.time.TimeScale;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class SunSpots {
    public static final String SUNSPOT = "Sunspt.asc";
    private static final String SUNSPOT_FILENAME;
    private static final int MAX_NUMBER_OF_YEARS = 300;
    private static final String SPACES = "                                                                                          ";
    private static String fileName;
    public static final int SUNSPOT_UNKNOWN = -1;
    private static boolean loaded;
    private static float[][] ssNumbers;
    private static int firstYear;
    private static int qtyOfYears;
    private static int[] startOfCycles;
    private static int qtyOfCycles;
    private static boolean extrapolated;
    private static int lastActualDataYear;
    private static int lastActualDataMonth;
    private static SunSpots sunspots;
    public static final int SSN_PREDICTED = 0;
    public static final int SSN_ACTUAL = 1;
    public static final int SSN_MISSING = 2;
    private int year;
    private int month;
    private float number;
    private int status;

    static {
        fileName = SUNSPOT_FILENAME = new File(CommonConst.getShareResourcesDir(), SUNSPOT).getPath();
        loaded = false;
        ssNumbers = null;
        firstYear = 0;
        qtyOfYears = 0;
        startOfCycles = null;
        qtyOfCycles = 0;
        extrapolated = false;
        lastActualDataYear = 0;
        lastActualDataMonth = 0;
    }

    private SunSpots(int year, int month, float number, int status) {
        if (status != 0 && status != 1 && status != 2) {
            throw new IllegalArgumentException("illegal status, " + status + ", should be " + 0 + ", " + 1 + ", or " + 2);
        }
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("illegal month number, " + month);
        }
        if (year < 1 || year > 3000) {
            throw new IllegalArgumentException("illegal year, " + year);
        }
        if (status != 2 && (double)number < 0.1 || number > 200.0f) {
            throw new IllegalArgumentException("illegal spot number, " + number);
        }
        if (status == 2 && number != -1.0f || number == -1.0f && status != 2) {
            throw new IllegalArgumentException("incompatible values for status and number, " + status + " and " + number);
        }
        this.year = year;
        this.month = month;
        this.number = number;
        this.status = status;
    }

    public float getNumber() {
        return this.number;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isAvailable() {
        return this.status != 2;
    }

    public boolean isPredicted() {
        return this.status == 0;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public static SunSpots get(TimeScale date) {
        return SunSpots.get(date.get(1), date.get(2) + 1);
    }

    public static synchronized SunSpots get(int year, int month) {
        if (!loaded) {
            SunSpots.load();
        }
        if (sunspots != null && year == SunSpots.sunspots.year && month == SunSpots.sunspots.month) {
            return sunspots;
        }
        sunspots = SunSpots.getIt(year, month);
        return sunspots;
    }

    private static synchronized void load() {
        boolean error;
        block26: {
            error = false;
            BufferedReader in = null;
            int cycle = 0;
            int year = 0;
            int month = 0;
            int prevYear = 0;
            boolean blankField = false;
            firstYear = 0;
            qtyOfYears = 0;
            qtyOfCycles = 0;
            try {
                try {
                    in = new BufferedReader(new FileReader(fileName));
                    SunSpots.initMemory();
                    loaded = true;
                    extrapolated = false;
                    while (in.ready()) {
                        String line = in.readLine();
                        if (line == null) break;
                        if (line.length() == 0 || !Character.isDigit(line.charAt(0))) continue;
                        if (line.length() < 83) {
                            line = String.valueOf(line) + SPACES.substring(0, 83 - line.length());
                        }
                        cycle = FC.StringToInteger(line.substring(79, 83));
                        year = FC.StringToInteger(line.substring(0, 4));
                        month = FC.StringToInteger(line.substring(5, 7));
                        if (qtyOfCycles == 0 && cycle > 0) {
                            qtyOfCycles = cycle - 1;
                        }
                        if (prevYear == 0 && year > 0) {
                            prevYear = year - 1;
                        }
                        if (prevYear != year - 1 || year < 1749) {
                            System.out.println("File " + fileName + " constructed wrong, data missing before year = " + year);
                            error = true;
                            break;
                        }
                        ++prevYear;
                        blankField = false;
                        int pos = 7;
                        int mo = 0;
                        while (mo < 12) {
                            if (line.substring(pos, pos + 6).equals("      ")) {
                                if (mo != 0) {
                                    ++qtyOfYears;
                                }
                                blankField = true;
                                break;
                            }
                            SunSpots.ssNumbers[SunSpots.qtyOfYears][mo] = (float)FC.StringToDouble(line.substring(pos, pos + 6));
                            pos += 6;
                            ++mo;
                        }
                        if (!blankField) {
                            ++qtyOfYears;
                            if (firstYear == 0) {
                                firstYear = year;
                            }
                            if (month == 0) continue;
                        }
                        if (blankField && month == 0) break;
                        if (++qtyOfCycles != cycle) {
                            System.out.println("File " + fileName + " constructed wrong. Cycles do not match before cycle " + cycle);
                            error = true;
                            break;
                        }
                        SunSpots.startOfCycles[SunSpots.qtyOfCycles - 1] = (year - firstYear) * 12 + month - 1;
                    }
                }
                catch (Exception ex) {
                    System.out.println("Can't calculate sunspot number due the following:");
                    System.out.println(ex.toString());
                    error = true;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ex2) {
                            ex2.printStackTrace();
                        }
                    }
                    break block26;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        if (error) {
            ssNumbers = null;
            startOfCycles = null;
        }
    }

    private static synchronized SunSpots getIt(int year, int month) {
        float sunspotNumber = -1.0f;
        int status = 2;
        if (ssNumbers != null && year >= firstYear && year < firstYear + 300) {
            sunspotNumber = ssNumbers[year - firstYear][month - 1];
            if (sunspotNumber < 0.0f && !extrapolated) {
                SunSpots.extrapolate();
                sunspotNumber = ssNumbers[year - firstYear][month - 1];
                extrapolated = true;
            }
            status = 0;
            if (!extrapolated) {
                status = 1;
            } else if (year < lastActualDataYear || year == lastActualDataYear && month <= lastActualDataMonth + 1) {
                status = 1;
            }
        }
        return new SunSpots(year, month, sunspotNumber, status);
    }

    private static void extrapolate() {
        int nbeg = firstYear + startOfCycles[qtyOfCycles - 1] / 12;
        int nend = nbeg + 12 - 1;
        int int1 = 0;
        int ibmo = startOfCycles[qtyOfCycles - 1] % 12;
        float ssn = 0.0f;
        float[] x = new float[qtyOfCycles];
        float[] y = new float[qtyOfCycles];
        int yr = nbeg;
        while (yr <= nend) {
            int idxyr = yr - firstYear;
            int mo = 0;
            while (mo < 12) {
                if (yr != nbeg || mo >= ibmo) {
                    if (ssNumbers[idxyr][mo] >= 0.0f) {
                        ssn = ssNumbers[idxyr][mo];
                        lastActualDataYear = yr;
                        lastActualDataMonth = mo;
                    } else {
                        ++int1;
                        int j = 0;
                        while (j < qtyOfCycles - 1) {
                            int ix = startOfCycles[j] + (lastActualDataYear - nbeg) * 12 + (lastActualDataMonth - ibmo);
                            x[j] = ssNumbers[ix / 12][ix % 12];
                            y[j] = ssNumbers[(ix + int1) / 12][(ix + int1) % 12];
                            ++j;
                        }
                        SunSpots.ssNumbers[idxyr][mo] = (float)SunSpots.predictSeries(x, y, 7, qtyOfCycles - 1, ssn);
                    }
                }
                ++mo;
            }
            ++yr;
        }
    }

    private static double predictSeries(float[] x, float[] y, int skip, int qty, float nextX) {
        int n = qty - skip;
        double nextY = 0.0;
        double sumX = 0.0;
        double sumY = 0.0;
        double sumXY = 0.0;
        double sumX2 = 0.0;
        double sumY2 = 0.0;
        int j = skip;
        while (j < qty) {
            sumX += (double)x[j];
            sumY += (double)y[j];
            sumXY += (double)(x[j] * y[j]);
            sumY2 += (double)(y[j] * y[j]);
            sumX2 += (double)(x[j] * x[j]);
            ++j;
        }
        double avgX = sumX / (double)n;
        double avgY = sumY / (double)n;
        double corr = ((double)n * sumXY - sumX * sumY) / ((double)n * sumX2 - sumX * sumX);
        nextY = avgY + corr * ((double)nextX - avgX);
        return nextY;
    }

    private static void initMemory() {
        if (ssNumbers == null) {
            ssNumbers = new float[300][12];
        }
        if (startOfCycles == null) {
            startOfCycles = new int[360];
        }
        int i = 0;
        while (i < ssNumbers.length) {
            int j = 0;
            while (j < 12) {
                SunSpots.ssNumbers[i][j] = -1.0f;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < startOfCycles.length) {
            SunSpots.startOfCycles[i] = -1;
            ++i;
        }
    }
}

