/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.geospace;

import edu.uml.lgdc.time.TimeScale;

public class TimeGrid {
    public static final int DEFAULT_TIME_STEP = 15;
    public static final int MAX_TIME_STEP = 2;
    private int timeStep = 15;
    private int nDiurnalSteps = 1440 / this.timeStep;
    private TimeScale[] timesUT = null;
    private long forecastPeriod_min = 0L;

    public void setForecastPeriod(long forecastPeriod_min) {
        this.forecastPeriod_min = forecastPeriod_min;
    }

    public void setNewTimeStep(int timeStep_min) {
        if (!TimeGrid.checkTimeStep(1440, timeStep_min)) {
            throw new RuntimeException("Check time grid step");
        }
        this.timeStep = timeStep_min;
        this.nDiurnalSteps = 1440 / this.timeStep;
    }

    public int getTimeStep_min() {
        return this.timeStep;
    }

    public int getNumDiurnalSteps() {
        return this.nDiurnalSteps;
    }

    public static boolean checkTimeStep(int range, int step) {
        return range % step == 0 && step >= 2;
    }

    public TimeScale getTime(TimeScale startTime, int iTime) {
        return new TimeScale(startTime.getTimeInMinutes() + (double)(iTime * this.timeStep));
    }

    public int findClosestTimeStep(TimeScale time) {
        double minutesSinceStart = time.diffIn(12, this.timesUT[0]);
        return (int)Math.round(minutesSinceStart / (double)this.timeStep);
    }

    public int timeToDiurnalPhaseIndex(TimeScale time) {
        double minuteOfDay = time.getTimeSinceMidnightIn(12);
        int iTime = (int)Math.round(minuteOfDay / (double)this.timeStep);
        return (iTime + this.nDiurnalSteps) % this.nDiurnalSteps;
    }

    public int findTimeNode(TimeScale time, TimeScale startTime) {
        double minutes = time.getTimeInMinutes() - startTime.getTimeInMinutes();
        return (int)Math.round(minutes / (double)this.timeStep);
    }

    public void findOffsetedTime(TimeScale time, int offsetInMinutes, boolean before) {
        time.set(14, 0);
        time.set(13, 0);
        int minutes = this.timeStep * (int)Math.floor(time.getTimeSinceMidnightIn(12) / (double)this.timeStep);
        TimeScale temp = time.startOfDay();
        temp.add(12, minutes + offsetInMinutes);
        while (before && temp.after(time)) {
            temp.add(12, -this.timeStep);
        }
        while (!before && temp.before(time)) {
            temp.add(12, this.timeStep);
        }
        time.setTimeInMillis(temp.getTimeInMillis());
    }

    public void findClosestOffsetedTime(TimeScale time, int offsetInMinutes) {
        TimeScale beforeTime = new TimeScale(time.getTimeInMinutes());
        TimeScale afterTime = new TimeScale(time.getTimeInMinutes());
        this.findOffsetedTime(beforeTime, offsetInMinutes, true);
        this.findOffsetedTime(afterTime, offsetInMinutes, false);
        double delayBefore = Math.abs(time.getTimeInMinutes() - beforeTime.getTimeInMinutes());
        double delayAfter = Math.abs(time.getTimeInMinutes() - afterTime.getTimeInMinutes());
        time.setTimeInMinutes(delayAfter < delayBefore ? afterTime.getTimeInMinutes() : beforeTime.getTimeInMinutes());
    }

    public boolean isTimeOffseted(TimeScale time, int offsetInMinutes) {
        return time.get(12) % this.timeStep == offsetInMinutes;
    }

    public int calculateNumberTimeSteps(TimeScale startTime, TimeScale endTime) {
        return (int)((endTime.getTimeInMinutes() - startTime.getTimeInMinutes()) / (double)this.timeStep) + 1;
    }

    public TimeScale snapToClosestGrid(TimeScale time) {
        TimeScale timeAdjusted = new TimeScale(this.timesUT[0].getTimeInMillis());
        timeAdjusted.addMillis(60000L * (long)this.timeStep * (long)this.findClosestTimeStep(time));
        return timeAdjusted;
    }

    public TimeScale snapToEarlierGrid(TimeScale time) {
        TimeScale timeAdjusted = this.snapToClosestGrid(time);
        if (timeAdjusted.after(time)) {
            timeAdjusted.add(12, -this.getTimeStep_min());
        }
        return timeAdjusted;
    }

    public TimeScale lowerBoundSnapped(TimeScale startTime) {
        TimeScale fromTime = this.snapToClosestGrid(startTime);
        return new TimeScale(fromTime.getTimeInMinutes() - (double)this.timeStep / 2.0 + 1.6666666666666667E-5);
    }

    public TimeScale upperBoundSnapped(TimeScale endTime) {
        TimeScale toTime = this.snapToClosestGrid(endTime);
        return new TimeScale(toTime.getTimeInMinutes() + (double)this.timeStep / 2.0 - 1.6666666666666667E-5);
    }

    public TimeScale getOneDayWindowStart(TimeScale tov) {
        return new TimeScale(tov.getTimeInMinutes() - 1440.0 + (double)this.getTimeStep_min());
    }

    public TimeScale getOneDayWindowStartQuery(TimeScale tov) {
        return this.lowerBoundSnapped(this.getOneDayWindowStart(tov));
    }

    public void setUTs(TimeScale tov) {
        double start = tov.getTimeInMinutes() - 1440.0 + (double)this.timeStep;
        int nTimeNodes = this.getNumDiurnalSteps();
        int totalTimeNodes = nTimeNodes + (int)(this.forecastPeriod_min / (long)this.timeStep);
        this.timesUT = new TimeScale[totalTimeNodes];
        int iTime = 0;
        while (iTime < totalTimeNodes) {
            this.timesUT[iTime] = new TimeScale(start + (double)(this.timeStep * iTime));
            ++iTime;
        }
    }

    public TimeScale[] getUTs() {
        return this.timesUT;
    }

    public TimeScale getTov() {
        return this.timesUT[this.nDiurnalSteps - 1];
    }

    public long getForecastPeriod_minutes() {
        return this.forecastPeriod_min;
    }
}

