/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.graph;

import edu.uml.lgdc.graph.LZWEncoder;
import edu.uml.lgdc.graph.NeuQuant;
import edu.uml.lgdc.project.Console;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class AnimatedGifEncoder {
    private int width;
    private int height;
    private Color transparent = null;
    private int transIndex;
    private int repeat = -1;
    private int delay = 0;
    private boolean started = false;
    private OutputStream out;
    private BufferedImage image;
    private byte[] pixels;
    private byte[] indexedPixels;
    private int colorDepth;
    private byte[] colorTab;
    private boolean[] usedEntry = new boolean[256];
    private int palSize = 7;
    private int dispose = -1;
    private boolean closeStream = false;
    private boolean firstFrame = true;
    private boolean sizeSet = false;
    private int sample = 10;

    public void setDelay(int ms) {
        this.delay = (int)Math.round((double)ms / 10.0);
    }

    public void setDispose(int code) {
        if (code >= 0) {
            this.dispose = code;
        }
    }

    public void setRepeat(int iter) {
        if (iter >= 0) {
            this.repeat = iter;
        }
    }

    public void setTransparent(Color c) {
        this.transparent = c;
    }

    public void addFrame(BufferedImage im) throws IOException {
        if (im == null) {
            throw new IllegalArgumentException("im == null");
        }
        if (!this.started) {
            throw new RuntimeException("not initialized");
        }
        boolean ok = false;
        try {
            if (!this.sizeSet) {
                this.setSize(im.getWidth(), im.getHeight());
            }
            this.image = im;
            this.getImagePixels();
            this.analyzePixels();
            if (this.firstFrame) {
                this.writeLSD();
                this.writePalette();
                if (this.repeat >= 0) {
                    this.writeNetscapeExt();
                }
            }
            this.writeGraphicCtrlExt();
            this.writeImageDesc();
            if (!this.firstFrame) {
                this.writePalette();
            }
            this.writePixels();
            this.firstFrame = false;
            ok = true;
        }
        finally {
            if (!ok) {
                if (this.closeStream) {
                    if (this.out != null) {
                        try {
                            this.out.close();
                        }
                        catch (IOException iOException) {}
                        this.out = null;
                    }
                    this.closeStream = false;
                }
                this.started = false;
            }
        }
    }

    public boolean finish() throws IOException {
        if (!this.started) {
            return false;
        }
        this.started = false;
        if (this.out == null) {
            return false;
        }
        try {
            this.out.write(59);
            this.out.flush();
            if (this.closeStream) {
                this.out.close();
            }
            this.out = null;
        }
        finally {
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (IOException iOException) {}
            }
            this.out = null;
            this.transIndex = 0;
            this.image = null;
            this.pixels = null;
            this.indexedPixels = null;
            this.colorTab = null;
            this.closeStream = false;
            this.firstFrame = true;
        }
        return true;
    }

    public void setFrameRate(double fps) {
        if (fps != 0.0) {
            this.delay = (int)Math.round(100.0 / fps);
        }
    }

    public void setQuality(int quality) {
        if (quality < 1) {
            quality = 1;
        }
        this.sample = quality;
    }

    public void setSize(int w, int h) {
        if (this.started && !this.firstFrame) {
            return;
        }
        this.width = w;
        this.height = h;
        if (this.width < 1) {
            this.width = 320;
        }
        if (this.height < 1) {
            this.height = 240;
        }
        this.sizeSet = true;
    }

    public void start(OutputStream os) throws IOException {
        if (os == null) {
            throw new IllegalArgumentException("os == null");
        }
        if (this.started) {
            if (this.closeStream) {
                try {
                    this.out.close();
                }
                catch (IOException ex) {
                    Console.printThreadStackTrace(ex);
                }
            }
            this.out = null;
            this.started = false;
        }
        this.closeStream = false;
        this.out = os;
        this.writeString("GIF89a");
        this.started = true;
    }

    public void start(String file) throws IOException {
        boolean ok = false;
        BufferedOutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(file));
            this.start(os);
            this.closeStream = true;
            ok = true;
        }
        finally {
            if (!ok && os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
                this.out = null;
            }
        }
    }

    protected void analyzePixels() {
        int len = this.pixels.length;
        int nPix = len / 3;
        this.indexedPixels = new byte[nPix];
        NeuQuant nq = new NeuQuant(this.pixels, len, this.sample);
        this.colorTab = nq.process();
        int i = 0;
        while (i < this.colorTab.length) {
            byte temp = this.colorTab[i];
            this.colorTab[i] = this.colorTab[i + 2];
            this.colorTab[i + 2] = temp;
            this.usedEntry[i / 3] = false;
            i += 3;
        }
        int k = 0;
        int i2 = 0;
        while (i2 < nPix) {
            int index = nq.map(this.pixels[k++] & 0xFF, this.pixels[k++] & 0xFF, this.pixels[k++] & 0xFF);
            this.usedEntry[index] = true;
            this.indexedPixels[i2] = (byte)index;
            ++i2;
        }
        this.pixels = null;
        this.colorDepth = 8;
        this.palSize = 7;
        if (this.transparent != null) {
            this.transIndex = this.findClosest(this.transparent);
        }
    }

    protected int findClosest(Color c) {
        if (this.colorTab == null) {
            return -1;
        }
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int minpos = 0;
        int dmin = 0x1000000;
        int len = this.colorTab.length;
        int i = 0;
        while (i < len) {
            int dr = r - (this.colorTab[i++] & 0xFF);
            int dg = g - (this.colorTab[i++] & 0xFF);
            int db = b - (this.colorTab[i] & 0xFF);
            int d = dr * dr + dg * dg + db * db;
            int index = i / 3;
            if (this.usedEntry[index] && d < dmin) {
                dmin = d;
                minpos = index;
            }
            ++i;
        }
        return minpos;
    }

    protected void getImagePixels() {
        int w = this.image.getWidth();
        int h = this.image.getHeight();
        int type = this.image.getType();
        if (w != this.width || h != this.height || type != 5) {
            BufferedImage temp = new BufferedImage(this.width, this.height, 5);
            Graphics2D g = temp.createGraphics();
            g.drawImage((Image)this.image, 0, 0, null);
            this.image = temp;
        }
        this.pixels = ((DataBufferByte)this.image.getRaster().getDataBuffer()).getData();
    }

    protected void writeGraphicCtrlExt() throws IOException {
        int disp;
        int transp;
        this.out.write(33);
        this.out.write(249);
        this.out.write(4);
        if (this.transparent == null) {
            transp = 0;
            disp = 0;
        } else {
            transp = 1;
            disp = 2;
        }
        if (this.dispose >= 0) {
            disp = this.dispose & 7;
        }
        this.out.write((disp <<= 2) | transp);
        this.writeShort(this.delay);
        this.out.write(this.transIndex);
        this.out.write(0);
    }

    protected void writeImageDesc() throws IOException {
        this.out.write(44);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(this.width);
        this.writeShort(this.height);
        if (this.firstFrame) {
            this.out.write(0);
        } else {
            this.out.write(0x80 | this.palSize);
        }
    }

    protected void writeLSD() throws IOException {
        this.writeShort(this.width);
        this.writeShort(this.height);
        this.out.write(0xF0 | this.palSize);
        this.out.write(0);
        this.out.write(0);
    }

    protected void writeNetscapeExt() throws IOException {
        this.out.write(33);
        this.out.write(255);
        this.out.write(11);
        this.writeString("NETSCAPE2.0");
        this.out.write(3);
        this.out.write(1);
        this.writeShort(this.repeat);
        this.out.write(0);
    }

    protected void writePalette() throws IOException {
        this.out.write(this.colorTab, 0, this.colorTab.length);
        int n = 768 - this.colorTab.length;
        int i = 0;
        while (i < n) {
            this.out.write(0);
            ++i;
        }
    }

    protected void writePixels() throws IOException {
        LZWEncoder encoder = new LZWEncoder(this.width, this.height, this.indexedPixels, this.colorDepth);
        encoder.encode(this.out);
    }

    protected void writeShort(int value) throws IOException {
        this.out.write(value & 0xFF);
        this.out.write(value >> 8 & 0xFF);
    }

    protected void writeString(String s) throws IOException {
        int i = 0;
        while (i < s.length()) {
            this.out.write((byte)s.charAt(i));
            ++i;
        }
    }
}

