/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.graph;

import edu.uml.lgdc.format.Formatter;
import java.util.List;
import javax.swing.JComboBox;

public class Combobox {
    public static <E> void initComboBox(JComboBox<E> comboBox, List<E> objects) {
        Combobox.initComboBox(comboBox, objects, 0);
    }

    public static <E> void initComboBox(JComboBox<E> comboBox, List<E> objects, int startIndex) {
        if (startIndex < 0 || startIndex >= objects.size()) {
            throw new RuntimeException("Illegal argument startIndex, " + startIndex);
        }
        comboBox.setSelectedIndex(-1);
        comboBox.removeAllItems();
        int i = startIndex;
        while (i < objects.size()) {
            comboBox.addItem(objects.get(i));
            ++i;
        }
    }

    public static <E> void initComboBox(JComboBox<E> comboBox, E[] objects) {
        Combobox.initComboBox(comboBox, objects, 0);
    }

    public static <E> void initComboBox(JComboBox<E> comboBox, E[] objects, int startIndex) {
        if (startIndex < 0 || startIndex >= objects.length) {
            throw new RuntimeException("Illegal argument startIndex, " + startIndex);
        }
        comboBox.setSelectedIndex(-1);
        comboBox.removeAllItems();
        int i = startIndex;
        while (i < objects.length) {
            comboBox.addItem(objects[i]);
            ++i;
        }
    }

    public static void initComboBox(JComboBox<String> comboBox, double[] values) {
        Combobox.initComboBox(comboBox, values, 0);
    }

    public static void initComboBox(JComboBox<String> comboBox, double[] values, int startIndex) {
        Combobox.initComboBox(comboBox, values, null, startIndex);
    }

    public static void initComboBox(JComboBox<String> comboBox, double[] values, String suffix) {
        Combobox.initComboBox(comboBox, values, suffix, 0);
    }

    public static void initComboBox(JComboBox<String> comboBox, double[] values, String suffix, int startIndex) {
        if (startIndex < 0 || startIndex >= values.length) {
            throw new RuntimeException("Illegal argument value startIndex, " + startIndex);
        }
        comboBox.setSelectedIndex(-1);
        comboBox.removeAllItems();
        if (suffix != null && suffix.length() == 0) {
            suffix = null;
        }
        int i = startIndex;
        while (i < values.length) {
            String item = Formatter.cutTail(Formatter.format("%.10f", values[i]));
            if (suffix != null) {
                item = String.valueOf(item) + suffix;
            }
            comboBox.addItem(item);
            ++i;
        }
    }
}

