/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.graph;

import edu.uml.lgdc.datatype.geom.R2;
import edu.uml.lgdc.graph.Draw;
import edu.uml.lgdc.graph.GraphBase;
import edu.uml.lgdc.graph.NumericAxis;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class FrameGraph
implements Cloneable {
    public static final int MAXIMUM_DIMENSION = 2;
    private static final boolean DEFAULT_QUALITY = true;
    public static final int NORTH = 1;
    public static final int EAST = 2;
    public static final int SOUTH = 3;
    public static final int WEST = 4;
    private static final int DIMENSION = 2;
    private NumericAxis[] axes;
    private int[] axesDirections;
    private int[] axesAnnotSides;
    private int[] axesBorderMargins;
    private int[] axesStartMargins;
    private int[] axesEndMargins;
    private int scrXOrigin;
    private int scrYOrigin;
    private double a11;
    private double a12;
    private double a21;
    private double a22;
    private Rectangle clipRegion;
    protected GraphBase gb;
    private int topMargin;
    private int leftMargin;
    private int bottomMargin;
    private int rightMargin;
    private int originType = 0;
    private int orientationType = 0;
    private Color gridColor = new Color(90, 100, 120);
    private boolean gridsVisible;
    private boolean xGridVisible = this.gridsVisible = true;
    private boolean yGridVisible = this.gridsVisible;
    private boolean xAxisVisible = true;
    private boolean yAxisVisible = true;
    private boolean frameVisible = true;
    private boolean quality = true;
    private boolean recalcBeforeDrawing = true;
    private boolean adjust = true;
    private transient boolean iAmHere = false;
    private transient Polygon triangle = new Polygon(new int[3], new int[3], 3);

    public FrameGraph(GraphBase gb) {
        this(gb, 0);
    }

    public FrameGraph(GraphBase gb, int originType) {
        this(gb, originType, 0);
    }

    public FrameGraph(GraphBase gb, int originType, int orientationType) {
        this(gb, originType, orientationType, 5, 5, 5, 5);
    }

    public FrameGraph(GraphBase gb, int originType, int orientationType, int topMargin, int leftMargin, int bottomMargin, int rightMargin) {
        this.gb = gb;
        this.originType = originType;
        this.orientationType = orientationType;
        this.topMargin = topMargin;
        this.leftMargin = leftMargin;
        this.bottomMargin = bottomMargin;
        this.rightMargin = rightMargin;
        this.axes = new NumericAxis[2];
        this.axesDirections = new int[2];
        this.axesAnnotSides = new int[2];
        this.axesBorderMargins = new int[2];
        this.axesStartMargins = new int[2];
        this.axesEndMargins = new int[2];
        this.setAxisLocationControl(0);
        this.setAxisLocationControl(1);
    }

    public Object clone() {
        try {
            FrameGraph cloned = (FrameGraph)super.clone();
            cloned.axes = new NumericAxis[2];
            cloned.axesDirections = new int[2];
            cloned.axesAnnotSides = new int[2];
            cloned.axesBorderMargins = new int[2];
            cloned.axesStartMargins = new int[2];
            cloned.axesEndMargins = new int[2];
            System.arraycopy(this.axesDirections, 0, cloned.axesDirections, 0, 2);
            System.arraycopy(this.axesAnnotSides, 0, cloned.axesAnnotSides, 0, 2);
            System.arraycopy(this.axesBorderMargins, 0, cloned.axesBorderMargins, 0, 2);
            System.arraycopy(this.axesStartMargins, 0, cloned.axesStartMargins, 0, 2);
            System.arraycopy(this.axesEndMargins, 0, cloned.axesEndMargins, 0, 2);
            int i = 0;
            while (i < 2) {
                cloned.axes[i] = (NumericAxis)this.axes[i].clone();
                ++i;
            }
            cloned.clipRegion = new Rectangle(this.clipRegion);
            cloned.gb = new GraphBase(this.gb.g, this.gb.size, this.gb.background, this.gb.foreground);
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public NumericAxis getXAxis() {
        return this.getAxis(0);
    }

    public NumericAxis getYAxis() {
        return this.getAxis(1);
    }

    public void setXAxis(NumericAxis xAxis) {
        this.setXAxis(xAxis, false);
    }

    public void setXAxis(NumericAxis xAxis, boolean asis) {
        this.setAxis(xAxis, 0, asis);
    }

    public void setYAxis(NumericAxis yAxis) {
        this.setYAxis(yAxis, false);
    }

    public void setYAxis(NumericAxis yAxis, boolean asis) {
        this.setAxis(yAxis, 1, asis);
    }

    public void draw() {
        this.draw(null);
    }

    public void draw(Color bk) {
        if (this.axes[0] != null && this.axes[1] != null) {
            this.recalcBeforeDrawing = false;
            this.setAllStuff();
            this.drawFrame(bk);
            if (this.xAxisVisible) {
                this.axes[0].draw();
            }
            if (this.yAxisVisible) {
                this.axes[1].draw();
            }
            if (this.xGridVisible) {
                this.drawXAxisGrid();
            }
            if (this.yGridVisible) {
                this.drawYAxisGrid();
            }
            this.recalcBeforeDrawing = true;
        }
    }

    public void setAdjust(boolean flag) {
        this.adjust = flag;
    }

    public void setAllStuff() {
        this.recalcBeforeDrawing = false;
        this.calcAllStuff();
        this.recalcBeforeDrawing = true;
    }

    private void calcAllStuff() {
        if (this.iAmHere) {
            return;
        }
        if (this.recalcBeforeDrawing) {
            return;
        }
        this.iAmHere = true;
        if (this.axes[0] != null && this.axes[1] != null) {
            if (this.adjust) {
                this.resetAxisLocation(0);
                this.resetAxisLocation(1);
                this.axes[0].setStartEndMargins(this.axesStartMargins[0] + this.axes[1].getLengthAcross(), this.axesEndMargins[0]);
                this.axes[1].setStartEndMargins(this.axesStartMargins[1] + this.axes[0].getLengthAcross(), this.axesEndMargins[1]);
                this.axes[0].setLength(this.axes[0].getLength());
                this.axes[1].setLength(this.axes[1].getLength());
                this.axes[0].setAllStuff();
                this.axes[1].setAllStuff();
            }
            this.scrXOrigin = this.axes[0].getXOrigin();
            this.scrYOrigin = this.axes[0].getYOrigin();
            this.setClipRegion();
        }
        this.iAmHere = false;
    }

    public void setOrigin(int xStart, int yStart) {
        this.scrXOrigin = xStart;
        this.scrYOrigin = yStart;
        this.axes[0].setOrigin(xStart, yStart);
        this.axes[1].setOrigin(xStart, yStart);
        this.setClipRegion();
    }

    public int getDirection(int axisIndex) {
        return this.axesDirections[axisIndex];
    }

    public int getAnnotSide(int axisIndex) {
        return this.axesAnnotSides[axisIndex];
    }

    public int getBorderMargin(int axisIndex) {
        return this.axesBorderMargins[axisIndex];
    }

    public GraphBase getGraphBase() {
        return this.gb;
    }

    public void setGraphBase(GraphBase gb) {
        this.gb = gb;
        int i = 0;
        while (i < 2) {
            if (this.axes[i] != null) {
                this.axes[i].setGraphBase(gb);
            }
            ++i;
        }
        this.calcAllStuff();
    }

    public void setGraphicsContext(Graphics g) {
        this.gb.g = g;
        int i = 0;
        while (i < 2) {
            if (this.axes[i] != null) {
                this.axes[i].setGraphicsContext(g);
            }
            ++i;
        }
    }

    public Color getBackground() {
        return this.gb.background;
    }

    public Color getForeground() {
        return this.gb.foreground;
    }

    public void setForeground() {
        this.setForeground(this.gb.foreground);
    }

    public void setForeground(Color foreground) {
        this.gb.foreground = foreground;
        int i = 0;
        while (i < 2) {
            if (this.axes[i] != null) {
                this.axes[i].setForeground(foreground);
            }
            ++i;
        }
    }

    public void setQuality(boolean value) {
        this.quality = value;
    }

    public void setAndForceToForeground() {
        this.setAndForceToForeground(this.gb.foreground);
    }

    public void setAndForceToForeground(Color foreground) {
        this.gb.foreground = foreground;
        int i = 0;
        while (i < 2) {
            if (this.axes[i] != null) {
                this.axes[i].setAndForceToForeground(foreground);
            }
            ++i;
        }
    }

    public int getOffset(Point point, NumericAxis axis) {
        int axisIndex = -1;
        int i = 0;
        while (i < 2) {
            if (axis == this.axes[i]) {
                axisIndex = i;
                break;
            }
            ++i;
        }
        return this.getOffset(point, axisIndex);
    }

    public int getOffset(Point point, int axisIndex) {
        int coordinate = Integer.MAX_VALUE;
        if (axisIndex == 0) {
            coordinate = point.x;
        } else if (axisIndex == 1) {
            coordinate = point.y;
        }
        return coordinate;
    }

    public Point toInternal(Point point) {
        Point intPoint = null;
        intPoint = this.toInternalUnbound(point.x, point.y);
        if (!this.isInsideGraphAxes(intPoint)) {
            intPoint = null;
        }
        return intPoint;
    }

    public void setGridsVisible(boolean flag) {
        this.gridsVisible = flag;
        this.xGridVisible = flag;
        this.yGridVisible = flag;
    }

    public void setXGridVisible(boolean flag) {
        this.xGridVisible = flag;
    }

    public void setYGridVisible(boolean flag) {
        this.yGridVisible = flag;
    }

    public void setFrameVisible(boolean flag) {
        this.frameVisible = flag;
    }

    public void setXAxisVisible(boolean flag) {
        this.xAxisVisible = flag;
    }

    public void setYAxisVisible(boolean flag) {
        this.yAxisVisible = flag;
    }

    public void setGridColor(Color value) {
        this.gridColor = value;
    }

    public Point toInternalUnbound(int x, int y) {
        return this.toInternalUnbound(new Point(x, y));
    }

    public Point toInternalUnbound(Point scrPoint) {
        R2 point = new R2(scrPoint);
        point.subtract(new R2((double)this.scrXOrigin, (double)this.scrYOrigin));
        point.applyLinearOperator(this.a11, this.a21, this.a12, this.a22);
        if (this.orientationType == 0) {
            point.mirror();
        }
        Point intPoint = new Point((int)Math.round(point.getX()), (int)Math.round(point.getY()));
        return intPoint;
    }

    public boolean contains(Point inExtCoord) {
        return this.isInsideGraphAxes(this.toInternalUnbound(inExtCoord));
    }

    public boolean contains(int x, int y) {
        return this.isInsideGraphAxes(this.toInternalUnbound(x, y));
    }

    public Point getScrPointInside(Point frmPoint) {
        Point scrPoint = null;
        if (this.isInsideGraphAxes(frmPoint)) {
            scrPoint = this.getScrPoint(frmPoint);
        }
        return scrPoint;
    }

    public Point getScrPoint(int x, int y) {
        return this.getScrPoint(new Point(x, y));
    }

    public Point getScrPoint(Point frmPoint) {
        R2 point = new R2(frmPoint);
        if (this.orientationType == 0) {
            point.mirror();
        }
        point.applyLinearOperator(this.a11, this.a12, this.a21, this.a22);
        Point scrPoint = new Point(this.scrXOrigin + (int)Math.round(point.getX()), this.scrYOrigin + (int)Math.round(point.getY()));
        return scrPoint;
    }

    public Point2D.Double getScrPoint(Point2D.Double frmPoint) {
        return this.getScrPoint(frmPoint.getX(), frmPoint.getY());
    }

    public Point2D.Double getScrPoint(double x, double y) {
        R2 point = new R2(x, y);
        if (this.orientationType == 0) {
            point.mirror();
        }
        point.applyLinearOperator(this.a11, this.a12, this.a21, this.a22);
        Point2D.Double scrPoint = new Point2D.Double((double)this.scrXOrigin + point.getX(), (double)this.scrYOrigin + point.getY());
        return scrPoint;
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        Shape prevClip = this.gb.g.getClip();
        this.gb.g.clipRect(this.clipRegion.x, this.clipRegion.y, this.clipRegion.width, this.clipRegion.height);
        this.drawLineUnbound(x1, y1, x2, y2);
        this.gb.g.setClip(prevClip);
    }

    public void drawLineUnbound(int x1, int y1, int x2, int y2) {
        Color prevColor = this.gb.g.getColor();
        this.gb.g.setColor(this.gb.foreground);
        Point p1 = this.getScrPoint(x1, y1);
        Point p2 = this.getScrPoint(x2, y2);
        this.gb.g.drawLine(p1.x, p1.y, p2.x, p2.y);
        this.gb.g.setColor(prevColor);
    }

    public void drawLine(double x1, double y1, double x2, double y2) {
        Shape prevClip = this.gb.g.getClip();
        this.gb.g.clipRect(this.clipRegion.x, this.clipRegion.y, this.clipRegion.width, this.clipRegion.height);
        this.drawLineUnbound(x1, y1, x2, y2);
        this.gb.g.setClip(prevClip);
    }

    public void drawLineUnbound(double x1, double y1, double x2, double y2) {
        Color prevColor = this.gb.g.getColor();
        this.gb.g.setColor(this.gb.foreground);
        Point2D.Double p1 = this.getScrPoint(x1, y1);
        Point2D.Double p2 = this.getScrPoint(x2, y2);
        Line2D.Double line = new Line2D.Double(p1, p2);
        ((Graphics2D)this.gb.g).draw(line);
        this.gb.g.setColor(prevColor);
    }

    public void drawSparseLine(int x1, int y1, int x2, int y2) {
        this.drawSparseLine(x1, y1, x2, y2, null);
    }

    public void drawSparseLine(int x1, int y1, int x2, int y2, Color background) {
        Shape prevClip = this.gb.g.getClip();
        this.gb.g.clipRect(this.clipRegion.x, this.clipRegion.y, this.clipRegion.width, this.clipRegion.height);
        this.drawSparseLineUnbound(x1, y1, x2, y2, background);
        this.gb.g.setClip(prevClip);
    }

    public void drawSparseLineUnbound(int x1, int y1, int x2, int y2) {
        this.drawSparseLineUnbound(x1, y1, x2, y2, null);
    }

    public void drawSparseLineUnbound(int x1, int y1, int x2, int y2, Color background) {
        Color prevColor = this.gb.g.getColor();
        this.gb.g.setColor(this.gb.foreground);
        Point p1 = this.getScrPoint(x1, y1);
        Point p2 = this.getScrPoint(x2, y2);
        if (this.quality) {
            Draw.drawThinLine(this.gb.g, p1.x, p1.y, p2.x, p2.y);
        } else {
            Draw.drawSparseLine(this.gb.g, p1.x, p1.y, p2.x, p2.y, background);
        }
        this.gb.g.setColor(prevColor);
    }

    public void drawString(String str, int x, int y) {
        Shape prevClip = this.gb.g.getClip();
        this.gb.g.clipRect(this.clipRegion.x, this.clipRegion.y, this.clipRegion.width, this.clipRegion.height);
        this.drawStringUnbound(str, x, y);
        this.gb.g.setClip(prevClip);
    }

    public void drawStringUnbound(String str, int x, int y) {
        Color prevColor = this.gb.g.getColor();
        this.gb.g.setColor(this.gb.foreground);
        Point p = this.getScrPoint(x, y);
        this.gb.g.drawString(str, p.x, p.y);
        this.gb.g.setColor(prevColor);
    }

    public void setFont(Font font) {
        this.gb.g.setFont(font);
    }

    public void drawRect(int x, int y, int width, int height) {
        Shape prevClip = this.gb.g.getClip();
        this.gb.g.clipRect(this.clipRegion.x, this.clipRegion.y, this.clipRegion.width, this.clipRegion.height);
        this.drawRectUnbound(x, y, width, height);
        this.gb.g.setClip(prevClip);
    }

    public void drawRectUnbound(int x, int y, int width, int height) {
        Color prevColor = this.gb.g.getColor();
        this.gb.g.setColor(this.gb.foreground);
        Rectangle r = this.rectTranslate(x, y, width, height);
        this.gb.g.drawRect(r.x, r.y, r.width, r.height);
        this.gb.g.setColor(prevColor);
    }

    public void fillRect(int x, int y, int width, int height) {
        this.fillRect(x, y, width, height, null);
    }

    public void fillRect(int x, int y, int width, int height, Color custom) {
        Shape prevClip = this.gb.g.getClip();
        this.gb.g.clipRect(this.clipRegion.x, this.clipRegion.y, this.clipRegion.width, this.clipRegion.height);
        this.fillRectUnbound(x, y, width, height, custom);
        this.gb.g.setClip(prevClip);
    }

    public void fillRectUnbound(int x, int y, int width, int height) {
        this.fillRectUnbound(x, y, width, height, null);
    }

    public void fillRectUnbound(int x, int y, int width, int height, Color custom) {
        Color prevColor = this.gb.g.getColor();
        if (custom == null) {
            custom = this.gb.foreground;
        }
        this.gb.g.setColor(custom);
        Rectangle r = this.rectTranslate(x, y, width - 1, height - 1);
        this.gb.g.fillRect(r.x, r.y, r.width + 1, r.height + 1);
        this.gb.g.setColor(prevColor);
    }

    public void fillTriangleUnbound(int x, int y, int height, int direction) {
        Color prevColor = this.gb.g.getColor();
        this.gb.g.setColor(this.gb.foreground);
        int sideLength = (int)((double)(2 * height) / Math.sqrt(3.0));
        Point p = this.getScrPoint(x, y);
        this.triangle.xpoints[0] = p.x;
        this.triangle.ypoints[0] = p.y;
        switch (direction) {
            case 1: {
                this.triangle.xpoints[1] = p.x - sideLength / 2;
                this.triangle.ypoints[1] = p.y + height;
                this.triangle.xpoints[2] = p.x + sideLength / 2;
                this.triangle.ypoints[2] = p.y + height;
                break;
            }
            case 2: {
                this.triangle.xpoints[1] = p.x - height;
                this.triangle.ypoints[1] = p.y + sideLength / 2;
                this.triangle.xpoints[1] = p.x - height;
                this.triangle.ypoints[2] = p.y - sideLength / 2;
                break;
            }
            case 3: {
                this.triangle.xpoints[1] = p.x - sideLength / 2;
                this.triangle.ypoints[1] = p.y - height;
                this.triangle.xpoints[2] = p.x + sideLength / 2;
                this.triangle.ypoints[2] = p.y - height;
                break;
            }
            default: {
                this.triangle.xpoints[1] = p.x + height;
                this.triangle.ypoints[1] = p.y + sideLength / 2;
                this.triangle.xpoints[1] = p.x + height;
                this.triangle.ypoints[2] = p.y - sideLength / 2;
            }
        }
        this.gb.g.fillPolygon(this.triangle);
        this.gb.g.setColor(prevColor);
    }

    public void drawOval(int x, int y, int width, int height) {
        Shape prevClip = this.gb.g.getClip();
        this.gb.g.clipRect(this.clipRegion.x, this.clipRegion.y, this.clipRegion.width, this.clipRegion.height);
        this.drawOvalUnbound(x, y, width, height);
        this.gb.g.setClip(prevClip);
    }

    public void drawOvalUnbound(int x, int y, int width, int height) {
        Color prevColor = this.gb.g.getColor();
        this.gb.g.setColor(this.gb.foreground);
        Rectangle r = this.rectTranslate(x, y, width, height);
        if (r.width > 1 && r.height > 1) {
            this.gb.g.drawOval(r.x, r.y, r.width, r.height);
        } else if (r.width <= 1) {
            int i = 0;
            while (i <= r.width) {
                this.gb.g.drawLine(r.x + i, r.y, r.x + i, r.y + r.height);
                ++i;
            }
        } else {
            int i = 0;
            while (i <= r.height) {
                this.gb.g.drawLine(r.x, r.y + i, r.x + r.width, r.y + i);
                ++i;
            }
        }
        this.gb.g.setColor(prevColor);
    }

    public void connectCircles(int x1, int y1, int x2, int y2, int d) {
        Shape prevClip = this.gb.g.getClip();
        this.gb.g.clipRect(this.clipRegion.x, this.clipRegion.y, this.clipRegion.width, this.clipRegion.height);
        this.connectCirclesUnbound(x1, y1, x2, y2, d);
        this.gb.g.setClip(prevClip);
    }

    public void connectCirclesUnbound(int x1, int y1, int x2, int y2, int d) {
        Color prevColor = this.gb.g.getColor();
        this.gb.g.setColor(this.gb.foreground);
        Point p1 = this.getScrPoint(x1, y1);
        Point p2 = this.getScrPoint(x2, y2);
        Draw.connectCircles(this.gb.g, p1.x, p1.y, p2.x, p2.y, d, this.originType);
        this.gb.g.setColor(prevColor);
    }

    public void fillOval(int x, int y, int width, int height) {
        Shape prevClip = this.gb.g.getClip();
        this.gb.g.clipRect(this.clipRegion.x, this.clipRegion.y, this.clipRegion.width, this.clipRegion.height);
        this.fillOvalUnbound(x, y, width, height);
        this.gb.g.setClip(prevClip);
    }

    public void fillOvalUnbound(int x, int y, int width, int height) {
        Color prevColor = this.gb.g.getColor();
        this.gb.g.setColor(this.gb.foreground);
        Rectangle r = this.rectTranslate(x, y, width - 1, height - 1);
        if (r.width > 1 && r.height > 1) {
            this.gb.g.fillOval(r.x, r.y, r.width + 1, r.height + 1);
        } else if (r.width <= 1) {
            int i = 0;
            while (i <= r.width) {
                this.gb.g.drawLine(r.x + i, r.y, r.x + i, r.y + r.height);
                ++i;
            }
        } else {
            int i = 0;
            while (i <= r.height) {
                this.gb.g.drawLine(r.x, r.y + i, r.x + r.width, r.y + i);
                ++i;
            }
        }
        this.gb.g.setColor(prevColor);
    }

    public void drawCircle(int x, int y, int d) {
        this.drawCircleED(x, y, d);
    }

    public void drawCircleED(int x, int y, int d) {
        this.drawOval(x - d / 2, y - d / 2, d - 1, d - 1);
    }

    public void drawCircleEC(int x, int y, int d) {
        this.drawOval(x - d / 2, y - d / 2, 2 * (d / 2), 2 * (d / 2));
    }

    public void drawCircleUnbound(int x, int y, int d) {
        this.drawCircleEDUnbound(x, y, d);
    }

    public void drawCircleEDUnbound(int x, int y, int d) {
        this.drawOvalUnbound(x - d / 2, y - d / 2, d - 1, d - 1);
    }

    public void drawCircleECUnbound(int x, int y, int d) {
        this.drawOvalUnbound(x - d / 2, y - d / 2, 2 * (d / 2), 2 * (d / 2));
    }

    public void fillCircle(int x, int y, int r) {
        this.fillCircleED(x, y, r);
    }

    public void fillCircleED(int x, int y, int d) {
        this.fillOval(x - d / 2, y - d / 2, d, d);
    }

    public void fillCircleEC(int x, int y, int d) {
        this.fillOval(x - d / 2, y - d / 2, 2 * (d / 2) + 1, 2 * (d / 2) + 1);
    }

    public void fillCircleUnbound(int x, int y, int d) {
        this.fillCircleEDUnbound(x, y, d);
    }

    public void fillCircleEDUnbound(int x, int y, int d) {
        this.fillOvalUnbound(x - d / 2, y - d / 2, d, d);
    }

    public void fillCircleECUnbound(int x, int y, int d) {
        this.fillOvalUnbound(x - d / 2, y - d / 2, 2 * (d / 2) + 1, 2 * (d / 2) + 1);
    }

    public void fillCircleCentered(int x, int y, int size) {
        this.fillCircle(x, y, size);
    }

    public void fillPolygon(Polygon pol) {
        Shape prevClip = this.gb.g.getClip();
        this.gb.g.clipRect(this.clipRegion.x, this.clipRegion.y, this.clipRegion.width, this.clipRegion.height);
        this.fillPolygonUnbound(pol);
        this.gb.g.setClip(prevClip);
    }

    public void fillPolygonUnbound(Polygon pol) {
        Color prevColor = this.gb.g.getColor();
        this.gb.g.setColor(this.gb.foreground);
        int i = 0;
        while (i < pol.npoints) {
            Point p = this.getScrPoint(pol.xpoints[i], pol.ypoints[i]);
            pol.xpoints[i] = p.x;
            pol.ypoints[i] = p.y;
            ++i;
        }
        this.gb.g.fillPolygon(pol);
        this.gb.g.setColor(prevColor);
    }

    public void clearFrameArea() {
        this.erase();
    }

    public void erase() {
        Color prevColor = this.getForeground();
        this.setForeground(this.gb.background);
        this.fillRectUnbound(1, 1, this.axes[0].getLength() - 1, this.axes[1].getLength() - 1);
        this.setForeground(prevColor);
    }

    public void drawFrame() {
        this.drawFrame(null);
    }

    public void drawFrame(Color custom) {
        if (this.frameVisible) {
            if (custom != null) {
                this.fillRectUnbound(0, 0, this.axes[0].getLength(), this.axes[1].getLength(), custom);
            }
            this.drawRectUnbound(0, 0, this.axes[0].getLength(), this.axes[1].getLength());
        }
    }

    public void drawGrids() {
        this.drawGrid(0);
        this.drawGrid(1);
    }

    public void drawGrid(int axisIndex) {
        if (axisIndex == 0) {
            this.drawXAxisGrid();
        } else if (axisIndex == 1) {
            this.drawYAxisGrid();
        }
    }

    public void drawXAxisGrid() {
        NumericAxis xAxis = this.axes[0];
        NumericAxis yAxis = this.axes[1];
        Color prevColor = this.gb.foreground;
        this.gb.foreground = this.gridColor;
        int offset = xAxis.getFirstBigTickOffset();
        while (offset >= 0) {
            if (offset > 0) {
                this.drawSparseLine(offset, 1, offset, yAxis.getLength() - 1);
            }
            offset = xAxis.getNextBigTickOffset();
        }
        this.gb.foreground = prevColor;
    }

    public void drawYAxisGrid() {
        NumericAxis xAxis = this.axes[0];
        NumericAxis yAxis = this.axes[1];
        Color prevColor = this.gb.foreground;
        this.gb.foreground = this.gridColor;
        int offset = yAxis.getFirstBigTickOffset();
        while (offset >= 0) {
            if (offset > 0) {
                this.drawSparseLine(1, offset, xAxis.getLength() - 1, offset);
            }
            offset = yAxis.getNextBigTickOffset();
        }
        this.gb.foreground = prevColor;
    }

    public Graphics getGraphics() {
        return this.gb.g;
    }

    public void setGraphics(Graphics g) {
        this.gb.g = g;
    }

    public int getOriginType() {
        return this.originType;
    }

    public int getOrientation() {
        return this.orientationType;
    }

    public Rectangle getClipRegion() {
        return new Rectangle(this.clipRegion);
    }

    public Dimension getClipSize() {
        return this.clipRegion.getSize();
    }

    public Point getClipLocation() {
        return this.clipRegion.getLocation();
    }

    public NumericAxis getAxis(int axisIndex) {
        return this.axes[axisIndex];
    }

    public void setAxis(NumericAxis axis, int axisIndex) {
        this.setAxis(axis, axisIndex, false);
    }

    public void setAxis(NumericAxis axis, int axisIndex, boolean asis) {
        NumericAxis thisAxis = this.axes[axisIndex];
        if (thisAxis != null) {
            thisAxis.detachFromFrame();
        }
        this.axes[axisIndex] = axis;
        axis.attachToFrame(this);
        if (!asis && this.adjust) {
            this.resetAxisLocation(axisIndex);
        }
    }

    private void setAxisLocationControl(int axisIndex) {
        int direction = 0;
        int annotSide = 0;
        int borderMargin = this.bottomMargin;
        int startMargin = this.leftMargin;
        int endMargin = this.rightMargin;
        double angle = 0.0;
        switch (this.originType) {
            case 0: {
                angle = 1.5707963267948966;
                break;
            }
            case 1: {
                angle = Math.PI;
                break;
            }
            case 2: {
                angle = 0.0;
                break;
            }
            case 3: {
                angle = 4.71238898038469;
            }
        }
        this.a11 = Math.cos(angle);
        this.a12 = Math.sin(angle);
        this.a21 = -Math.sin(angle);
        this.a22 = Math.cos(angle);
        block6 : switch (this.originType) {
            case 0: {
                switch (axisIndex) {
                    case 0: {
                        if (this.orientationType == 0) {
                            direction = 0;
                            annotSide = 0;
                            borderMargin = this.bottomMargin;
                            startMargin = this.leftMargin;
                            endMargin = this.rightMargin;
                            break;
                        }
                        direction = 1;
                        annotSide = 1;
                        borderMargin = this.leftMargin;
                        startMargin = this.bottomMargin;
                        endMargin = this.topMargin;
                        break;
                    }
                    case 1: {
                        if (this.orientationType == 0) {
                            direction = 1;
                            annotSide = 1;
                            borderMargin = this.leftMargin;
                            startMargin = this.bottomMargin;
                            endMargin = this.topMargin;
                            break;
                        }
                        direction = 0;
                        annotSide = 0;
                        borderMargin = this.bottomMargin;
                        startMargin = this.leftMargin;
                        endMargin = this.rightMargin;
                    }
                }
                break;
            }
            case 1: {
                switch (axisIndex) {
                    case 0: {
                        if (this.orientationType == 0) {
                            direction = 1;
                            annotSide = 0;
                            borderMargin = this.rightMargin;
                            startMargin = this.bottomMargin;
                            endMargin = this.topMargin;
                            break;
                        }
                        direction = 2;
                        annotSide = 1;
                        borderMargin = this.bottomMargin;
                        startMargin = this.rightMargin;
                        endMargin = this.leftMargin;
                        break;
                    }
                    case 1: {
                        if (this.orientationType == 0) {
                            direction = 2;
                            annotSide = 1;
                            borderMargin = this.bottomMargin;
                            startMargin = this.rightMargin;
                            endMargin = this.leftMargin;
                            break;
                        }
                        direction = 1;
                        annotSide = 0;
                        borderMargin = this.rightMargin;
                        startMargin = this.bottomMargin;
                        endMargin = this.topMargin;
                    }
                }
                break;
            }
            case 2: {
                switch (axisIndex) {
                    case 0: {
                        if (this.orientationType == 0) {
                            direction = 3;
                            annotSide = 0;
                            borderMargin = this.leftMargin;
                            startMargin = this.topMargin;
                            endMargin = this.bottomMargin;
                            break;
                        }
                        direction = 0;
                        annotSide = 1;
                        borderMargin = this.topMargin;
                        startMargin = this.leftMargin;
                        endMargin = this.rightMargin;
                        break;
                    }
                    case 1: {
                        if (this.orientationType == 0) {
                            direction = 0;
                            annotSide = 1;
                            borderMargin = this.topMargin;
                            startMargin = this.leftMargin;
                            endMargin = this.rightMargin;
                            break;
                        }
                        direction = 3;
                        annotSide = 0;
                        borderMargin = this.leftMargin;
                        startMargin = this.topMargin;
                        endMargin = this.bottomMargin;
                    }
                }
                break;
            }
            case 3: {
                switch (axisIndex) {
                    case 0: {
                        if (this.orientationType == 0) {
                            direction = 2;
                            annotSide = 0;
                            borderMargin = this.topMargin;
                            startMargin = this.rightMargin;
                            endMargin = this.leftMargin;
                            break block6;
                        }
                        direction = 3;
                        annotSide = 1;
                        borderMargin = this.rightMargin;
                        startMargin = this.topMargin;
                        endMargin = this.bottomMargin;
                        break block6;
                    }
                    case 1: {
                        if (this.orientationType == 0) {
                            direction = 3;
                            annotSide = 1;
                            borderMargin = this.rightMargin;
                            startMargin = this.topMargin;
                            endMargin = this.bottomMargin;
                            break block6;
                        }
                        direction = 2;
                        annotSide = 0;
                        borderMargin = this.topMargin;
                        startMargin = this.rightMargin;
                        endMargin = this.leftMargin;
                    }
                }
            }
        }
        this.axesDirections[axisIndex] = direction;
        this.axesAnnotSides[axisIndex] = annotSide;
        this.axesBorderMargins[axisIndex] = borderMargin;
        this.axesStartMargins[axisIndex] = startMargin;
        this.axesEndMargins[axisIndex] = endMargin;
    }

    private void setClipRegion() {
        this.clipRegion = R2.getRectangle(this.getScrPoint(1, 0), this.getScrPoint(1, this.axes[1].getLength() - 1), this.getScrPoint(this.axes[0].getLength(), this.axes[1].getLength() - 1), this.getScrPoint(this.axes[0].getLength(), 0));
    }

    private void resetAxisLocation(int axisIndex) {
        NumericAxis axis = this.axes[axisIndex];
        axis.setAxisDirection(this.axesDirections[axisIndex]);
        axis.setAnnotSide(this.axesAnnotSides[axisIndex]);
        axis.setAdjustToBorder(this.axesBorderMargins[axisIndex]);
    }

    public boolean isInsideGraphAxes(int x, int y) {
        return this.isInsideGraphAxes(new Point(x, y));
    }

    public boolean isInsideGraphAxes(Point point) {
        return point.x >= 0 && point.x < this.axes[0].getLength() && point.y >= 0 && point.y < this.axes[1].getLength();
    }

    private Rectangle rectTranslate(Rectangle rect) {
        return this.rectTranslate(rect.x, rect.y, rect.width, rect.height);
    }

    private Rectangle rectTranslate(int x, int y, int width, int height) {
        return R2.getRectangle(this.getScrPoint(x, y), this.getScrPoint(x + width, y), this.getScrPoint(x + width, y + height), this.getScrPoint(x, y + height));
    }

    public void setAnnotFont(Font font) {
        if (this.axes != null) {
            this.axes[0].setAnnotFont(font);
            this.axes[1].setAnnotFont(font);
        }
    }

    public void setLabelFont(Font font) {
        if (this.axes != null) {
            this.axes[0].setLabelFont(font);
            this.axes[1].setLabelFont(font);
        }
    }
}

