/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.graph;

import edu.uml.lgdc.datatype.DoubleArray;
import edu.uml.lgdc.datatype.IncreasingDoubleArray;
import edu.uml.lgdc.datatype.WrapToDoubleArray;
import edu.uml.lgdc.graph.ColorValueLegend;
import edu.uml.lgdc.graph.DiscreteAxis;
import edu.uml.lgdc.graph.DiscreteLinearAxis;
import edu.uml.lgdc.graph.DiscreteLogarithmicAxis;
import edu.uml.lgdc.graph.FrameGraph;
import edu.uml.lgdc.graph.LinearAxis;
import edu.uml.lgdc.graph.LogarithmicAxis;
import edu.uml.lgdc.graph.MonotonicAxis;
import edu.uml.lgdc.graph.NumericAxis;

public class GraphUtil {
    public static NumericAxis createAxis(int axisType, FrameGraph frameGraph, int axisIndex, double[] data) {
        return GraphUtil.createAxis(axisType, frameGraph, axisIndex, new WrapToDoubleArray(data));
    }

    public static NumericAxis createAxis(int axisType, FrameGraph frameGraph, int axisIndex, DoubleArray data) {
        return GraphUtil.createAxis(axisType, frameGraph, axisIndex, data, "");
    }

    public static NumericAxis createAxis(int axisType, FrameGraph frameGraph, int axisIndex, double[] data, String label) {
        return GraphUtil.createAxis(axisType, frameGraph, axisIndex, new WrapToDoubleArray(data), label);
    }

    public static NumericAxis createAxis(int axisType, FrameGraph frameGraph, int axisIndex, DoubleArray data, String label) {
        NumericAxis axis = null;
        switch (axisType) {
            case 2: {
                axis = new DiscreteAxis(frameGraph, axisIndex, data, label);
                break;
            }
            case 3: {
                axis = new DiscreteLinearAxis(frameGraph, axisIndex, (IncreasingDoubleArray)data, label);
                break;
            }
            case 4: {
                axis = new DiscreteLogarithmicAxis(frameGraph, axisIndex, (IncreasingDoubleArray)data, label);
                break;
            }
            case 0: {
                axis = new LinearAxis(frameGraph, axisIndex, data.element(0), data.element(data.size() - 1), label);
                break;
            }
            case 1: {
                axis = new LogarithmicAxis(frameGraph, axisIndex, data.element(0), data.element(data.size() - 1), label);
            }
        }
        return axis;
    }

    public static NumericAxis createAxis(int axisType, ColorValueLegend colorValueLegend, double startValue, double endValue) {
        return GraphUtil.createAxis(axisType, colorValueLegend, startValue, endValue, "");
    }

    public static NumericAxis createAxis(int axisType, ColorValueLegend colorValueLegend, double startValue, double endValue, String label) {
        MonotonicAxis axis = null;
        switch (axisType) {
            case 0: {
                axis = new LinearAxis(colorValueLegend, startValue, endValue, label);
                break;
            }
            case 1: {
                axis = new LogarithmicAxis(colorValueLegend, startValue, endValue, label);
            }
        }
        return axis;
    }
}

