/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.graph;

import edu.uml.lgdc.graph.Annotation;
import edu.uml.lgdc.graph.ColorValueLegend;
import edu.uml.lgdc.graph.FrameGraph;
import edu.uml.lgdc.graph.GraphBase;
import edu.uml.lgdc.graph.LinearScale;
import edu.uml.lgdc.graph.MonotonicAxis;
import edu.uml.lgdc.math.ExtMath;

public class LinearAxis
extends MonotonicAxis {
    private static final double[][] factorControl = new double[][]{{10.0, 2.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {2.0, 2.0, 1.0, 2.0}, {20.0, 2.0, 1.0, 1.0}, {2.0, 2.0, 2.0, 5.0}, {5.0, 1.0, 1.0, 2.0}};
    private LinearScale linearScale;
    private double smallTickStepInValues;
    private double bigTickStepInValues;
    private double annotStepInValues;
    private int base = 10;
    private boolean isTickNeeded;
    private double currentValue;
    private double averageAnnotSize;
    private int factNo = 0;
    private int factQty = factorControl.length;
    private double step;
    private int stepNo = 0;
    private int bigStepInSteps;
    private int annotStepInSteps;
    private boolean endOfValues;
    private boolean forceThisLayout = false;
    private double prevAnnotStepInValues;

    public LinearAxis(FrameGraph frameGraph, int axisIndex, double startValue, double endValue) {
        this(frameGraph, axisIndex, startValue, endValue, "");
    }

    public LinearAxis(ColorValueLegend colorValueLegend, double startValue, double endValue) {
        this(colorValueLegend, startValue, endValue, "");
    }

    public LinearAxis(GraphBase gb, double startValue, double endValue) {
        this(gb, startValue, endValue, 0, 0);
    }

    public LinearAxis(GraphBase gb, double startValue, double endValue, int direction, int annotSide) {
        this(gb, startValue, endValue, direction, annotSide, "");
    }

    public LinearAxis(GraphBase gb, double startValue, double endValue, int direction, int annotSide, String label) {
        this(gb, startValue, endValue, direction, annotSide, label, 0);
    }

    public LinearAxis(FrameGraph frameGraph, int axisIndex, double startValue, double endValue, String label) {
        super(frameGraph, axisIndex, startValue, endValue, label);
        this.linearScale = new LinearScale(startValue, endValue, this.length);
    }

    public LinearAxis(ColorValueLegend colorValueLegend, double startValue, double endValue, String label) {
        super(colorValueLegend, startValue, endValue, label);
        this.linearScale = new LinearScale(startValue, endValue, this.length);
    }

    public LinearAxis(GraphBase gb, double startValue, double endValue, int direction, int annotSide, String label, int borderMargin) {
        super(gb, startValue, endValue, direction, annotSide, label, borderMargin);
        this.linearScale = new LinearScale(startValue, endValue, this.length);
    }

    public LinearAxis(GraphBase gb, double startValue, double endValue, int direction, int annotSide, String label, int xStart, int yStart, int length) {
        super(gb, startValue, endValue, direction, annotSide, label, xStart, yStart, length);
        this.linearScale = new LinearScale(startValue, endValue, length);
    }

    @Override
    public Object clone() {
        LinearAxis cloned = null;
        cloned = (LinearAxis)super.clone();
        cloned.linearScale = new LinearScale(this.linearScale);
        return cloned;
    }

    @Override
    public int offsetToIndex(int offset) {
        return -1;
    }

    @Override
    public int indexToOffset(int index) {
        return -1;
    }

    @Override
    public int indexToOffsetCenter(int index) {
        return -1;
    }

    @Override
    public int indexToOffsetEnd(int index) {
        return -1;
    }

    @Override
    public int indexToSegmentWidth(int index) {
        return -1;
    }

    @Override
    public int indexToInsideOffset(int index) {
        return -1;
    }

    @Override
    public int indexToInsideOffsetCenter(int index) {
        return -1;
    }

    @Override
    public int indexToInsideOffsetEnd(int index) {
        return -1;
    }

    @Override
    public int indexToInsideSegmentWidth(int index) {
        return -1;
    }

    @Override
    public int indexToUnrestrictedOffset(int index) {
        return -1;
    }

    @Override
    public int indexToUnrestrictedOffsetCenter(int index) {
        return -1;
    }

    @Override
    public int indexToUnrestrictedOffsetEnd(int index) {
        return -1;
    }

    @Override
    public int indexToUnrestrictedSegmentWidth(int index) {
        return -1;
    }

    @Override
    public int valueToOffset(double value) {
        return this.linearScale.valueToOffset(value);
    }

    @Override
    public int valueToUnrestrictedOffset(double value) {
        return this.linearScale.valueToUnrestrictedOffset(value);
    }

    public double valueToDoubleOffset(double value) {
        return this.linearScale.valueToDoubleOffset(value);
    }

    public double valueToDoubleUnrestrictedOffset(double value) {
        return this.linearScale.valueToDoubleUnrestrictedOffset(value);
    }

    @Override
    public double offsetToValue(int offset) {
        return this.linearScale.offsetToValue(offset);
    }

    @Override
    public double unrestrictedOffsetToValue(int offset) {
        return this.linearScale.unrestrictedOffsetToValue(offset);
    }

    @Override
    public void setLength(int length) {
        if (this.linearScale != null) {
            this.linearScale.setLength(length);
        }
        super.setLength(length);
    }

    @Override
    public void setStartValue(double startValue) {
        this.linearScale.setStartValue(startValue);
        super.setStartValue(startValue);
    }

    @Override
    public void setEndValue(double endValue) {
        this.linearScale.setEndValue(endValue);
        super.setEndValue(endValue);
    }

    public void setBase(int base) {
        this.base = base;
    }

    @Override
    protected void startFirstLayout() {
        this.factNo = 0;
        this.averageAnnotSize = this.averageAnnotSizeAlongAxis();
        int maxAnnotSteps = (int)((double)this.length / (this.averageAnnotSize * 100.0 / this.getAnnotDensity()));
        this.annotStepInValues = (this.getMaxValue() - this.getMinValue()) / (double)maxAnnotSteps;
        if (this.annotStepInValues == 0.0) {
            this.annotStepInValues = 1.0;
        }
        this.annotStepInValues = Math.pow(this.base, Math.floor(ExtMath.log(this.annotStepInValues, this.base)));
        if (this.getEndValue() < this.getStartValue()) {
            this.annotStepInValues = -this.annotStepInValues;
        }
        this.prevAnnotStepInValues = this.annotStepInValues;
        this.startAnnotationProcess();
        this.setBeforeStartAnyLayout();
    }

    @Override
    protected void startNextLayout() {
        if (this.factNo < this.factQty - 1) {
            this.annotStepInValues = this.annotStepInValues / factorControl[this.factNo][2] * factorControl[this.factNo][3];
            ++this.factNo;
        } else {
            this.prevAnnotStepInValues = this.annotStepInValues = this.prevAnnotStepInValues * (double)this.base;
            this.factNo = 0;
        }
        this.startAnnotationProcess();
        this.setBeforeStartAnyLayout();
    }

    @Override
    protected boolean forceThisLayout() {
        return this.forceThisLayout;
    }

    @Override
    protected Annotation getNextAnnotation() {
        Annotation annotation = null;
        if (!this.endOfValues && this.isCurrentBeforeEnd() || ExtMath.areClose(this.currentValue, super.getEndValue())) {
            int offset;
            boolean isAnnotNumber;
            boolean isBigTick;
            boolean isSmallTick;
            if (this.isTickNeeded) {
                isSmallTick = true;
                isBigTick = this.stepNo % this.bigStepInSteps == 0;
                isAnnotNumber = this.stepNo % this.annotStepInSteps == 0;
            } else {
                isSmallTick = false;
                isBigTick = isAnnotNumber = this.stepNo % this.annotStepInSteps == 0;
            }
            if (isBigTick) {
                isSmallTick = false;
            }
            if ((offset = Math.round(this.valueToOffset(this.currentValue))) >= this.length || !this.isCurrentBeforeEnd()) {
                this.endOfValues = true;
            }
            annotation = new Annotation(offset, this.currentValue, isAnnotNumber, isSmallTick, isBigTick);
            this.nextAnnotNumber();
        }
        return annotation;
    }

    private boolean isCurrentBeforeEnd() {
        return this.getEndValue() > this.getStartValue() && this.currentValue <= super.getEndValue() || this.getEndValue() < this.getStartValue() && this.currentValue >= super.getEndValue();
    }

    private void nextAnnotNumber() {
        this.currentValue += this.step;
        ++this.stepNo;
    }

    private void setBeforeStartAnyLayout() {
        double firstAnnotInValues;
        double firstSmallTickInValues;
        this.isTickNeeded = this.isTickPresent;
        if (this.getIntegerValuesFlag()) {
            if (this.getEndValue() > this.getStartValue()) {
                this.annotStepInValues = Math.max(this.annotStepInValues, 1.0);
                if (ExtMath.areClose(this.annotStepInValues, 1.0)) {
                    this.isTickNeeded = false;
                }
            } else {
                this.annotStepInValues = Math.min(this.annotStepInValues, -1.0);
                if (ExtMath.areClose(this.annotStepInValues, -1.0)) {
                    this.isTickNeeded = false;
                }
            }
        }
        this.smallTickStepInValues = this.annotStepInValues / factorControl[this.factNo][0];
        this.bigTickStepInValues = this.annotStepInValues / factorControl[this.factNo][1];
        if (this.getEndValue() > this.getStartValue()) {
            firstSmallTickInValues = ExtMath.closestNotLess(this.getStartValue(), this.smallTickStepInValues);
            firstAnnotInValues = ExtMath.closestNotLess(this.getStartValue(), this.annotStepInValues);
        } else {
            firstSmallTickInValues = ExtMath.closestNotGreater(this.getStartValue(), this.smallTickStepInValues);
            firstAnnotInValues = ExtMath.closestNotGreater(this.getStartValue(), this.annotStepInValues);
        }
        if (!this.isTickNeeded) {
            this.bigTickStepInValues = this.annotStepInValues;
        }
        if (this.isTickNeeded) {
            this.currentValue = firstSmallTickInValues;
            this.step = this.smallTickStepInValues;
        } else {
            this.currentValue = firstAnnotInValues;
            this.step = this.annotStepInValues;
        }
        this.stepNo = (int)Math.round(this.currentValue / this.step);
        if (this.isTickNeeded) {
            this.bigStepInSteps = (int)Math.round(factorControl[this.factNo][0] / factorControl[this.factNo][1]);
            this.annotStepInSteps = (int)Math.round(factorControl[this.factNo][0]);
        } else {
            this.bigStepInSteps = 1;
            this.annotStepInSteps = 1;
        }
        this.endOfValues = false;
    }
}

