/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.graph;

import edu.uml.lgdc.datatype.IncreasingDoubleArray;
import edu.uml.lgdc.graph.IncreasingDoubleArrayAxis;
import edu.uml.lgdc.graph.LinearScale;

public class LinearDoubleArrayAxis
extends IncreasingDoubleArrayAxis {
    LinearScale linearScale;

    public LinearDoubleArrayAxis(IncreasingDoubleArray data, int length) {
        super(data, length);
        this.linearScale = new LinearScale(data.element(0), data.element(data.size() - 1), length);
    }

    public LinearDoubleArrayAxis(IncreasingDoubleArray data, LinearScale linearScale) {
        super(data, linearScale.length);
        this.linearScale = new LinearScale(linearScale);
        this.linearScale.startValue = data.element(0);
        this.linearScale.endValue = data.element(data.size() - 1);
    }

    public int valueToOffset(double value) {
        return this.linearScale.valueToOffset(value);
    }

    @Override
    public double offsetToValue(int offset) {
        return this.linearScale.offsetToValue(offset);
    }

    @Override
    public int offsetToIndex(int offset) {
        int index = -1;
        double value = this.offsetToValue(offset);
        if (!Double.isNaN(value)) {
            index = this.valueToIndex(value);
        }
        return index;
    }

    @Override
    public int indexToOffset(int index) {
        int offset = -1;
        if (index >= 0 && index < this.data.size()) {
            offset = this.valueToOffset(this.element(index));
        }
        return offset;
    }

    @Override
    public void setLength(int length) {
        this.linearScale.length = length;
        super.setLength(length);
    }

    public void setData(IncreasingDoubleArray data) {
        this.linearScale.startValue = data.element(0);
        this.linearScale.endValue = data.element(data.size() - 1);
        super.setData(data);
    }
}

