/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.graph;

import edu.uml.lgdc.graph.Scale;
import edu.uml.lgdc.math.ExtMath;

public class LinearScale
extends Scale {
    private double minValue = 0.0;
    private double maxValue = 0.0;

    public LinearScale(LinearScale linearScale) {
        super(linearScale);
        this.setMinMax();
    }

    public LinearScale(double startValue, double endValue, int length) {
        super(startValue, endValue, length);
        this.setMinMax();
    }

    @Override
    public void setStartValue(double startValue) {
        super.setStartValue(startValue);
        this.setMinMax();
    }

    @Override
    public void setEndValue(double endValue) {
        super.setEndValue(endValue);
        this.setMinMax();
    }

    private void setMinMax() {
        this.minValue = Math.min(this.startValue, this.endValue);
        this.maxValue = Math.max(this.startValue, this.endValue);
    }

    @Override
    public int valueToOffset(double value) {
        return (int)this.valueToDoubleOffset(value);
    }

    public int valueToUnrestrictedOffset(double value) {
        return (int)this.valueToDoubleUnrestrictedOffset(value);
    }

    public double valueToDoubleOffset(double value) {
        return this.valueToOffset(value, false);
    }

    public double valueToDoubleUnrestrictedOffset(double value) {
        return this.valueToOffset(value, true);
    }

    @Override
    public double unrestrictedOffsetToValue(int offset) {
        double value = offset == 0 ? this.startValue : (offset == this.length - 1 ? this.endValue : this.startValue + (double)offset * (this.endValue - this.startValue) / (double)this.length);
        return value;
    }

    private double valueToOffset(double value, boolean unRestricted) {
        double offset = -1.0;
        if ((unRestricted || value >= this.minValue && value <= this.maxValue || ExtMath.areClose(value, this.startValue) || ExtMath.areClose(value, this.endValue)) && (offset = (double)this.length * (value - this.startValue) / (this.endValue - this.startValue)) >= (double)this.length) {
            offset = (double)this.length - 1.0E-6;
        }
        return offset;
    }
}

