/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.graph;

import edu.uml.lgdc.datatype.IncreasingDoubleArray;
import edu.uml.lgdc.graph.IncreasingDoubleArrayAxis;
import edu.uml.lgdc.graph.LogarithmicScale;

public class LogarithmicDoubleArrayAxis
extends IncreasingDoubleArrayAxis {
    LogarithmicScale logarithmicScale;

    public LogarithmicDoubleArrayAxis(IncreasingDoubleArray data, int length) {
        super(data, length);
        this.logarithmicScale = new LogarithmicScale(data.element(0), data.element(data.size() - 1), length);
    }

    public LogarithmicDoubleArrayAxis(IncreasingDoubleArray data, LogarithmicScale logarithmicScale) {
        super(data, logarithmicScale.length);
        this.logarithmicScale = new LogarithmicScale(logarithmicScale);
        this.logarithmicScale.startValue = data.element(0);
        this.logarithmicScale.endValue = data.element(data.size() - 1);
    }

    public int valueToOffset(double value) {
        return this.logarithmicScale.valueToOffset(value);
    }

    @Override
    public double offsetToValue(int offset) {
        return this.logarithmicScale.offsetToValue(offset);
    }

    @Override
    public int offsetToIndex(int offset) {
        int index = -1;
        double value = this.offsetToValue(offset);
        if (!Double.isNaN(value)) {
            index = this.valueToIndex(value);
        }
        return index;
    }

    @Override
    public int indexToOffset(int index) {
        int offset = -1;
        if (index >= 0 && index < this.data.size()) {
            offset = this.valueToOffset(this.element(index));
        }
        return offset;
    }

    @Override
    public void setLength(int length) {
        this.logarithmicScale.length = length;
        super.setLength(length);
    }

    public void setData(IncreasingDoubleArray data) {
        this.logarithmicScale.startValue = data.element(0);
        this.logarithmicScale.endValue = data.element(data.size() - 1);
        super.setData(data);
    }
}

