/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.graph;

import edu.uml.lgdc.graph.Draw;
import edu.uml.lgdc.graph.WindowDisposerProcess;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class MessageWindow
extends JDialog {
    public static final int BTN_OK = 0;
    public static final int BTN_CANCEL = 1;
    private int exitState = 1;
    private int defaultExitState = 0;
    private int durationSec = 0;
    private Window parentWindow;
    private JButton btnDefault;
    private WindowDisposerProcess disposerProcess = null;
    private BorderLayout mainBorderLayout = new BorderLayout();
    private FlowLayout flowLayout1 = new FlowLayout();
    private BorderLayout borderLayoutPanelMessage = new BorderLayout();
    private JPanel panelMessage = new JPanel();
    private JScrollPane scrollPaneMessage = new JScrollPane();
    private JTextArea message = new JTextArea();
    private JPanel panelButtons = new JPanel();
    private JButton btnOK = new JButton();
    private JButton btnCancel = new JButton();
    private transient String procName;

    public MessageWindow(Frame frame, String title, boolean modal, String textStr, int defaultExitState, int durationSec) {
        super(frame, title, modal);
        this.init(frame, textStr, defaultExitState, durationSec);
    }

    public MessageWindow(Dialog dialog, String title, boolean modal, String textStr, int defaultExitState, int durationSec) {
        super(dialog, title, modal);
        this.init(dialog, textStr, defaultExitState, durationSec);
    }

    public MessageWindow(Frame frame, String title, boolean modal, String textStr, int durationSec) {
        this(frame, title, modal, textStr, 0, durationSec);
    }

    public MessageWindow(Dialog dialog, String title, boolean modal, String textStr, int durationSec) {
        this(dialog, title, modal, textStr, 0, durationSec);
    }

    public MessageWindow(Frame frame, String title, boolean modal, String textStr) {
        this(frame, title, modal, textStr, 0);
    }

    public MessageWindow(Frame frame, String textStr, int durationSec) {
        this(frame, "Error window", true, textStr, durationSec);
    }

    public MessageWindow(Frame frame, String textStr) {
        this(frame, textStr, 0);
    }

    public MessageWindow(String textStr, int durationSec) {
        this((Frame)null, "Error window", true, textStr, durationSec);
    }

    public MessageWindow(String textStr) {
        this(textStr, 0);
    }

    public MessageWindow(Dialog dialog, String title, boolean modal, String textStr) {
        this(dialog, title, modal, textStr, 0);
    }

    public MessageWindow(Dialog dialog, String textStr, int durationSec) {
        this(dialog, "Error window", true, textStr, durationSec);
    }

    public MessageWindow(Dialog dialog, String textStr) {
        this(dialog, textStr, 0);
    }

    private void init(Window parentWindow, String textStr, int defaultExitState, int durationSec) {
        if (defaultExitState != 0 && defaultExitState != 1) {
            throw new IllegalArgumentException("defaultExitState is illegal, " + defaultExitState + ", but must be " + 0 + " or " + 1);
        }
        Font font = new Font("SansSerif", 0, 14);
        this.message.setFont(font);
        if (textStr.length() > 0) {
            this.message.append(textStr);
        }
        this.guiInit();
        this.btnCancel.setVisible(false);
        this.parentWindow = parentWindow;
        this.defaultExitState = defaultExitState;
        this.durationSec = durationSec;
        this.setDefaultButton();
        this.durationSec = durationSec;
    }

    private void guiInit() {
        this.message.setLineWrap(true);
        this.message.setWrapStyleWord(true);
        this.message.setEditable(false);
        this.scrollPaneMessage.getViewport().add((Component)this.message, null);
        this.panelMessage.setLayout(this.borderLayoutPanelMessage);
        this.panelMessage.add((Component)this.scrollPaneMessage, "Center");
        this.btnOK.setText("OK");
        this.btnOK.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                MessageWindow.this.btnOK_keyPressed(e);
            }
        });
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageWindow.this.btnOK_actionPerformed(e);
            }
        });
        this.btnCancel.setText("Cancel");
        this.btnCancel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                MessageWindow.this.btnCancel_keyPressed(e);
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageWindow.this.btnCancel_actionPerformed(e);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                MessageWindow.this.common_keyPressed(e);
            }
        });
        this.panelButtons.setLayout(this.flowLayout1);
        this.panelButtons.add((Component)this.btnOK, null);
        this.panelButtons.add((Component)this.btnCancel, null);
        this.getContentPane().setLayout(this.mainBorderLayout);
        this.getContentPane().add((Component)this.panelMessage, "Center");
        this.getContentPane().add((Component)this.panelButtons, "South");
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.panelMessage.setPreferredSize(Draw.rebuildTextArea(this.message));
            this.pack();
            Draw.centerPosition(this, this.parentWindow);
            this.panelButtons.setFocusCycleRoot(true);
            this.btnDefault.requestFocus();
            if (this.durationSec > 0) {
                if (this.disposerProcess != null) {
                    this.disposerProcess.stopIt();
                }
                this.disposerProcess = new WindowDisposerProcess(this, this.durationSec);
                this.procName = this.disposerProcess.getName();
                this.disposerProcess.start();
            }
        } else if (this.durationSec > 0 && this.disposerProcess != null && Thread.currentThread().getName().equals(this.procName)) {
            this.exitState = this.defaultExitState;
        }
        super.setVisible(visible);
    }

    @Override
    public void setFont(Font font) {
        this.message.setFont(font);
    }

    public void setBgColor(Color color) {
        this.message.setBackground(color);
    }

    public void setFgColor(Color color) {
        this.message.setForeground(color);
    }

    public void addCancelButton() {
        this.btnCancel.setVisible(true);
    }

    public void addCancelButton(String text) {
        this.btnCancel.setVisible(true);
        this.setCancelButtonText(text);
    }

    public void setOKButtonText(String text) {
        this.btnOK.setText(text);
    }

    public void setCancelButtonText(String text) {
        this.btnCancel.setText(text);
    }

    public int getExitCode() {
        return this.exitState;
    }

    private void btnOK_actionPerformed(ActionEvent e) {
        this.exitState = 0;
        this.dispose();
    }

    private void btnOK_keyPressed(KeyEvent e) {
        int key = e.getKeyCode();
        if (key == 10) {
            this.exitState = 0;
            this.dispose();
        } else if (key == 27) {
            this.exitState = this.btnCancel.isVisible() ? 1 : 0;
            this.dispose();
        }
    }

    private void btnCancel_keyPressed(KeyEvent e) {
        int key = e.getKeyCode();
        if (key == 10 || key == 27) {
            this.exitState = 1;
            this.dispose();
        }
    }

    private void common_keyPressed(KeyEvent e) {
        int key = e.getKeyCode();
        if (key == 27) {
            this.exitState = this.btnCancel.isVisible() ? 1 : 0;
            this.dispose();
        }
    }

    private void btnCancel_actionPerformed(ActionEvent e) {
        this.exitState = 1;
        this.dispose();
        System.gc();
    }

    public static boolean ask(Dialog dialog, String title, boolean modal, String textStr) {
        MessageWindow mesW = new MessageWindow(dialog, title, modal, textStr);
        return MessageWindow.isYes(mesW);
    }

    public static boolean ask(Frame frame, String title, boolean modal, String textStr) {
        MessageWindow mesW = new MessageWindow(frame, title, modal, textStr);
        return MessageWindow.isYes(mesW);
    }

    private static boolean isYes(MessageWindow mesW) {
        mesW.setOKButtonText("Yes");
        mesW.addCancelButton("No");
        mesW.setVisible(true);
        return mesW.getExitCode() == 0;
    }

    private void setDefaultButton() {
        this.btnDefault = this.defaultExitState == 0 ? this.btnOK : this.btnCancel;
    }
}

