/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.graph;

import edu.uml.lgdc.graph.ColorValueLegend;
import edu.uml.lgdc.graph.FrameGraph;
import edu.uml.lgdc.graph.GraphBase;
import edu.uml.lgdc.graph.HotValue;
import edu.uml.lgdc.graph.NumericAxis;

public abstract class MonotonicAxis
extends NumericAxis {
    public static final int MAX_NO_OF_HOT_VALUES = 20;
    protected double direction = 1.0;
    private double[] hotValues;
    private String[] hotStrings;
    private int qtyOfHots = 0;

    public MonotonicAxis(FrameGraph frameGraph, int axisIndex, double startValue, double endValue) {
        this(frameGraph, axisIndex, startValue, endValue, "");
    }

    public MonotonicAxis(ColorValueLegend colorValueLegend, double startValue, double endValue) {
        this(colorValueLegend, startValue, endValue, "");
    }

    public MonotonicAxis(GraphBase gb, double startValue, double endValue) {
        this(gb, startValue, endValue, 0, 0);
    }

    public MonotonicAxis(GraphBase gb, double startValue, double endValue, int direction, int annotSide) {
        this(gb, startValue, endValue, direction, annotSide, "");
    }

    public MonotonicAxis(GraphBase gb, double startValue, double endValue, int direction, int annotSide, String label) {
        this(gb, startValue, endValue, direction, annotSide, label, 0);
    }

    public MonotonicAxis(FrameGraph frameGraph, int axisIndex, double startValue, double endValue, String label) {
        super(frameGraph, axisIndex, label);
        this.set_StartValue(startValue);
        this.set_EndValue(endValue);
        this.clear_Hots();
        this.calcAllStuff();
    }

    public MonotonicAxis(ColorValueLegend colorValueLegend, double startValue, double endValue, String label) {
        super(colorValueLegend, label);
        this.set_StartValue(startValue);
        this.set_EndValue(endValue);
        this.clear_Hots();
        this.calcAllStuff();
    }

    public MonotonicAxis(GraphBase gb, double startValue, double endValue, int direction, int annotSide, String label, int borderMargin) {
        super(gb, direction, annotSide, label, borderMargin);
        this.set_StartValue(startValue);
        this.set_EndValue(endValue);
        this.clear_Hots();
        this.calcAllStuff();
    }

    public MonotonicAxis(GraphBase gb, double startValue, double endValue, int direction, int annotSide, String label, int xStart, int yStart, int length) {
        super(gb, direction, annotSide, label, xStart, yStart, length);
        this.set_StartValue(startValue);
        this.set_EndValue(endValue);
        this.clear_Hots();
        this.calcAllStuff();
    }

    public boolean isPossibleToConvertValueToPixel() {
        return true;
    }

    @Override
    public void setStartValue(double startValue) {
        this.set_StartValue(startValue);
    }

    @Override
    public void setEndValue(double endValue) {
        this.set_EndValue(endValue);
    }

    public void clearHots() {
        this.clear_Hots();
    }

    @Override
    public void addOneHot(double value) {
        this.add_OneHot(value);
    }

    @Override
    public void addOneHot(double value, String str) {
        this.add_OneHot(value, str);
    }

    @Override
    public void addHots(double[] values) {
        int i = 0;
        while (i < values.length) {
            this.add_OneHot(values[i]);
            ++i;
        }
    }

    @Override
    protected void reFillHotValues() {
        this.clearHotValues();
        int i = 0;
        while (i < this.qtyOfHots) {
            int offset = this.valueToOffset(this.hotValues[i]);
            if (offset >= 0) {
                this.addHotValue(new HotValue(offset, this.hotValues[i], this.hotStrings[i]));
            }
            ++i;
        }
    }

    private void clear_Hots() {
        this.qtyOfHots = 0;
        this.hotValues = new double[20];
        this.hotStrings = new String[20];
    }

    private void add_OneHot(double value) {
        if (this.qtyOfHots < 19) {
            this.hotValues[this.qtyOfHots] = value;
            this.hotStrings[this.qtyOfHots] = null;
            ++this.qtyOfHots;
        }
    }

    private void add_OneHot(double value, String str) {
        if (this.qtyOfHots < 19) {
            this.hotValues[this.qtyOfHots] = value;
            this.hotStrings[this.qtyOfHots] = str;
            ++this.qtyOfHots;
        }
    }

    private void setMinMaxValue() {
        if (this.startValue < this.endValue) {
            this.direction = 1.0;
            super.setMinValue(this.startValue);
            super.setMaxValue(this.endValue);
        } else {
            this.direction = -1.0;
            super.setMinValue(this.endValue);
            super.setMaxValue(this.startValue);
        }
    }

    private void set_StartValue(double startValue) {
        super.setStartValue(startValue);
        this.setMinMaxValue();
        this.calcAllStuff();
    }

    private void set_EndValue(double endValue) {
        super.setEndValue(endValue);
        this.setMinMaxValue();
        this.calcAllStuff();
    }
}

