/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.graph;

import edu.uml.lgdc.format.FC;
import edu.uml.lgdc.graph.Annotation;
import edu.uml.lgdc.graph.ColorValueLegend;
import edu.uml.lgdc.graph.Draw;
import edu.uml.lgdc.graph.FrameGraph;
import edu.uml.lgdc.graph.GraphBase;
import edu.uml.lgdc.graph.HotValue;
import edu.uml.lgdc.graph.VerticalStr;
import edu.uml.lgdc.math.ExtMath;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.Vector;

public abstract class NumericAxis
implements Cloneable {
    public static final int LABEL_LOCATION_WHERE_ANNOT = 0;
    public static final int LABEL_LOCATION_OPPOSITE_ANNOT = 1;
    public static final int LABEL_LOCATION_AXIS_START = 2;
    public static final int LABEL_LOCATION_AXIS_END = 3;
    public static final int ITEM_ORIENTATION_HORIZONTAL = 0;
    public static final int ITEM_ORIENTATION_VERTICAL = 1;
    public static final int ITEM_ORIENTATION_ALONG_AXIS = 2;
    public static final int ITEM_ORIENTATION_ACROSS_AXIS = 3;
    public static final int LABEL_ALIGNMENT_START = 0;
    public static final int LABEL_ALIGNMENT_END = 1;
    public static final int LABEL_ALIGNMENT_CENTER = 2;
    public static final int LABEL_ALIGNMENT_OTHER = 3;
    protected static final int GAP_BEFORE_ANNOT = 3;
    protected static final int GAP_BEFORE_LABEL = 12;
    protected static final int MAX_DECIMALS_TO_DISPLAY = 16;
    private GraphBase gb;
    private Color foreground = Color.white;
    private FrameGraph frameGraph;
    private ColorValueLegend colorValueLegend;
    private int xStart;
    private int yStart;
    private int axisDirection = 0;
    protected int length;
    private int annotSide = 0;
    protected String label;
    private double annotMinimalGap = 1.0;
    private double annotDensity = 50.0;
    private double smallTickMinimalGap = 1.0;
    private double smallTickDensity = 30.0;
    private double bigTickMinimalGap = 2.0;
    private double bigTickDensity = 30.0;
    private int smallTickThickness = 1;
    private int bigTickThickness = 1;
    protected boolean isLabelPresent = true;
    protected boolean isTickPresent = true;
    protected boolean isAnnotPresent = true;
    protected boolean isLabelVisible = true;
    protected boolean isTickVisible = true;
    protected boolean isAnnotVisible = true;
    protected double labelTransparency = 1.0;
    protected Font annotFont = new Font("Dialog", 1, 11);
    protected Font labelFont = new Font("Dialog", 1, 15);
    protected Color axisColor = Color.white;
    protected Color tickColor = Color.white;
    protected Color annotColor = Color.white;
    protected Color hotValueColor = Color.yellow;
    protected Color labelColor = Color.white;
    private boolean axisColorForeground = true;
    private boolean tickColorForeground = true;
    private boolean annotColorForeground = true;
    private boolean labelColorForeground = true;
    private boolean hotValueColorForeground = false;
    private boolean useOnlyHotValues = false;
    private int annotOrientation = 0;
    private int labelLocation = 0;
    private int labelOrientation = 2;
    private int labelAlignment = 2;
    private boolean drawMarginValues = true;
    private boolean drawStartMarginValue = true;
    private boolean drawEndMarginValue = true;
    private boolean adjustToBorder = false;
    private int borderMargin = 0;
    private boolean adjustToStartEnd = false;
    private int startMargin = 0;
    private int endMargin = 0;
    protected double startValue;
    protected double endValue;
    protected double minValue;
    protected double maxValue;
    private boolean isInteger = false;
    private boolean isScientific = false;
    private int minDecimalsToDisplay = 1;
    private int decimalsToDisplay = 1;
    private int exponentSize = 2;
    private boolean isDecimalsFixed = false;
    private boolean isDiscardTrailingZeroes = false;
    private int xEnd;
    private int yEnd;
    private int xTickVector;
    private int yTickVector;
    private int xAxisVector;
    private int yAxisVector;
    private int graphicRelatedAnnotOrientation;
    private int axisRelatedAnnotOrientation;
    private int graphicRelatedLabelOrientation;
    private int axisRelatedLabelOrientation;
    private double labelAlignmentCoefficient = 0.5;
    protected Vector annotations = null;
    private int totalAnnotations = 0;
    private int totalAnnotNumbers = 0;
    private int totalBigTicks = 0;
    private int totalSmallTicks = 0;
    private int totalAnnotNumberLength = 0;
    private int totalBigTickLength = 0;
    private int totalSmallTickLength = 0;
    protected Vector annotStrings = new Vector(20, 10);
    protected Vector hotValues = new Vector(20, 10);
    private boolean recalcBeforeDrawing = true;
    private boolean needToRecalc = true;
    private int indexOfAnyTick = 0;
    private int indexOfBigTick = 0;
    private transient boolean iAmHere = false;
    VerticalStr verticalStr;

    public NumericAxis(GraphBase gb) {
        this(gb, 0, 0);
    }

    public NumericAxis(GraphBase gb, int direction, int annotSide) {
        this(gb, direction, annotSide, "");
    }

    public NumericAxis(GraphBase gb, int direction, int annotSide, String label) {
        this(gb, direction, annotSide, label, -1);
    }

    public NumericAxis(GraphBase gb, int direction, int annotSide, String label, int borderMargin) {
        this(gb, direction, annotSide, label, -borderMargin - 1, -borderMargin - 1, 50);
    }

    public NumericAxis(FrameGraph frameGraph, int axisIndex) {
        this(frameGraph, axisIndex, "");
    }

    public NumericAxis(FrameGraph frameGraph, int axisIndex, String label) {
        int direction = frameGraph.getDirection(axisIndex);
        int annotSide = frameGraph.getAnnotSide(axisIndex);
        int borderMargin = frameGraph.getBorderMargin(axisIndex);
        this.initialConstructor(frameGraph.getGraphBase(), direction, annotSide, label, -borderMargin - 1, -borderMargin - 1, 50);
        frameGraph.setAxis(this, axisIndex);
    }

    public NumericAxis(ColorValueLegend colorValueLegend) {
        this(colorValueLegend, "");
    }

    public NumericAxis(ColorValueLegend colorValueLegend, String label) {
        int direction = colorValueLegend.getDirection();
        int annotSide = colorValueLegend.getSide();
        int xStart = colorValueLegend.getOrigin().x;
        int yStart = colorValueLegend.getOrigin().y;
        int length = colorValueLegend.getLength();
        this.initialConstructor(colorValueLegend.gb, direction, annotSide, label, xStart, yStart, length);
        colorValueLegend.setAxis(this);
    }

    public NumericAxis(GraphBase gb, int direction, int annotSide, String label, int xStart, int yStart, int length) {
        this.initialConstructor(gb, direction, annotSide, label, xStart, yStart, length);
    }

    private void initialConstructor(GraphBase gb, int direction, int annotSide, String label, int xStart, int yStart, int length) {
        this.gb = gb;
        this.foreground = gb.foreground;
        this.length = length;
        this.annotSide = annotSide;
        this.label = label != null ? label : "";
        this.verticalStr = new VerticalStr(gb.g, gb.foreground);
        this.setAxisDirection(direction, true);
        boolean adjust = false;
        int tempMargin = 0;
        this.setXStartAdjusted(xStart);
        if (this.adjustToBorder) {
            adjust = true;
            tempMargin = this.borderMargin;
        }
        this.setYStartAdjusted(yStart);
        if (adjust) {
            this.adjustToBorder = true;
            this.borderMargin = tempMargin;
        }
        this.setVariousOrientation();
        this.setEndPosition();
        if (this.adjustToBorder) {
            this.setStartAdjusted();
            this.setEndPosition();
        }
    }

    public Object clone() {
        NumericAxis cloned = null;
        try {
            cloned = (NumericAxis)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return cloned;
    }

    public abstract int offsetToIndex(int var1);

    public abstract int valueToOffset(double var1);

    public abstract int valueToUnrestrictedOffset(double var1);

    public abstract int indexToOffset(int var1);

    public abstract int indexToOffsetCenter(int var1);

    public abstract int indexToOffsetEnd(int var1);

    public abstract int indexToSegmentWidth(int var1);

    public abstract int indexToInsideOffset(int var1);

    public abstract int indexToInsideOffsetCenter(int var1);

    public abstract int indexToInsideOffsetEnd(int var1);

    public abstract int indexToInsideSegmentWidth(int var1);

    public abstract int indexToUnrestrictedOffset(int var1);

    public abstract int indexToUnrestrictedOffsetCenter(int var1);

    public abstract int indexToUnrestrictedOffsetEnd(int var1);

    public abstract int indexToUnrestrictedSegmentWidth(int var1);

    public void addOneHot(double value) {
    }

    public void addOneHot(double value, String str) {
    }

    public void addHots(double[] values) {
    }

    public void setAdjustToBorder(int borderMargin) {
        if (!this.adjustToBorder || this.borderMargin != borderMargin) {
            this.adjustToBorder = true;
            this.borderMargin = borderMargin;
            this.calcAllStuff();
        }
    }

    void detachFromFrame() {
        this.frameGraph = null;
    }

    void attachToFrame(FrameGraph frameGraph) {
        this.frameGraph = frameGraph;
    }

    void detachFromLegend() {
        this.colorValueLegend = null;
    }

    void attachToLegend(ColorValueLegend colorValueLegend) {
        this.colorValueLegend = colorValueLegend;
    }

    public void setStartEndMargins(int startMargin, int endMargin) {
        this.setStartEndMargins(startMargin, endMargin, false);
    }

    public abstract double offsetToValue(int var1);

    public abstract double unrestrictedOffsetToValue(int var1);

    public void draw() {
        this.recalcBeforeDrawing = false;
        if (this.needToRecalc) {
            this.calcAllStuff();
        }
        if (this.length > 0) {
            this.drawAxis();
            if (this.isTickPresent && this.isTickVisible) {
                this.drawSmallTicks();
            }
            if (this.isAnnotPresent && this.isAnnotVisible) {
                this.drawBigTicks();
                this.drawAnnotations();
            }
            if (this.isLabelPresent && this.isLabelVisible) {
                this.drawLabel();
            }
        }
        this.recalcBeforeDrawing = true;
    }

    public void setAllStuff() {
        this.recalcBeforeDrawing = false;
        this.calcAllStuff();
    }

    public int getLengthAcross() {
        if (this.needToRecalc && (this.isTickPresent || this.isAnnotPresent)) {
            this.calcAnnotationLayout();
        }
        return this.getSizeAcrossAxis();
    }

    public int getLengthAcrossWithoutLabel() {
        if (this.needToRecalc && (this.isTickPresent || this.isAnnotPresent)) {
            this.calcAnnotationLayout();
        }
        return this.getSizeAcrossAxisWithoutLabel();
    }

    protected void calcAllStuff() {
        if (this.iAmHere) {
            return;
        }
        this.needToRecalc = true;
        if (this.recalcBeforeDrawing) {
            return;
        }
        this.iAmHere = true;
        if (this.adjustToBorder) {
            this.setVariousOrientation();
            this.setStartAdjusted();
            this.setEndPosition();
        }
        if (this.isTickPresent || this.isAnnotPresent) {
            this.calcAnnotationLayout();
            if (this.adjustToBorder) {
                this.setStartAdjusted();
                this.setEndPosition();
            }
        }
        this.iAmHere = false;
        this.needToRecalc = false;
    }

    public void setAxisDirection(int direction) {
        this.setAxisDirection(direction, false);
    }

    public void setAnnotSide(int annotSide) {
        if (this.annotSide != annotSide) {
            this.annotSide = annotSide;
            this.setTickVector();
            this.calcAllStuff();
        }
    }

    public int getXOrigin() {
        return this.xStart;
    }

    public void setOrigin(int xStart, int yStart) {
        this.xStart = xStart;
        this.yStart = yStart;
        this.setEndPosition();
        this.adjustToBorder = false;
        this.adjustToStartEnd = false;
    }

    public void setXOrigin(int xStart) {
        this.xStart = xStart;
        this.setVariousOrientation();
        this.setEndPosition();
        this.calcAllStuff();
        if (this.axisDirection == 1 || this.axisDirection == 3) {
            this.adjustToBorder = false;
        } else {
            this.adjustToStartEnd = true;
        }
    }

    public int getYOrigin() {
        return this.yStart;
    }

    public void setYOrigin(int yStart) {
        this.yStart = yStart;
        this.setVariousOrientation();
        this.setEndPosition();
        this.calcAllStuff();
        if (this.axisDirection == 0 || this.axisDirection == 2) {
            this.adjustToBorder = false;
        } else {
            this.adjustToStartEnd = true;
        }
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        if (length < 0) {
            length = 0;
        }
        this.length = length;
        this.setEndPosition();
        this.calcAllStuff();
    }

    public void clearAnnotStrings() {
        this.annotStrings = null;
        this.annotStrings = new Vector(20, 10);
        this.calcAllStuff();
    }

    public void addToAnnotStrings(String annotStr) {
        this.annotStrings.addElement(annotStr);
        this.calcAllStuff();
    }

    public void addToAnnotStrings(String[] annotStr) {
        int i = 0;
        while (i < annotStr.length) {
            this.annotStrings.addElement(annotStr[i]);
            ++i;
        }
        this.calcAllStuff();
    }

    protected double getMinValue() {
        return this.minValue;
    }

    protected double getMaxValue() {
        return this.maxValue;
    }

    protected void setMinValue(double minValue) {
        this.minValue = minValue;
    }

    protected void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public double getStartValue() {
        return this.get_StartValue();
    }

    protected void setStartValue(double startValue) {
        this.startValue = startValue;
    }

    public double getEndValue() {
        return this.get_EndValue();
    }

    protected void setEndValue(double endValue) {
        this.endValue = endValue;
    }

    public GraphBase getGraphBase() {
        return this.gb;
    }

    public void setGraphBase(GraphBase gb) {
        this.gb = gb;
        this.setForeground(gb.foreground);
        this.calcAllStuff();
    }

    public void setGraphicsContext(Graphics g) {
        this.gb.g = g;
    }

    public Color getBackground() {
        return this.gb.background;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color foreground) {
        this.setForeground(foreground, false);
    }

    public void forceAllToForeground() {
        this.setForeground(this.foreground, true);
    }

    public void setAndForceToForeground(Color foreground) {
        this.setForeground(foreground, true);
    }

    public Color getAxisColor() {
        return this.axisColorForeground ? this.foreground : this.axisColor;
    }

    public void setAxisColor(Color axisColor) {
        this.axisColorForeground = false;
        if (!this.axisColor.equals(axisColor)) {
            this.axisColor = axisColor;
            this.calcAllStuff();
        }
    }

    public void forceAxisToForeground() {
        if (!this.axisColorForeground) {
            this.axisColorForeground = true;
            if (!this.axisColor.equals(this.foreground)) {
                this.calcAllStuff();
            }
        }
    }

    public Color getTickColor() {
        return this.tickColorForeground ? this.foreground : this.tickColor;
    }

    public void setTickColor(Color tickColor) {
        this.tickColorForeground = false;
        if (!this.tickColor.equals(tickColor)) {
            this.tickColor = tickColor;
            this.calcAllStuff();
        }
    }

    public void forceTickToForeground() {
        if (!this.tickColorForeground) {
            this.tickColorForeground = true;
            if (!this.tickColor.equals(this.foreground)) {
                this.calcAllStuff();
            }
        }
    }

    public Color getAnnotColor() {
        return this.annotColorForeground ? this.foreground : this.annotColor;
    }

    public void setAnnotColor(Color annotColor) {
        this.annotColorForeground = false;
        if (!this.annotColor.equals(annotColor)) {
            this.annotColor = annotColor;
            this.calcAllStuff();
        }
    }

    public void forceAnnotToForeground() {
        if (!this.annotColorForeground) {
            this.annotColorForeground = true;
            if (!this.annotColor.equals(this.foreground)) {
                this.calcAllStuff();
            }
        }
    }

    public Color getLabelColor() {
        return this.labelColorForeground ? this.foreground : this.labelColor;
    }

    public void setLabelColor(Color labelColor) {
        this.labelColorForeground = false;
        if (!this.labelColor.equals(labelColor)) {
            this.labelColor = labelColor;
            this.calcAllStuff();
        }
    }

    public void forceLabelToForeground() {
        if (!this.labelColorForeground) {
            this.labelColorForeground = true;
            if (!this.labelColor.equals(this.foreground)) {
                this.calcAllStuff();
            }
        }
    }

    public Color getHotValueColor() {
        return this.hotValueColorForeground ? this.foreground : this.hotValueColor;
    }

    public void setHotValueColor(Color hotValueColor) {
        this.hotValueColorForeground = false;
        if (!this.hotValueColor.equals(hotValueColor)) {
            this.hotValueColor = hotValueColor;
            this.calcAllStuff();
        }
    }

    public void forceHotValueToForeground() {
        if (!this.hotValueColorForeground) {
            this.hotValueColorForeground = true;
            if (!this.hotValueColor.equals(this.foreground)) {
                this.calcAllStuff();
            }
        }
    }

    public Font getAnnotFont() {
        return this.annotFont;
    }

    public void setAnnotFont(Font annotFont) {
        if (!this.annotFont.equals(annotFont)) {
            this.annotFont = annotFont;
            this.calcAllStuff();
        }
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font labelFont) {
        if (!this.labelFont.equals(labelFont)) {
            this.labelFont = labelFont;
            this.calcAllStuff();
        }
    }

    public int getMinDecimalsToDisplay() {
        return this.minDecimalsToDisplay;
    }

    public void setMinDecimalsToDisplay(int minDecimalsToDisplay) {
        this.minDecimalsToDisplay = minDecimalsToDisplay;
        this.decimalsToDisplay = minDecimalsToDisplay;
        this.calcAllStuff();
    }

    public int getDecimalsToDisplay() {
        return this.decimalsToDisplay;
    }

    public int getExponentSize() {
        return this.exponentSize;
    }

    public void setExponentSize(int value) {
        this.exponentSize = value;
        this.calcAllStuff();
    }

    public boolean getDecimalsFixed() {
        return this.isDecimalsFixed;
    }

    public void setDecimalsFixed() {
        this.isDecimalsFixed = true;
        this.calcAllStuff();
    }

    public void clearDecimalsFixed() {
        this.isDecimalsFixed = false;
        this.calcAllStuff();
    }

    public boolean getDiscardTrailingZeroes() {
        return this.isDiscardTrailingZeroes;
    }

    public void setDiscardTrailingZeroes() {
        this.isDiscardTrailingZeroes = true;
        this.calcAllStuff();
    }

    public void clearDiscardTrailingZeroes() {
        this.isDiscardTrailingZeroes = false;
        this.calcAllStuff();
    }

    public int getAnnotOrientation() {
        return this.annotOrientation;
    }

    public void setAnnotOrientation(int annotOrientation) {
        this.annotOrientation = annotOrientation;
        this.setGraphicRelatedAnnotOrientation();
        this.setAxisRelatedAnnotOrientation();
        this.calcAllStuff();
    }

    public void setAnnotMinimalGap(double annotMinimalGap) {
        this.annotMinimalGap = annotMinimalGap;
        this.calcAllStuff();
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
        if (this.labelOrientation == 3) {
            this.calcAllStuff();
        }
    }

    public int getLabelLocation() {
        return this.labelLocation;
    }

    public void setLabelLocation(int labelLocation) {
        this.labelLocation = labelLocation;
        this.calcAllStuff();
    }

    public int getLabelOrientation() {
        return this.labelOrientation;
    }

    public void setLabelOrientation(int labelOrientation) {
        this.labelOrientation = labelOrientation;
        this.setGraphicRelatedLabelOrientation();
        this.setAxisRelatedLabelOrientation();
        this.calcAllStuff();
    }

    public int getLabelAlignment() {
        return this.labelAlignment;
    }

    public void setLabelAlignment(int labelAlignment) {
        double alignment = this.labelAlignment;
        switch (labelAlignment) {
            case 0: {
                this.labelAlignment = 0;
                alignment = 0.0;
                break;
            }
            case 1: {
                this.labelAlignment = 1;
                alignment = 1.0;
                break;
            }
            case 2: {
                this.labelAlignment = 2;
                alignment = 0.5;
            }
        }
        this.setLabelAlignmentCoefficient(alignment, false);
        this.calcAllStuff();
    }

    public double getLabelAlignmentCoefficient() {
        return this.labelAlignmentCoefficient;
    }

    public void setLabelAlignmentCoefficient(double labelAlignmentCoefficient) {
        this.setLabelAlignmentCoefficient(labelAlignmentCoefficient, true);
    }

    public double getSmallTickDensity() {
        return this.smallTickDensity;
    }

    public void setSmallTickDensity(int smallTickDensity) {
        this.smallTickDensity = smallTickDensity;
        this.calcAllStuff();
    }

    public double getBigTickDensity() {
        return this.bigTickDensity;
    }

    public void setBigTickDensity(int bigTickDensity) {
        this.bigTickDensity = bigTickDensity;
        this.calcAllStuff();
    }

    public double getAnnotDensity() {
        return this.annotDensity;
    }

    public void setAnnotDensity(int annotDensity) {
        this.annotDensity = annotDensity;
        this.calcAllStuff();
    }

    public boolean getDrawMarginValues() {
        return this.get_DrawMarginValues();
    }

    public void setDrawMarginValues() {
        if (!this.drawMarginValues) {
            this.drawMarginValues = true;
            this.drawStartMarginValue = true;
            this.drawEndMarginValue = true;
            this.calcAllStuff();
        }
    }

    public void clearDrawMarginValues() {
        if (this.drawMarginValues) {
            this.drawMarginValues = false;
            this.drawStartMarginValue = false;
            this.drawEndMarginValue = false;
            this.calcAllStuff();
        }
    }

    public boolean getDrawStartMarginValue() {
        return this.get_DrawStartMarginValue();
    }

    public void setDrawStartMarginValue() {
        if (!this.drawStartMarginValue) {
            this.drawStartMarginValue = true;
            if (this.drawEndMarginValue) {
                this.drawMarginValues = true;
            }
            this.calcAllStuff();
        }
    }

    public void clearDrawStartMarginValue() {
        if (this.drawStartMarginValue) {
            this.drawStartMarginValue = false;
            this.drawMarginValues = false;
            this.calcAllStuff();
        }
    }

    public boolean getDrawEndMarginValue() {
        return this.get_DrawEndMarginValue();
    }

    public void setDrawEndMarginValue() {
        if (!this.drawEndMarginValue) {
            this.drawEndMarginValue = true;
            if (this.drawStartMarginValue) {
                this.drawMarginValues = true;
            }
            this.calcAllStuff();
        }
    }

    public void clearDrawEndMarginValue() {
        if (this.drawEndMarginValue) {
            this.drawEndMarginValue = false;
            this.drawMarginValues = false;
            this.calcAllStuff();
        }
    }

    protected void setLabelAlignment(double labelAlignmentCoefficient) {
        if (this.labelAlignment >= 0 && this.labelAlignment <= 1) {
            this.setLabelAlignmentCoefficient(labelAlignmentCoefficient, false);
            this.labelAlignment = 3;
            switch ((int)Math.round(2.0 * labelAlignmentCoefficient)) {
                case 0: {
                    this.labelAlignment = 0;
                    break;
                }
                case 1: {
                    this.labelAlignment = 2;
                    break;
                }
                case 2: {
                    this.labelAlignment = 1;
                }
            }
            this.calcAllStuff();
        }
    }

    public boolean getIntegerValuesFlag() {
        return this.isInteger;
    }

    public void setIntegerValuesFlag() {
        this.isInteger = true;
        this.calcAllStuff();
    }

    public void clearIntegerValuesFlag() {
        this.isInteger = false;
        this.calcAllStuff();
    }

    public boolean getScientificValuesFlag() {
        return this.isScientific;
    }

    public void setScientificValuesFlag() {
        this.isScientific = true;
        this.calcAllStuff();
    }

    public void clearScientificValuesFlag() {
        this.isScientific = false;
        this.calcAllStuff();
    }

    public int getX(int offset) {
        int xCoordinate = 0;
        switch (this.axisDirection) {
            case 0: {
                xCoordinate = this.xStart + offset;
                break;
            }
            case 1: {
                xCoordinate = this.xStart;
                break;
            }
            case 2: {
                xCoordinate = this.xStart - offset;
                break;
            }
            case 3: {
                xCoordinate = this.xStart;
            }
        }
        return xCoordinate;
    }

    public int getY(int offset) {
        int yCoordinate = 0;
        switch (this.axisDirection) {
            case 0: {
                yCoordinate = this.yStart;
                break;
            }
            case 1: {
                yCoordinate = this.yStart - offset;
                break;
            }
            case 2: {
                yCoordinate = this.yStart;
                break;
            }
            case 3: {
                yCoordinate = this.yStart + offset;
            }
        }
        return yCoordinate;
    }

    public int getFirstTickOffset() {
        this.indexOfAnyTick = 0;
        return this.getNextTickOffset();
    }

    public int getNextTickOffset() {
        int offset = -1;
        if (this.isTickPresent && (this.totalSmallTicks > 0 || this.totalBigTicks > 0)) {
            while (this.indexOfAnyTick < this.annotations.size()) {
                Annotation annotation = (Annotation)this.annotations.elementAt(this.indexOfAnyTick);
                if (annotation.isSmallTick || annotation.isBigTick) break;
                ++this.indexOfAnyTick;
            }
            if (this.indexOfAnyTick < this.annotations.size()) {
                offset = ((Annotation)this.annotations.elementAt((int)this.indexOfAnyTick)).offset;
                ++this.indexOfAnyTick;
            }
        }
        return offset;
    }

    public int getFirstBigTickOffset() {
        this.indexOfBigTick = 0;
        return this.getNextBigTickOffset();
    }

    public int getNextBigTickOffset() {
        int offset = -1;
        if (this.isTickPresent && this.totalBigTicks > 0) {
            while (this.indexOfBigTick < this.annotations.size()) {
                Annotation annotation = (Annotation)this.annotations.elementAt(this.indexOfBigTick);
                if (annotation.isBigTick) break;
                ++this.indexOfBigTick;
            }
            if (this.indexOfBigTick < this.annotations.size()) {
                offset = ((Annotation)this.annotations.elementAt((int)this.indexOfBigTick)).offset;
                ++this.indexOfBigTick;
            }
        }
        return offset;
    }

    public void disableLabel() {
        this.isLabelPresent = false;
    }

    public void enableLabel() {
        this.isLabelPresent = true;
    }

    public boolean isLabelPresent() {
        return this.isLabelPresent;
    }

    public boolean isLabelVisible() {
        return this.isLabelVisible;
    }

    public void setLabelVisible(boolean flag) {
        this.isLabelVisible = flag;
    }

    public void setLabelTransparency(double value) {
        this.labelTransparency = value;
    }

    public void disableAnnot() {
        this.isAnnotPresent = false;
    }

    public void enableAnnot() {
        this.isAnnotPresent = true;
    }

    public boolean isAnnotPresent() {
        return this.isAnnotPresent;
    }

    public boolean isAnnotVisible() {
        return this.isAnnotVisible;
    }

    public void setAnnotVisible(boolean flag) {
        this.isAnnotVisible = flag;
    }

    public void disableTicks() {
        this.isTickPresent = false;
    }

    public void enableTicks() {
        this.isTickPresent = true;
    }

    public boolean isTickPresent() {
        return this.isTickPresent;
    }

    public boolean isTickVisible() {
        return this.isTickVisible;
    }

    public void setTickVisible(boolean flag) {
        this.isTickVisible = flag;
    }

    public void setUseOnlyHotValues(boolean flag) {
        this.useOnlyHotValues = flag;
    }

    protected double averageAnnotSizeAlongAxis() {
        double averageSize = this.annotSizeAlongAxis(this.getMinValue());
        if (!this.isFixedAnnotSizeAlongAxis()) {
            averageSize = (averageSize + (double)this.annotSizeAlongAxis(this.getMaxValue())) / 8.0;
        }
        return averageSize;
    }

    protected void drawAxis() {
        Color prevColor = this.gb.g.getColor();
        this.gb.g.setColor(this.getAxisColor());
        this.gb.g.drawLine(this.xStart, this.yStart, this.xEnd, this.yEnd);
        this.gb.g.setColor(prevColor);
    }

    protected void drawAnnotations() {
        if (this.isAnnotVisible && this.totalAnnotNumbers > 0) {
            int ind = 0;
            while (ind < this.annotations.size()) {
                Annotation annotation = (Annotation)this.annotations.elementAt(ind);
                if (annotation.isAnnotNumber) {
                    this.drawAnnotation(annotation);
                }
                ++ind;
            }
        }
    }

    protected void drawAnnotation(Annotation annotation) {
        this.drawAnnotString(this.getAnnotationString(annotation), annotation.offset, annotation.color);
    }

    protected void drawSmallTicks() {
        if (this.isTickPresent && this.isTickVisible && this.totalSmallTicks > 0) {
            int ind = 0;
            while (ind < this.annotations.size()) {
                Annotation annotation = (Annotation)this.annotations.elementAt(ind);
                if (annotation.isSmallTick) {
                    this.drawSmallTick(annotation.offset, annotation.color);
                }
                ++ind;
            }
        }
    }

    protected void drawBigTicks() {
        if (this.isTickPresent && this.isTickVisible && this.totalBigTicks > 0) {
            int ind = 0;
            while (ind < this.annotations.size()) {
                Annotation annotation = (Annotation)this.annotations.elementAt(ind);
                if (annotation.isBigTick) {
                    this.drawBigTick(annotation.offset, annotation.color);
                }
                ++ind;
            }
        }
    }

    protected void drawSmallTick(int offset, Color color) {
        if (this.isTickPresent && this.isTickVisible) {
            this.drawTick(offset, 3, color);
        }
    }

    protected void drawBigTick(int offset, Color color) {
        if (this.isTickPresent && this.isTickVisible) {
            this.drawTick(offset, 6, color);
        }
    }

    protected boolean isFixedAnnotSizeAlongAxis() {
        return this.axisRelatedAnnotOrientation == 1;
    }

    protected int annotSizeAlongAxis(double annotation) {
        if (!this.isAnnotPresent) {
            return 0;
        }
        return this.stringItemSizeAlongAxis(this.getAnnotationString(annotation), this.annotFont, this.axisRelatedAnnotOrientation);
    }

    protected int annotSizeAlongAxis(Annotation annotation) {
        if (!this.isAnnotPresent) {
            return 0;
        }
        return this.stringItemSizeAlongAxis(this.getAnnotationString(annotation), this.annotFont, this.axisRelatedAnnotOrientation);
    }

    protected int annotSizeAcrossAxis(double annotation) {
        if (!this.isAnnotPresent) {
            return 0;
        }
        return this.stringItemSizeAcrossAxis(this.getAnnotationString(annotation), this.annotFont, this.axisRelatedAnnotOrientation);
    }

    protected int annotSizeAcrossAxis(Annotation annotation) {
        if (!this.isAnnotPresent) {
            return 0;
        }
        return this.stringItemSizeAcrossAxis(this.getAnnotationString(annotation), this.annotFont, this.axisRelatedAnnotOrientation);
    }

    protected int annotSizeAcrossAxis() {
        int sizeAcrossAxis = Math.max(this.annotSizeAcrossAxis(this.getMaxValue()), this.annotSizeAcrossAxis(this.getMinValue()));
        int i = 0;
        while (i < this.annotStrings.size()) {
            sizeAcrossAxis = Math.max(sizeAcrossAxis, this.stringItemSizeAcrossAxis((String)this.annotStrings.elementAt(i), this.annotFont, this.axisRelatedAnnotOrientation));
            ++i;
        }
        return sizeAcrossAxis;
    }

    protected int labelSizeAlongAxis() {
        if (!this.isLabelPresent || this.label.length() == 0) {
            return 0;
        }
        return this.stringItemSizeAlongAxis(this.label, this.labelFont, this.axisRelatedLabelOrientation);
    }

    protected int labelSizeAcrossAxis() {
        if (!this.isLabelPresent || this.label.length() == 0) {
            return 0;
        }
        return this.stringItemSizeAcrossAxis(this.label, this.labelFont, this.axisRelatedLabelOrientation);
    }

    protected int annotSymbolSizeAlongAxis() {
        return this.stringItemSizeAlongAxis("9", this.annotFont, this.axisRelatedAnnotOrientation);
    }

    protected int annotSymbolSizeAcrossAxis() {
        return this.stringItemSizeAcrossAxis("9", this.annotFont, this.axisRelatedAnnotOrientation);
    }

    protected void drawAnnotString(String annotation, int offset, Color color) {
        if (!this.isAnnotPresent) {
            return;
        }
        int xS = this.getX(offset) + this.xTickVector * this.getSizeAcrossAxisUptoAnnot();
        int yS = this.getY(offset) + this.yTickVector * this.getSizeAcrossAxisUptoAnnot();
        Font prevFont = this.gb.g.getFont();
        Color prevColor = this.gb.g.getColor();
        this.gb.g.setFont(this.annotFont);
        if (color == null) {
            this.gb.g.setColor(this.getAnnotColor());
        } else {
            this.gb.g.setColor(color);
        }
        int height = this.gb.g.getFontMetrics().getHeight() - this.gb.g.getFontMetrics().getLeading();
        int width = this.gb.g.getFontMetrics().stringWidth(annotation);
        if (this.graphicRelatedAnnotOrientation == 0) {
            if (this.axisDirection == 0 || this.axisDirection == 2) {
                xS -= width / 2;
                yS = this.yTickVector == -1 ? (yS -= this.gb.g.getFontMetrics().getDescent()) : (yS += this.gb.g.getFontMetrics().getAscent());
            } else {
                if (this.xTickVector == -1) {
                    xS -= width;
                }
                yS = yS + this.gb.g.getFontMetrics().getAscent() / 2 - 1;
            }
            this.gb.g.drawString(annotation, xS, yS);
        } else {
            if (this.axisDirection == 0 || this.axisDirection == 2) {
                xS -= height / 2;
                if (this.yTickVector == -1) {
                    yS -= width;
                }
            } else {
                if (this.xTickVector == -1) {
                    xS -= height;
                }
                yS -= width / 2;
            }
            this.verticalStr.setFont(this.annotFont);
            this.verticalStr.setColor(this.getAnnotColor());
            this.verticalStr.drawString(annotation, xS, yS);
        }
        this.gb.g.setColor(prevColor);
        this.gb.g.setFont(prevFont);
    }

    public void drawLabel() {
        if (!this.isLabelPresent || this.label.trim().equals("")) {
            return;
        }
        int xLabel = this.xStart + this.xTickVector * this.getSizeAcrossAxisUptoLabel();
        int yLabel = this.yStart + this.yTickVector * this.getSizeAcrossAxisUptoLabel();
        Graphics2D g = (Graphics2D)this.gb.g;
        Font prevFont = this.gb.g.getFont();
        Color prevColor = this.gb.g.getColor();
        this.gb.g.setFont(this.labelFont);
        this.gb.g.setColor(this.getLabelColor());
        Composite prevComposite = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, (float)this.labelTransparency));
        int height = this.gb.g.getFontMetrics().getHeight() - this.gb.g.getFontMetrics().getLeading();
        int width = this.gb.g.getFontMetrics().stringWidth(this.label);
        int adjusting = this.gb.g.getFontMetrics().getAscent() + this.gb.g.getFontMetrics().getLeading();
        if (this.labelLocation == 0 || this.labelLocation == 1) {
            int labelDirection;
            int n = labelDirection = this.labelLocation == 0 ? 1 : -1;
            if (this.graphicRelatedLabelOrientation == 0) {
                if (this.axisDirection == 0 || this.axisDirection == 2) {
                    if (this.xAxisVector == -1) {
                        xLabel -= width;
                    }
                    xLabel = (int)((double)xLabel + (double)this.xAxisVector * this.labelAlignmentCoefficient * (double)(this.length - width));
                    if (this.labelLocation == 1) {
                        yLabel = this.yStart - this.yTickVector;
                    }
                    yLabel = this.yTickVector != labelDirection ? (yLabel -= this.gb.g.getFontMetrics().getDescent()) : yLabel + this.gb.g.getFontMetrics().getAscent() - (int)(0.75 * (double)adjusting);
                } else {
                    if (this.labelLocation == 1) {
                        xLabel = this.xStart - this.xTickVector;
                    }
                    if (this.xTickVector != labelDirection) {
                        xLabel -= width;
                    }
                    if (this.yAxisVector == -1) {
                        yLabel -= height;
                    }
                    yLabel += this.gb.g.getFontMetrics().getAscent();
                    yLabel = (int)((double)yLabel + (double)this.yAxisVector * this.labelAlignmentCoefficient * (double)(this.length - height));
                }
                this.gb.g.drawString(this.label, xLabel, yLabel);
            } else {
                if (this.axisDirection == 0 || this.axisDirection == 2) {
                    if (this.xAxisVector == -1) {
                        xLabel -= height;
                    }
                    xLabel = (int)((double)xLabel + (double)this.xAxisVector * this.labelAlignmentCoefficient * (double)(this.length - height));
                    if (this.labelLocation == 1) {
                        yLabel = this.yStart - this.yTickVector;
                    }
                    if (this.yTickVector != labelDirection) {
                        yLabel -= width;
                    }
                } else {
                    if (this.labelLocation == 1) {
                        xLabel = this.xStart - this.xTickVector;
                    }
                    xLabel = this.xTickVector != labelDirection ? (xLabel -= height) : (xLabel -= adjusting);
                    if (this.yAxisVector == -1) {
                        yLabel -= width;
                    }
                    yLabel = (int)((double)yLabel + (double)this.yAxisVector * this.labelAlignmentCoefficient * (double)(this.length - width));
                }
                this.verticalStr.setFont(this.labelFont);
                this.verticalStr.setColor(this.getLabelColor());
                this.verticalStr.drawString(this.label, xLabel, yLabel);
            }
        } else {
            int labelDirection = this.labelLocation == 3 ? 1 : -1;
            xLabel = this.xStart - this.xAxisVector * 3;
            yLabel = this.yStart - this.yAxisVector * 3;
            if (this.graphicRelatedLabelOrientation == 0) {
                if (this.axisDirection == 0 || this.axisDirection == 2) {
                    if (this.labelLocation == 3) {
                        xLabel += this.xAxisVector * (3 + this.length + 3);
                    }
                    if (this.xAxisVector != labelDirection) {
                        xLabel -= width;
                    }
                    if (this.yTickVector == -1) {
                        yLabel -= height;
                    }
                    yLabel += this.gb.g.getFontMetrics().getAscent();
                    yLabel = (int)((double)yLabel - (double)this.yTickVector * this.labelAlignmentCoefficient * (double)height);
                } else {
                    if (this.labelLocation == 3) {
                        yLabel += this.yAxisVector * (3 + this.length + 3);
                    }
                    yLabel = this.yAxisVector != labelDirection ? (yLabel -= this.gb.g.getFontMetrics().getDescent()) : (yLabel += this.gb.g.getFontMetrics().getAscent());
                    if (this.xTickVector == -1) {
                        xLabel -= width;
                    }
                    xLabel = (int)((double)xLabel - (double)this.xTickVector * this.labelAlignmentCoefficient * (double)width);
                }
                this.gb.g.drawString(this.label, xLabel, yLabel);
            } else {
                if (this.axisDirection == 0 || this.axisDirection == 2) {
                    if (this.labelLocation == 3) {
                        xLabel += this.xAxisVector * (3 + this.length + 3);
                    }
                    if (this.xAxisVector != labelDirection) {
                        xLabel -= height;
                    }
                    if (this.yTickVector == -1) {
                        yLabel -= width;
                    }
                    yLabel = (int)((double)yLabel - (double)this.yTickVector * this.labelAlignmentCoefficient * (double)width);
                } else {
                    if (this.labelLocation == 3) {
                        yLabel += this.yAxisVector * (3 + this.length + 3);
                    }
                    if (this.yAxisVector != labelDirection) {
                        yLabel -= width;
                    }
                    if (this.xTickVector == -1) {
                        xLabel -= height;
                    }
                    xLabel = (int)((double)xLabel - (double)this.xTickVector * this.labelAlignmentCoefficient * (double)height);
                }
                this.verticalStr.setFont(this.labelFont);
                this.verticalStr.setColor(this.getLabelColor());
                this.verticalStr.drawString(this.label, xLabel, yLabel);
            }
        }
        this.gb.g.setColor(prevColor);
        this.gb.g.setFont(prevFont);
        g.setComposite(prevComposite);
    }

    protected void startAnnotationProcess() {
        this.annotations = null;
        this.annotations = new Vector(20, 10);
        this.totalAnnotations = 0;
        this.totalAnnotNumbers = 0;
        this.totalBigTicks = 0;
        this.totalSmallTicks = 0;
        this.totalAnnotNumberLength = 0;
        this.totalBigTickLength = 0;
        this.totalSmallTickLength = 0;
    }

    protected abstract void startFirstLayout();

    protected abstract void startNextLayout();

    protected abstract boolean forceThisLayout();

    protected abstract Annotation getNextAnnotation();

    protected void calcAnnotationLayout() {
        boolean result = false;
        boolean isStartMarginStandAlone = false;
        boolean isEndMarginStandAlone = false;
        boolean needToCheckOverlappingWithStart = false;
        boolean dontTroubleIt = false;
        int prevIndexOfHigherPriorAnnot = -1;
        double smallValue = 1.0E-10 * Math.min(Math.abs(this.getMinValue()), Math.abs(this.getMaxValue()));
        if (smallValue == 0.0) {
            smallValue = 1.0E-10 * Math.max(Math.abs(this.getMinValue()), Math.abs(this.getMaxValue()));
        }
        this.startFirstLayout();
        while (!result) {
            Annotation annotation;
            this.reFillHotValues();
            this.decimalsToDisplay = this.minDecimalsToDisplay;
            isStartMarginStandAlone = false;
            isEndMarginStandAlone = false;
            needToCheckOverlappingWithStart = false;
            int totalQty = 0;
            int totalAnnotNumberQty = 0;
            result = true;
            prevIndexOfHigherPriorAnnot = -1;
            while ((annotation = this.getNextAnnotation()) != null && result) {
                int prevAnnot;
                if (this.useOnlyHotValues) {
                    annotation.isAnnotNumber = false;
                    annotation.annotStr = null;
                }
                if (!annotation.isAnnotNumber && !annotation.isSmallTick && !annotation.isBigTick || annotation.offset < 0 || annotation.offset >= this.length) continue;
                if (this.forceThisLayout()) {
                    this.addAnnotation(annotation);
                    continue;
                }
                if (totalAnnotNumberQty >= 2) {
                    needToCheckOverlappingWithStart = false;
                }
                dontTroubleIt = false;
                if (!this.useOnlyHotValues && totalQty == 0) {
                    if (this.isAnnotPresent && this.get_DrawStartMarginValue()) {
                        isStartMarginStandAlone = !ExtMath.areClose(annotation.number, this.get_StartValue()) || !annotation.isAnnotNumber;
                    }
                    needToCheckOverlappingWithStart = isStartMarginStandAlone;
                    if (isStartMarginStandAlone) {
                        if (!ExtMath.areClose(annotation.number, this.get_StartValue())) {
                            this.addAnnotation(new Annotation(0, this.get_StartValue(), true, false, true));
                            ++totalQty;
                            ++totalAnnotNumberQty;
                        } else {
                            annotation.offset = 0;
                            annotation.number = this.get_StartValue();
                            annotation.isAnnotNumber = true;
                            annotation.isSmallTick = false;
                            annotation.isBigTick = true;
                            dontTroubleIt = true;
                        }
                    }
                }
                if (!dontTroubleIt && Math.abs(annotation.number) < smallValue) {
                    annotation.number = 0.0;
                }
                if (annotation.offset == 18) {
                    annotation.offset = 18;
                }
                result = this.addAnnotation(annotation);
                ++totalQty;
                if (annotation.isAnnotNumber) {
                    ++totalAnnotNumberQty;
                }
                if (result) continue;
                if (annotation.priority == 0) {
                    if (needToCheckOverlappingWithStart && (annotation.isAnnotNumber || annotation.isBigTick)) {
                        if (!annotation.isAnnotNumber) {
                            if (totalQty != 2) continue;
                            result = true;
                            continue;
                        }
                        if (totalAnnotNumberQty < 2) continue;
                        if (totalAnnotNumberQty == 2 && this.isAnnotNumbersTooClose()) {
                            if (!(this.isSmallTickTooClose() || this.isBigTickTooClose() && totalQty != 2)) {
                                result = true;
                            }
                            if (this.clearAnnotNumber(totalQty - 1)) {
                                --totalQty;
                            }
                            --totalAnnotNumberQty;
                        }
                        needToCheckOverlappingWithStart = false;
                        continue;
                    }
                    prevAnnot = this.findPrevAnnotNumberInd(totalQty - 1);
                    if (prevAnnot < 0 || ((Annotation)this.annotations.elementAt((int)prevAnnot)).priority <= annotation.priority) continue;
                    if (!annotation.isAnnotNumber) {
                        if (totalQty - 1 - prevAnnot != 1) continue;
                        result = true;
                        continue;
                    }
                    if (prevAnnot == prevIndexOfHigherPriorAnnot) continue;
                    prevIndexOfHigherPriorAnnot = prevAnnot;
                    result = true;
                    if (this.clearAnnotNumber(totalQty - 1)) {
                        --totalQty;
                    }
                    --totalAnnotNumberQty;
                    continue;
                }
                if (this.isAnnotNumbersTooClose()) {
                    prevAnnot = this.findPrevAnnotNumberInd(totalQty - 1);
                    if (((Annotation)this.annotations.elementAt((int)prevAnnot)).priority > annotation.priority) {
                        if (prevAnnot == prevIndexOfHigherPriorAnnot) continue;
                        prevIndexOfHigherPriorAnnot = prevAnnot;
                        result = true;
                        if (this.clearAnnotNumber(totalQty - 1)) {
                            --totalQty;
                        }
                        --totalAnnotNumberQty;
                        continue;
                    }
                    if (((Annotation)this.annotations.elementAt((int)prevAnnot)).priority >= annotation.priority) continue;
                    if (this.clearAnnotNumber(prevAnnot)) {
                        --totalQty;
                    }
                    --totalAnnotNumberQty;
                    result = true;
                    continue;
                }
                result = true;
            }
            if (this.forceThisLayout()) continue;
            if (result && !this.useOnlyHotValues && totalQty > 0) {
                annotation = this.getAnnotation(totalQty - 1);
                if (this.isAnnotPresent && this.get_DrawEndMarginValue()) {
                    boolean bl = isEndMarginStandAlone = !annotation.isAnnotNumber || !ExtMath.areClose(annotation.number, this.get_EndValue());
                }
                if (isEndMarginStandAlone) {
                    if (ExtMath.areClose(annotation.number, this.get_EndValue())) {
                        this.setAnnotNumber(totalQty - 1, this.get_EndValue());
                        this.setBigTick(totalQty - 1);
                        this.clearSmallTick(totalQty - 1);
                    } else {
                        this.addAnnotation(new Annotation(this.length - 1, this.get_EndValue(), true, false, true));
                        ++totalQty;
                    }
                    ++totalAnnotNumberQty;
                    if (this.isAnnotNumbersTooClose()) {
                        if (totalAnnotNumberQty > 2) {
                            if (this.clearAnnotNumber(this.findPrevAnnotNumberInd(totalQty - 1))) {
                                --totalQty;
                            }
                        } else if (this.clearAnnotNumber(totalQty - 1)) {
                            --totalQty;
                        }
                        --totalAnnotNumberQty;
                    }
                }
            }
            if (result && (this.isAnnotTooThick() || this.isBigTickTooThick() || this.isSmallTickTooThick())) {
                result = false;
            }
            if (!result) {
                this.startNextLayout();
                continue;
            }
            this.addHotValuesToAnnotations();
            if (!this.useOnlyHotValues || (result = this.checkForExcessiveBigTicks())) continue;
            this.startNextLayout();
        }
    }

    protected abstract void reFillHotValues();

    private void addHotValuesToAnnotations() {
        int qtyDeleted = 0;
        int totAnnotQty = this.totalAnnotNumbers;
        int nextHotValuePriority = 10000;
        int i = 0;
        while (i < this.hotValues.size()) {
            HotValue hotValue = (HotValue)this.hotValues.elementAt(i);
            qtyDeleted += this.addHotValueToAnnotations(hotValue, nextHotValuePriority);
            --nextHotValuePriority;
            ++i;
        }
    }

    private int addHotValueToAnnotations(HotValue hotValue, int priority) {
        int qtyDeleted = 0;
        int prevIndex = -1;
        int nextIndex = -1;
        int nextAnnot = this.findNextAnnotFromOffset(hotValue.offset);
        Annotation thisAnnotation = null;
        Annotation prevAnnotation = null;
        Annotation nextAnnotation = null;
        boolean coincide = false;
        boolean isLeftClosed = false;
        boolean isRightClosed = false;
        if (nextAnnot == -1) {
            prevIndex = this.findPrevAnnotNumberInd(this.annotations.size());
            if (prevIndex >= 0) {
                prevAnnotation = (Annotation)this.annotations.elementAt(prevIndex);
            }
        } else {
            thisAnnotation = (Annotation)this.annotations.elementAt(nextAnnot);
            if (hotValue.offset == thisAnnotation.offset) {
                coincide = true;
                if (thisAnnotation.isAnnotNumber && thisAnnotation.priority >= priority) {
                    return 0;
                }
            }
            if (nextAnnot > 0 && (prevIndex = this.findPrevAnnotNumberInd(nextAnnot)) >= 0) {
                prevAnnotation = (Annotation)this.annotations.elementAt(prevIndex);
            }
            if ((nextIndex = this.findNextAnnotNumberInd(nextAnnot - (coincide ? 0 : 1))) >= 0) {
                nextAnnotation = (Annotation)this.annotations.elementAt(nextIndex);
            }
        }
        Annotation hotAnnotation = new Annotation(hotValue.offset, hotValue.number, true, true, false, priority, hotValue.str);
        hotAnnotation.setColor(this.getHotValueColor());
        if (prevAnnotation != null) {
            isLeftClosed = this.isClosedAnnot(prevAnnotation, hotAnnotation);
        }
        if (nextAnnotation != null) {
            isRightClosed = this.isClosedAnnot(hotAnnotation, nextAnnotation);
        }
        if (isLeftClosed && prevAnnotation.priority >= hotAnnotation.priority) {
            return 0;
        }
        if (isRightClosed && nextAnnotation.priority >= hotAnnotation.priority) {
            return 0;
        }
        if (coincide) {
            if (thisAnnotation.isAnnotNumber) {
                ++qtyDeleted;
            }
            this.substAnnotWith(nextAnnot, hotAnnotation);
        } else if (nextAnnot < 0) {
            this.addAnnotation(hotAnnotation);
        } else {
            this.insertAnnotation(hotAnnotation, nextAnnot);
            if (nextIndex >= 0) {
                ++nextIndex;
            }
        }
        if (isRightClosed) {
            this.clearAnnotNumber(nextIndex);
            ++qtyDeleted;
        }
        if (isLeftClosed) {
            this.clearAnnotNumber(prevIndex);
            ++qtyDeleted;
        }
        return qtyDeleted;
    }

    private int findNextAnnotFromOffset(int offset) {
        int nextAnnot = 0;
        while (nextAnnot < this.annotations.size()) {
            if (((Annotation)this.annotations.elementAt((int)nextAnnot)).offset >= offset) break;
            ++nextAnnot;
        }
        if (nextAnnot == this.annotations.size()) {
            nextAnnot = -1;
        }
        return nextAnnot;
    }

    private void substAnnotWith(int index, Annotation hotAnnotation) {
        Annotation annotation = (Annotation)this.annotations.elementAt(index);
        this.maintainCountsOnAnnotDelete(annotation);
        annotation.isAnnotNumber = true;
        annotation.number = hotAnnotation.number;
        annotation.annotStr = hotAnnotation.annotStr;
        annotation.color = hotAnnotation.color;
        this.maintainCountsOnAnnotAdd(annotation);
    }

    private void insertAnnotation(Annotation hotAnnotation, int beforeIndex) {
        this.annotations.insertElementAt(hotAnnotation, beforeIndex);
        ++this.totalAnnotations;
        this.maintainCountsOnAnnotAdd(hotAnnotation);
    }

    private void maintainCountsOnAnnotDelete(Annotation annotation) {
        if (annotation.isAnnotNumber) {
            --this.totalAnnotNumbers;
            this.totalAnnotNumberLength -= this.annotSizeAlongAxisInside(annotation);
        }
        if (annotation.isBigTick) {
            --this.totalBigTicks;
            --this.totalBigTickLength;
        }
        if (annotation.isSmallTick) {
            --this.totalSmallTicks;
            --this.totalSmallTickLength;
        }
    }

    private void maintainCountsOnAnnotAdd(Annotation annotation) {
        if (annotation.isAnnotNumber) {
            ++this.totalAnnotNumbers;
            this.totalAnnotNumberLength += this.annotSizeAlongAxisInside(annotation);
        }
        if (annotation.isBigTick) {
            ++this.totalBigTicks;
            ++this.totalBigTickLength;
        }
        if (annotation.isSmallTick) {
            ++this.totalSmallTicks;
            ++this.totalSmallTickLength;
        }
    }

    protected void clearHotValues() {
        this.hotValues = null;
        this.hotValues = new Vector(20, 10);
        this.calcAllStuff();
    }

    protected void addHotValue(HotValue hotValue) {
        this.hotValues.addElement(hotValue);
        this.calcAllStuff();
    }

    private boolean addAnnotation(Annotation annotation) {
        boolean isNotClose = true;
        this.annotations.addElement(annotation);
        ++this.totalAnnotations;
        if (annotation.isAnnotNumber) {
            this.totalAnnotNumberLength += this.annotSizeAlongAxisInside(annotation);
            ++this.totalAnnotNumbers;
            if (!this.forceThisLayout()) {
                isNotClose = this.calcDecimalsToDisplay();
            }
        }
        if (annotation.isBigTick) {
            ++this.totalBigTicks;
            ++this.totalBigTickLength;
        }
        if (annotation.isSmallTick) {
            ++this.totalSmallTicks;
            ++this.totalSmallTickLength;
        }
        if (isNotClose && !this.forceThisLayout()) {
            isNotClose = !this.isAnnotNumbersTooClose() && !this.isBigTickTooClose() && !this.isSmallTickTooClose();
        }
        return isNotClose;
    }

    private boolean calcDecimalsToDisplay() {
        int ind2;
        int ind1;
        boolean isNotClose = true;
        if (!(this.isDecimalsFixed || this.isInteger || this.isScientific || this.decimalsToDisplay >= 16 || this.annotations.size() <= 1 || (ind1 = this.findPrevAnnotNumberInd(ind2 = this.annotations.size() - 1)) < 0)) {
            Annotation annot1 = (Annotation)this.annotations.elementAt(ind1);
            Annotation annot2 = (Annotation)this.annotations.elementAt(ind2);
            if (annot1.annotStr == null && annot2.annotStr == null) {
                String annotation1 = this.getAnnotationString(annot1.number);
                String annotation2 = this.getAnnotationString(annot2.number);
                boolean expanded = false;
                while (!this.isAnnotNumbersTooClose(ind2) && annotation1.equals(annotation2) && this.decimalsToDisplay < 16) {
                    ++this.decimalsToDisplay;
                    expanded = true;
                    annotation1 = this.getAnnotationString(((Annotation)this.annotations.elementAt((int)ind1)).number);
                    annotation2 = this.getAnnotationString(((Annotation)this.annotations.elementAt((int)ind2)).number);
                }
                if (expanded) {
                    this.recalcTotalAnnotNumberLength();
                    isNotClose = !this.isAnyAnnotNumbersTooClose();
                }
            }
        }
        return isNotClose;
    }

    private void recalcTotalAnnotNumberLength() {
        int ind = 0;
        this.totalAnnotNumberLength = 0;
        while (ind < this.annotations.size()) {
            Annotation annotation = (Annotation)this.annotations.elementAt(ind);
            if (annotation.isAnnotNumber) {
                this.totalAnnotNumberLength += this.annotSizeAlongAxisInside(annotation);
            }
            ++ind;
        }
    }

    private boolean isAnyAnnotNumbersTooClose() {
        boolean isClosed = false;
        int ind = 1;
        while (!isClosed && ind < this.annotations.size()) {
            if (((Annotation)this.annotations.elementAt((int)ind)).isAnnotNumber) {
                isClosed = this.isAnnotNumbersTooClose(ind);
            }
            ++ind;
        }
        return isClosed;
    }

    private Annotation getAnnotation(int ind) {
        Annotation annotation = null;
        if (ind >= 0 && ind < this.totalAnnotations) {
            annotation = (Annotation)this.annotations.elementAt(ind);
        }
        return annotation;
    }

    private boolean isAnnotNumbersTooClose() {
        return this.isAnnotNumbersTooClose(this.totalAnnotations - 1);
    }

    private boolean isAnnotNumbersTooClose(int ind) {
        boolean isClose = false;
        if (ind > 0 && ind < this.totalAnnotations) {
            int prevInd;
            Annotation annotation2 = (Annotation)this.annotations.elementAt(ind);
            if (annotation2.isAnnotNumber && (prevInd = this.findPrevAnnotNumberInd(ind)) >= 0) {
                Annotation annotation1 = (Annotation)this.annotations.elementAt(prevInd);
                isClose = this.isClosedAnnot(annotation1, annotation2);
            }
        }
        return isClose;
    }

    private boolean isClosedAnnot(Annotation annotation1, Annotation annotation2) {
        boolean isClose = false;
        if (annotation1.offset > annotation2.offset) {
            Annotation tempAnnot = annotation1;
            annotation1 = annotation2;
            annotation2 = tempAnnot;
        }
        int annotSize1 = this.annotSizeAlongAxis(annotation1);
        int annotSize2 = this.annotSizeAlongAxis(annotation2);
        isClose = (double)annotation2.offset - (double)annotSize2 / 2.0 - 1.0 - ((double)annotation1.offset + (double)annotSize1 / 2.0 + 1.0) <= this.annotMinimalGap * (double)this.annotSymbolSizeAlongAxis();
        return isClose;
    }

    private boolean isBigTickTooClose() {
        return this.isBigTickTooClose(this.totalAnnotations - 1);
    }

    private boolean isBigTickTooClose(int ind) {
        boolean isClose = false;
        if (ind > 0 && ind < this.totalAnnotations) {
            int prevInd;
            Annotation annotation2 = (Annotation)this.annotations.elementAt(ind);
            if (annotation2.isBigTick && (prevInd = this.findPrevBigTickInd(ind)) >= 0) {
                Annotation annotation1 = (Annotation)this.annotations.elementAt(prevInd);
                isClose = (double)(annotation2.offset - annotation1.offset) <= this.bigTickMinimalGap * (double)this.bigTickThickness;
            }
        }
        return isClose;
    }

    private boolean isSmallTickTooClose() {
        return this.isSmallTickTooClose(this.totalAnnotations - 1);
    }

    private boolean isSmallTickTooClose(int ind) {
        boolean isClose = false;
        if (ind > 0 && ind < this.totalAnnotations) {
            int prevInd;
            Annotation annotation2 = (Annotation)this.annotations.elementAt(ind);
            if (annotation2.isSmallTick && (prevInd = this.findPrevSmallTickInd(ind)) >= 0) {
                Annotation annotation1 = (Annotation)this.annotations.elementAt(prevInd);
                isClose = (double)(annotation2.offset - annotation1.offset) <= this.smallTickMinimalGap * (double)this.smallTickThickness;
            }
        }
        return isClose;
    }

    private boolean clearAnnotNumber(int ind) {
        boolean isDeleted = false;
        if (ind >= 0 && ind < this.totalAnnotations) {
            Annotation annotation = (Annotation)this.annotations.elementAt(ind);
            if (annotation.isAnnotNumber) {
                this.totalAnnotNumberLength -= this.annotSizeAlongAxisInside(annotation);
                --this.totalAnnotNumbers;
                annotation.isAnnotNumber = false;
            }
            isDeleted = this.deleteIfEmpty(ind);
        }
        return isDeleted;
    }

    private void setAnnotNumber(int ind, double number) {
        if (ind >= 0 && ind < this.totalAnnotations) {
            Annotation annotation = (Annotation)this.annotations.elementAt(ind);
            if (annotation.isAnnotNumber) {
                this.totalAnnotNumberLength -= this.annotSizeAlongAxisInside(annotation);
                --this.totalAnnotNumbers;
            }
            annotation.number = number;
            annotation.isAnnotNumber = true;
            ++this.totalAnnotNumbers;
            this.totalAnnotNumberLength += this.annotSizeAlongAxisInside(annotation);
        }
    }

    private void setAnnotNumberFlag(int ind) {
        if (ind >= 0 && ind < this.totalAnnotations) {
            Annotation annotation = (Annotation)this.annotations.elementAt(ind);
            if (annotation.isAnnotNumber) {
                this.totalAnnotNumberLength -= this.annotSizeAlongAxisInside(annotation);
                --this.totalAnnotNumbers;
            }
            annotation.isAnnotNumber = true;
            ++this.totalAnnotNumbers;
            this.totalAnnotNumberLength += this.annotSizeAlongAxisInside(annotation);
        }
    }

    private boolean isSetAnnotNumber(int ind) {
        boolean isSet = false;
        if (ind >= 0 && ind < this.totalAnnotations) {
            Annotation annotation = (Annotation)this.annotations.elementAt(ind);
            isSet = annotation.isAnnotNumber;
        }
        return isSet;
    }

    private boolean clearBigTick(int ind) {
        boolean isDeleted = false;
        if (ind >= 0 && ind < this.totalAnnotations) {
            Annotation annotation = (Annotation)this.annotations.elementAt(ind);
            if (annotation.isBigTick) {
                --this.totalBigTickLength;
                --this.totalBigTicks;
                annotation.isBigTick = false;
            }
            isDeleted = this.deleteIfEmpty(ind);
        }
        return isDeleted;
    }

    private void setBigTick(int ind) {
        boolean isDeleted = false;
        if (ind >= 0 && ind < this.totalAnnotations) {
            Annotation annotation = (Annotation)this.annotations.elementAt(ind);
            if (!annotation.isBigTick) {
                ++this.totalBigTickLength;
                ++this.totalBigTicks;
                annotation.isBigTick = true;
            }
        }
    }

    private boolean isSetBigTick(int ind) {
        boolean isSet = false;
        if (ind >= 0 && ind < this.totalAnnotations) {
            Annotation annotation = (Annotation)this.annotations.elementAt(ind);
            isSet = annotation.isBigTick;
        }
        return isSet;
    }

    private boolean clearSmallTick(int ind) {
        Annotation annotation = (Annotation)this.annotations.elementAt(ind);
        if (annotation.isSmallTick) {
            --this.totalSmallTickLength;
            --this.totalSmallTicks;
            annotation.isSmallTick = false;
        }
        return this.deleteIfEmpty(ind);
    }

    private void setSmallTick(int ind) {
        boolean isDeleted = false;
        if (ind >= 0 && ind < this.totalAnnotations) {
            Annotation annotation = (Annotation)this.annotations.elementAt(ind);
            if (!annotation.isSmallTick) {
                ++this.totalSmallTickLength;
                ++this.totalSmallTicks;
                annotation.isSmallTick = true;
            }
        }
    }

    private boolean isSetSmallTick(int ind) {
        boolean isSet = false;
        if (ind >= 0 && ind < this.totalAnnotations) {
            Annotation annotation = (Annotation)this.annotations.elementAt(ind);
            isSet = annotation.isSmallTick;
        }
        return isSet;
    }

    private boolean isAnnotTooThick() {
        double coeff = (double)this.totalAnnotNumberLength / (double)this.length;
        return coeff > this.annotDensity / 100.0;
    }

    private boolean isBigTickTooThick() {
        return (double)this.totalBigTickLength / (double)this.length > this.bigTickDensity / 100.0;
    }

    private boolean isSmallTickTooThick() {
        return (double)this.totalSmallTickLength / (double)this.length > this.smallTickDensity / 100.0;
    }

    private int findPrevAnnotNumberInd(int ind) {
        int prevInd = -1;
        if (ind > 0 && ind <= this.totalAnnotations) {
            prevInd = ind - 1;
            while (prevInd >= 0) {
                Annotation annotation = (Annotation)this.annotations.elementAt(prevInd);
                if (annotation.isAnnotNumber) break;
                --prevInd;
            }
        }
        return prevInd;
    }

    private int findPrevBigTickInd(int ind) {
        int prevInd = -1;
        if (ind > 0 && ind <= this.totalAnnotations) {
            prevInd = ind - 1;
            while (prevInd >= 0) {
                Annotation annotation = (Annotation)this.annotations.elementAt(prevInd);
                if (annotation.isBigTick) break;
                --prevInd;
            }
        }
        return prevInd;
    }

    private int findPrevSmallTickInd(int ind) {
        int prevInd = -1;
        if (ind > 0 && ind <= this.totalAnnotations) {
            prevInd = ind - 1;
            while (prevInd >= 0) {
                Annotation annotation = (Annotation)this.annotations.elementAt(prevInd);
                if (annotation.isSmallTick) break;
                --prevInd;
            }
        }
        return prevInd;
    }

    private int findNextAnnotNumberInd(int ind) {
        int nextInd = -1;
        if (ind >= -1 && ind < this.totalAnnotations - 1) {
            nextInd = ind + 1;
            while (nextInd < this.totalAnnotations) {
                Annotation annotation = (Annotation)this.annotations.elementAt(nextInd);
                if (annotation.isAnnotNumber) break;
                ++nextInd;
            }
            if (nextInd == this.totalAnnotations) {
                nextInd = -1;
            }
        }
        return nextInd;
    }

    private int findNextBigTickInd(int ind) {
        int nextInd = -1;
        if (ind >= -1 && ind < this.totalAnnotations - 1) {
            nextInd = ind + 1;
            while (nextInd < this.totalAnnotations) {
                Annotation annotation = (Annotation)this.annotations.elementAt(nextInd);
                if (annotation.isBigTick) break;
                ++nextInd;
            }
            if (nextInd == this.totalAnnotations) {
                nextInd = -1;
            }
        }
        return nextInd;
    }

    private int findNextSmallTickInd(int ind) {
        int nextInd = -1;
        if (ind >= -1 && ind < this.totalAnnotations - 1) {
            nextInd = ind + 1;
            while (nextInd < this.totalAnnotations) {
                Annotation annotation = (Annotation)this.annotations.elementAt(nextInd);
                if (annotation.isSmallTick) break;
                ++nextInd;
            }
            if (nextInd == this.totalAnnotations) {
                nextInd = -1;
            }
        }
        return nextInd;
    }

    private boolean deleteIfEmpty(int ind) {
        boolean isEmpty;
        Annotation annotation = (Annotation)this.annotations.elementAt(ind);
        boolean bl = isEmpty = !annotation.isAnnotNumber && !annotation.isBigTick && !annotation.isSmallTick;
        if (isEmpty) {
            this.annotations.removeElementAt(ind);
            --this.totalAnnotations;
        }
        return isEmpty;
    }

    private void drawTick(int offset, int tickLength, Color color) {
        int xTickStart = this.getX(offset);
        int yTickStart = this.getY(offset);
        Color prevColor = this.gb.g.getColor();
        if (color == null) {
            this.gb.g.setColor(this.getTickColor());
        } else {
            this.gb.g.setColor(color);
        }
        this.gb.g.drawLine(xTickStart + this.xTickVector, yTickStart + this.yTickVector, xTickStart + this.xTickVector * tickLength, yTickStart + this.yTickVector * tickLength);
        this.gb.g.setColor(prevColor);
    }

    private int annotSizeAlongAxisInside(Annotation annotation) {
        int annotSize = this.annotSizeAlongAxis(annotation);
        return Math.min(annotation.offset + annotSize / 2, this.length - 1) - Math.max(annotation.offset - annotSize / 2, 0);
    }

    private void setGraphicRelatedAnnotOrientation() {
        this.graphicRelatedAnnotOrientation = this.setGraphicRelatedItemOrientation(this.annotOrientation);
    }

    private void setGraphicRelatedLabelOrientation() {
        this.graphicRelatedLabelOrientation = this.setGraphicRelatedItemOrientation(this.labelOrientation);
    }

    private void setAxisRelatedAnnotOrientation() {
        this.axisRelatedAnnotOrientation = this.setAxisRelatedItemOrientation(this.annotOrientation);
    }

    private void setAxisRelatedLabelOrientation() {
        this.axisRelatedLabelOrientation = this.setAxisRelatedItemOrientation(this.labelOrientation);
    }

    private int setGraphicRelatedItemOrientation(int itemOrientation) {
        int graphicRelatedItemOrientation = 0;
        switch (itemOrientation) {
            case 0: {
                graphicRelatedItemOrientation = 0;
                break;
            }
            case 1: {
                graphicRelatedItemOrientation = 1;
                break;
            }
            case 2: {
                if (this.axisDirection == 0 || this.axisDirection == 2) {
                    graphicRelatedItemOrientation = 0;
                    break;
                }
                graphicRelatedItemOrientation = 1;
                break;
            }
            case 3: {
                graphicRelatedItemOrientation = this.axisDirection == 0 || this.axisDirection == 2 ? 1 : 0;
            }
        }
        return graphicRelatedItemOrientation;
    }

    private int setAxisRelatedItemOrientation(int itemOrientation) {
        int axisRelatedItemOrientation = 0;
        switch (itemOrientation) {
            case 0: {
                if (this.axisDirection == 0 || this.axisDirection == 2) {
                    axisRelatedItemOrientation = 0;
                    break;
                }
                axisRelatedItemOrientation = 1;
                break;
            }
            case 1: {
                if (this.axisDirection == 0 || this.axisDirection == 2) {
                    axisRelatedItemOrientation = 1;
                    break;
                }
                axisRelatedItemOrientation = 0;
                break;
            }
            case 2: {
                axisRelatedItemOrientation = 0;
                break;
            }
            case 3: {
                axisRelatedItemOrientation = 1;
            }
        }
        return axisRelatedItemOrientation;
    }

    private String getAnnotationString(double annotation) {
        String strAnnotation;
        if (this.isInteger) {
            strAnnotation = Integer.toString((int)annotation);
        } else if (this.isScientific) {
            strAnnotation = FC.ScientificToString(annotation, 20, this.decimalsToDisplay, this.exponentSize);
        } else if (this.decimalsToDisplay > 0) {
            strAnnotation = !this.isDiscardTrailingZeroes ? FC.DoubleToString(annotation, 25, this.decimalsToDisplay) : FC.doubleToString(annotation, this.decimalsToDisplay, true);
            if ((strAnnotation = strAnnotation.trim()).startsWith(".")) {
                strAnnotation = "0" + strAnnotation;
            } else if (strAnnotation.startsWith("-.")) {
                strAnnotation = "-0" + strAnnotation.substring(1);
            }
        } else {
            strAnnotation = "" + Math.round(annotation);
        }
        strAnnotation = strAnnotation.trim();
        return strAnnotation;
    }

    private String getAnnotationString(Annotation annotation) {
        String strAnnotation = annotation.annotStr != null ? annotation.annotStr : this.getAnnotationString(annotation.number);
        return strAnnotation;
    }

    private void setAxisDirection(int direction, boolean fromConstructor) {
        if (fromConstructor || this.axisDirection != direction) {
            this.axisDirection = direction;
            if (!fromConstructor) {
                if (this.adjustToStartEnd) {
                    this.setStartEndMargins();
                } else if (!(direction != 0 && direction != 2 || this.axisDirection != 0 && this.axisDirection != 2)) {
                    this.xStart = this.xEnd;
                    this.xEnd = this.getX(this.length);
                } else if (!(direction != 1 && direction != 3 || this.axisDirection != 1 && this.axisDirection != 3)) {
                    this.yStart = this.yEnd;
                    this.yEnd = this.getY(this.length);
                }
            }
            this.setAxisVector();
            this.setTickVector();
            if (!fromConstructor) {
                this.calcAllStuff();
            }
        }
    }

    private void setAxisVector() {
        Point point = Draw.getScrVectorDirection(this.axisDirection);
        this.xAxisVector = point.x;
        this.yAxisVector = point.y;
    }

    private void setTickVector() {
        Point p = Draw.getScrSideVector(new Point(this.xAxisVector, this.yAxisVector), this.annotSide).getP();
        this.xTickVector = p.x;
        this.yTickVector = p.y;
    }

    private void setLabelAlignmentCoefficient(double labelAlignmentCoefficient, boolean recalculate) {
        if (labelAlignmentCoefficient >= 0.0 && labelAlignmentCoefficient <= 1.0) {
            this.labelAlignmentCoefficient = labelAlignmentCoefficient;
        }
        if (recalculate) {
            this.calcAllStuff();
        }
    }

    private int stringItemSizeAlongAxis(String stringItem, Font itemFont, int axisRelatedItemOrientation) {
        int size = 0;
        Font prevFont = this.gb.g.getFont();
        this.gb.g.setFont(itemFont);
        size = axisRelatedItemOrientation == 1 ? this.gb.g.getFontMetrics().getHeight() - this.gb.g.getFontMetrics().getLeading() - this.gb.g.getFontMetrics().getDescent() : this.gb.g.getFontMetrics().stringWidth(stringItem);
        this.gb.g.setFont(prevFont);
        return size;
    }

    private int stringItemSizeAcrossAxis(String stringItem, Font itemFont, int axisRelatedItemOrientation) {
        int size = 0;
        Font prevFont = this.gb.g.getFont();
        this.gb.g.setFont(itemFont);
        size = axisRelatedItemOrientation == 1 ? this.gb.g.getFontMetrics().stringWidth(stringItem) : this.gb.g.getFontMetrics().getHeight() - this.gb.g.getFontMetrics().getLeading();
        this.gb.g.setFont(prevFont);
        return size;
    }

    private int getSizeAcrossAxisUptoAnnot() {
        int size = 0;
        if (this.isTickPresent) {
            size += 6;
        }
        return size += 3;
    }

    private int getSizeAcrossAxisUptoLabel() {
        int size = 0;
        if (this.isTickPresent) {
            size += 6;
        }
        if (this.isAnnotPresent) {
            size += 3 + this.annotSizeAcrossAxis();
        }
        return size += 12;
    }

    private int getSizeAcrossAxis() {
        int width = this.getSizeAcrossAxisWithoutLabel();
        if (this.isLabelPresent) {
            if (this.labelLocation == 0) {
                width += 12 + this.labelSizeAcrossAxis();
            } else if (this.labelLocation == 2 || this.labelLocation == 3) {
                width = Math.max(width, (int)((double)this.labelSizeAcrossAxis() * (1.0 - this.labelAlignmentCoefficient)));
            }
        }
        return width;
    }

    private int getSizeAcrossAxisWithoutLabel() {
        int width = 0;
        if (this.isTickPresent) {
            width += 6;
        }
        if (this.isAnnotPresent) {
            width += 3 + this.annotSizeAcrossAxis();
        }
        return width;
    }

    private void setStartAdjusted() {
        int borderSide = this.getBorderSide(this.axisDirection, this.annotSide);
        if (borderSide == 0) {
            this.yStart = this.gb.size.height - this.borderMargin - this.getSizeAcrossAxis();
        } else if (borderSide == 2) {
            this.yStart = this.borderMargin + this.getSizeAcrossAxis();
        } else if (borderSide == 1) {
            this.xStart = this.gb.size.width - this.borderMargin - this.getSizeAcrossAxis();
        } else if (borderSide == 3) {
            this.xStart = this.borderMargin + this.getSizeAcrossAxis();
        }
    }

    private void setVariousOrientation() {
        this.setGraphicRelatedAnnotOrientation();
        this.setGraphicRelatedLabelOrientation();
        this.setAxisRelatedAnnotOrientation();
        this.setAxisRelatedLabelOrientation();
    }

    private void setEndPosition() {
        this.xEnd = this.getX(this.length - 1);
        this.yEnd = this.getY(this.length - 1);
    }

    private void setXStartAdjusted(int xStart) {
        if (xStart < 0) {
            this.borderMargin = -xStart - 1;
            this.adjustToBorder = true;
            if (this.axisDirection == 1) {
                this.length = this.gb.size.width - this.borderMargin;
                this.xStart = this.annotSide == 0 ? this.gb.size.width - this.borderMargin : this.borderMargin;
            } else if (this.axisDirection == 3) {
                this.length = this.gb.size.width - this.borderMargin;
                this.xStart = this.annotSide == 0 ? this.borderMargin : this.gb.size.width - this.borderMargin;
            } else {
                this.xStart = 0;
                this.borderMargin = 0;
                this.adjustToBorder = false;
            }
        } else {
            this.xStart = xStart;
        }
    }

    private void setYStartAdjusted(int yStart) {
        if (yStart < 0) {
            this.borderMargin = -yStart - 1;
            this.adjustToBorder = true;
            if (this.axisDirection == 0) {
                this.length = this.gb.size.height - this.borderMargin;
                this.yStart = this.annotSide == 0 ? this.gb.size.height - this.borderMargin : this.borderMargin;
            } else if (this.axisDirection == 2) {
                this.length = this.gb.size.height - this.borderMargin;
                this.yStart = this.annotSide == 0 ? this.borderMargin : this.gb.size.height - this.borderMargin;
            } else {
                this.yStart = 0;
                this.borderMargin = 0;
                this.adjustToBorder = false;
            }
        } else {
            this.yStart = yStart;
        }
    }

    private int getBorderSide(int direction, int annotSide) {
        int borderSide = 0;
        if (direction == 0) {
            borderSide = annotSide == 1 ? 2 : 0;
        } else if (direction == 2) {
            borderSide = annotSide == 1 ? 0 : 2;
        } else if (direction == 1) {
            borderSide = annotSide == 1 ? 3 : 1;
        } else if (direction == 3) {
            borderSide = annotSide == 1 ? 1 : 3;
        }
        return borderSide;
    }

    private void setStartEndMargins() {
        this.setStartEndMargins(this.startMargin, this.endMargin, true);
    }

    private void setStartEndMargins(int startMargin, int endMargin, boolean internalCall) {
        int height = this.gb.size.height;
        int width = this.gb.size.width;
        switch (this.axisDirection) {
            case 0: {
                this.length = width - startMargin - endMargin;
                this.xStart = startMargin;
                break;
            }
            case 2: {
                this.length = width - startMargin - endMargin;
                this.xStart = width - startMargin;
                break;
            }
            case 1: {
                this.length = height - startMargin - endMargin;
                this.yStart = height - startMargin;
                break;
            }
            case 3: {
                this.length = height - startMargin - endMargin;
                this.yStart = startMargin;
            }
        }
        if (!internalCall) {
            this.setVariousOrientation();
            this.setEndPosition();
            this.startMargin = startMargin;
            this.endMargin = endMargin;
            this.calcAllStuff();
            this.adjustToStartEnd = true;
        }
    }

    private void setForeground(Color foreground, boolean forceAllItemsToForeground) {
        boolean recalc = false;
        if (!this.foreground.equals(foreground)) {
            this.foreground = foreground;
            if (this.axisColorForeground || this.tickColorForeground || this.annotColorForeground || this.labelColorForeground) {
                recalc = true;
            }
        }
        if (forceAllItemsToForeground) {
            if (!this.axisColorForeground) {
                this.axisColorForeground = true;
                recalc = true;
            }
            if (!this.tickColorForeground) {
                this.tickColorForeground = true;
                recalc = true;
            }
            if (!this.annotColorForeground) {
                this.annotColorForeground = true;
                recalc = true;
            }
            if (!this.labelColorForeground) {
                this.labelColorForeground = true;
                recalc = true;
            }
            if (!this.hotValueColorForeground) {
                this.hotValueColorForeground = true;
                recalc = true;
            }
        }
        if (recalc) {
            this.calcAllStuff();
        }
    }

    private double get_StartValue() {
        return this.startValue;
    }

    private double get_EndValue() {
        return this.endValue;
    }

    private boolean get_DrawMarginValues() {
        return this.drawMarginValues;
    }

    private boolean get_DrawStartMarginValue() {
        return this.drawStartMarginValue;
    }

    private boolean get_DrawEndMarginValue() {
        return this.drawEndMarginValue;
    }

    private void dropExcessiveBigTicks() {
        if (this.isTickPresent && this.totalBigTicks > 0) {
            int ind = 0;
            int count = 0;
            while (ind < this.annotations.size()) {
                Annotation annotation = (Annotation)this.annotations.elementAt(ind);
                if (!annotation.isBigTick || annotation.isAnnotNumber) {
                    if (count == 3) {
                        this.annotations.removeElementAt(ind - 1);
                        this.annotations.removeElementAt(ind - 3);
                        this.totalAnnotations -= 2;
                        ind -= 2;
                        count = 0;
                    }
                    count = 0;
                } else {
                    ++count;
                }
                if (count == 5) {
                    this.annotations.removeElementAt(ind);
                    this.annotations.removeElementAt(ind - 1);
                    this.annotations.removeElementAt(ind - 3);
                    this.annotations.removeElementAt(ind - 4);
                    this.totalAnnotations -= 4;
                    this.setAnnotNumberFlag(ind -= 4);
                    count = 0;
                }
                ++ind;
            }
        }
    }

    private boolean checkForExcessiveBigTicks() {
        boolean result = true;
        if (this.isTickPresent && this.totalBigTicks > 0 && this.totalSmallTicks == 0) {
            result = (double)this.totalBigTicks / (double)this.totalAnnotNumbers <= 4.0;
        }
        return result;
    }
}

