/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.graph;

import edu.uml.lgdc.fileio.FileRW;
import edu.uml.lgdc.graph.MessageWindow;
import edu.uml.lgdc.project.Console;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import org.jibble.epsgraphics.EpsGraphics2D;

public class SaveImage {
    private Frame frame;
    private String filename;
    private String path;
    private Dimension size;
    private boolean presentation = true;
    private double xScale;
    private double yScale;

    public SaveImage(Frame frame, String filename, String path, Dimension size) {
        this(frame, filename, path, size, true);
    }

    public SaveImage(Frame frame, String filename, String path, Dimension size, boolean presentation) {
        this.frame = frame;
        this.filename = filename;
        this.path = path;
        this.size = size;
        this.presentation = presentation;
    }

    public String getPath() {
        return this.path;
    }

    public void save(JComponent component) {
        this.save(component, null);
    }

    public void save(JComponent component, double xScale, double yScale) {
        this.save(component, null, xScale, yScale);
    }

    public void save(JComponent component, String defaultExt) {
        this.save(component, defaultExt, 1.0, 1.0);
    }

    public void save(JComponent component, String defaultExt, double xScale, double yScale) {
        this.xScale = xScale;
        this.yScale = yScale;
        this.saveIt(component, defaultExt);
    }

    private void saveIt(JComponent component, String defaultExt) {
        FileDialog fd = new FileDialog(this.frame, "Save picture into a file", 1);
        fd.setDirectory(this.path);
        fd.setFile(this.filename);
        fd.setVisible(true);
        this.path = fd.getDirectory();
        if (this.path == null || fd.getFile() == null) {
            return;
        }
        if (defaultExt == null) {
            defaultExt = FileRW.getExt(this.filename);
        }
        String fullFileName = new File(this.path, fd.getFile()).getPath();
        if (defaultExt != null && defaultExt.length() > 0 && FileRW.getExt(fullFileName).length() == 0) {
            fullFileName = fullFileName.charAt(fullFileName.length() - 1) != '.' ? String.valueOf(fullFileName) + "." + defaultExt : String.valueOf(fullFileName) + defaultExt;
        }
        try {
            this.createAndSave(component, this.createImage(), fullFileName, this.size);
        }
        catch (IOException ex) {
            String errMsg = "Error during creating image";
            Console.showError(errMsg);
            Console.printThreadStackTrace(ex);
            new MessageWindow(this.frame, String.valueOf(errMsg) + "\n" + ex.getMessage()).setVisible(true);
        }
    }

    protected BufferedImage createImage() {
        return new BufferedImage((int)(this.xScale * (double)this.size.width), (int)(this.yScale * (double)this.size.height), 1);
    }

    protected void createAndSave(JComponent component, BufferedImage image, String fullFileName, Dimension size) throws IOException {
        SaveImage.toFile(component, image, fullFileName, size, this.presentation);
    }

    public static void toStream(JComponent picture, BufferedImage image, Format format, Dimension size, OutputStream outputStream) throws IOException {
        SaveImage.toStream(picture, image, format, size, true, outputStream);
    }

    public static void toStream(JComponent picture, BufferedImage image, Format format, Dimension size, boolean presentation, OutputStream outputStream) throws IOException {
        Graphics g;
        if (format == Format.EPS) {
            g = new EpsGraphics2D(format.toString(), outputStream, 0, 0, size.width, size.height);
            ((EpsGraphics2D)g).setColorDepth(3);
        } else {
            g = image.getGraphics();
        }
        g.setFont(new Font("Dialog", 1, 11));
        Dimension prevCanvasSize = picture.getSize();
        picture.setSize(size);
        double xScale = (double)image.getWidth(null) / (double)size.width;
        double yScale = (double)image.getHeight(null) / (double)size.height;
        Graphics2D g2d = (Graphics2D)g;
        if (presentation && format != Format.GIF) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        if (format != Format.EPS) {
            g2d.scale(xScale, yScale);
        }
        picture.setDoubleBuffered(false);
        picture.paint(g);
        picture.setDoubleBuffered(true);
        if (format == Format.EPS) {
            ((EpsGraphics2D)g).flush();
            ((EpsGraphics2D)g).close();
        } else {
            ImageIO.write((RenderedImage)image, format.toString(), outputStream);
        }
        picture.setSize(prevCanvasSize);
    }

    public static void toFile(JComponent picture, BufferedImage image, String fullFileName, Dimension size) throws IOException {
        SaveImage.toFile(picture, image, fullFileName, size, true);
    }

    public static void toFile(JComponent picture, BufferedImage image, String fullFileName, Dimension size, boolean presentation) throws IOException {
        Format format;
        int pos = fullFileName.lastIndexOf(46);
        if (pos < 0) {
            throw new IllegalArgumentException("can't determine format, as no extension for file, " + fullFileName);
        }
        String imageFormat = fullFileName.substring(pos + 1);
        try {
            format = Format.valueOf(imageFormat.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("illegal file extension, " + imageFormat);
        }
        FilterOutputStream os = null;
        File file = new File(fullFileName);
        file.delete();
        boolean ok = false;
        try {
            os = new BufferedOutputStream(new FileOutputStream(file));
            SaveImage.toStream(picture, image, format, size, presentation, os);
            ok = true;
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException ex) {
                    Console.printThreadStackTrace(ex);
                }
            }
            if (!ok) {
                file.delete();
            }
        }
    }

    public static enum Format {
        GIF,
        PNG,
        EPS,
        JPG;

        public static final String[] FORMATS;
        public static final String FORMAT_LIST;

        static {
            FORMATS = new String[Format.values().length];
            int i = 0;
            while (i < Format.values().length) {
                Format.FORMATS[i] = Format.values()[i].ext();
                ++i;
            }
            String tmp = null;
            int i2 = 0;
            while (i2 < FORMATS.length) {
                tmp = i2 > 0 ? String.valueOf(tmp) + ", " + FORMATS[i2] : FORMATS[i2];
                ++i2;
            }
            FORMAT_LIST = tmp;
        }

        public String ext() {
            return this.toString().toLowerCase();
        }

        public static Format fromStr(String strValue, Format defaultVal) {
            Format format;
            try {
                format = Format.valueOf(strValue.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                format = defaultVal;
            }
            return format;
        }

        public static boolean isLegal(String strFormat) {
            Format[] formatArray = Format.values();
            int n = formatArray.length;
            int n2 = 0;
            while (n2 < n) {
                Format f = formatArray[n2];
                if (f.ext().equalsIgnoreCase(strFormat)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public static String checkPicFileExt(String filename, boolean admitNoExt) {
            if (filename != null) {
                int dotPos = filename.lastIndexOf(46);
                if (dotPos >= 0) {
                    String ext = filename.substring(dotPos + 1);
                    if (!Format.isLegal(ext)) {
                        return "illegal file extension for graphic file " + filename + "\nthe followinng extensions are legal: " + FORMAT_LIST;
                    }
                } else if (!admitNoExt) {
                    return "graphic file " + filename + " does not have extension";
                }
            }
            return null;
        }
    }
}

