/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.graph;

import edu.uml.lgdc.format.FC;
import edu.uml.lgdc.graph.Annotation;
import edu.uml.lgdc.graph.ColorValueLegend;
import edu.uml.lgdc.graph.FrameGraph;
import edu.uml.lgdc.graph.GraphBase;
import edu.uml.lgdc.graph.LinearAxis;
import edu.uml.lgdc.math.ExtMath;
import edu.uml.lgdc.time.TimeMeasure;
import edu.uml.lgdc.time.TimeScale;
import edu.uml.lgdc.time.TimeType;
import java.awt.Color;

public class TimeAxis
extends LinearAxis {
    public static final int TIME_MEASURE_NOT_FORCED = -1;
    public static final int ROLLOVER_DISABLED = 0;
    public static final int ROLLOVER_OUT = 1;
    public static final int ROLLOVER_MIN = 2;
    private static final int QTY_OF_TIME_MEASURES = TimeMeasure.values().length;
    private static final char hyphen = '-';
    private static final int[][] fields;
    private TimeScale start;
    private TimeScale end;
    private boolean drawMarginValues = false;
    private Color highlightingAnnot = new Color(152, 6, 116);
    private TimeMeasure annotTimeMeasure;
    private long startBaseTime;
    private long startTime;
    private long endTime;
    private double startTimeZoom;
    private double endTimeZoom;
    private int fieldNo;
    private long divisor = 1L;
    private String label = null;
    private TimeType timeType = TimeType.UT;
    private TimeMeasure timeMeasure;
    private long currStartBaseTime;
    private long currStartTime;
    private long currEndTime;
    private double currStartTimeZoom;
    private double currEndTimeZoom;
    private int currFieldNo;
    private long currDivisor = 1L;
    private double smallTickStepInValues;
    private double bigTickStepInValues;
    private double annotStepInValues;
    private double currentValue;
    private double averageAnnotSize;
    private double step;
    private int stepNo = 0;
    private int bigStepInSteps;
    private int annotStepInSteps;
    private boolean endOfValues;
    private TimeScale annotValue;
    private TimeScale saveAnnotValue;
    private double saveCurrentValue;
    private boolean startOfNextPeriod = false;
    private boolean minMarginValueIsAlreadyDrawn = false;
    private boolean maxMarginValueIsAlreadyDrawn = false;
    private boolean exactUserLabel = false;
    private int rollOverNotation = 1;
    public static final int MAX_NO_OF_HOT_VALUES = 20;
    private TimeScale[] timeHotValues;
    private int qtyOfHots = 0;
    private TimeMeasure forcedTimeMeasure;
    private boolean forceThisLayout = false;

    static {
        int[][] nArrayArray = new int[10][];
        int[] nArray = new int[4];
        nArray[0] = 14;
        nArray[1] = 1;
        nArray[2] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[4];
        nArray2[0] = 13;
        nArray2[1] = 1;
        nArray2[2] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[4];
        nArray3[0] = 12;
        nArray3[1] = 1;
        nArray3[2] = 1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[4];
        nArray4[0] = 11;
        nArray4[1] = 1;
        nArray4[2] = 1;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[4];
        nArray5[0] = 5;
        nArray5[1] = 1;
        nArray5[2] = 1;
        nArrayArray[4] = nArray5;
        nArrayArray[5] = new int[]{2, 1, 1, 1};
        int[] nArray6 = new int[4];
        nArray6[0] = 1;
        nArray6[1] = 1;
        nArray6[2] = 10;
        nArrayArray[6] = nArray6;
        int[] nArray7 = new int[4];
        nArray7[0] = 1;
        nArray7[1] = 10;
        nArray7[2] = 100;
        nArrayArray[7] = nArray7;
        int[] nArray8 = new int[4];
        nArray8[0] = 1;
        nArray8[1] = 100;
        nArray8[2] = 1000;
        nArrayArray[8] = nArray8;
        int[] nArray9 = new int[4];
        nArray9[0] = 1;
        nArray9[1] = 1000;
        nArrayArray[9] = nArray9;
        fields = nArrayArray;
    }

    public TimeAxis(FrameGraph frameGraph, int axisIndex, TimeScale startTime, TimeScale endTime) {
        this(frameGraph, axisIndex, startTime.getTimeInMinutes(), endTime.getTimeInMinutes(), "");
    }

    public TimeAxis(FrameGraph frameGraph, int axisIndex, TimeScale startTime, TimeScale endTime, String label) {
        this(frameGraph, axisIndex, startTime.getTimeInMinutes(), endTime.getTimeInMinutes(), label);
    }

    public TimeAxis(FrameGraph frameGraph, int axisIndex, double startTimeInMinutes, double endTimeInMinutes) {
        this(frameGraph, axisIndex, startTimeInMinutes, endTimeInMinutes, "");
    }

    public TimeAxis(ColorValueLegend colorValueLegend, TimeScale startTime, TimeScale endTime) {
        this(colorValueLegend, startTime.getTimeInMinutes(), endTime.getTimeInMinutes(), "");
    }

    public TimeAxis(ColorValueLegend colorValueLegend, TimeScale startTime, TimeScale endTime, String label) {
        this(colorValueLegend, startTime.getTimeInMinutes(), endTime.getTimeInMinutes(), label);
    }

    public TimeAxis(ColorValueLegend colorValueLegend, double startTimeInMinutes, double endTimeInMinutes) {
        this(colorValueLegend, startTimeInMinutes, endTimeInMinutes, "");
    }

    public TimeAxis(GraphBase gb, TimeScale startTime, TimeScale endTime) {
        this(gb, startTime.getTimeInMinutes(), endTime.getTimeInMinutes());
    }

    public TimeAxis(GraphBase gb, double startTimeInMinutes, double endTimeInMinutes) {
        this(gb, startTimeInMinutes, endTimeInMinutes, 0, 0);
    }

    public TimeAxis(GraphBase gb, TimeScale startTime, TimeScale endTime, int direction, int annotSide) {
        this(gb, startTime.getTimeInMinutes(), endTime.getTimeInMinutes(), direction, annotSide);
    }

    public TimeAxis(GraphBase gb, double startTimeInMinutes, double endTimeInMinutes, int direction, int annotSide) {
        this(gb, startTimeInMinutes, endTimeInMinutes, direction, annotSide, "");
    }

    public TimeAxis(GraphBase gb, TimeScale startTime, TimeScale endTime, int direction, int annotSide, String label) {
        this(gb, startTime.getTimeInMinutes(), endTime.getTimeInMinutes(), direction, annotSide, label);
    }

    public TimeAxis(GraphBase gb, double startTimeInMinutes, double endTimeInMinutes, int direction, int annotSide, String label) {
        this(gb, startTimeInMinutes, endTimeInMinutes, direction, annotSide, label, 0);
    }

    public TimeAxis(GraphBase gb, TimeScale startTime, TimeScale endTime, int direction, int annotSide, String label, int borderMargin) {
        this(gb, startTime.getTimeInMinutes(), endTime.getTimeInMinutes(), direction, annotSide, label, borderMargin);
    }

    public TimeAxis(GraphBase gb, double startTimeInMinutes, double endTimeInMinutes, int direction, int annotSide, String label, int borderMargin) {
        super(gb, startTimeInMinutes, endTimeInMinutes, direction, annotSide, label, borderMargin);
        this.label = label;
        this.clearHots();
        super.clearDrawMarginValues();
        this.setInitial(startTimeInMinutes, endTimeInMinutes);
    }

    public TimeAxis(GraphBase gb, TimeScale startTime, TimeScale endTime, int direction, int annotSide, String label, int xStart, int yStart, int length) {
        this(gb, startTime.getTimeInMinutes(), endTime.getTimeInMinutes(), direction, annotSide, label, xStart, yStart, length);
    }

    public TimeAxis(GraphBase gb, double startTimeInMinutes, double endTimeInMinutes, int direction, int annotSide, String label, int xStart, int yStart, int length) {
        super(gb, startTimeInMinutes, endTimeInMinutes, direction, annotSide, label, xStart, yStart, length);
        this.label = label;
        this.clearHots();
        super.clearDrawMarginValues();
        this.setInitial(startTimeInMinutes, endTimeInMinutes);
    }

    public TimeAxis(FrameGraph frameGraph, int axisIndex, double startTimeInMinutes, double endTimeInMinutes, String label) {
        super(frameGraph, axisIndex, startTimeInMinutes, endTimeInMinutes, label);
        this.label = label;
        this.clearHots();
        super.clearDrawMarginValues();
        this.setInitial(startTimeInMinutes, endTimeInMinutes);
    }

    public TimeAxis(ColorValueLegend colorValueLegend, double startTimeInMinutes, double endTimeInMinutes, String label) {
        super(colorValueLegend, startTimeInMinutes, endTimeInMinutes, label);
        this.label = label;
        this.clearHots();
        super.clearDrawMarginValues();
        this.setInitial(startTimeInMinutes, endTimeInMinutes);
    }

    @Override
    public Object clone() {
        TimeAxis cloned = null;
        cloned = (TimeAxis)super.clone();
        return cloned;
    }

    public TimeScale offsetToTime(int offset) {
        TimeScale time = null;
        double value = this.offsetToValue(offset);
        if (value != Double.MIN_VALUE || value != Double.MIN_VALUE) {
            time = this.internalAxisValueToTime(value);
        }
        return time;
    }

    public int timeToOffset(double timeInMinutes) {
        return this.valueToOffset(this.timeToInternalAxisValue(timeInMinutes));
    }

    public int timeToUnrestrictedOffset(double timeInMinutes) {
        return this.valueToUnrestrictedOffset(this.timeToInternalAxisValue(timeInMinutes));
    }

    @Override
    public double getStartValue() {
        return this.getStartTime().getTimeInMinutes();
    }

    @Override
    public void setStartValue(double startTimeInMinutes) {
        this.setInitial(startTimeInMinutes, this.end.getTimeInMinutes());
    }

    public TimeScale getStartTime() {
        return this.offsetToTime(0);
    }

    public void setStartTime(TimeScale startTime) {
        this.setInitial(startTime.getTimeInMinutes(), this.end.getTimeInMinutes());
    }

    @Override
    public double getEndValue() {
        return this.getEndTime().getTimeInMinutes();
    }

    @Override
    public void setEndValue(double endTimeInMinutes) {
        this.setInitial(this.start.getTimeInMinutes(), endTimeInMinutes);
    }

    public TimeScale getEndTime() {
        return this.offsetToTime(this.length - 1);
    }

    public void setEndTime(TimeScale endTime) {
        this.setInitial(this.start.getTimeInMinutes(), endTime.getTimeInMinutes());
    }

    public void setTimeInterval(TimeScale startTime, TimeScale endTime) {
        this.setInitial(startTime.getTimeInMinutes(), endTime.getTimeInMinutes());
    }

    public void setTimeInterval(double startTimeInMinutes, double endTimeInMinutes) {
        this.setInitial(startTimeInMinutes, endTimeInMinutes);
    }

    public void setTimeType(TimeType timeType) {
        if (timeType != null && timeType != this.timeType) {
            this.timeType = timeType;
            if (this.label != null && !this.exactUserLabel) {
                this.appendLabel(this.label);
            }
        }
    }

    public void appendLabel(String label) {
        this.exactUserLabel = false;
        this.label = label;
        if (!label.equals("")) {
            label = String.valueOf(label) + " ";
        }
        label = String.valueOf(label) + this.getFullDefaultLabel();
        super.setLabel(label);
    }

    public String getFullDefaultLabel() {
        return this.getFullDefaultLabel(false);
    }

    public String getFullDefaultLabel(boolean dontShowDay) {
        String label = this.getDefaultLabel(dontShowDay);
        String timeRef = (Object)((Object)this.timeType) + ", " + this.timeMeasure.getName();
        label = !label.equals("") ? String.valueOf(timeRef) + " (" + label + ")" : timeRef;
        return label;
    }

    public String getAnnotTimeMeasure() {
        return this.timeMeasure.getName();
    }

    public String getDefaultLabel() {
        return this.getDefaultLabel(false);
    }

    public String getDefaultLabel(boolean dontShowDay) {
        String label = "";
        int tmpStartYear = this.start.get(1);
        int tmpStartMonth = this.start.get(2);
        int tmpStartDay = this.start.get(5);
        int tmpStartHour = this.start.get(11);
        int tmpStartMin = this.start.get(12);
        int tmpStartSec = this.start.get(13);
        int tmpStartMill = this.start.get(14);
        int tmpEndYear = this.end.get(1);
        int tmpEndMonth = this.end.get(2);
        int tmpEndDay = this.end.get(5);
        int tmpEndHour = this.end.get(11);
        int tmpEndMin = this.end.get(12);
        int tmpEndSec = this.end.get(13);
        int tmpEndMill = this.end.get(14);
        String formatStr = "";
        switch (this.timeMeasure) {
            case TM_MILLISECOND: {
                formatStr = dontShowDay ? "HH:mm:ss" : "yyyy.MM.dd HH:mm:ss";
                break;
            }
            case TM_SECOND: {
                formatStr = dontShowDay ? "HH:mm" : "yyyy.MM.dd HH:mm";
                break;
            }
            case TM_MINUTE: {
                formatStr = dontShowDay ? "HH" : "yyyy.MM.dd HH";
                break;
            }
            case TM_HOUR: {
                formatStr = "yyyy.MM.dd";
                break;
            }
            case TM_DAY: {
                formatStr = "yyyy.MM";
                break;
            }
            case TM_MONTH: {
                formatStr = "yyyy G";
                break;
            }
            case TM_YEAR: {
                tmpStartYear = 10 * (tmpStartYear / 10);
                tmpEndYear = 10 * (tmpEndYear / 10);
                formatStr = "yyyy G";
                break;
            }
            case TM_DECENNIUM: {
                tmpStartYear = 100 * (tmpStartYear / 100);
                tmpEndYear = 100 * (tmpEndYear / 100);
                formatStr = "yyyy G";
                break;
            }
            case TM_CENTENNIUM: {
                tmpStartYear = 1000 * (tmpStartYear / 1000);
                tmpEndYear = 1000 * (tmpEndYear / 1000);
                formatStr = "yyyy G";
                break;
            }
            case TM_MILLENNIUM: {
                tmpStartYear = 1000 * (tmpStartYear / 1000);
                tmpEndYear = 1000 * (tmpEndYear / 1000);
                formatStr = "yyyy G";
            }
        }
        TimeScale tmpStartTime = new TimeScale(tmpStartYear, tmpStartMonth, tmpStartDay, tmpStartHour, tmpStartMin, tmpStartSec);
        tmpStartTime.set(14, tmpStartMill);
        tmpStartTime.complete();
        TimeScale tmpEndTime = new TimeScale(tmpEndYear, tmpEndMonth, tmpEndDay, tmpEndHour, tmpEndMin, tmpEndSec);
        tmpEndTime.set(14, tmpEndMill);
        tmpEndTime.complete();
        String startTimeStr = tmpStartTime.toFormatUT(formatStr);
        String endTimeStr = tmpEndTime.toFormatUT(formatStr);
        if (!formatStr.equals("")) {
            label = startTimeStr;
            if (!startTimeStr.equals(endTimeStr) || dontShowDay) {
                label = String.valueOf(label) + " - " + endTimeStr;
            }
        }
        return label;
    }

    @Override
    public void setLabel(String label) {
        this.exactUserLabel = true;
        super.setLabel(label);
    }

    @Override
    public boolean getDrawMarginValues() {
        return this.drawMarginValues;
    }

    @Override
    public void setDrawMarginValues() {
        if (!this.drawMarginValues) {
            this.drawMarginValues = true;
            this.calcAllStuff();
        }
    }

    @Override
    public void clearDrawMarginValues() {
        if (this.drawMarginValues) {
            this.drawMarginValues = false;
            this.calcAllStuff();
        }
    }

    @Override
    public void clearHots() {
        this.qtyOfHots = 0;
        this.timeHotValues = new TimeScale[20];
        super.clearHots();
    }

    @Override
    public void addOneHot(double timeInMinutes) {
        this.addOneHot(new TimeScale(timeInMinutes));
    }

    public void addOneHot(TimeScale time) {
        if (this.qtyOfHots < 19) {
            this.timeHotValues[this.qtyOfHots] = time;
            ++this.qtyOfHots;
        }
    }

    @Override
    public void addHots(double[] timesInMinutes) {
        int i = 0;
        while (i < timesInMinutes.length) {
            this.addOneHot(timesInMinutes[i]);
            ++i;
        }
    }

    public void addHots(TimeScale[] times) {
        int i = 0;
        while (i < times.length) {
            this.addOneHot(times[i]);
            ++i;
        }
    }

    public void setRollOverNotation(int rollOverNotation) {
        if (rollOverNotation == 0 || rollOverNotation == 1 || rollOverNotation == 2) {
            this.rollOverNotation = rollOverNotation;
        }
    }

    public void forceTimeMeasure(TimeMeasure timeMeasure) {
        this.forcedTimeMeasure = timeMeasure;
        this.setInitial(this.start.getTimeInMinutes(), this.end.getTimeInMinutes());
    }

    public void setHighlightAnnot(Color color) {
        this.highlightingAnnot = color;
    }

    @Override
    protected void reFillHotValues() {
        String str = null;
        super.clearHots();
        int i = 0;
        while (i < this.qtyOfHots) {
            double number = this.timeToInternalAxisValue(this.timeHotValues[i].getTimeInMinutes());
            int offset = this.valueToOffset(number);
            if (offset >= 0) {
                if (this.timeMeasure.isLessThan(TimeMeasure.TM_YEAR) && TimeMeasure.TM_SECOND.isLessThan(this.timeMeasure) && this.rollOverNotation != 0) {
                    double value = this.timeHotValues[i].get(this.currFieldNo);
                    str = value == (double)this.timeHotValues[i].getMinimum(this.currFieldNo) ? (this.rollOverNotation == 2 ? "" + (int)Math.round(value) : this.getRollTimeString(this.timeHotValues[i])) : "" + (int)Math.round(value + (double)fields[this.timeMeasure.ordinal()][3]);
                }
                super.addOneHot(number, str);
            }
            ++i;
        }
        super.reFillHotValues();
    }

    @Override
    protected void startFirstLayout() {
        this.copyToCurrent();
        this.resetAxisValues();
        this.firstStepInValues();
        this.forceThisLayout = false;
        this.startAnnotationProcess();
        this.setBeforeStartAnyLayout();
    }

    @Override
    protected void startNextLayout() {
        if (!this.timeMeasure.isLast()) {
            if (this.annotStepInValues < (double)this.timeMeasure.getQtyInNextUnits() || this.smallTickStepInValues < this.bigTickStepInValues || this.bigStepInSteps < this.annotStepInSteps) {
                if (this.smallTickStepInValues == this.bigTickStepInValues && this.bigStepInSteps == this.annotStepInSteps) {
                    this.annotStepInSteps = ExtMath.getNextDivisor(this.timeMeasure.getQtyInNextUnits(), (int)Math.round(this.annotStepInValues));
                    this.annotStepInValues = this.annotStepInSteps;
                    this.smallTickStepInValues = 1.0;
                    this.bigTickStepInValues = this.annotStepInSteps <= 2 || this.annotStepInSteps % 2 == 1 ? this.annotStepInValues : this.annotStepInValues / 2.0;
                } else {
                    this.smallTickStepInValues = this.smallTickStepInValues < this.bigTickStepInValues ? this.bigTickStepInValues : (this.bigTickStepInValues = this.annotStepInValues);
                }
                if (this.forcedTimeMeasure != null && !(this.annotStepInValues < (double)this.timeMeasure.getQtyInNextUnits()) && !(this.smallTickStepInValues < this.bigTickStepInValues) && this.bigStepInSteps >= this.annotStepInSteps) {
                    this.forceThisLayout = true;
                }
            } else {
                this.setNextTimeMeasure();
                this.firstStepInValues();
            }
        } else if (this.smallTickStepInValues == this.bigTickStepInValues && this.bigStepInSteps == this.annotStepInSteps) {
            this.annotStepInValues *= 10.0;
            this.smallTickStepInValues = this.annotStepInValues / 10.0;
            this.bigTickStepInValues = this.annotStepInValues / 2.0;
        } else {
            this.smallTickStepInValues = this.smallTickStepInValues < this.bigTickStepInValues ? this.bigTickStepInValues : (this.bigTickStepInValues = this.annotStepInValues);
        }
        this.startAnnotationProcess();
        this.setBeforeStartAnyLayout();
    }

    @Override
    protected boolean forceThisLayout() {
        return this.forceThisLayout;
    }

    @Override
    protected Annotation getNextAnnotation() {
        Annotation annotation = null;
        long value = 0L;
        boolean thisIsMarginValue = false;
        boolean forceToDrawMarginValue = false;
        int priority = 0;
        boolean rollValue = false;
        String annotStr = null;
        Color color = null;
        if (!this.endOfValues && (this.currentValue <= super.getEndValue() || ExtMath.areClose(this.currentValue, super.getEndValue()))) {
            int offset;
            boolean isAnnotNumber;
            value = this.annotValue.get(this.currFieldNo);
            boolean isSmallTick = true;
            boolean isBigTick = this.stepNo % this.bigStepInSteps == 0;
            boolean bl = isAnnotNumber = this.stepNo % this.annotStepInSteps == 0;
            if (value == (long)this.annotValue.getMinimum(this.currFieldNo)) {
                if (this.rollOverNotation != 0) {
                    rollValue = true;
                }
                isAnnotNumber = true;
                isBigTick = true;
                priority = 1;
                this.stepNo = 0;
            }
            if (this.drawMarginValues) {
                if (!this.minMarginValueIsAlreadyDrawn) {
                    thisIsMarginValue = true;
                    if (!ExtMath.areClose(this.currentValue, super.getStartValue())) {
                        forceToDrawMarginValue = true;
                    }
                    priority = 3;
                    this.minMarginValueIsAlreadyDrawn = true;
                } else if (ExtMath.areClose(this.currentValue, super.getEndValue())) {
                    thisIsMarginValue = true;
                    priority = 2;
                    this.maxMarginValueIsAlreadyDrawn = true;
                }
                if (thisIsMarginValue) {
                    isAnnotNumber = true;
                    isBigTick = true;
                }
                if (forceToDrawMarginValue) {
                    this.saveCurrentValue = this.currentValue;
                    this.saveAnnotValue = new TimeScale(this.annotValue.getTimeInMinutes());
                    this.currentValue = super.getStartValue();
                    this.annotValue = this.start;
                    value = this.annotValue.get(this.currFieldNo);
                }
            }
            if (isBigTick) {
                isSmallTick = false;
            }
            if ((offset = Math.round(this.valueToOffset(this.currentValue))) >= this.length || this.currentValue > super.getEndValue()) {
                this.endOfValues = true;
            }
            if (TimeMeasure.TM_YEAR.isLessOrEqualThan(this.timeMeasure) || this.timeMeasure.isLessOrEqualThan(TimeMeasure.TM_SECOND) || this.rollOverNotation == 0) {
                value = (long)this.currentValue;
            } else if (rollValue) {
                if (this.rollOverNotation == 1) {
                    annotStr = this.getRollTimeString(this.annotValue);
                }
                color = this.highlightingAnnot;
            }
            annotation = new Annotation(offset, value, isAnnotNumber, isSmallTick, isBigTick, priority, annotStr, color);
            if (!forceToDrawMarginValue) {
                this.nextAnnotNumber();
            } else {
                this.currentValue = this.saveCurrentValue;
                this.annotValue = this.saveAnnotValue;
            }
        } else if (this.drawMarginValues && !this.maxMarginValueIsAlreadyDrawn) {
            this.currentValue = super.getEndValue();
            this.annotValue = new TimeScale(this.end.getTimeInMinutes());
            value = this.annotValue.get(this.currFieldNo);
            value += (long)fields[this.timeMeasure.ordinal()][3];
            if (TimeMeasure.TM_YEAR.isLessOrEqualThan(this.timeMeasure) || this.timeMeasure.isLessOrEqualThan(TimeMeasure.TM_SECOND)) {
                value = (long)this.currentValue;
            }
            annotation = new Annotation(this.length - 1, value, true, false, true, 2);
            this.maxMarginValueIsAlreadyDrawn = true;
            this.endOfValues = true;
        }
        return annotation;
    }

    private void nextAnnotNumber() {
        int fieldStep = (int)Math.round(this.step * (double)fields[this.timeMeasure.ordinal()][1]);
        if (TimeMeasure.TM_YEAR.isLessOrEqualThan(this.timeMeasure) || this.timeMeasure.isLessOrEqualThan(TimeMeasure.TM_SECOND) || this.startOfNextPeriod) {
            this.startOfNextPeriod = false;
            this.currentValue += this.step;
            ++this.stepNo;
            this.annotValue.add(this.currFieldNo, fieldStep);
        } else {
            this.saveAnnotValue = new TimeScale(this.annotValue.getTimeInMinutes());
            this.annotValue.add(this.currFieldNo, fieldStep);
            if (this.annotValue.get(this.currFieldNo) != this.annotValue.getMinimum(this.currFieldNo) && this.annotValue.get(this.currFieldNo) <= this.saveAnnotValue.get(this.currFieldNo)) {
                this.startOfNextPeriod = true;
                this.currentValue += (double)(fieldStep - (this.annotValue.get(this.currFieldNo) - this.annotValue.getMinimum(this.currFieldNo))) / (double)fieldStep;
                this.annotValue.set(this.currFieldNo, this.annotValue.getMinimum(this.currFieldNo));
            } else {
                this.currentValue += this.step;
                ++this.stepNo;
            }
        }
    }

    private void setBeforeStartAnyLayout() {
        this.startOfNextPeriod = false;
        this.minMarginValueIsAlreadyDrawn = false;
        this.maxMarginValueIsAlreadyDrawn = false;
        this.currentValue = ExtMath.closestNotLess(super.getStartValue(), this.smallTickStepInValues);
        this.annotValue = this.internalAxisValueToTime(this.currentValue);
        this.step = this.smallTickStepInValues;
        this.stepNo = (int)Math.round(this.currentValue / this.step);
        this.bigStepInSteps = (int)Math.round(this.bigTickStepInValues / this.step);
        this.annotStepInSteps = (int)Math.round(this.annotStepInValues / this.step);
        this.endOfValues = false;
    }

    /*
     * Unable to fully structure code
     */
    private void setInitial(double startTimeInMinutes, double endTimeInMinutes) {
        block3: {
            this.start = new TimeScale(startTimeInMinutes);
            this.end = new TimeScale(endTimeInMinutes);
            this.startTime = (long)(startTimeInMinutes * 60.0 * 1000.0);
            this.endTime = (long)(endTimeInMinutes * 60.0 * 1000.0);
            this.startTimeZoom = this.startTime;
            this.endTimeZoom = this.endTime;
            timeInterval = this.endTime - this.startTime;
            this.annotTimeMeasure = TimeMeasure.values()[0];
            this.divisor = 1L;
            if (this.forcedTimeMeasure != null) ** GOTO lbl21
            while (!this.annotTimeMeasure.isLast()) {
                if (!(this.annotTimeMeasure.ordinal() < TimeAxis.QTY_OF_TIME_MEASURES - 2 && timeInterval / (long)this.annotTimeMeasure.getQtyInNextUnits() < (long)this.annotTimeMeasure.getNext().getQtyInNextUnits() || (this.annotTimeMeasure.ordinal() < TimeAxis.QTY_OF_TIME_MEASURES - 3 ? timeInterval / (long)this.annotTimeMeasure.getQtyInNextUnits() < (long)(this.annotTimeMeasure.getNext().getQtyInNextUnits() * this.annotTimeMeasure.getNext().getNext().getQtyInNextUnits()) : timeInterval < 1000L))) {
                    timeInterval /= (long)this.annotTimeMeasure.getQtyInNextUnits();
                    this.divisor *= (long)this.annotTimeMeasure.getQtyInNextUnits();
                    this.annotTimeMeasure = this.annotTimeMeasure.getNext();
                    continue;
                }
                break block3;
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                this.divisor *= (long)this.annotTimeMeasure.getQtyInNextUnits();
                this.annotTimeMeasure = this.annotTimeMeasure.getNext();
lbl21:
                // 2 sources

                ** while (this.annotTimeMeasure.isLessThan((TimeMeasure)this.forcedTimeMeasure))
            }
        }
        this.fieldNo = TimeAxis.fields[this.annotTimeMeasure.ordinal()][0];
        this.initialZoomOut();
        this.copyToCurrent();
        this.resetAxisValues();
        this.setIntegerValuesFlag();
    }

    private void setNextTimeMeasure() {
        if (!this.timeMeasure.isLast()) {
            this.currDivisor *= (long)this.timeMeasure.getQtyInNextUnits();
            this.timeMeasure = this.timeMeasure.getNext();
            this.currFieldNo = fields[this.timeMeasure.ordinal()][0];
            this.nextZoomOut();
            this.resetAxisValues();
        }
    }

    private void copyToCurrent() {
        this.currDivisor = this.divisor;
        this.timeMeasure = this.annotTimeMeasure;
        this.currFieldNo = this.fieldNo;
        this.currStartTime = this.startTime;
        this.currEndTime = this.endTime;
        this.currStartTimeZoom = this.startTimeZoom;
        this.currEndTimeZoom = this.endTimeZoom;
        this.currStartBaseTime = this.startBaseTime;
    }

    private void resetAxisValues() {
        super.setStartValue((this.currStartTimeZoom - (double)this.currStartBaseTime) / (double)fields[this.timeMeasure.ordinal()][1]);
        super.setEndValue((this.currEndTimeZoom - (double)this.currStartBaseTime) / (double)fields[this.timeMeasure.ordinal()][1]);
        if (this.label != null && !this.exactUserLabel) {
            this.appendLabel(this.label);
        }
        this.setSpecialAnnotStrings();
    }

    private void firstStepInValues() {
        if (!this.timeMeasure.isLast()) {
            this.annotStepInValues = 1.0;
            this.smallTickStepInValues = 1.0;
        } else {
            this.averageAnnotSize = this.averageAnnotSizeAlongAxis();
            int maxAnnotSteps = (int)((double)this.length / (this.averageAnnotSize * 100.0 / this.getAnnotDensity()));
            this.annotStepInValues = (this.getMaxValue() - this.getMinValue()) / (double)maxAnnotSteps;
            this.annotStepInValues = Math.pow(10.0, Math.floor(ExtMath.log10(this.annotStepInValues)));
            this.annotStepInValues = Math.max(this.annotStepInValues, 1.0);
            this.smallTickStepInValues = Math.max((int)Math.round(this.annotStepInValues / 10.0), 1);
        }
        this.annotStepInSteps = (int)Math.round(this.annotStepInValues);
        this.bigTickStepInValues = this.annotStepInSteps == 1 ? this.annotStepInValues : (this.annotStepInSteps <= 2 || this.annotStepInSteps % 2 == 1 ? this.annotStepInValues : this.annotStepInValues / 2.0);
    }

    private void initialZoomOut() {
        int coeff1 = fields[this.annotTimeMeasure.ordinal()][1];
        int coeff2 = fields[this.annotTimeMeasure.ordinal()][2];
        TimeScale tmpStart = new TimeScale(this.start.getTimeInMinutes());
        this.startTime = this.start.getWholeTimeIn(this.fieldNo);
        this.endTime = this.end.getNextWholeTimeIn(this.fieldNo);
        if (!this.annotTimeMeasure.isFirst()) {
            int prevFieldNo = fields[this.annotTimeMeasure.getPrev().ordinal()][0];
            this.startTimeZoom = (double)this.start.getWholeTimeIn(prevFieldNo) / (double)this.annotTimeMeasure.getPrev().getQtyInNextUnits();
            this.endTimeZoom = (double)this.end.getNextWholeTimeIn(prevFieldNo) / (double)this.annotTimeMeasure.getPrev().getQtyInNextUnits();
        } else {
            this.startTimeZoom = this.start.getWholeTimeIn(this.fieldNo);
            this.endTimeZoom = this.end.getNextWholeTimeIn(this.fieldNo);
        }
        if (this.annotTimeMeasure.isLessThan(TimeMeasure.TM_YEAR)) {
            tmpStart.set(this.fieldNo, tmpStart.getMinimum(this.fieldNo));
            this.startBaseTime = tmpStart.getWholeTimeIn(this.fieldNo);
        } else {
            this.startTime = (long)coeff1 * (this.startTime / (long)coeff1);
            this.endTime = (long)coeff1 * (this.endTime / (long)coeff1);
            this.startBaseTime = coeff2 != 0 ? (long)coeff2 * (this.startTime / (long)coeff2) : 0L;
        }
    }

    private void nextZoomOut() {
        int coeff1 = fields[this.timeMeasure.ordinal()][1];
        int coeff2 = fields[this.timeMeasure.ordinal()][2];
        TimeScale tmpStart = new TimeScale(this.start.getTimeInMinutes());
        this.currStartTime = this.start.getWholeTimeIn(this.currFieldNo);
        this.currEndTime = this.end.getNextWholeTimeIn(this.currFieldNo);
        if (!this.timeMeasure.isFirst()) {
            int prevFieldNo = fields[this.timeMeasure.getPrev().ordinal()][0];
            this.currStartTimeZoom = (double)this.start.getWholeTimeIn(prevFieldNo) / (double)this.timeMeasure.getPrev().getQtyInNextUnits();
            this.currEndTimeZoom = (double)this.end.getNextWholeTimeIn(prevFieldNo) / (double)this.timeMeasure.getPrev().getQtyInNextUnits();
        } else {
            this.currStartTimeZoom = this.start.getWholeTimeIn(this.currFieldNo);
            this.currEndTimeZoom = this.end.getNextWholeTimeIn(this.currFieldNo);
        }
        if (this.timeMeasure.isLessThan(TimeMeasure.TM_YEAR)) {
            tmpStart.set(this.currFieldNo, tmpStart.getMinimum(this.currFieldNo));
            this.currStartBaseTime = tmpStart.getWholeTimeIn(this.currFieldNo);
        } else {
            this.currStartTime = (long)coeff1 * (this.currStartTime / (long)coeff1);
            this.currEndTime = (long)coeff1 * (this.currEndTime / (long)coeff1);
            this.currStartBaseTime = coeff2 != 0 ? (long)coeff2 * (this.currStartTime / (long)coeff2) : 0L;
        }
    }

    private void setSpecialAnnotStrings() {
        this.clearAnnotStrings();
        if (!this.timeMeasure.isLast()) {
            String prefix = this.timeMeasure.getNext().getShortName().substring(0, 1).toUpperCase();
            this.addToAnnotStrings(String.valueOf(prefix) + '-' + (this.timeMeasure.getQtyInNextUnits() - 1));
        }
    }

    private TimeScale internalAxisValueToTime(double currentValue) {
        TimeScale time = null;
        currentValue = (currentValue - super.getStartValue()) * (double)fields[this.timeMeasure.ordinal()][1];
        currentValue = (double)this.currDivisor * (this.currStartTimeZoom + currentValue);
        time = new TimeScale();
        time.setTimeInMilliSeconds((long)currentValue);
        time.complete();
        return time;
    }

    private double timeToInternalAxisValue(double timeInMinutes) {
        double internalAxisValue = timeInMinutes * 60000.0;
        internalAxisValue -= (double)this.currDivisor * this.currStartTimeZoom;
        internalAxisValue = super.getStartValue() + internalAxisValue / (double)this.currDivisor / (double)fields[this.timeMeasure.ordinal()][1];
        return internalAxisValue;
    }

    private String getRollTimeString(TimeScale timeValue) {
        TimeMeasure tm = this.timeMeasure;
        tm = this.timeMeasure.getNext();
        String mark = tm.getShortName().substring(0, 1).toLowerCase();
        String annotStr = this.currFieldNo != 2 ? "" + (timeValue.get(fields[tm.ordinal()][0]) + fields[tm.ordinal()][3]) : FC.IntegerToString(timeValue.get(fields[tm.ordinal()][0]) % 100, 2).replace(' ', '0');
        annotStr = String.valueOf(annotStr) + mark;
        return annotStr;
    }
}

