/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.gui;

import edu.uml.lgdc.gui.FocusMonitoredObject;

public class FocusMonitor
implements Runnable {
    private static final int DEFAULT_WAIT_IN_MILLISECONDS = 50;
    private FocusMonitoredObject object;
    private int waitInMilliseconds;

    public FocusMonitor(FocusMonitoredObject object) {
        this(object, 50);
    }

    public FocusMonitor(FocusMonitoredObject object, int waitInMilliseconds) {
        this.object = object;
        this.waitInMilliseconds = waitInMilliseconds;
    }

    @Override
    public void run() {
        this.startMonitorProcess();
    }

    private void startMonitorProcess() {
        try {
            try {
                this.object.fireFocusGained();
                do {
                    Thread.sleep(this.waitInMilliseconds);
                } while (this.object.isFocused());
                this.object.fireFocusLost();
            }
            catch (InterruptedException e) {
                System.out.println("FocusMonitor interrupted");
                this.object.focusMonitorExit();
            }
        }
        finally {
            this.object.focusMonitorExit();
        }
    }
}

