/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.gui;

import edu.uml.lgdc.gui.InputAware;
import edu.uml.lgdc.math.Search;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.TextComponent;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.text.JTextComponent;

public class HotKey {
    private static final int[] TAB_KEY_ONLY = new int[]{9};

    public static boolean dispatchHotKeyEvent(KeyEvent e, KeyboardFocusManager keyboardFocusManager, Window window) {
        return HotKey.dispatchHotKeyEvent(e, keyboardFocusManager, window, false);
    }

    public static boolean dispatchHotKeyEvent(KeyEvent e, KeyboardFocusManager keyboardFocusManager, Window window, boolean redispatchEscape) {
        return HotKey.dispatchHotKeyEvent(e, keyboardFocusManager, window, redispatchEscape, TAB_KEY_ONLY);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean dispatchHotKeyEvent(KeyEvent e, KeyboardFocusManager keyboardFocusManager, Window window, boolean redispatchEscape, int[] doNotRedispatchKeyCodes) {
        boolean reDispatch;
        block10: {
            int code;
            char c;
            Component focusOwner;
            block13: {
                block11: {
                    block12: {
                        if (!window.isActive()) return false;
                        if (e.isConsumed()) return true;
                        if (doNotRedispatchKeyCodes != null && Search.scan(doNotRedispatchKeyCodes, e.getKeyCode()) >= 0) {
                            return false;
                        }
                        reDispatch = true;
                        focusOwner = window.getFocusOwner();
                        c = e.getKeyChar();
                        code = e.getKeyCode();
                        if (focusOwner == null || code == 27 && redispatchEscape) break block10;
                        if (!(focusOwner instanceof InputAware)) break block11;
                        if (code != 0) break block12;
                        if (((InputAware)((Object)focusOwner)).getLegalChars().indexOf(c) >= 0) {
                            return false;
                        }
                        break block10;
                    }
                    if (!e.isAltDown() && !e.isControlDown()) {
                        char c1 = KeyEvent.getKeyText(code).charAt(0);
                        if (((InputAware)((Object)focusOwner)).getLegalChars().indexOf(c1) >= 0) {
                            return false;
                        }
                    }
                    break block13;
                }
                if ((focusOwner instanceof JTextComponent || focusOwner instanceof TextComponent) && code == 0) {
                    return false;
                }
            }
            if (focusOwner instanceof JComponent) {
                KeyStroke keyStroke = code == 0 ? KeyStroke.getKeyStroke(new Character(c), e.getModifiers()) : KeyStroke.getKeyStroke(code, e.getModifiers());
                Object[] allKeys = ((JComponent)focusOwner).getRegisteredKeyStrokes();
                if (allKeys != null && Search.scan(allKeys, (Object)keyStroke) >= 0) {
                    return false;
                }
                if (code == 0 && focusOwner instanceof JComboBox && ((JComboBox)focusOwner).getItemCount() > 0 && ((JComboBox)focusOwner).selectWithKeyChar(c)) {
                    return false;
                }
                if (code == 0 && focusOwner instanceof JButton) {
                    if (c == '\n') return false;
                    if (c == '\r') {
                        return false;
                    }
                }
            }
        }
        if (!reDispatch) return reDispatch;
        if (e.isConsumed()) return reDispatch;
        keyboardFocusManager.redispatchEvent(window, e);
        return reDispatch;
    }

    public static boolean respondToMenuHotKey(KeyEvent e, JMenuBar menuBar) {
        MenuElement[] elements;
        int c = e.getKeyCode();
        JPopupMenu popupMenu = HotKey.getLowestVisibleMenu(menuBar);
        if (popupMenu == null) {
            if (e.getModifiersEx() != 512) {
                return false;
            }
            elements = menuBar.getSubElements();
        } else {
            elements = popupMenu.getSubElements();
            c |= e.getModifiersEx();
        }
        int j = 0;
        while (j < elements.length) {
            AbstractButton button;
            if (elements[j] instanceof AbstractButton && (button = (AbstractButton)((Object)elements[j])).getMnemonic() == c) {
                if (button.isEnabled() && button.isVisible()) {
                    button.doClick(68);
                }
                e.consume();
                return true;
            }
            ++j;
        }
        return false;
    }

    public static boolean isMenuOpened(JMenuBar menuBar) {
        int qtyOfMenus = menuBar.getMenuCount();
        int i = 0;
        while (i < qtyOfMenus) {
            if (menuBar.getMenu(i).getPopupMenu().isVisible()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static JPopupMenu getLowestVisibleMenu(JMenuBar menuBar) {
        JPopupMenu popupMenu = null;
        int qtyOfMenus = menuBar.getMenuCount();
        int i = 0;
        while (i < qtyOfMenus) {
            JMenu menu = menuBar.getMenu(i);
            if (menu.getPopupMenu().isVisible()) {
                popupMenu = HotKey.getLowestVisibleMenu(menu.getPopupMenu());
                if (popupMenu != null) break;
                popupMenu = menu.getPopupMenu();
                break;
            }
            ++i;
        }
        return popupMenu;
    }

    private static JPopupMenu getLowestVisibleMenu(JPopupMenu menu) {
        JPopupMenu popupMenu = null;
        MenuElement[] elements = menu.getSubElements();
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof JMenu && ((JMenu)elements[i]).getPopupMenu().isVisible()) {
                popupMenu = HotKey.getLowestVisibleMenu(((JMenu)elements[i]).getPopupMenu());
                if (popupMenu != null) break;
                popupMenu = ((JMenu)elements[i]).getPopupMenu();
                break;
            }
            ++i;
        }
        return popupMenu;
    }

    public static void moveToNextTab(JTabbedPane tabbedPane) {
        int nTabs = tabbedPane.getTabCount();
        int currentTab = tabbedPane.getSelectedIndex();
        currentTab = currentTab < nTabs - 1 ? ++currentTab : 0;
        tabbedPane.setSelectedIndex(currentTab);
    }

    public static void moveToPrevTab(JTabbedPane tabbedPane) {
        int nTabs = tabbedPane.getTabCount();
        int currentTab = tabbedPane.getSelectedIndex();
        currentTab = currentTab > 0 ? --currentTab : nTabs - 1;
        tabbedPane.setSelectedIndex(currentTab);
    }

    public static void closeWindow(Window window) {
        WindowEvent ev = new WindowEvent(window, 201);
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(ev);
    }
}

