/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.gui;

import edu.uml.lgdc.format.C;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractButton;

public class HotKeyButton {
    private AbstractButton button;
    private String[] texts;
    private char hotKey;
    private int hotKeyCode;
    private int modifier;
    private int modifierKeyCode;
    private KeyListener listener;
    private String forTooltip = "";
    private transient String startTag;
    private transient String endTag;
    private transient int txtIndex;

    public HotKeyButton(AbstractButton button, String text, char hotKey, int modifier, KeyListener listener) {
        this(button, new String[]{text}, hotKey, modifier, listener);
    }

    public HotKeyButton(AbstractButton button, String[] texts, char hotKey, int modifier, KeyListener listener) {
        if (button == null) {
            throw new IllegalArgumentException("button is null");
        }
        if (texts == null) {
            throw new IllegalArgumentException("texts is null");
        }
        if (texts.length == 0) {
            throw new IllegalArgumentException("texts.length == 0");
        }
        this.button = button;
        this.texts = texts;
        this.hotKey = hotKey;
        this.hotKeyCode = Character.toUpperCase(hotKey);
        if (modifier == 128) {
            this.modifierKeyCode = 17;
        } else if (modifier == 512) {
            this.modifierKeyCode = 18;
        } else if (modifier == 64) {
            this.modifierKeyCode = 16;
        } else {
            throw new IllegalArgumentException("illegal modifier, CTRL_DOWN_MASK or ALT_DOWN_MASK exptected");
        }
        this.modifier = modifier;
        this.listener = listener;
    }

    public void setTags(String startTag, String endTag) {
        this.startTag = startTag;
        this.endTag = endTag;
    }

    public AbstractButton getButton() {
        return this.button;
    }

    public String getText() {
        return this.texts[this.txtIndex];
    }

    public void advanceTextIndex() {
        if (this.texts.length > 1) {
            ++this.txtIndex;
            if (this.txtIndex >= this.texts.length) {
                this.txtIndex = 0;
            }
        }
    }

    public char getHotKey() {
        return this.hotKey;
    }

    public boolean withModifier() {
        return this.modifier != 0;
    }

    public int getModifier() {
        return this.modifier;
    }

    public int getModifierKeyCode() {
        return this.modifierKeyCode;
    }

    public String getForTooltip() {
        return this.forTooltip;
    }

    public void setKey() {
        HotKeyButton.setKey(this.button, this.texts[this.txtIndex], this.hotKey, this.startTag, this.endTag);
    }

    public void removeKey() {
        this.button.setText(this.texts[this.txtIndex]);
        this.button.setMnemonic(-1);
    }

    public void keyPressed(KeyEvent e) {
        if (this.listener == null) {
            return;
        }
        int keyCode = e.getKeyCode();
        int modif = e.getModifiersEx();
        if (keyCode == this.hotKeyCode && modif == this.modifier) {
            this.listener.keyPressed(e);
            e.consume();
            if (this.texts.length > 1) {
                ++this.txtIndex;
                if (this.txtIndex >= this.texts.length) {
                    this.txtIndex = 0;
                }
                this.setKey();
            }
        }
    }

    public static void setKey(AbstractButton button, String text, char hotKey, String startTag, String endTag) {
        button.setText(C.emphasizeChar(text, hotKey, startTag, endTag));
        button.setMnemonic((int)Character.toUpperCase(hotKey));
    }

    public static void setKey(AbstractButton button, String text, int pos, String startTag, String endTag) {
        char key = Character.toUpperCase(text.charAt(pos));
        button.setText(C.emphasizeChar(text, pos, startTag, endTag));
        button.setMnemonic((int)Character.toUpperCase(key));
    }
}

