/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.gui;

import edu.uml.lgdc.format.C;
import edu.uml.lgdc.gui.HotKeyButton;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.util.List;

public class HotKeyButtons {
    public static final Color COLOR = new Color(5, 118, 131);
    private List<HotKeyButton> hotKeyButtons;
    private boolean useUnderscore;
    private boolean useColor;
    private boolean activatedByModifier;
    private Color color = COLOR;
    private String startTag;
    private String endTag;

    public HotKeyButtons(List<HotKeyButton> hotKeyButtons, boolean useUnderscore, boolean useColor, boolean activateByModifier) {
        if (hotKeyButtons == null) {
            throw new IllegalArgumentException("hotKeyButtons is null");
        }
        this.hotKeyButtons = hotKeyButtons;
        this.useUnderscore = useUnderscore;
        this.useColor = useColor;
        this.activatedByModifier = activateByModifier;
        this.setTags();
        this.setWithoutModifierKeys();
    }

    public void setColor(Color color) {
        this.color = color;
        this.setTags();
    }

    public void setKeys() {
        for (HotKeyButton hotKeyButton : this.hotKeyButtons) {
            if (hotKeyButton.getModifier() == 0) continue;
            hotKeyButton.setKey();
        }
    }

    public void removeKeys() {
        for (HotKeyButton hotKeyButton : this.hotKeyButtons) {
            if (hotKeyButton.getModifier() == 0) continue;
            hotKeyButton.removeKey();
        }
    }

    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        int modifier = e.getModifiersEx();
        for (HotKeyButton hotKeyButton : this.hotKeyButtons) {
            if (this.activatedByModifier && keyCode == hotKeyButton.getModifierKeyCode() && modifier == hotKeyButton.getModifier()) {
                hotKeyButton.setKey();
                e.consume();
                continue;
            }
            hotKeyButton.keyPressed(e);
            if (e.isConsumed()) break;
        }
    }

    public void keyReleased(KeyEvent e) {
        if (!this.activatedByModifier) {
            return;
        }
        int keyCode = e.getKeyCode();
        for (HotKeyButton hotKeyButton : this.hotKeyButtons) {
            if (!this.activatedByModifier || keyCode != hotKeyButton.getModifierKeyCode()) continue;
            hotKeyButton.removeKey();
            e.consume();
        }
    }

    private void setTags() {
        String htmlColorStr = C.getHtmlColorStr(this.color);
        if (this.useUnderscore) {
            if (this.useColor) {
                this.startTag = "<U><FONT COLOR=\"" + htmlColorStr + "\">";
                this.endTag = "</FONT></U>";
            } else {
                this.startTag = "<U>";
                this.endTag = "</U>";
            }
        } else if (this.useColor) {
            this.startTag = "<FONT COLOR=\"" + htmlColorStr + "\">";
            this.endTag = "</FONT>";
        } else {
            this.startTag = "";
            this.endTag = "";
        }
        for (HotKeyButton hotKeyButton : this.hotKeyButtons) {
            hotKeyButton.setTags(this.startTag, this.endTag);
        }
    }

    private void setWithoutModifierKeys() {
        for (HotKeyButton hotKeyButton : this.hotKeyButtons) {
            if (hotKeyButton.getModifier() != 0) continue;
            hotKeyButton.setKey();
        }
    }
}

